/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.util.Locale;

public enum ChatTokenCounterMode {
    HIDDEN("hidden"),
    CONTEXT_WINDOW("context"),
    TOTAL_CHAT("total"),
    MODEL_RESPONSE("model_response");

    private final String preferenceValue;

    private ChatTokenCounterMode(String preferenceValue) {
        this.preferenceValue = preferenceValue;
    }

    String getPreferenceValue() {
        return this.preferenceValue;
    }

    static ChatTokenCounterMode fromPreferenceValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return HIDDEN;
        }
        String normalized = value.trim().toLowerCase(Locale.ROOT);
        for (ChatTokenCounterMode mode : ChatTokenCounterMode.values()) {
            if (!mode.preferenceValue.equals(normalized)) continue;
            return mode;
        }
        return HIDDEN;
    }
}

