---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Enforce two-factor authentication
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

[Two-factor authentication (2FA)](../user/profile/account/two_factor_authentication.md)
is an authentication method that requires the user to provide two different factors
to prove their identity:

- Username and password.
- A second authentication method, such as a code generated by an application.

2FA makes it harder for an unauthorized person to access an account because
they would need both factors.

{{< alert type="note" >}}

If you are [using and enforcing SSO](../user/group/saml_sso/_index.md#sso-enforcement), you might already be enforcing 2FA on the identity provider (IdP) side. Enforcing 2FA on GitLab as well might be unnecessary.

{{< /alert >}}

## Enforce 2FA for all users

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

Administrators can enforce 2FA for all users in two different ways:

- Enforce on next sign in.
- Suggest on next sign in, but allow a grace period before enforcing.

  After the configured grace period has elapsed, users can sign in but
  cannot leave the 2FA configuration area at `/-/profile/two_factor_auth`.

You can use the UI or the API to enforce 2FA for all users.

### Use the UI

1. On the left sidebar, at the bottom, select **Admin**. If you've [turned on the new navigation](../user/interface_redesign.md#turn-new-navigation-on-or-off), in the upper-right corner, select **Admin**.
1. Select **Settings** > **General**.
1. Expand **Sign-in restrictions**:
   - Select **Enforce two-factor authentication** to enable this feature.
   - In **Two-factor grace period**, enter a number of hours. If you want to
     enforce 2FA on next sign-in attempt, enter `0`.

### Use the API

Use the [application settings API](../api/settings.md) to modify the following settings:

- `require_two_factor_authentication`.
- `two_factor_grace_period`.

For more information, see the [list of settings that can be accessed through API calls](../api/settings.md#available-settings).

## Enforce 2FA for Administrator users

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/427549) in GitLab 16.8.
- Support for enforcing 2FA for regular users who have custom admin roles [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/556110) in GitLab 18.3.

{{< /history >}}

Administrators can enforce 2FA for both:

- Administrator users.
- Regular users who have been assigned a [custom admin role](../user/custom_roles/_index.md).

1. On the left sidebar, at the bottom, select **Admin**. If you've [turned on the new navigation](../user/interface_redesign.md#turn-new-navigation-on-or-off), in the upper-right corner, select **Admin**.
1. On the left sidebar, select **Settings** > **General**.
1. Expand the **Sign-in restrictions** section:
   1. Select **Require administrators to enable 2FA**.
   1. In **Two-factor grace period**, enter a number of hours. If you want to
     enforce 2FA on the next sign-in attempt, enter `0`.
1. Select **Save changes**.

{{< alert type="note" >}}

If you are using an external provider to sign in into GitLab, this setting will **not** enforce 2FA for users. 2FA should be enabled on that external provider.

{{< /alert >}}

## Enforce 2FA for all users in a group

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

You can enforce 2FA for all users in a group or subgroup.

{{< alert type="note" >}}

2FA enforcement applies to both [direct and inherited members](../user/project/members/_index.md#membership-types) group members.
If 2FA is enforced on a subgroup, inherited members (members of the ancestor groups) must also enroll an authentication factor.

{{< /alert >}}

Prerequisites:

- You must have the Owner role for the group.

To enforce 2FA for a group:

1. On the left sidebar, select **Search or go to** and find your group. If you've [turned on the new navigation](../user/interface_redesign.md#turn-new-navigation-on-or-off), this field is on the top bar.
1. Select **Settings** > **General**.
1. Expand **Permissions and group features**.
1. Select **All users in this group must set up two-factor authentication**.
1. Optional. In **Delay 2FA enforcement (hours)**, enter the number of hours you
   want the grace period to last for.
   If there are multiple different grace periods in a top-level group and its subgroups
   and projects, the shortest grace period is used.
1. Select **Save changes**.

Access tokens are not required to provide a second factor for authentication because
they are API-based. Tokens generated before 2FA is enforced remain valid.

The GitLab [incoming email](../administration/incoming_email.md) feature does not follow 2FA enforcement. Users can use incoming email features such as creating issues or commenting on merge requests without having to authenticate themselves using 2FA first. This applies even if 2FA is enforced.

### 2FA in subgroups

By default, each subgroup can configure 2FA requirements that might differ from the parent group.

{{< alert type="note" >}}

Inherited members might also have different 2FA requirements applied at higher levels in the hierarchy.
In such cases, the most restrictive requirement takes precedence.

{{< /alert >}}

To prevent subgroups from setting individual 2FA requirements:

1. Go to the top-level group's **Settings** > **General**.
1. Expand the **Permissions and group features** section.
1. Clear the **Allow subgroups to set up their own two-factor authentication rule** checkbox.

### 2FA in projects

If a project belonging to a group that enables or enforces 2FA is [shared](../user/project/members/sharing_projects_groups.md)
with a group that does not enable or enforce 2FA, members of the non-2FA group can access that project
without using 2FA. For example:

- Group A has 2FA enabled and enforced. Group B does not have 2FA enabled.
- If a project, P, that belongs to group A is shared with group B, members
  of group B can access project P without 2FA.

To ensure this does not occur, [prevent sharing of projects](../user/project/members/sharing_projects_groups.md#prevent-a-project-from-being-shared-with-groups)
for the 2FA group.

{{< alert type="warning" >}}

If you add members to a project in a group or subgroup that has 2FA
enabled, 2FA is **not** required for those individually added members.

{{< /alert >}}

## Disable 2FA

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

You can disable 2FA for a single user or all users.

This action is permanent and irreversible. Users must reactivate 2FA to use it again.

{{< alert type="warning" >}}

Disabling 2FA for users does not disable the [enforce 2FA for all users](#enforce-2fa-for-all-users)
or [enforce 2FA for all users in a group](#enforce-2fa-for-all-users-in-a-group)
settings. You must also disable any enforced 2FA settings so users aren't asked to set up 2FA again
when they next sign in to GitLab.

{{< /alert >}}

### For all users

To disable 2FA for all users even when forced 2FA is disabled, use the following Rake task.

- For installations that use the Linux package:

  ```shell
  sudo gitlab-rake gitlab:two_factor:disable_for_all_users
  ```

- For self-compiled installations:

  ```shell
  sudo -u git -H bundle exec rake gitlab:two_factor:disable_for_all_users RAILS_ENV=production
  ```

### For a single user

#### Administrators

It is possible to use the [Rails console](../administration/operations/rails_console.md)
to disable 2FA for a single administrator:

```ruby
admin = User.find_by_username('<USERNAME>')
user_to_disable = User.find_by_username('<USERNAME>')

TwoFactor::DestroyService.new(admin, user: user_to_disable).execute
```

The administrator is notified that 2FA has been disabled.

#### Non-administrators

You can use either the Rails console or the
[API endpoint](../api/users.md#disable-two-factor-authentication-for-a-user) to disable 2FA
for a non-administrator.

You can disable 2FA for your own account.

You cannot use the API endpoint to disable 2FA for administrators.

#### Enterprise users

{{< details >}}

- Tier: Premium, Ultimate
- Offering: GitLab.com

{{< /details >}}

Top-level group Owners can disable two-factor authentication (2FA) for enterprise users.

To disable 2FA:

1. On the left sidebar, select **Search or go to** and find your group. If you've [turned on the new navigation](../user/interface_redesign.md#turn-new-navigation-on-or-off), this field is on the top bar.
1. Select **Manage** > **Members**.
1. Find a user with the **Enterprise** and **2FA** badges.
1. Select **More actions** ({{< icon name="ellipsis_v" >}}) and select **Disable two-factor authentication**.

You can also [use the API](../api/group_enterprise_users.md#disable-two-factor-authentication-for-an-enterprise-user) to disable 2FA for enterprise users, including enterprise users who are no longer a member of the group.

## 2FA for Git over SSH operations

{{< details >}}

- Tier: Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

{{< alert type="flag" >}}

By default this feature is not available. To make it available, an administrator can [enable the feature flag](../administration/feature_flags/_index.md) named `two_factor_for_cli`. This feature is not ready for production use. This feature flag also affects [session duration for Git Operations when 2FA is enabled](../administration/settings/account_and_limit_settings.md#customize-session-duration-for-git-operations-when-2fa-is-enabled).

{{< /alert >}}

You can enforce 2FA for Git over SSH operations. However, you should use
[ED25519_SK](../user/ssh.md#ed25519_sk-ssh-keys) or [ECDSA_SK](../user/ssh.md#ecdsa_sk-ssh-keys) SSH keys instead. 2FA is enforced for Git operations only, and internal commands from GitLab Shell such as `personal_access_token` are excluded.

To perform one-time password (OTP) verification, run:

```shell
ssh git@<hostname> 2fa_verify
```

Then authenticate by either:

- Entering the correct OTP.
- Responding to a device push notification if
  [FortiAuthenticator is enabled](../user/profile/account/two_factor_authentication.md#enable-a-one-time-password-authenticator-using-fortiauthenticator).

After successful authentication, you can perform Git over SSH operations for 15 minutes (default) with the associated
SSH key.

### Security limitation

2FA does not protect users with compromised private SSH keys.

Once an OTP is verified, anyone can run Git over SSH with that private SSH key for
the configured [session duration](../administration/settings/account_and_limit_settings.md#customize-session-duration-for-git-operations-when-2fa-is-enabled).
