/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.IntersectingLocalChangesPanel;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeContentsVariants;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.QuickMergeWayOptionsPanel;
import org.jetbrains.idea.svn.integrate.SelectMergeItemsResult;
import org.jetbrains.idea.svn.integrate.ToBeMergedDialog;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;

public class QuickMergeInteractionImpl
implements QuickMergeInteraction {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Project myProject;

    public QuickMergeInteractionImpl(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(0);
        }
        this.myMergeContext = mergeContext;
        this.myProject = mergeContext.getProject();
    }

    @Override
    @NotNull
    public QuickMergeContentsVariants selectMergeVariant() {
        QuickMergeWayOptionsPanel panel2 = new QuickMergeWayOptionsPanel();
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.title(SvnBundle.message("dialog.title.select.merge.variant", new Object[0])).centerPanel((JComponent)panel2.getMainPanel()).removeAllActions();
        panel2.setWrapper(builder.getDialogWrapper());
        builder.show();
        QuickMergeContentsVariants quickMergeContentsVariants = panel2.getVariant();
        if (quickMergeContentsVariants == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(1);
        }
        return quickMergeContentsVariants;
    }

    @Override
    public boolean shouldContinueSwitchedRootFound() {
        return this.prompt(SvnBundle.message("dialog.message.merge.with.switched.paths.in.working.copy", new Object[0]));
    }

    @Override
    public boolean shouldReintegrate(@NotNull Url targetUrl) {
        if (targetUrl == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(2);
        }
        return this.prompt(XmlStringUtil.wrapInHtml((CharSequence)SvnBundle.message("dialog.message.merge.confirm.reintegrate", this.myMergeContext.getSourceUrl().toDecodedString(), targetUrl.toDecodedString())));
    }

    @Override
    @NotNull
    public SelectMergeItemsResult selectMergeItems(@NotNull List<SvnChangeList> lists, @NotNull MergeChecker mergeChecker, boolean allStatusesCalculated, boolean allListsLoaded) {
        if (lists == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(3);
        }
        if (mergeChecker == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(4);
        }
        ToBeMergedDialog dialog = new ToBeMergedDialog(this.myMergeContext, lists, mergeChecker, allStatusesCalculated, allListsLoaded);
        dialog.show();
        QuickMergeContentsVariants resultCode = QuickMergeInteractionImpl.toMergeVariant(dialog.getExitCode());
        List<SvnChangeList> selectedLists = resultCode == QuickMergeContentsVariants.select ? dialog.getSelected() : ContainerUtil.emptyList();
        return new SelectMergeItemsResult(resultCode, selectedLists);
    }

    @Override
    @NotNull
    public LocalChangesAction selectLocalChangesAction(boolean mergeAll) {
        String message;
        LocalChangesAction[] possibleResults;
        if (!mergeAll) {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.inspect, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = SvnBundle.message("dialog.message.merge.intersects.with.local.changes.prompt", new Object[0]);
        } else {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = SvnBundle.message("dialog.message.merge.potentially.intersects.with.local.changes.prompt", new Object[0]);
        }
        int result = Messages.showDialog((String)message, (String)this.myMergeContext.getMergeTitle(), (String[])((String[])ContainerUtil.map2Array((Object[])possibleResults, String.class, (Function)Functions.TO_STRING())), (int)0, (Icon)Messages.getQuestionIcon());
        LocalChangesAction localChangesAction = result == -1 ? LocalChangesAction.cancel : possibleResults[result];
        if (localChangesAction == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(5);
        }
        return localChangesAction;
    }

    @Override
    public void showIntersectedLocalPaths(@NotNull List<FilePath> paths) {
        if (paths == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(6);
        }
        IntersectingLocalChangesPanel.showInVersionControlToolWindow(this.myProject, SvnBundle.message("tab.title.merge.local.changes.intersection", this.myMergeContext.getMergeTitle()), paths);
    }

    @Override
    public void showErrors(@NlsContexts.TabTitle @NotNull String message, @NotNull List<VcsException> exceptions) {
        if (message == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(7);
        }
        if (exceptions == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(8);
        }
        AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, message);
    }

    @Override
    public void showErrors(@NlsContexts.NotificationContent @NotNull String message, boolean isError) {
        if (message == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(9);
        }
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)message, (MessageType)(isError ? MessageType.ERROR : MessageType.WARNING), (NamedRunnable[])new NamedRunnable[0]);
    }

    private boolean prompt(@NlsContexts.DialogMessage @NotNull String question) {
        if (question == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(10);
        }
        return Messages.showOkCancelDialog((Project)this.myProject, (String)question, (String)this.myMergeContext.getMergeTitle(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static QuickMergeContentsVariants toMergeVariant(int exitCode) {
        QuickMergeContentsVariants quickMergeContentsVariants = switch (exitCode) {
            case 222 -> QuickMergeContentsVariants.all;
            case 0 -> QuickMergeContentsVariants.select;
            default -> QuickMergeContentsVariants.cancel;
        };
        if (quickMergeContentsVariants == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(11);
        }
        return quickMergeContentsVariants;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeChecker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "question";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMergeVariant";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "selectLocalChangesAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toMergeVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldReintegrate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectMergeItems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showIntersectedLocalPaths";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prompt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 11 -> new IllegalStateException(string);
        };
    }
}

