/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.compiler;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;

public final class FormLayoutUtils {
    private FormLayoutUtils() {
    }

    public static String getEncodedRowSpecs(FormLayout formLayout) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i <= formLayout.getRowCount(); ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(FormLayoutUtils.getEncodedSpec((FormSpec)formLayout.getRowSpec(i)));
        }
        return result.toString();
    }

    public static String getEncodedColumnSpecs(FormLayout formLayout) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i <= formLayout.getColumnCount(); ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(FormLayoutUtils.getEncodedSpec((FormSpec)formLayout.getColumnSpec(i)));
        }
        return result.toString();
    }

    public static String getEncodedSpec(FormSpec formSpec) {
        String result = formSpec.toString();
        while (true) {
            int pos;
            if ((pos = result.indexOf("dluX")) < 0) {
                pos = result.indexOf("dluY");
            }
            if (pos < 0) break;
            result = result.substring(0, pos + 3) + result.substring(pos + 4);
        }
        return result;
    }
}

