/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckboxIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FileFilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureFilterPopupComponent
extends FilterPopupComponent<VcsLogFilterCollection, FileFilterModel> {
    private static final String PATHS = "Paths";
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    private static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    private static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;

    public StructureFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull FileFilterModel filterModel, @NotNull VcsLogColorManager colorManager) {
        if (uiProperties == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (filterModel == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(1);
        }
        if (colorManager == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(2);
        }
        super(VcsLogBundle.messagePointer("vcs.log.filter.popup.paths", new Object[0]), filterModel);
        this.myUiProperties = uiProperties;
        this.myColorManager = colorManager;
    }

    private static VcsLogRootFilter getRootFilter(@Nullable VcsLogFilterCollection filter) {
        if (filter == null) {
            return null;
        }
        return (VcsLogRootFilter)filter.get(VcsLogFilterCollection.ROOT_FILTER);
    }

    private static VcsLogStructureFilter getStructureFilter(@Nullable VcsLogFilterCollection filter) {
        if (filter == null) {
            return null;
        }
        return (VcsLogStructureFilter)filter.get(VcsLogFilterCollection.STRUCTURE_FILTER);
    }

    @NotNull
    private Collection<VirtualFile> getFilterRoots(@Nullable VcsLogRootFilter filter) {
        Set<VirtualFile> set = filter != null ? filter.getRoots() : this.getAllRoots();
        if (set == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Collection<FilePath> getFilterFiles(@Nullable VcsLogStructureFilter filter) {
        Collection<Object> collection = filter != null ? filter.getFiles() : Collections.emptySet();
        if (collection == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    @Nls
    protected String getText(@NotNull VcsLogFilterCollection filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(5);
        }
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter(filter);
        VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter(filter);
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), rootFilter, structureFilter);
        Collection<VirtualFile> roots = this.getFilterRoots(rootFilter);
        Collection<FilePath> files = StructureFilterPopupComponent.getFilterFiles(structureFilter);
        if (files.isEmpty()) {
            return StructureFilterPopupComponent.getTextFromRoots(roots, visibleRoots.size() == this.getAllRoots().size());
        }
        return this.getTextFromFilePaths(files, VcsLogBundle.message("vcs.log.filter.popup.no.folders", new Object[0]), false);
    }

    @NotNull
    @Nls
    private static String getTextFromRoots(@NotNull Collection<? extends VirtualFile> files, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return StructureFilterPopupComponent.getText(files, VcsLogBundle.message("vcs.log.filter.popup.no.roots", new Object[0]), FILE_BY_NAME_COMPARATOR, VirtualFile::getName, full);
    }

    @NotNull
    @Nls
    private String getTextFromFilePaths(@NotNull Collection<? extends FilePath> files, @Nls @NotNull String categoryText, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(7);
        }
        if (categoryText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(8);
        }
        return StructureFilterPopupComponent.getText(files, categoryText, FILE_PATH_BY_PATH_COMPARATOR, file -> StringUtil.shortenPathWithEllipsis((String)this.path2Text((FilePath)file, true), (int)30), full);
    }

    @NotNull
    @Nls
    private static <F> String getText(@NotNull Collection<? extends F> files, @Nls @NotNull String categoryText, @NotNull Comparator<? super F> comparator, @NotNull NotNullFunction<? super F, @Nls String> getText, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(9);
        }
        if (categoryText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(10);
        }
        if (comparator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(11);
        }
        if (getText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(12);
        }
        if (full) {
            String string = (String)ALL_ACTION_TEXT.get();
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (files.isEmpty()) {
            String string = categoryText;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(14);
            }
            return string;
        }
        F firstFile = Collections.min(files, comparator);
        String firstFileName = (String)getText.fun(firstFile);
        if (files.size() == 1) {
            String string = firstFileName;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = firstFileName + " + " + (files.size() - 1);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @Nls
    protected String getToolTip(@NotNull VcsLogFilterCollection filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(17);
        }
        return this.getToolTip(this.getFilterRoots(StructureFilterPopupComponent.getRootFilter(filter)), StructureFilterPopupComponent.getFilterFiles(StructureFilterPopupComponent.getStructureFilter(filter)));
    }

    @Nls
    @NotNull
    private String getToolTip(@NotNull Collection<? extends VirtualFile> roots, @NotNull Collection<? extends FilePath> files) {
        if (roots == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(18);
        }
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(19);
        }
        HtmlBuilder tooltip = new HtmlBuilder();
        if (roots.isEmpty()) {
            tooltip.append(VcsLogBundle.message("vcs.log.filter.tooltip.no.roots.selected", new Object[0]));
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip.append(VcsLogBundle.message("vcs.log.filter.tooltip.roots", new Object[0])).br().append(StructureFilterPopupComponent.getTooltipTextForRoots(roots));
        }
        if (!files.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip.br();
            }
            tooltip.append(VcsLogBundle.message("vcs.log.filter.tooltip.folders", new Object[0])).br().append(this.getTooltipTextForFilePaths(files, (HtmlChunk)HtmlChunk.br()));
        }
        String string = tooltip.toString();
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NlsContexts.Tooltip
    @NotNull
    private static HtmlChunk getTooltipTextForRoots(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(21);
        }
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_BY_NAME_COMPARATOR, VirtualFile::getName, (HtmlChunk)HtmlChunk.br());
    }

    @NlsContexts.Tooltip
    @NotNull
    private HtmlChunk getTooltipTextForFilePaths(@NotNull Collection<? extends FilePath> files, @NotNull HtmlChunk separator) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(22);
        }
        if (separator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(23);
        }
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_PATH_BY_PATH_COMPARATOR, filePath -> this.path2Text((FilePath)filePath, true), separator);
    }

    @NlsContexts.Tooltip
    @NotNull
    private static <F> HtmlChunk getTooltipTextForFiles(@NotNull Collection<? extends F> files, @NotNull Comparator<? super F> comparator, @NotNull @NotNull Function<? super F, @NotNull @Nls String> getText, @NotNull HtmlChunk separator) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(24);
        }
        if (comparator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(25);
        }
        if (getText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(26);
        }
        if (separator == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(27);
        }
        List filesToDisplay = ContainerUtil.sorted(files, comparator);
        filesToDisplay = ContainerUtil.getFirstItems((List)filesToDisplay, (int)10);
        HtmlBuilder tooltip = new HtmlBuilder().appendWithSeparators(separator, (Iterable)ContainerUtil.map((Collection)filesToDisplay, f -> HtmlChunk.text((String)((String)getText.apply((Object)f)))));
        if (files.size() > 10) {
            tooltip.append(separator).append("...");
        }
        HtmlChunk htmlChunk = tooltip.toFragment();
        if (htmlChunk == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(28);
        }
        return htmlChunk;
    }

    @Override
    @NotNull
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.hasMultiplePaths()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter : this.getRecentFilters()) {
            structureActions.add(new SelectFromHistoryAction(filter));
        }
        ArrayList<AnAction> actionsList = new ArrayList<AnAction>(Arrays.asList(new AnAction[]{new EditPathsAction(), new SelectPathsInTreeAction(), new Separator(VcsLogBundle.messagePointer("vcs.log.filter.recent", new Object[0])), new DefaultActionGroup(structureActions)}));
        int position = roots.size() > 15 ? actionsList.size() : actionsList.size() - 2;
        actionsList.addAll(position, List.of(new Separator(VcsLogBundle.messagePointer("vcs.log.filter.roots", new Object[0])), new DefaultActionGroup(rootActions)));
        return new DefaultActionGroup(actionsList);
    }

    @NotNull
    private List<VcsLogStructureFilter> getRecentFilters() {
        List<List<String>> filterValues = this.myUiProperties.getRecentlyFilteredGroups(PATHS);
        List list = ContainerUtil.map(filterValues, values -> FileFilterModel.createStructureFilter(values));
        if (list == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(29);
        }
        return list;
    }

    private Set<VirtualFile> getAllRoots() {
        return ((FileFilterModel)this.myFilterModel).getRoots();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        VcsLogRootFilter rootFilter;
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(30);
        }
        if ((rootFilter = StructureFilterPopupComponent.getRootFilter((VcsLogFilterCollection)((FileFilterModel)this.myFilterModel).getFilter())) != null) {
            return rootFilter.getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(31);
        }
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter((VcsLogFilterCollection)((FileFilterModel)this.myFilterModel).getFilter());
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        ((FileFilterModel)this.myFilterModel).setFilter(VcsLogFilterObject.collection(new VcsLogFilter[]{VcsLogFilterObject.fromRoots(visibleRoots)}));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(32);
        }
        ((FileFilterModel)this.myFilterModel).setFilter(VcsLogFilterObject.collection(new VcsLogFilter[]{VcsLogFilterObject.fromRoot(root)}));
    }

    @NotNull
    @NlsActions.ActionText
    private String getStructureActionText(@NotNull VcsLogStructureFilter filter) {
        if (filter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(33);
        }
        return this.getTextFromFilePaths(filter.getFiles(), VcsLogBundle.message("vcs.log.filter.popup.no.items", new Object[0]), filter.getFiles().isEmpty());
    }

    @NotNull
    @NlsSafe
    private String path2Text(@NotNull FilePath filePath, boolean systemDependent) {
        if (filePath == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(34);
        }
        return StructureFilterPopupComponent.path2Text(filePath, systemDependent, this.getAllRoots());
    }

    @NotNull
    @NlsSafe
    public static String path2Text(@NotNull FilePath filePath, boolean systemDependent, Set<VirtualFile> roots) {
        if (filePath == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(35);
        }
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(roots);
        String path = null;
        if (commonAncestor != null && (path = FileUtil.getRelativePath((String)commonAncestor.getPath(), (String)filePath.getPath(), (char)'/')) != null && systemDependent) {
            path = FileUtil.toSystemDependentName((String)path);
        }
        if (path == null) {
            path = systemDependent ? filePath.getPresentableUrl() : filePath.getPath();
        }
        char separator = StructureFilterPopupComponent.separator(systemDependent);
        String string = path + String.valueOf(filePath.isDirectory() && !StringUtil.endsWithChar((CharSequence)path, (char)separator) ? Character.valueOf(separator) : "");
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private FilePath text2Path(@NotNull String path) {
        if (path == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(37);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        boolean isDirectory = StringUtil.endsWithChar((CharSequence)path, (char)'/');
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(this.getAllRoots());
        if (commonAncestor != null && !FileUtil.isAbsolute((String)FileUtil.toSystemDependentName((String)path))) {
            path = commonAncestor.getPath() + "/" + (String)path;
        }
        if (isDirectory) {
            FilePath filePath = VcsUtil.getFilePath((String)path, (boolean)true);
            if (filePath == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(38);
            }
            return filePath;
        }
        FilePath filePath = VcsUtil.getFilePath((String)path);
        if (filePath == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(39);
        }
        return filePath;
    }

    private static char separator(boolean systemDependent) {
        return systemDependent ? File.separatorChar : (char)'/';
    }

    @NotNull
    private Collection<FilePath> getStructureFilterPaths() {
        VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter((VcsLogFilterCollection)((FileFilterModel)this.myFilterModel).getFilter());
        Collection<Object> collection = structureFilter != null ? structureFilter.getFiles() : Collections.emptyList();
        if (collection == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(40);
        }
        return collection;
    }

    private void setStructureFilter(@NotNull VcsLogStructureFilter newFilter) {
        if (newFilter == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(41);
        }
        ((FileFilterModel)this.myFilterModel).setFilter(VcsLogFilterObject.collection(new VcsLogFilter[]{newFilter}));
        this.myUiProperties.addRecentlyFilteredGroup(PATHS, FileFilterModel.getStructureFilterValues(newFilter));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 13, 14, 15, 16, 20, 28, 29, 36, 38, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 5: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryText";
                break;
            }
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterFiles";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTip";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFilters";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "path2Text";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "text2Path";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureFilterPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromFilePaths";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFilePaths";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setVisible";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setVisibleOnly";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStructureActionText";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "path2Text";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "text2Path";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setStructureFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 13, 14, 15, 16, 20, 28, 29, 36, 38, 39, 40 -> new IllegalStateException(string);
        };
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private final class SelectVisibleRootAction
    extends DumbAwareToggleAction {
        private final Icon mySelectedIcon;
        private final Icon myDeselectedIcon;
        final VirtualFile myRoot;

        SelectVisibleRootAction(VirtualFile root) {
            if (root == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(0);
            }
            super(null, root.getPresentableUrl(), null);
            this.getTemplatePresentation().setText(root.getName(), false);
            this.myRoot = root;
            Color color = StructureFilterPopupComponent.this.myColorManager.getRootColor(this.myRoot);
            this.mySelectedIcon = CheckboxIcon.createAndScaleCheckbox((Color)color, (boolean)true);
            this.myDeselectedIcon = CheckboxIcon.createAndScaleCheckbox((Color)color, (boolean)false);
            this.getTemplatePresentation().setIcon((Icon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)15)));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(2);
            }
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(3);
            }
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e.getModifiers() & SelectVisibleRootAction.getModifier()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        private static int getModifier() {
            return ClientSystemInfo.isMac() ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            boolean isSelected = StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled();
            e.getPresentation().setIcon(isSelected ? this.mySelectedIcon : this.myDeselectedIcon);
            String modifierText = InputEvent.getModifiersExText(SelectVisibleRootAction.getModifier() << 6);
            String tooltip = VcsLogBundle.message("vcs.log.filter.tooltip.click.to.see.only", modifierText, e.getPresentation().getText());
            e.getPresentation().putClientProperty(ActionUtil.TOOLTIP_TEXT, (Object)tooltip);
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.getStructureFilter((VcsLogFilterCollection)((FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class SelectFromHistoryAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter) {
            if (filter == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(0);
            }
            super(StructureFilterPopupComponent.this.getStructureActionText(filter), StructureFilterPopupComponent.this.getTooltipTextForFilePaths(filter.getFiles(), HtmlChunk.text((String)" ")).toString(), null);
            this.myFilter = filter;
            this.myIcon = JBUIScale.scaleIcon((JBScalableIcon)new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15));
            this.myEmptyIcon = JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)15));
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Never);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(1);
            }
            return this.myFilter.equals((Object)StructureFilterPopupComponent.getStructureFilter((VcsLogFilterCollection)((FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()));
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(2);
            }
            ((FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(VcsLogFilterObject.collection(new VcsLogFilter[]{this.myFilter}));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (this.isSelected(e)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private class EditPathsAction
    extends DumbAwareAction {
        EditPathsAction() {
            super(VcsLogBundle.messagePointer("vcs.log.filter.edit.folders", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                EditPathsAction.$$$reportNull$$$0(0);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            List filesPaths = ContainerUtil.sorted(StructureFilterPopupComponent.this.getStructureFilterPaths(), (Comparator)HierarchicalFilePathComparator.NATURAL);
            String oldValue = StringUtil.join((Collection)ContainerUtil.map((Collection)filesPaths, filePath -> StructureFilterPopupComponent.this.path2Text((FilePath)filePath, false)), (String)"\n");
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project, oldValue, new char[]{'\n'});
            JBPopup popup = popupBuilder.createPopup();
            popup.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.isOk()) {
                        List selectedPaths = ContainerUtil.map(popupBuilder.getSelectedValues(), path -> StructureFilterPopupComponent.this.text2Path((String)path));
                        if (selectedPaths.isEmpty()) {
                            ((FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(null);
                        } else {
                            StructureFilterPopupComponent.this.setStructureFilter(VcsLogFilterObject.fromPaths(selectedPaths));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$EditPathsAction$1", "onClosed"));
                }
            });
            popup.showUnderneathOf(StructureFilterPopupComponent.this.getTargetComponent());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EditPathsAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditPathsAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$EditPathsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$EditPathsAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class SelectPathsInTreeAction
    extends DumbAwareAction {
        SelectPathsInTreeAction() {
            super(VcsLogBundle.messagePointer("vcs.log.filter.select.folders", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                SelectPathsInTreeAction.$$$reportNull$$$0(0);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            Set<VirtualFile> roots = ((FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getRoots();
            List files = ContainerUtil.mapNotNull(StructureFilterPopupComponent.this.getStructureFilterPaths(), FilePath::getVirtualFile);
            VcsStructureChooser chooser = new VcsStructureChooser(project, VcsLogBundle.message("vcs.log.select.folder.dialog.title", new Object[0]), files, new ArrayList<VirtualFile>(roots));
            if (chooser.showAndGet()) {
                VcsLogStructureFilter newFilter = VcsLogFilterObject.fromVirtualFiles(chooser.getSelectedFiles());
                StructureFilterPopupComponent.this.setStructureFilter(newFilter);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SelectPathsInTreeAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectPathsInTreeAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectPathsInTreeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectPathsInTreeAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

