/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.ContentAnnotationCache;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

final class ContentAnnotationCacheImpl
implements ContentAnnotationCache {
    private final Cache<HistoryCacheWithRevisionKey, TreeMap<Integer, Long>> cache = Caffeine.newBuilder().maximumSize(50L).build();

    ContentAnnotationCacheImpl() {
    }

    @Override
    @NotNull
    public ThreeState isRecent(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, TextRange range, long boundTime) {
        TreeMap treeMap = (TreeMap)this.cache.getIfPresent((Object)new HistoryCacheWithRevisionKey(VcsContextFactory.getInstance().createFilePathOn(vf), vcsKey, number));
        if (treeMap != null) {
            Map.Entry last = treeMap.floorEntry(range.getEndOffset());
            if (last == null || last.getKey() < range.getStartOffset()) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    ContentAnnotationCacheImpl.$$$reportNull$$$0(0);
                }
                return threeState;
            }
            Map.Entry first = treeMap.ceilingEntry(range.getStartOffset());
            assert (first != null);
            SortedMap interval = treeMap.subMap(first.getKey(), last.getKey());
            for (Map.Entry entry : interval.entrySet()) {
                if ((Long)entry.getValue() < boundTime) continue;
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    ContentAnnotationCacheImpl.$$$reportNull$$$0(1);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ContentAnnotationCacheImpl.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            ContentAnnotationCacheImpl.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    @Override
    public void register(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, FileAnnotation fa) {
        HistoryCacheWithRevisionKey key = new HistoryCacheWithRevisionKey(VcsContextFactory.getInstance().createFilePathOn(vf), vcsKey, number);
        if (this.cache.getIfPresent((Object)key) != null) {
            return;
        }
        long absoluteLimit = System.currentTimeMillis() - VcsContentAnnotationSettings.ourAbsoluteLimit;
        TreeMap<Integer, Long> map = new TreeMap<Integer, Long>();
        int lineCount = fa.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            Date lineDate = fa.getLineDate(i);
            if (lineDate == null) {
                return;
            }
            if (lineDate.getTime() < absoluteLimit) continue;
            map.put(i, lineDate.getTime());
        }
        this.cache.put((Object)key, map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/contentAnnotation/ContentAnnotationCacheImpl", "isRecent"));
    }
}

