/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.temptable;

import java.util.function.Function;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class StandardTemporaryTableExporter
implements TemporaryTableExporter {
    private final Dialect dialect;

    public StandardTemporaryTableExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Deprecated(forRemoval=true, since="7.1")
    protected String getCreateCommand() {
        return this.dialect.getTemporaryTableCreateCommand();
    }

    protected String getCreateCommand(TemporaryTableStrategy temporaryTableStrategy) {
        return temporaryTableStrategy.getTemporaryTableCreateCommand();
    }

    @Deprecated(forRemoval=true, since="7.1")
    protected String getCreateOptions() {
        return this.dialect.getTemporaryTableCreateOptions();
    }

    protected String getCreateOptions(TemporaryTableStrategy temporaryTableStrategy) {
        return temporaryTableStrategy.getTemporaryTableCreateOptions();
    }

    @Deprecated(forRemoval=true, since="7.1")
    protected String getDropCommand() {
        return this.dialect.getTemporaryTableDropCommand();
    }

    protected String getDropCommand(TemporaryTableStrategy temporaryTableStrategy) {
        return temporaryTableStrategy.getTemporaryTableDropCommand();
    }

    @Deprecated(forRemoval=true, since="7.1")
    protected String getTruncateTableCommand() {
        return this.dialect.getTemporaryTableTruncateCommand();
    }

    protected String getTruncateTableCommand(TemporaryTableStrategy temporaryTableStrategy) {
        return temporaryTableStrategy.getTemporaryTableTruncateCommand();
    }

    private TemporaryTableStrategy getDefaultTemporaryTableStrategy(TemporaryTable temporaryTable) {
        TemporaryTableStrategy temporaryTableStrategy;
        switch (temporaryTable.getTemporaryTableKind()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LOCAL: {
                TemporaryTableStrategy temporaryTableStrategy2 = this.dialect.getLocalTemporaryTableStrategy();
                break;
            }
            case GLOBAL: {
                TemporaryTableStrategy temporaryTableStrategy2 = this.dialect.getGlobalTemporaryTableStrategy();
                break;
            }
            case PERSISTENT: {
                TemporaryTableStrategy temporaryTableStrategy2 = temporaryTableStrategy = this.dialect.getPersistentTemporaryTableStrategy();
            }
        }
        if (temporaryTableStrategy == null) {
            throw new IllegalStateException("Dialect returns null TemporaryTableStrategy for temporary table " + temporaryTable.getQualifiedTableName() + " of type " + String.valueOf((Object)temporaryTable.getTemporaryTableKind()));
        }
        return temporaryTableStrategy;
    }

    @Override
    public String getSqlCreateCommand(TemporaryTable temporaryTable) {
        TemporaryTableStrategy temporaryTableStrategy = this.getDefaultTemporaryTableStrategy(temporaryTable);
        StringBuilder buffer = new StringBuilder(this.getCreateCommand(temporaryTableStrategy)).append(' ');
        buffer.append(temporaryTable.getQualifiedTableName());
        buffer.append('(');
        for (TemporaryTableColumn column : temporaryTable.getColumnsForExport()) {
            buffer.append(column.getColumnName()).append(' ');
            int sqlTypeCode = column.getJdbcMapping().getJdbcType().getDdlTypeCode();
            String databaseTypeName = column.getSqlTypeDefinition();
            buffer.append(databaseTypeName);
            String columnAnnotation = temporaryTableStrategy.getCreateTemporaryTableColumnAnnotation(sqlTypeCode);
            if (!columnAnnotation.isEmpty()) {
                buffer.append(' ').append(columnAnnotation);
            }
            if (temporaryTableStrategy.supportsTemporaryTableNullConstraint()) {
                if (column.isNullable()) {
                    String nullColumnString = this.dialect.getNullColumnString(databaseTypeName);
                    if (!databaseTypeName.contains(nullColumnString)) {
                        buffer.append(nullColumnString);
                    }
                } else {
                    buffer.append(" not null");
                }
            }
            buffer.append(", ");
        }
        if (temporaryTableStrategy.supportsTemporaryTablePrimaryKey()) {
            buffer.append("primary key (");
            for (TemporaryTableColumn column : temporaryTable.getColumnsForExport()) {
                if (!column.isPrimaryKey()) continue;
                buffer.append(column.getColumnName());
                buffer.append(", ");
            }
            buffer.setLength(buffer.length() - 2);
            buffer.append(')');
        } else {
            buffer.setLength(buffer.length() - 2);
        }
        buffer.append(')');
        String createOptions = this.getCreateOptions(temporaryTableStrategy);
        if (createOptions != null) {
            buffer.append(' ').append(createOptions);
        }
        return buffer.toString();
    }

    @Override
    public String getSqlDropCommand(TemporaryTable temporaryTable) {
        TemporaryTableStrategy temporaryTableStrategy = this.getDefaultTemporaryTableStrategy(temporaryTable);
        return this.getDropCommand(temporaryTableStrategy) + " " + temporaryTable.getQualifiedTableName();
    }

    @Override
    public String getSqlTruncateCommand(TemporaryTable temporaryTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, SharedSessionContractImplementor session) {
        TemporaryTableStrategy temporaryTableStrategy = this.getDefaultTemporaryTableStrategy(temporaryTable);
        if (temporaryTable.getSessionUidColumn() != null) {
            ParameterMarkerStrategy parameterMarkerStrategy = session.getSessionFactory().getParameterMarkerStrategy();
            return this.getTruncateTableCommand(temporaryTableStrategy) + " " + temporaryTable.getQualifiedTableName() + " where " + temporaryTable.getSessionUidColumn().getColumnName() + " = " + parameterMarkerStrategy.createMarker(1, null);
        }
        return this.getTruncateTableCommand(temporaryTableStrategy) + " " + temporaryTable.getQualifiedTableName();
    }
}

