/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.admin.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.validator.constraints.URL;
import org.keycloak.representations.admin.v2.BaseRepresentation;
import org.keycloak.representations.admin.v2.validation.CreateClient;

public class ClientRepresentation
extends BaseRepresentation {
    public static final String OIDC = "openid-connect";
    @NotBlank(groups={CreateClient.class})
    @JsonPropertyDescription(value="ID uniquely identifying this client")
    private String clientId;
    @JsonPropertyDescription(value="Human readable name of the client")
    private String displayName;
    @JsonPropertyDescription(value="Human readable description of the client")
    private String description;
    @JsonProperty(defaultValue="openid-connect")
    @JsonPropertyDescription(value="The protocol used to communicate with the client")
    private String protocol;
    @JsonPropertyDescription(value="Whether this client is enabled")
    private Boolean enabled;
    @URL
    @JsonPropertyDescription(value="URL to the application's homepage that is represented by this client")
    private String appUrl;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="URLs that the browser can redirect to after login")
    private Set<@NotBlank @URL(message="Each redirect URL must be valid") String> appRedirectUrls = new LinkedHashSet<String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Login flows that are enabled for this client")
    private Set<@NotBlank String> loginFlows = new LinkedHashSet<String>();
    @Valid
    @JsonPropertyDescription(value="Authentication configuration for this client")
    private Auth auth;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Web origins that are allowed to make requests to this client")
    private Set<@NotBlank String> webOrigins = new LinkedHashSet<String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Roles associated with this client")
    private Set<@NotBlank String> roles = new LinkedHashSet<String>();
    @Valid
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Service account configuration for this client")
    private ServiceAccount serviceAccount;

    public ClientRepresentation() {
    }

    public ClientRepresentation(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public Set<String> getAppRedirectUrls() {
        return this.appRedirectUrls;
    }

    public void setAppRedirectUrls(Set<String> appRedirectUrls) {
        this.appRedirectUrls = appRedirectUrls;
    }

    public Set<String> getLoginFlows() {
        return this.loginFlows;
    }

    public void setLoginFlows(Set<String> loginFlows) {
        this.loginFlows = loginFlows;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public Set<String> getWebOrigins() {
        return this.webOrigins;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.webOrigins = webOrigins;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public ServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientRepresentation that = (ClientRepresentation)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.appUrl, that.appUrl) && Objects.equals(this.appRedirectUrls, that.appRedirectUrls) && Objects.equals(this.loginFlows, that.loginFlows) && Objects.equals(this.auth, that.auth) && Objects.equals(this.webOrigins, that.webOrigins) && Objects.equals(this.roles, that.roles) && Objects.equals(this.serviceAccount, that.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.displayName, this.description, this.protocol, this.enabled, this.appUrl, this.appRedirectUrls, this.loginFlows, this.auth, this.webOrigins, this.roles, this.serviceAccount);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class Auth {
        @JsonPropertyDescription(value="Whether authentication is enabled for this client")
        private Boolean enabled;
        @JsonPropertyDescription(value="Which authentication method is used for this client")
        private String method;
        @JsonPropertyDescription(value="Secret used to authenticate this client with Secret authentication")
        private String secret;
        @JsonPropertyDescription(value="Public key used to authenticate this client with Signed JWT authentication")
        private String certificate;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Auth)) {
                return false;
            }
            Auth auth = (Auth)o;
            return Objects.equals(this.enabled, auth.enabled) && Objects.equals(this.method, auth.method) && Objects.equals(this.secret, auth.secret) && Objects.equals(this.certificate, auth.certificate);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.method, this.secret, this.certificate);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class ServiceAccount {
        @JsonPropertyDescription(value="Whether the service account is enabled")
        private Boolean enabled;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Roles assigned to the service account")
        private Set<String> roles = new LinkedHashSet<String>();

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public void setRoles(Set<String> roles) {
            this.roles = roles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ServiceAccount)) {
                return false;
            }
            ServiceAccount that = (ServiceAccount)o;
            return Objects.equals(this.enabled, that.enabled) && Objects.equals(this.roles, that.roles);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.roles);
        }
    }
}

