/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.ImmutableMap;

public enum Format {
    JDBC("jdbc"),
    CSV("csv"),
    RAW("raw"),
    VIZ("viz"),
    SIMPLE("simple"),
    STANDARD("standard"),
    EXTENDED("extended"),
    COST("cost"),
    YAML("yaml");

    private final String formatName;
    public static final Map<String, Format> RESPONSE_FORMATS;
    public static final Map<String, Format> EXPLAIN_FORMATS;

    public static Optional<Format> of(String formatName) {
        String format = Strings.isNullOrEmpty((String)formatName) ? "jdbc" : formatName.toLowerCase();
        return Optional.ofNullable(RESPONSE_FORMATS.getOrDefault(format, null));
    }

    public static Optional<Format> ofExplain(String formatName) {
        String format = Strings.isNullOrEmpty((String)formatName) ? "standard" : formatName.toLowerCase();
        return Optional.ofNullable(EXPLAIN_FORMATS.getOrDefault(format, null));
    }

    @Generated
    private Format(String formatName) {
        this.formatName = formatName;
    }

    @Generated
    public String getFormatName() {
        return this.formatName;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Format.JDBC.formatName, (Object)JDBC);
        builder.put((Object)Format.CSV.formatName, (Object)CSV);
        builder.put((Object)Format.RAW.formatName, (Object)RAW);
        builder.put((Object)Format.VIZ.formatName, (Object)VIZ);
        RESPONSE_FORMATS = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put((Object)Format.SIMPLE.formatName, (Object)SIMPLE);
        builder.put((Object)Format.STANDARD.formatName, (Object)STANDARD);
        builder.put((Object)Format.EXTENDED.formatName, (Object)EXTENDED);
        builder.put((Object)Format.COST.formatName, (Object)COST);
        builder.put((Object)Format.YAML.formatName, (Object)YAML);
        EXPLAIN_FORMATS = builder.build();
    }
}

