/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.util.SafeSecurityInjector;
import org.opensearch.timeseries.util.SecurityUtil;

public class TimeSeriesSafeSecurityInjector
extends SafeSecurityInjector {
    private static final Logger LOG = LogManager.getLogger(TimeSeriesSafeSecurityInjector.class);
    private NodeStateManager nodeStateManager;
    private AnalysisType context;

    public TimeSeriesSafeSecurityInjector(String configId, Settings settings, ThreadContext tc, NodeStateManager stateManager, AnalysisType context) {
        super(configId, settings, tc);
        this.nodeStateManager = stateManager;
        this.context = context;
    }

    public void injectUserRolesFromConfig(ActionListener<Void> injectListener) {
        if (Strings.isEmpty((CharSequence)this.id)) {
            LOG.debug("Empty id");
            injectListener.onResponse(null);
            return;
        }
        if (!this.shouldInject()) {
            LOG.debug("Don't need to inject");
            injectListener.onResponse(null);
            return;
        }
        ActionListener getConfigListener = ActionListener.wrap(configOp -> {
            if (!configOp.isPresent()) {
                injectListener.onFailure((Exception)new EndRunException(this.id, "Config is not available.", false));
                return;
            }
            Config config = (Config)configOp.get();
            User userInfo = SecurityUtil.getUserFromConfig(config, this.settings);
            this.inject(userInfo.getName(), userInfo.getRoles());
            injectListener.onResponse(null);
        }, arg_0 -> injectListener.onFailure(arg_0));
        this.nodeStateManager.getConfig(this.id, this.context, false, (ActionListener<Optional<? extends Config>>)getConfigListener);
    }

    public void injectUserRoles(User user) {
        if (user == null) {
            LOG.debug("null user");
            return;
        }
        if (this.shouldInject()) {
            this.inject(user.getName(), user.getRoles());
        }
    }
}

