/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.timingdiagram.PlayerAnalog;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandAnalog
extends SingleLineCommand2<TimingDiagram> {
    public CommandAnalog() {
        super(CommandAnalog.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandAnalog.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(1, "COMPACT", "(compact)"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("analog"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "FULL", "[%g]([^%g]+)[%g]"), StereotypePattern.optional("STEREOTYPE"), new RegexOptional((IRegex)new RegexConcat(new RegexOr(new RegexLeaf("between"), new RegexLeaf("from")), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "START", "(-?[0-9]*\\.?[0-9]+)"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("and"), new RegexLeaf("to")), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "END", "(-?[0-9]*\\.?[0-9]+)"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "CODE", "([%pLN_.@]+)"), StereotypePattern.optional("STEREOTYPE2"), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String compact = arg.get("COMPACT", 0);
        String code = arg.get("CODE", 0);
        String full = arg.get("FULL", 0);
        Stereotype stereotype = null;
        if (arg.get("STEREOTYPE", 0) != null) {
            stereotype = Stereotype.build(arg.get("STEREOTYPE", 0));
        } else if (arg.get("STEREOTYPE2", 0) != null) {
            stereotype = Stereotype.build(arg.get("STEREOTYPE2", 0));
        }
        PlayerAnalog player = diagram.createPlayerAnalog(code, full, compact != null, stereotype);
        String start = arg.get("START", 0);
        String end = arg.get("END", 0);
        if (start != null && end != null) {
            player.setBounds(start, end);
        }
        return CommandExecutionResult.ok();
    }
}

