/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class NavBarListWrapper
extends JBScrollPane
implements UiDataProvider {
    private static final int MAX_SIZE = 20;
    private final JList myList;

    public NavBarListWrapper(final JList list) {
        super((Component)list);
        list.addMouseMotionListener(new MouseMotionAdapter(this){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                    Point point = e.getPoint();
                    int index = list.locationToIndex(point);
                    list.setSelectedIndex(index);
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        ScrollingUtil.installActions((JList)list);
        this.myList = list;
        if (this.isPopupHeightStatic()) {
            list.setVisibleRowCount(0);
            this.updateViewportPreferredSizeIfNeeded();
        } else {
            list.setVisibleRowCount(20);
        }
    }

    public void updateViewportPreferredSizeIfNeeded() {
        if (this.isPopupHeightStatic()) {
            this.getViewport().setPreferredSize(this.myList.getPreferredSize());
        }
    }

    private boolean isPopupHeightStatic() {
        if (ExperimentalUI.isNewUI()) {
            return false;
        }
        int modelSize = this.myList.getModel().getSize();
        return modelSize > 0 && modelSize <= 20;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            NavBarListWrapper.$$$reportNull$$$0(0);
        }
        sink.set(PlatformCoreDataKeys.SELECTED_ITEM, this.myList.getSelectedValue());
        sink.set(PlatformCoreDataKeys.SELECTED_ITEMS, (Object)this.myList.getSelectedValues());
    }

    public void setBorder(Border border) {
        if (this.myList != null) {
            this.myList.setBorder(border);
        }
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myList, true));
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.myList.addMouseListener(l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/platform/navbar/frontend/ui/NavBarListWrapper", "uiDataSnapshot"));
    }
}

