/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIaqo {
    T4CConnection connection;
    T4CMAREngine meg;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private byte[] payload;
    private AQMessagePropertiesI aqMessageProperties;
    private JMSDequeueOptions jmsDequeueOptions;
    private byte[] outMsgId;
    private int aqxaqopt;
    private JMSEnqueueOptions jmsEnqueueOptions;
    private boolean isAQMsg;
    private AQEnqueueOptions aqEnqueueOptions;
    private AQDequeueOptions aqDequeueOptions;
    private boolean isRawQueue;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    T4CTTIaqo(T4CConnection _connection, int _aqxaqopt, JMSEnqueueOptions _enqueueOptions, AQMessagePropertiesI _aqMessageProperties, JMSDequeueOptions _dequeueOptions, boolean _isRawQueue) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$4, null, _connection, _aqxaqopt, _enqueueOptions, _aqMessageProperties, _dequeueOptions, _isRawQueue);
            }
            this.payload = null;
            this.aqMessageProperties = null;
            this.jmsDequeueOptions = null;
            this.outMsgId = null;
            this.aqxaqopt = 0;
            this.isAQMsg = false;
            this.aqEnqueueOptions = null;
            this.aqDequeueOptions = null;
            this.isRawQueue = false;
            this.initCommon(_connection, _aqxaqopt, _aqMessageProperties, _isRawQueue);
            this.jmsEnqueueOptions = _enqueueOptions;
            this.jmsDequeueOptions = _dequeueOptions;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CTTIaqo(T4CConnection _connection, int _aqxaqopt, AQEnqueueOptions _aqEnqueueOptions, AQMessagePropertiesI _aqMessageProperties, AQDequeueOptions _aqDequeueOptions, boolean _isRawQueue) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$5, null, _connection, _aqxaqopt, _aqEnqueueOptions, _aqMessageProperties, _aqDequeueOptions, _isRawQueue);
            }
            this.payload = null;
            this.aqMessageProperties = null;
            this.jmsDequeueOptions = null;
            this.outMsgId = null;
            this.aqxaqopt = 0;
            this.isAQMsg = false;
            this.aqEnqueueOptions = null;
            this.aqDequeueOptions = null;
            this.isRawQueue = false;
            this.isAQMsg = true;
            this.initCommon(_connection, _aqxaqopt, _aqMessageProperties, _isRawQueue);
            this.aqEnqueueOptions = _aqEnqueueOptions;
            this.aqDequeueOptions = _aqDequeueOptions;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initCommon(T4CConnection t4CConnection, int n2, AQMessagePropertiesI aQMessagePropertiesI, boolean bl) {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _isRawQueue;
            void _aqMessageProperties;
            void _aqxaqopt;
            void _connection;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$0, this, t4CConnection, n2, aQMessagePropertiesI, bl);
            }
            this.connection = _connection;
            this.meg = this.connection.getMarshalEngine();
            this.aqxaqopt = _aqxaqopt;
            this.aqMessageProperties = _aqMessageProperties;
            this.toh = new T4Ctoh((T4CConnection)_connection);
            this.aqm = new T4CTTIaqm(this.connection, this.toh);
            this.isRawQueue = _isRawQueue;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void unmarshal() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int aqoexl;
            int aqorel;
            int msgPropLength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if ((msgPropLength = this.meg.unmarshalUB2()) > 0) {
                short len = this.meg.unmarshalUB1();
                this.aqm.initToDefaultValues();
                this.aqm.receive();
                this.aqMessageProperties.setPriority(this.aqm.aqmpri);
                this.aqMessageProperties.setDelay(this.aqm.aqmdel);
                this.aqMessageProperties.setExpiration(this.aqm.aqmexp);
                if (this.aqm.aqmcorBytes != null) {
                    String aqmcor = this.meg.conv.CharBytesToString(this.aqm.aqmcorBytes, this.aqm.aqmcorBytesLength, true);
                    this.aqMessageProperties.setCorrelation(aqmcor);
                }
                this.aqMessageProperties.setAttempts(this.aqm.aqmatt);
                if (this.aqm.aqmeqnBytes != null) {
                    String aqmeqn = this.meg.conv.CharBytesToString(this.aqm.aqmeqnBytes, this.aqm.aqmeqnBytesLength, true);
                    this.aqMessageProperties.setExceptionQueue(aqmeqn);
                }
                this.aqMessageProperties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
                if (this.aqm.aqmeqt != null) {
                    this.aqMessageProperties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
                }
                AQAgentI senderAgent = new AQAgentI();
                if (this.aqm.senderAgentName != null) {
                    senderAgent.setName(this.meg.conv.CharBytesToString(this.aqm.senderAgentName, this.aqm.senderAgentNameLength, true));
                }
                if (this.aqm.senderAgentAddress != null) {
                    senderAgent.setAddress(this.meg.conv.CharBytesToString(this.aqm.senderAgentAddress, this.aqm.senderAgentAddressLength, true));
                }
                senderAgent.setProtocol(this.aqm.senderAgentProtocol);
                this.aqMessageProperties.setSender(senderAgent);
                this.aqMessageProperties.setPreviousQueueMessageId(this.aqm.originalMsgId);
                this.aqMessageProperties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
                if (this.aqm.aqmetiBytes != null) {
                    String aqmeti = this.meg.conv.CharBytesToString(this.aqm.aqmetiBytes, this.aqm.aqmetiBytes.length, true);
                    this.aqMessageProperties.setTransactionGroup(aqmeti);
                }
            }
            if ((aqorel = this.meg.unmarshalUB2()) > 0) {
                // empty if block
            }
            int lengthOfPayload = this.meg.unmarshalUB2();
            if (this.aqxaqopt == 2) {
                this.toh.unmarshal(this.meg);
                lengthOfPayload = this.toh.imageLength;
            }
            if (lengthOfPayload > 0) {
                int bufferToAllocate = lengthOfPayload;
                if (this.isRawQueue) {
                    if (lengthOfPayload > 4) {
                        bufferToAllocate -= 4;
                    }
                    int maxBufLength = this.isAQMsg ? this.aqDequeueOptions.getMaximumBufferLength() : bufferToAllocate;
                    bufferToAllocate = Math.min(bufferToAllocate, maxBufLength);
                    byte[] image = new byte[bufferToAllocate];
                    int[] intAr = new int[1];
                    if (lengthOfPayload > 4) {
                        this.meg.unmarshalCLR(image, 0, intAr, image.length, 4);
                    } else {
                        this.meg.unmarshalCLR(image, 0, intAr, image.length);
                    }
                    this.payload = image;
                } else {
                    byte[] image = new byte[bufferToAllocate];
                    int[] intAr = new int[1];
                    this.meg.unmarshalCLR(image, 0, intAr, image.length);
                    this.payload = image;
                }
            }
            int msgIdLen = this.meg.unmarshalSWORD();
            if ((this.aqxaqopt == 1 && !this.isAQMsg && this.jmsEnqueueOptions != null && this.jmsEnqueueOptions.isRetrieveMessageId() || this.aqxaqopt == 2 && !this.isAQMsg && this.jmsDequeueOptions != null && this.jmsDequeueOptions.isRetrieveMessageId() || this.aqxaqopt == 1 && this.isAQMsg && this.aqEnqueueOptions != null && this.aqEnqueueOptions.getRetrieveMessageId() || this.aqxaqopt == 2 && this.isAQMsg && this.aqDequeueOptions != null && this.aqDequeueOptions.getRetrieveMessageId()) && msgIdLen > 0) {
                byte[] aqomsi = new byte[msgIdLen];
                int[] readBytes = new int[1];
                this.meg.unmarshalCLR(aqomsi, 0, readBytes);
                this.outMsgId = aqomsi;
            }
            if ((aqoexl = this.meg.unmarshalUB2()) > 0) {
                // empty if block
            }
            int aqolac = this.meg.unmarshalUB2();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] getMsgId() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$2, this, new Object[0]);
            }
            byte[] byArray = this.outMsgId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$2, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$2, this, null);
            }
            return this.outMsgId;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] getPayload() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$3, this, new Object[0]);
            }
            byte[] byArray = this.payload;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$3, this, null);
            }
            return this.payload;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIaqo.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = T4CTTIaqo.class.getDeclaredConstructor(T4CConnection.class, Integer.TYPE, AQEnqueueOptions.class, AQMessagePropertiesI.class, AQDequeueOptions.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIaqo.class.getDeclaredConstructor(T4CConnection.class, Integer.TYPE, JMSEnqueueOptions.class, AQMessagePropertiesI.class, JMSDequeueOptions.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIaqo.class.getDeclaredMethod("getPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIaqo.class.getDeclaredMethod("getMsgId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIaqo.class.getDeclaredMethod("unmarshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIaqo.class.getDeclaredMethod("initCommon", T4CConnection.class, Integer.TYPE, AQMessagePropertiesI.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

