/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import schemacrawler.ermodel.implementation.MutableERModel;
import schemacrawler.ermodel.implementation.MutableEntity;
import schemacrawler.ermodel.implementation.MutableEntitySubtype;
import schemacrawler.ermodel.implementation.MutableManyToManyRelationship;
import schemacrawler.ermodel.implementation.MutableTableReferenceRelationship;
import schemacrawler.ermodel.implementation.TableEntityModelInferrer;
import schemacrawler.ermodel.model.ERModel;
import schemacrawler.ermodel.model.EntityType;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.ermodel.weakassociations.WeakAssociation;
import schemacrawler.ermodel.weakassociations.WeakAssociationsAnalyzer;
import schemacrawler.ermodel.weakassociations.WeakAssociationsAnalyzerBuilder;
import schemacrawler.ermodel.weakassociations.WeakColumnReference;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.Builder;

public class ERModelBuilder
implements Builder<ERModel> {
    private final Catalog catalog;
    final MutableERModel erModel;
    final Map<NamedObjectKey, TableEntityModelInferrer> inferrerMap;
    final Map<NamedObjectKey, MutableEntity> entityMap;
    final WeakAssociationsAnalyzer weakAssociationsAnalyzer;

    public ERModelBuilder(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.inferrerMap = new HashMap<NamedObjectKey, TableEntityModelInferrer>();
        this.entityMap = new HashMap<NamedObjectKey, MutableEntity>();
        this.erModel = new MutableERModel();
        this.weakAssociationsAnalyzer = WeakAssociationsAnalyzerBuilder.builder(catalog.getTables()).withIdMatcher().withExtensionTableMatcher().build();
    }

    @Override
    public ERModel build() {
        for (Table table : this.catalog.getTables()) {
            this.erModel.addTable(table);
            if (MetaDataUtility.isPartial(table)) continue;
            this.lookupOrCreateEntity(table);
            TableEntityModelInferrer modelInferrer = this.getModelInferrer(table);
            if (modelInferrer.inferBridgeTable()) {
                MutableManyToManyRelationship rel = new MutableManyToManyRelationship(table);
                ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>(table.getForeignKeys());
                if (foreignKeys.size() != 2) continue;
                Table leftTable = ((ForeignKey)foreignKeys.get(0)).getPrimaryKeyTable();
                rel.setLeftEntity(this.lookupOrCreateEntity(leftTable));
                Table rightTable = ((ForeignKey)foreignKeys.get(1)).getPrimaryKeyTable();
                rel.setRightEntity(this.lookupOrCreateEntity(rightTable));
                this.erModel.addRelationship(rel);
                continue;
            }
            for (ForeignKey fk : table.getImportedForeignKeys()) {
                MutableTableReferenceRelationship rel = this.createRelationship(fk);
                this.erModel.addRelationship(rel);
            }
        }
        Collection<WeakColumnReference> weakReferences = this.weakAssociationsAnalyzer.analyzeTables();
        for (WeakColumnReference weakReference : weakReferences) {
            WeakAssociation weakAssociation = new WeakAssociation(weakReference);
            MutableTableReferenceRelationship rel = this.createRelationship(weakAssociation);
            this.erModel.addWeakRelationship(rel);
        }
        return this.erModel;
    }

    private MutableTableReferenceRelationship createRelationship(TableReference tableReference) {
        TableEntityModelInferrer modelInferrer = this.getModelInferrer(tableReference.getForeignKeyTable());
        MutableTableReferenceRelationship rel = new MutableTableReferenceRelationship(tableReference);
        RelationshipCardinality cardinality = modelInferrer.inferCardinality(tableReference);
        rel.setCardinality(cardinality);
        Table leftTable = tableReference.getForeignKeyTable();
        rel.setLeftEntity(this.lookupOrCreateEntity(leftTable));
        Table rightTable = tableReference.getPrimaryKeyTable();
        rel.setRightEntity(this.lookupOrCreateEntity(rightTable));
        return rel;
    }

    private TableEntityModelInferrer getModelInferrer(Table table) {
        return this.inferrerMap.computeIfAbsent(table.key(), key -> new TableEntityModelInferrer(table));
    }

    private MutableEntity lookupOrCreateEntity(Table table) {
        return this.entityMap.computeIfAbsent(table.key(), key -> {
            MutableEntity newEntity;
            TableEntityModelInferrer modelInferrer = this.getModelInferrer(table);
            EntityType entityType = modelInferrer.inferEntityType();
            if (entityType != EntityType.subtype) {
                newEntity = new MutableEntity(table);
                newEntity.setEntityType(entityType);
            } else {
                newEntity = new MutableEntitySubtype(table);
                newEntity.setEntityType(entityType);
                Table superTypeTable = modelInferrer.inferSuperType().get();
                ((MutableEntitySubtype)newEntity).setSupertype(this.lookupOrCreateEntity(superTypeTable));
            }
            this.erModel.addEntity(newEntity);
            return newEntity;
        });
    }
}

