/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import java.sql.SQLException;
import java.text.BreakIterator;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.regex.Pattern;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.escape.FBEscapedCallParser;
import org.firebirdsql.jdbc.escape.FBEscapedFunctionHelper;
import org.firebirdsql.jdbc.escape.FBSQLParseException;

public final class FBEscapedParser {
    private static final String ESCAPE_CALL_KEYWORD = "call";
    private static final String ESCAPE_CALL_KEYWORD3 = "?";
    private static final String ESCAPE_DATE_KEYWORD = "d";
    private static final String ESCAPE_TIME_KEYWORD = "t";
    private static final String ESCAPE_TIMESTAMP_KEYWORD = "ts";
    private static final String ESCAPE_FUNCTION_KEYWORD = "fn";
    private static final String ESCAPE_ESCAPE_KEYWORD = "escape";
    private static final String ESCAPE_OUTERJOIN_KEYWORD = "oj";
    private static final String ESCAPE_LIMIT_KEYWORD = "limit";
    private static final Pattern CHECK_ESCAPE_PATTERN = Pattern.compile("\\{(?:(?:\\?\\s*=\\s*)?call|d|ts?|escape|fn|oj|limit)\\s", 2);
    private static final String LIMIT_OFFSET_CLAUSE = " offset ";

    private FBEscapedParser() {
    }

    private static boolean checkForEscapes(String sql) {
        return CHECK_ESCAPE_PATTERN.matcher(sql).find();
    }

    public static String toNativeSql(String sql) throws SQLException {
        return FBEscapedParser.parse(sql);
    }

    public static String parse(String sql) throws SQLException {
        if (!FBEscapedParser.checkForEscapes(sql)) {
            return sql;
        }
        ParserState state = ParserState.INITIAL_STATE;
        ArrayDeque<StringBuilder> bufferStack = new ArrayDeque<StringBuilder>(8);
        int sqlLength = sql.length();
        StringBuilder buffer = new StringBuilder(sqlLength);
        block7: for (int i = 0; i < sqlLength; ++i) {
            char currentChar = sql.charAt(i);
            state = state.nextState(currentChar);
            switch (state) {
                case INITIAL_STATE: {
                    continue block7;
                }
                case NORMAL_STATE: 
                case LITERAL_STATE: 
                case START_LINE_COMMENT: 
                case LINE_COMMENT: 
                case START_BLOCK_COMMENT: 
                case BLOCK_COMMENT: 
                case END_BLOCK_COMMENT: 
                case POSSIBLE_Q_LITERAL_ENTER: {
                    buffer.append(currentChar);
                    continue block7;
                }
                case ESCAPE_ENTER_STATE: {
                    bufferStack.push(buffer);
                    buffer = new StringBuilder();
                    continue block7;
                }
                case ESCAPE_EXIT_STATE: {
                    if (bufferStack.isEmpty()) {
                        throw new FBSQLParseException("Unbalanced JDBC escape, too many '}'");
                    }
                    String escapeText = buffer.toString();
                    buffer = (StringBuilder)bufferStack.pop();
                    FBEscapedParser.escapeToNative(buffer, escapeText);
                    continue block7;
                }
                case Q_LITERAL_START: {
                    buffer.append(currentChar);
                    if (++i >= sqlLength) {
                        throw new FBSQLParseException("Unexpected end of string at parser state " + String.valueOf((Object)state));
                    }
                    char alternateStartChar = sql.charAt(i);
                    buffer.append(alternateStartChar);
                    char alternateEndChar = FBEscapedParser.qLiteralEndChar(alternateStartChar);
                    ++i;
                    while (i < sqlLength) {
                        currentChar = sql.charAt(i);
                        buffer.append(currentChar);
                        if (currentChar == alternateEndChar && i + 1 < sqlLength && sql.charAt(i + 1) == '\'') {
                            state = ParserState.Q_LITERAL_END;
                            break;
                        }
                        ++i;
                    }
                    if (i != sqlLength) continue block7;
                    throw new FBSQLParseException("Unexpected end of string at parser state " + String.valueOf((Object)state));
                }
                default: {
                    throw new FBSQLParseException("Unexpected parser state " + String.valueOf((Object)state));
                }
            }
        }
        if (!bufferStack.isEmpty()) {
            throw new FBSQLParseException("Unbalanced JDBC escape, too many '{'");
        }
        return buffer.toString();
    }

    private static char qLiteralEndChar(char startChar) {
        return switch (startChar) {
            case '(' -> ')';
            case '{' -> '}';
            case '[' -> ']';
            case '<' -> '>';
            default -> startChar;
        };
    }

    private static void processEscaped(String escaped, StringBuilder keyword, StringBuilder payload) {
        int payloadEnd;
        int payloadStart;
        assert (keyword.isEmpty() && payload.isEmpty()) : "StringBuilders keyword and payload should be empty";
        BreakIterator iterator = BreakIterator.getWordInstance();
        iterator.setText(escaped);
        int keyStart = iterator.first();
        int keyEnd = iterator.next();
        keyword.append(escaped, keyStart, keyEnd);
        for (payloadStart = keyEnd; payloadStart < escaped.length() - 1 && escaped.charAt(payloadStart) <= ' '; ++payloadStart) {
        }
        for (payloadEnd = escaped.length(); payloadEnd > payloadStart && escaped.charAt(payloadEnd - 1) <= ' '; --payloadEnd) {
        }
        payload.append(escaped, payloadStart, payloadEnd);
    }

    private static void escapeToNative(StringBuilder target, String escaped) throws SQLException {
        String keywordStr;
        StringBuilder keyword = new StringBuilder();
        StringBuilder payload = new StringBuilder(Math.max(16, escaped.length()));
        FBEscapedParser.processEscaped(escaped, keyword, payload);
        switch (keywordStr = keyword.toString().toLowerCase(Locale.ROOT)) {
            case "call": {
                FBEscapedParser.convertProcedureCall(target, "{" + String.valueOf(keyword) + " " + String.valueOf(payload) + "}");
                break;
            }
            case "?": {
                FBEscapedParser.convertProcedureCall(target, "{?" + String.valueOf(payload) + "}");
                break;
            }
            case "d": {
                FBEscapedParser.toDateString(target, payload);
                break;
            }
            case "escape": {
                FBEscapedParser.convertEscapeString(target, payload);
                break;
            }
            case "fn": {
                FBEscapedParser.convertEscapedFunction(target, payload);
                break;
            }
            case "oj": {
                FBEscapedParser.convertOuterJoin(target, payload);
                break;
            }
            case "t": {
                FBEscapedParser.toTimeString(target, payload);
                break;
            }
            case "ts": {
                FBEscapedParser.toTimestampString(target, payload);
                break;
            }
            case "limit": {
                FBEscapedParser.convertLimitString(target, payload);
                break;
            }
            default: {
                throw new FBSQLParseException("Unknown keyword " + keywordStr + " for escaped syntax.");
            }
        }
    }

    private static void toDateString(StringBuilder target, CharSequence dateStr) {
        target.append("DATE ").append(dateStr);
    }

    private static void toTimeString(StringBuilder target, CharSequence timeStr) {
        target.append("TIME ").append(timeStr);
    }

    private static void toTimestampString(StringBuilder target, CharSequence timestampStr) {
        target.append("TIMESTAMP ").append(timestampStr);
    }

    private static void convertProcedureCall(StringBuilder target, String procedureCall) throws SQLException {
        FBEscapedCallParser tempParser = new FBEscapedCallParser();
        FBProcedureCall call = tempParser.parseCall(procedureCall);
        call.checkParameters();
        target.append(call.getSQL(false));
    }

    private static void convertOuterJoin(StringBuilder target, CharSequence outerJoin) {
        target.append(outerJoin);
    }

    private static void convertEscapeString(StringBuilder target, CharSequence escapeString) {
        target.append("ESCAPE ").append(escapeString);
    }

    private static void convertLimitString(StringBuilder target, CharSequence limitClause) throws FBSQLParseException {
        String limitEscape = limitClause.toString().toLowerCase(Locale.ROOT);
        int offsetStart = limitEscape.indexOf(LIMIT_OFFSET_CLAUSE);
        if (offsetStart == -1) {
            target.append("ROWS ").append(limitEscape);
        } else {
            String rows = limitEscape.substring(0, offsetStart).trim();
            String offset = limitEscape.substring(offsetStart + LIMIT_OFFSET_CLAUSE.length()).trim();
            if (offset.indexOf(63) != -1) {
                throw new FBSQLParseException("Extended limit escape ({limit <rows> offset <offset_rows>}) does not support parameters for <offset_rows>");
            }
            target.append("ROWS ").append(offset).append(" TO ").append(offset).append("+").append(rows);
        }
    }

    private static void convertEscapedFunction(StringBuilder target, CharSequence escapedFunction) throws FBSQLParseException {
        String templateResult = FBEscapedFunctionHelper.convertTemplate(escapedFunction.toString());
        target.append(templateResult != null ? templateResult : escapedFunction);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ParserState {
        INITIAL_STATE{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return Character.isWhitespace(inputChar) ? INITIAL_STATE : NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        NORMAL_STATE{

            @Override
            protected ParserState nextState(char inputChar) {
                return switch (inputChar) {
                    case '\'' -> LITERAL_STATE;
                    case '{' -> ESCAPE_ENTER_STATE;
                    case '}' -> ESCAPE_EXIT_STATE;
                    case '-' -> START_LINE_COMMENT;
                    case '/' -> START_BLOCK_COMMENT;
                    case 'Q', 'q' -> POSSIBLE_Q_LITERAL_ENTER;
                    default -> NORMAL_STATE;
                };
            }
        }
        ,
        LITERAL_STATE{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '\'' ? NORMAL_STATE : LITERAL_STATE;
            }
        }
        ,
        ESCAPE_ENTER_STATE{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                switch (inputChar) {
                    case '?': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'L': 
                    case 'O': 
                    case 'T': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'l': 
                    case 'o': 
                    case 't': {
                        break;
                    }
                    default: {
                        throw new FBSQLParseException("Unexpected first character inside JDBC escape: " + inputChar);
                    }
                }
                return NORMAL_STATE;
            }
        }
        ,
        ESCAPE_EXIT_STATE{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        START_LINE_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return inputChar == '-' ? LINE_COMMENT : NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        LINE_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '\n' ? NORMAL_STATE : LINE_COMMENT;
            }
        }
        ,
        START_BLOCK_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return inputChar == '*' ? BLOCK_COMMENT : NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        BLOCK_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '*' ? END_BLOCK_COMMENT : BLOCK_COMMENT;
            }
        }
        ,
        END_BLOCK_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '/' ? NORMAL_STATE : BLOCK_COMMENT;
            }
        }
        ,
        POSSIBLE_Q_LITERAL_ENTER{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '\'' ? Q_LITERAL_START : NORMAL_STATE;
            }
        }
        ,
        Q_LITERAL_START{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                throw new FBSQLParseException("Q-literal handling needs to be performed separately");
            }
        }
        ,
        Q_LITERAL_END{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                if (inputChar != '\'') {
                    throw new FBSQLParseException("Invalid char " + inputChar + " for state Q_LITERAL_END");
                }
                return NORMAL_STATE;
            }
        };


        protected abstract ParserState nextState(char var1) throws FBSQLParseException;
    }
}

