/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalAddDateNode
extends JavaScriptBaseNode {
    protected TemporalAddDateNode() {
    }

    public abstract JSTemporalPlainDateObject execute(TruffleString var1, JSTemporalPlainDateObject var2, JSTemporalDurationObject var3, TemporalUtil.Overflow var4);

    @Specialization
    protected JSTemporalPlainDateObject addDate(TruffleString calendar, JSTemporalPlainDateObject plainDate, JSTemporalDurationObject duration, TemporalUtil.Overflow overflow, @Cached InlinedBranchProfile errorBranch) {
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        if (duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0) {
            return TemporalUtil.calendarDateAdd(ctx, realm, calendar, plainDate, duration, overflow, this, errorBranch);
        }
        BigInt norm = TemporalUtil.normalizeTimeDuration(duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
        TimeDurationRecord balancedDuration = TemporalUtil.balanceTimeDuration(norm, TemporalUtil.Unit.DAY);
        double days = duration.getDays() + balancedDuration.days();
        ISODateRecord result = TemporalUtil.addISODate(plainDate.getYear(), plainDate.getMonth(), plainDate.getDay(), 0.0, 0.0, 0.0, days, overflow);
        return JSTemporalPlainDate.create(ctx, realm, result.year(), result.month(), result.day(), calendar, this, errorBranch);
    }
}

