/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.effects.Beam;
import com.shatteredpixel.shatteredpixeldungeon.effects.TargetedCell;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.WardSprite;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.watabou.utils.Bundle;

public class VaultLaser
extends NPC {
    public int[] laserDirs;
    public int laserDirIdx;
    public int initialLaserCooldown;
    public int cooldown;
    private static final String LASER_DIRS = "laser_dirs";
    private static final String LASER_DIR_IDX = "laser_dir_idx";
    private static final String INITIAL_COOLDOWN = "initial_cooldown";
    private static final String COOLDOWN = "cooldown";

    public VaultLaser() {
        this.spriteClass = WardSprite.class;
        this.properties.add(Char.Property.IMMOVABLE);
    }

    @Override
    protected boolean act() {
        --this.cooldown;
        if (this.cooldown <= 0) {
            Ballistica beam = new Ballistica(this.pos, this.laserDirs[this.laserDirIdx], 4);
            boolean visible = false;
            for (int cell : beam.subPath(1, beam.dist)) {
                if (Dungeon.level.heroFOV[cell]) {
                    visible = true;
                }
                if (Actor.findChar(cell) != Dungeon.hero) continue;
                Dungeon.hero.sprite.showStatus(0xFF0000, "!!!", new Object[0]);
            }
            if (visible) {
                this.sprite.parent.add(new Beam.DeathRay(this.sprite.center(), DungeonTilemap.raisedTileCenterToWorld(beam.collisionPos)));
            }
            ++this.laserDirIdx;
            if (this.laserDirIdx >= this.laserDirs.length) {
                this.laserDirIdx = 0;
            }
            this.cooldown = this.initialLaserCooldown;
        }
        if (this.cooldown == 1) {
            Ballistica nextBeam = new Ballistica(this.pos, this.laserDirs[this.laserDirIdx], 4);
            for (int cell : nextBeam.subPath(1, nextBeam.dist)) {
                if (!Dungeon.level.heroFOV[cell]) continue;
                this.sprite.parent.add(new TargetedCell(cell, 0xFF0000));
            }
        }
        this.throwItems();
        this.spend(1.0f);
        return true;
    }

    @Override
    public boolean isImmune(Class effect) {
        return true;
    }

    @Override
    public boolean isInvulnerable(Class effect) {
        return true;
    }

    @Override
    public boolean reset() {
        return true;
    }

    @Override
    public boolean interact(Char c) {
        return true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(LASER_DIRS, this.laserDirs);
        bundle.put(LASER_DIR_IDX, this.laserDirIdx);
        bundle.put(INITIAL_COOLDOWN, this.initialLaserCooldown);
        bundle.put(COOLDOWN, this.cooldown);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.laserDirs = bundle.getIntArray(LASER_DIRS);
        this.laserDirIdx = bundle.getInt(LASER_DIR_IDX);
        this.initialLaserCooldown = bundle.getInt(INITIAL_COOLDOWN);
        this.cooldown = bundle.getInt(COOLDOWN);
    }

    @Override
    public CharSprite sprite() {
        WardSprite sprite = (WardSprite)super.sprite();
        sprite.linkVisuals(this);
        return sprite;
    }
}

