import { DataType, DataTypeClass } from "./definition/enums";
import { type FoundationDefinition } from "./definition/foundation";
import type { Attribute, Cluster, ClusterName, Command, CustomClusters, Parameter } from "./definition/tstype";
export declare function getDataTypeClass(dataType: DataType): DataTypeClass;
export declare function getCluster(key: string | number, manufacturerCode?: number | undefined, customClusters?: CustomClusters): Cluster;
export declare function getGlobalCommand(key: number | string): Command;
export declare function isClusterName(name: string): name is ClusterName;
export declare function getFoundationCommand(id: number): FoundationDefinition;
export declare function isFoundationDiscoverRsp(id: number): boolean;
export declare function processAttributeWrite<T>(attribute: Attribute, value: T): T;
export declare function processAttributePreRead(attribute: Attribute): void;
export declare function processAttributePostRead<T>(attribute: Attribute, value: T): T;
export declare function processParameterWrite<T>(parameter: Parameter, value: T): T;
export declare function processParameterRead<T>(parameter: Parameter, value: T): T;
//# sourceMappingURL=utils.d.ts.map