﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2_EXPORTS.h>
#include <aws/elasticloadbalancingv2/model/Listener.h>
#include <aws/elasticloadbalancingv2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace ElasticLoadBalancingv2 {
namespace Model {
class DescribeListenersResult {
 public:
  AWS_ELASTICLOADBALANCINGV2_API DescribeListenersResult() = default;
  AWS_ELASTICLOADBALANCINGV2_API DescribeListenersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_ELASTICLOADBALANCINGV2_API DescribeListenersResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the listeners.</p>
   */
  inline const Aws::Vector<Listener>& GetListeners() const { return m_listeners; }
  template <typename ListenersT = Aws::Vector<Listener>>
  void SetListeners(ListenersT&& value) {
    m_listenersHasBeenSet = true;
    m_listeners = std::forward<ListenersT>(value);
  }
  template <typename ListenersT = Aws::Vector<Listener>>
  DescribeListenersResult& WithListeners(ListenersT&& value) {
    SetListeners(std::forward<ListenersT>(value));
    return *this;
  }
  template <typename ListenersT = Listener>
  DescribeListenersResult& AddListeners(ListenersT&& value) {
    m_listenersHasBeenSet = true;
    m_listeners.emplace_back(std::forward<ListenersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If there are additional results, this is the marker for the next set of
   * results. Otherwise, this is null.</p>
   */
  inline const Aws::String& GetNextMarker() const { return m_nextMarker; }
  template <typename NextMarkerT = Aws::String>
  void SetNextMarker(NextMarkerT&& value) {
    m_nextMarkerHasBeenSet = true;
    m_nextMarker = std::forward<NextMarkerT>(value);
  }
  template <typename NextMarkerT = Aws::String>
  DescribeListenersResult& WithNextMarker(NextMarkerT&& value) {
    SetNextMarker(std::forward<NextMarkerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeListenersResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Listener> m_listeners;

  Aws::String m_nextMarker;

  ResponseMetadata m_responseMetadata;
  bool m_listenersHasBeenSet = false;
  bool m_nextMarkerHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticLoadBalancingv2
}  // namespace Aws
