﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgent {
namespace Model {

/**
 * <p>Contains details about the routing configuration of the alias.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AgentAliasRoutingConfigurationListItem">AWS
 * API Reference</a></p>
 */
class AgentAliasRoutingConfigurationListItem {
 public:
  AWS_BEDROCKAGENT_API AgentAliasRoutingConfigurationListItem() = default;
  AWS_BEDROCKAGENT_API AgentAliasRoutingConfigurationListItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API AgentAliasRoutingConfigurationListItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The version of the agent with which the alias is associated.</p>
   */
  inline const Aws::String& GetAgentVersion() const { return m_agentVersion; }
  inline bool AgentVersionHasBeenSet() const { return m_agentVersionHasBeenSet; }
  template <typename AgentVersionT = Aws::String>
  void SetAgentVersion(AgentVersionT&& value) {
    m_agentVersionHasBeenSet = true;
    m_agentVersion = std::forward<AgentVersionT>(value);
  }
  template <typename AgentVersionT = Aws::String>
  AgentAliasRoutingConfigurationListItem& WithAgentVersion(AgentVersionT&& value) {
    SetAgentVersion(std::forward<AgentVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information on the Provisioned Throughput assigned to an agent alias.</p>
   */
  inline const Aws::String& GetProvisionedThroughput() const { return m_provisionedThroughput; }
  inline bool ProvisionedThroughputHasBeenSet() const { return m_provisionedThroughputHasBeenSet; }
  template <typename ProvisionedThroughputT = Aws::String>
  void SetProvisionedThroughput(ProvisionedThroughputT&& value) {
    m_provisionedThroughputHasBeenSet = true;
    m_provisionedThroughput = std::forward<ProvisionedThroughputT>(value);
  }
  template <typename ProvisionedThroughputT = Aws::String>
  AgentAliasRoutingConfigurationListItem& WithProvisionedThroughput(ProvisionedThroughputT&& value) {
    SetProvisionedThroughput(std::forward<ProvisionedThroughputT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_agentVersion;

  Aws::String m_provisionedThroughput;
  bool m_agentVersionHasBeenSet = false;
  bool m_provisionedThroughputHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
