/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.AbstractCalendarFactory;
import net.sf.mpxj.mpp.MPPUtility;

abstract class AbstractCalendarAndExceptionFactory
extends AbstractCalendarFactory {
    private static final RecurrenceType[] RECURRENCE_TYPES = new RecurrenceType[]{null, RecurrenceType.DAILY, RecurrenceType.YEARLY, RecurrenceType.YEARLY, RecurrenceType.MONTHLY, RecurrenceType.MONTHLY, RecurrenceType.WEEKLY, RecurrenceType.DAILY};
    private static final boolean[] RELATIVE_MAP = new boolean[]{false, false, false, true, false, true};
    private static final int[] DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};

    public AbstractCalendarAndExceptionFactory(ProjectFile file) {
        super(file);
    }

    @Override
    protected void processCalendarExceptions(byte[] data, ProjectCalendar cal) {
        if (data.length > 420) {
            int offset = 420;
            int exceptionCount = MPPUtility.getShort(data, offset);
            if (exceptionCount == 0) {
                offset += 4;
            } else {
                offset += 4;
                for (int index = 0; index < exceptionCount && offset + 92 <= data.length; ++index) {
                    int exceptionNameLength;
                    Date toDate;
                    Date fromDate = MPPUtility.getDate(data, offset);
                    RecurringData rd = this.readRecurringData(data, offset, fromDate, toDate = MPPUtility.getDate(data, offset + 2));
                    ProjectCalendarException exception = rd == null ? cal.addCalendarException(fromDate, toDate) : cal.addCalendarException(rd);
                    int periodCount = MPPUtility.getShort(data, offset + 14);
                    if (periodCount != 0) {
                        for (int exceptionPeriodIndex = 0; exceptionPeriodIndex < periodCount; ++exceptionPeriodIndex) {
                            Date start = MPPUtility.getTime(data, offset + 20 + exceptionPeriodIndex * 2);
                            long duration = MPPUtility.getDuration(data, offset + 32 + exceptionPeriodIndex * 4);
                            exception.add(new DateRange(start, new Date(start.getTime() + duration)));
                        }
                    }
                    if ((exceptionNameLength = MPPUtility.getInt(data, offset + 88)) % 4 != 0) {
                        exceptionNameLength = (exceptionNameLength / 4 + 1) * 4;
                    }
                    if (exceptionNameLength != 0) {
                        exception.setName(MPPUtility.getUnicodeString(data, offset + 92));
                    }
                    offset += 92 + exceptionNameLength;
                }
            }
            this.processWorkWeeks(data, offset, cal);
        }
    }

    private RecurringData readRecurringData(byte[] data, int offset, Date fromDate, Date toDate) {
        RecurringData rd = new RecurringData();
        int recurrenceTypeValue = MPPUtility.getShort(data, offset + 72);
        rd.setStartDate(fromDate);
        rd.setFinishDate(toDate);
        rd.setRecurrenceType(this.getRecurrenceType(recurrenceTypeValue));
        rd.setRelative(this.getRelative(recurrenceTypeValue));
        rd.setOccurrences(MPPUtility.getShort(data, offset + 4));
        switch (rd.getRecurrenceType()) {
            case DAILY: {
                int frequency = recurrenceTypeValue == 1 ? 1 : MPPUtility.getShort(data, offset + 76);
                rd.setFrequency(frequency);
                break;
            }
            case WEEKLY: {
                rd.setWeeklyDaysFromBitmap(MPPUtility.getByte(data, offset + 76), DAY_MASKS);
                rd.setFrequency(MPPUtility.getShort(data, offset + 78));
                break;
            }
            case MONTHLY: {
                if (rd.getRelative()) {
                    rd.setDayOfWeek(Day.getInstance(MPPUtility.getByte(data, offset + 77) - 2));
                    rd.setDayNumber(MPPUtility.getByte(data, offset + 76) + 1);
                    rd.setFrequency(MPPUtility.getShort(data, offset + 78));
                    break;
                }
                rd.setDayNumber(MPPUtility.getByte(data, offset + 76));
                rd.setFrequency(MPPUtility.getByte(data, offset + 78));
                break;
            }
            case YEARLY: {
                if (rd.getRelative()) {
                    rd.setDayOfWeek(Day.getInstance(MPPUtility.getByte(data, offset + 78) - 2));
                    rd.setDayNumber(MPPUtility.getByte(data, offset + 77) + 1);
                } else {
                    rd.setDayNumber(MPPUtility.getByte(data, offset + 77));
                }
                rd.setMonthNumber(MPPUtility.getByte(data, offset + 76) + 1);
            }
        }
        if (rd.getRecurrenceType() == RecurrenceType.DAILY && NumberHelper.getInt(rd.getFrequency()) == 1) {
            rd = null;
        }
        return rd;
    }

    private void processWorkWeeks(byte[] data, int offset, ProjectCalendar cal) {
        offset += 4;
        while (data.length >= offset + 436) {
            ProjectCalendarWeek week = cal.addWorkWeek();
            for (Day day : Day.values()) {
                this.processWorkWeekDay(data, offset, week, day);
                offset += 60;
            }
            Date startDate = DateHelper.getDayStartDate(MPPUtility.getDate(data, offset));
            Date finishDate = DateHelper.getDayEndDate(MPPUtility.getDate(data, offset += 2));
            offset += 2;
            int nameLength = MPPUtility.getInt(data, offset += 8);
            if (nameLength % 4 != 0) {
                nameLength = (nameLength / 4 + 1) * 4;
            }
            offset += 4;
            if (nameLength != 0) {
                String name = MPPUtility.getUnicodeString(data, offset, nameLength);
                offset += nameLength;
                week.setName(name);
            }
            week.setDateRange(new DateRange(startDate, finishDate));
        }
    }

    private void processWorkWeekDay(byte[] data, int offset, ProjectCalendarWeek week, Day day) {
        int dayType = MPPUtility.getShort(data, offset);
        if (dayType == 1) {
            week.setCalendarDayType(day, DayType.DEFAULT);
        } else {
            ProjectCalendarHours hours = week.addCalendarHours(day);
            int rangeCount = MPPUtility.getShort(data, offset + 2);
            if (rangeCount == 0) {
                week.setCalendarDayType(day, DayType.NON_WORKING);
            } else {
                week.setCalendarDayType(day, DayType.WORKING);
                Calendar cal = DateHelper.popCalendar();
                for (int index = 0; index < rangeCount; ++index) {
                    Date startTime = DateHelper.getCanonicalTime(MPPUtility.getTime(data, offset + 8 + index * 2));
                    int durationInSeconds = MPPUtility.getInt(data, offset + 20 + index * 4) * 6;
                    cal.setTime(startTime);
                    cal.add(13, durationInSeconds);
                    Date finishTime = DateHelper.getCanonicalTime(cal.getTime());
                    hours.add(new DateRange(startTime, finishTime));
                }
                DateHelper.pushCalendar(cal);
            }
        }
    }

    private RecurrenceType getRecurrenceType(int value) {
        RecurrenceType result = value < 0 || value >= RECURRENCE_TYPES.length ? null : RECURRENCE_TYPES[value];
        return result;
    }

    private boolean getRelative(int value) {
        boolean result = value < 0 || value >= RELATIVE_MAP.length ? false : RELATIVE_MAP[value];
        return result;
    }
}

