/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public class DatabaseEditorPreferences {
    public static final String PROP_TITLE_SHOW_FULL_NAME = "navigator.editor.full-name";
    public static final String PROP_SAVE_EDITORS_STATE = "ui.editors.reopen-after-restart";
    public static final String PROP_KEEP_EDITORS_ON_DISCONNECT = "ui.editors.keep-editors-on-disconnect";
    public static final String PROP_DISCONNECT_ON_EDITORS_CLOSE = "ui.editors.disconnect-on-editors-close";
    public static final String UI_STATUS_BAR_SHOW_BREADCRUMBS = "ui.statusBar.show.breadcrumbs";

    public static enum BreadcrumbLocation {
        IN_STATUS_BAR,
        IN_EDITORS,
        HIDDEN;


        @NotNull
        public static BreadcrumbLocation get(@NotNull DBPPreferenceStore store) {
            return BreadcrumbLocation.get(store.getString(DatabaseEditorPreferences.UI_STATUS_BAR_SHOW_BREADCRUMBS));
        }

        @NotNull
        public static BreadcrumbLocation getDefault(@NotNull DBPPreferenceStore store) {
            return BreadcrumbLocation.get(store.getDefaultString(DatabaseEditorPreferences.UI_STATUS_BAR_SHOW_BREADCRUMBS));
        }

        @NotNull
        private static BreadcrumbLocation get(@Nullable String value) {
            return switch (CommonUtils.notEmpty((String)value)) {
                case "HIDDEN", "false" -> HIDDEN;
                case "IN_EDITORS" -> IN_EDITORS;
                default -> IN_STATUS_BAR;
            };
        }
    }
}

