/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.net;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DefaultCallbackHandler
implements CallbackHandler {
    private char[] password = null;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                if (this.password == null) {
                    DBPAuthInfo authInfo = DBWorkbench.getPlatformUI().promptUserCredentials("Enter password", null, null, null, true, true);
                    if (authInfo == null) continue;
                    if (authInfo.isSavePassword()) {
                        this.password = authInfo.getUserPassword().toCharArray();
                    }
                    ((PasswordCallback)callback).setPassword(authInfo.getUserPassword().toCharArray());
                    continue;
                }
                ((PasswordCallback)callback).setPassword(this.password);
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                String propValue = DBWorkbench.getPlatformUI().promptProperty(nameCallback.getPrompt(), nameCallback.getName());
                nameCallback.setName(propValue);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

