/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardManagerDialog;
import org.jkiss.dbeaver.ui.dashboard.view.catalogpanel.DashboardCatalogPanel;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class DashboardAddItemDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardAddDialog";
    private final DashboardConfiguration viewConfiguration;
    private DashboardCatalogPanel catalogPanel;

    public DashboardAddItemDialog(Shell parentShell, DashboardConfiguration viewConfiguration) {
        super(parentShell, UIDashboardMessages.dialog_add_dashboard_dialog_title, null);
        this.viewConfiguration = viewConfiguration;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIDashboardActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        this.catalogPanel = new DashboardCatalogPanel(dialogArea, this.viewConfiguration.getProject(), this.viewConfiguration.getDataSourceContainer(), item -> this.viewConfiguration.getItemConfig(item.getId()) != null, false){

            @Override
            protected void handleChartSelected() {
                DashboardAddItemDialog.this.enableButton(0, this.getSelectedDashboard() != null);
            }

            @Override
            protected void handleChartSelectedFinal() {
                DashboardAddItemDialog.this.okPressed();
            }
        };
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridData)parent.getLayoutData()).grabExcessHorizontalSpace = true;
        Button managerButton = this.createButton(parent, 1, UIDashboardMessages.dialog_add_dashboard_button_manage, false);
        ((GridData)managerButton.getLayoutData()).horizontalAlignment = 1;
        ((GridData)managerButton.getLayoutData()).grabExcessHorizontalSpace = true;
        managerButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                new DashboardManagerDialog(UIUtils.getActiveWorkbenchShell()).open();
            }
        });
        this.createButton(parent, 0, UIDashboardMessages.dialog_add_dashboard_button_add, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public DashboardItemConfiguration getSelectedDashboard() {
        return this.catalogPanel.getSelectedDashboard();
    }
}

