/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.Tags;
import org.freeplane.features.map.NodeModel;

class TagBuilder
implements IExtensionAttributeWriter {
    TagBuilder() {
    }

    private void registerAttributeHandlers(ReadManager reader) {
        IAttributeHandler tagsHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                TagCategories tagCategories = node.getMap().getIconRegistry().getTagCategories();
                Tags.setTagReferences(node, Stream.of(value.split("\n")).map(tagCategories::createTagReference).collect(Collectors.toList()));
            }
        };
        reader.addAttributeHandler("node", "TAGS", tagsHandler);
        reader.addAttributeHandler("stylenode", "TAGS", tagsHandler);
    }

    void registerBy(ReadManager readManager, WriteManager writeManager) {
        this.registerAttributeHandlers(readManager);
        writeManager.addExtensionAttributeWriter(Tags.class, this);
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        Tags tagsExtension = (Tags)extension;
        List<Tag> tags = tagsExtension.getTags();
        if (!tags.isEmpty()) {
            writer.addAttribute("TAGS", tags.stream().map(Tag::getContent).collect(Collectors.joining("\n")));
        }
    }
}

