/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class ImageCreator {
    private int imageResolutionInDpi;

    public ImageCreator(int imageResolutionInDpi) {
        this.imageResolutionInDpi = imageResolutionInDpi;
    }

    public RenderedImage createBufferedImage(MapModel map, int imageType) {
        Controller controller = Controller.getCurrentController();
        if (!map.equals(controller.getMap())) {
            return null;
        }
        return controller.getMapViewManager().createImage(this.imageResolutionInDpi, imageType);
    }

    public RenderedImage createBufferedImage(MapModel map, Dimension slideSize, NodeModel placedNode, IMapSelection.NodePosition placedNodePosition, int imageType) {
        Controller controller = Controller.getCurrentController();
        if (!map.equals(controller.getMap())) {
            return null;
        }
        return controller.getMapViewManager().createImage(slideSize, placedNode, placedNodePosition, this.imageResolutionInDpi, imageType);
    }

    public int getImageResolutionDPI() {
        return this.imageResolutionInDpi;
    }
}

