---
stage: Developer Experience
group: API
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GraphQL API resources
---

<!--
  This documentation is auto generated by a script.
  Please do not edit this file directly.

  To edit the introductory text, modify `tooling/graphql/docs/templates/default.md.haml`.

  Run `bundle exec rake gitlab:graphql:compile_docs`
  or check the `compile_docs` task in `lib/tasks/gitlab/graphql.rake`.
-->

This documentation is self-generated based on GitLab current GraphQL schema.

The API can be explored using the [interactive GraphQL explorer](../_index.md#interactive-graphql-explorer). Developers can also generate a machine-readable GraphQL schema in IDL and JSON formats.

Each table below documents a GraphQL type. Types match loosely to models, but not all
fields and methods on a model are available via GraphQL.

{{< alert type="warning" >}}

Fields that are deprecated are marked with {{< icon name="warning-solid" >}}.
Items (fields, enums, etc) that have been removed according to our [deprecation process](../_index.md#deprecation-and-removal-process) can be found
in [Removed Items](../removed_items.md).

{{< /alert >}}

<!-- vale off -->
<!-- Vale linting disabled after this line. -->
<!-- See https://docs.gitlab.com/development/documentation/testing/vale/#disable-vale-tests -->

<!-- markdownlint-disable MD044 -->
<!-- MD044/proper-names test disabled after this line to make page compatible with markdownlint-cli 0.29.0. -->
<!-- See https://docs.gitlab.com/development/documentation/testing/markdownlint/#disable-markdownlint-tests -->

## `Query` type

The `Query` type contains the API's top-level entry points for all executable queries.

### `Query.abuseReport`

{{< details >}}
**Introduced** in GitLab 16.3.
**Status**: Experiment.
{{< /details >}}

Find an abuse report.

Returns [`AbuseReport`](#abusereport).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryabusereportid"></a>`id` | [`AbuseReportID!`](#abusereportid) | ID of the abuse report. |

### `Query.accessTokenPermissions`

{{< details >}}
**Introduced** in GitLab 18.6.
**Status**: Experiment.
{{< /details >}}

List of permissions for fine-grained access tokens.

Returns [`[AccessTokenPermission!]!`](#accesstokenpermission).

### `Query.addOnPurchases`

Retrieve all active add-on purchases. This query can be used in GitLab.com and self-managed environments.

Returns [`[AddOnPurchase!]`](#addonpurchase).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaddonpurchasesnamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | ID of namespace that the add-ons were purchased for. |

### `Query.adminGroups`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Find groups visible to the current admin.

Returns [`GroupInterfaceConnection`](#groupinterfaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryadmingroupsactive"></a>`active` | [`Boolean`](#boolean) | When `nil` (default value), returns all groups. When `true`, returns only groups that are not pending deletion. When `false`, only returns groups that are pending deletion. |
| <a id="queryadmingroupsallavailable"></a>`allAvailable` | [`Boolean`](#boolean) | When `true`, returns all accessible groups. When `false`, returns only groups where the user is a member. Unauthenticated requests always return all public groups. The `owned_only` argument takes precedence. |
| <a id="queryadmingroupsids"></a>`ids` | [`[ID!]`](#id) | Filter groups by IDs. |
| <a id="queryadmingroupsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | Date when the group was marked for deletion. |
| <a id="queryadmingroupsownedonly"></a>`ownedOnly` | [`Boolean`](#boolean) | Only include groups where the current user has an owner role. |
| <a id="queryadmingroupsparentpath"></a>`parentPath` | [`ID`](#id) | Full path of the parent group. |
| <a id="queryadmingroupssearch"></a>`search` | [`String`](#string) | Search query for group name or group full path. |
| <a id="queryadmingroupssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. |
| <a id="queryadmingroupstoplevelonly"></a>`topLevelOnly` | [`Boolean`](#boolean) | Only include top-level groups. |

### `Query.adminMemberRole`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

Finds a single admin custom role for the instance. Available only for GitLab Self-Managed.

Returns [`AdminMemberRole`](#adminmemberrole).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryadminmemberroleid"></a>`id` | [`MemberRoleID`](#memberroleid) | Global ID of the member role to look up. |
| <a id="queryadminmemberroleids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | Global IDs of the member role to look up. |
| <a id="queryadminmemberroleorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | Ordering column. Default is NAME. |
| <a id="queryadminmemberrolesort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | Ordering column. Default is ASC. |

### `Query.adminMemberRolePermissions`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

List of all admin customizable permissions.

Returns [`CustomizableAdminPermissionConnection`](#customizableadminpermissionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.adminMemberRoles`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

Admin custom roles available for the instance. Available only for GitLab Self-Managed.

Returns [`AdminMemberRoleConnection`](#adminmemberroleconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryadminmemberrolesid"></a>`id` | [`MemberRoleID`](#memberroleid) | Global ID of the member role to look up. |
| <a id="queryadminmemberrolesids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | Global IDs of the member role to look up. |
| <a id="queryadminmemberrolesorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | Ordering column. Default is NAME. |
| <a id="queryadminmemberrolessort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | Ordering column. Default is ASC. |

### `Query.adminProjects`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Find projects visible to the current admin.

Returns [`ProjectInterfaceConnection`](#projectinterfaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryadminprojectsactive"></a>`active` | [`Boolean`](#boolean) | Filters by projects that are not archived and not marked for deletion. |
| <a id="queryadminprojectsaimedfordeletion"></a>`aimedForDeletion` | [`Boolean`](#boolean) | Return only projects marked for deletion. |
| <a id="queryadminprojectsarchived"></a>`archived` | [`ProjectArchived`](#projectarchived) | Filter projects by archived status. |
| <a id="queryadminprojectsfullpaths"></a>`fullPaths` | [`[String!]`](#string) | Filter projects by full paths. You cannot provide more than 50 full paths. |
| <a id="queryadminprojectsids"></a>`ids` | [`[ID!]`](#id) | Filter projects by IDs. |
| <a id="queryadminprojectsincludehidden"></a>`includeHidden` | [`Boolean`](#boolean) | Include hidden projects. |
| <a id="queryadminprojectslastrepositorycheckfailed"></a>`lastRepositoryCheckFailed` | [`Boolean`](#boolean) | Return only projects where the last repository check failed. Only available for administrators. |
| <a id="queryadminprojectsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | Date when the project was marked for deletion. |
| <a id="queryadminprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | Return only projects that the current user is a member of. |
| <a id="queryadminprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | Return only projects where current user has at least the specified access level. |
| <a id="queryadminprojectsnamespacepath"></a>`namespacePath` | [`ID`](#id) | Filter projects by their namespace's full path (group or user). |
| <a id="queryadminprojectsnotaimedfordeletion"></a>`notAimedForDeletion` | [`Boolean`](#boolean) | Exclude projects that are marked for deletion. |
| <a id="queryadminprojectspersonal"></a>`personal` | [`Boolean`](#boolean) | Return only personal projects. |
| <a id="queryadminprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | Filter projects by programming language name (case insensitive). For example: `css` or `ruby`. |
| <a id="queryadminprojectssearch"></a>`search` | [`String`](#string) | Search query, which can be for the project name, a path, or a description. |
| <a id="queryadminprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | Include namespace in project search. |
| <a id="queryadminprojectssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. Defaults to `id_desc`, or `similarity` if search used. |
| <a id="queryadminprojectstopics"></a>`topics` | [`[String!]`](#string) | Filter projects by topics. |
| <a id="queryadminprojectstrending"></a>`trending` | [`Boolean`](#boolean) | Return only projects that are trending. |
| <a id="queryadminprojectsvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | Filter projects by visibility level. |
| <a id="queryadminprojectswithcodeembeddingsindexed"></a>`withCodeEmbeddingsIndexed` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 18.2. **Status**: Experiment. Include projects with indexed code embeddings. Requires `ids` to be sent. Applies only if the feature flag `allow_with_code_embeddings_indexed_projects_filter` is enabled. |
| <a id="queryadminprojectswithduoeligible"></a>`withDuoEligible` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 18.6. **Status**: Experiment. Include only projects that are eligible for GitLab Duo and have Duo features enabled.Applies only if the feature flag `with_duo_eligible_projects_filter` is enabled. |
| <a id="queryadminprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | Return only projects with issues enabled. |
| <a id="queryadminprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | Return only projects with merge requests enabled. |

### `Query.aiCatalogAgentFlowConfig`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Get flow configuration for an AI Catalog agent.

Returns [`String`](#string).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaicatalogagentflowconfigagentversionid"></a>`agentVersionId` | [`AiCatalogItemVersionID!`](#aicatalogitemversionid) | Global ID of the agent version to use. |
| <a id="queryaicatalogagentflowconfigflowconfigtype"></a>`flowConfigType` | [`AiCatalogFlowConfigType!`](#aicatalogflowconfigtype) | Type of flow configuration to generate. |

### `Query.aiCatalogBuiltInTools`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

List of AI Catalog built-in tools.

Returns [`AiCatalogBuiltInToolConnection!`](#aicatalogbuiltintoolconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.aiCatalogConfiguredItems`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

AI Catalog items configured for use.

Returns [`AiCatalogItemConsumerConnection!`](#aicatalogitemconsumerconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaicatalogconfigureditemsgroupid"></a>`groupId` | [`GroupID`](#groupid) | Group ID to retrieve configured AI Catalog items for. |
| <a id="queryaicatalogconfigureditemsincludeinherited"></a>`includeInherited` | [`Boolean`](#boolean) | Include configured AI Catalog items inherited from parent groups. |
| <a id="queryaicatalogconfigureditemsitemid"></a>`itemId` | [`AiCatalogItemID`](#aicatalogitemid) | Item ID to retrieve configured AI Catalog items for. |
| <a id="queryaicatalogconfigureditemsitemtype"></a>`itemType` | [`AiCatalogItemType`](#aicatalogitemtype) | Type of items to retrieve. |
| <a id="queryaicatalogconfigureditemsitemtypes"></a>`itemTypes` | [`[AiCatalogItemType!]`](#aicatalogitemtype) | Types of items to retrieve. |
| <a id="queryaicatalogconfigureditemsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Project ID to retrieve configured AI Catalog items for. |

### `Query.aiCatalogItem`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Find an AI Catalog item.

Returns [`AiCatalogItem`](#aicatalogitem).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaicatalogitemid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog item to find. |
| <a id="queryaicatalogitemshowsoftdeleted"></a>`showSoftDeleted` | [`Boolean`](#boolean) | Whether to show the item if it has been soft-deleted. Defaults to `false`. |

### `Query.aiCatalogItemConsumer`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Find a single AI Catalog item consumer by ID.

Returns [`AiCatalogItemConsumer`](#aicatalogitemconsumer).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaicatalogitemconsumerid"></a>`id` | [`AiCatalogItemConsumerID!`](#aicatalogitemconsumerid) | Global ID of the AI Catalog item consumer. |

### `Query.aiCatalogItems`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

List of AI Catalog items.

Returns [`AiCatalogItemConnection!`](#aicatalogitemconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaicatalogitemsitemtype"></a>`itemType` | [`AiCatalogItemType`](#aicatalogitemtype) | Type of items to retrieve. |
| <a id="queryaicatalogitemsitemtypes"></a>`itemTypes` | [`[AiCatalogItemType!]`](#aicatalogitemtype) | Types of items to retrieve. |
| <a id="queryaicatalogitemssearch"></a>`search` | [`String`](#string) | Search items by name and description. |

### `Query.aiChatAvailableModels`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Get available models for Duo Agentic Chat.

Returns [`AvailableModels`](#availablemodels).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaichatavailablemodelsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project the user is acting on. |
| <a id="queryaichatavailablemodelsrootnamespaceid"></a>`rootNamespaceId` | [`GroupID`](#groupid) | Global ID of the namespace the user is acting on. |

### `Query.aiChatContextPresets`

Get available GitLab Duo Chat context presets for the current user for a specific URL.

Returns [`ContextPreset`](#contextpreset).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaichatcontextpresetsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project the user is acting on. |
| <a id="queryaichatcontextpresetsquestioncount"></a>`questionCount` | [`Int`](#int) | Number of questions for the default screen. |
| <a id="queryaichatcontextpresetsresourceid"></a>`resourceId` | [`AiModelID`](#aimodelid) | Global ID of the resource from the current page. |
| <a id="queryaichatcontextpresetsurl"></a>`url` | [`String`](#string) | URL of the page the user is currently on. |

### `Query.aiConversationThreads`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

List conversation threads of AI features.

Returns [`AiConversationsThreadConnection!`](#aiconversationsthreadconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaiconversationthreadsconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | Conversation type of the thread. |
| <a id="queryaiconversationthreadsid"></a>`id` | [`AiConversationThreadID`](#aiconversationthreadid) | Id of the thread. |

### `Query.aiFeatureSettings`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

List of configurable AI features.

Returns [`AiFeatureSettingConnection`](#aifeaturesettingconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaifeaturesettingsselfhostedmodelid"></a>`selfHostedModelId` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | Global ID of the self-hosted model. |

### `Query.aiFoundationalChatAgents`

{{< details >}}
**Introduced** in GitLab 18.6.
**Status**: Experiment.
{{< /details >}}

Core agents in GitLab.

Returns [`AiFoundationalChatAgentConnection!`](#aifoundationalchatagentconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaifoundationalchatagentsnamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | Global ID of the namespace where the chat is present. |
| <a id="queryaifoundationalchatagentsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project where the chat is present. |

### `Query.aiMessages`

{{< details >}}
**Introduced** in GitLab 16.1.
**Status**: Experiment.
{{< /details >}}

Find GitLab Duo Chat messages.

Returns [`AiMessageConnection!`](#aimessageconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaimessagesagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | Global ID of the agent to answer the chat. |
| <a id="queryaimessagesconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | Conversation type of the thread. |
| <a id="queryaimessagesrequestids"></a>`requestIds` | [`[ID!]`](#id) | Array of request IDs to fetch. |
| <a id="queryaimessagesroles"></a>`roles` | [`[AiMessageRole!]`](#aimessagerole) | Array of roles to fetch. |
| <a id="queryaimessagesthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | Global Id of the existing thread.If it is not specified, the last thread for the specified conversation_type will be retrieved. |

### `Query.aiModelSelectionNamespaceSettings`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

List of configurable AI features for namespace Model Selection.

Returns [`AiModelSelectionNamespaceFeatureSettingConnection`](#aimodelselectionnamespacefeaturesettingconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaimodelselectionnamespacesettingsgroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the model selection. |

### `Query.aiSelfHostedModels`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Returns the self-hosted model if an ID is provided, otherwise returns all models.

Returns [`AiSelfHostedModelConnection`](#aiselfhostedmodelconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaiselfhostedmodelsid"></a>`id` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | Global ID of a self-hosted model. |

### `Query.aiSlashCommands`

Get available GitLab Duo Chat slash commands for the current user for a specific URL.

Returns [`[SlashCommand!]`](#slashcommand).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaislashcommandsurl"></a>`url` | [`String!`](#string) | URL of the page the user is currently on. |

### `Query.auditEventDefinitions`

Definitions for all audit events available on the instance.

Returns [`AuditEventDefinitionConnection!`](#auditeventdefinitionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.auditEventsInstanceAmazonS3Configurations`

Instance-level Amazon S3 configurations for audit events.

Returns [`InstanceAmazonS3ConfigurationTypeConnection`](#instanceamazons3configurationtypeconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.auditEventsInstanceStreamingDestinations`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Instance-level external audit event streaming destinations.

Returns [`InstanceAuditEventStreamingDestinationConnection`](#instanceauditeventstreamingdestinationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.blobSearch`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Find code visible to the current user.

Returns [`BlobSearch`](#blobsearch).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryblobsearchchunkcount"></a>`chunkCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | **Introduced** in GitLab 17.2. **Status**: Experiment. Maximum chunks per file. |
| <a id="queryblobsearchexcludeforks"></a>`excludeForks` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 17.11. **Status**: Experiment. Excludes forked projects in the search. Always false for project search. Default is true. |
| <a id="queryblobsearchgroupid"></a>`groupId` {{< icon name="warning-solid" >}} | [`GroupID`](#groupid) | **Introduced** in GitLab 17.2. **Status**: Experiment. Group to search in. |
| <a id="queryblobsearchincludearchived"></a>`includeArchived` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 17.7. **Status**: Experiment. Includes archived projects in the search. Always true for project search. Default is false. |
| <a id="queryblobsearchpage"></a>`page` {{< icon name="warning-solid" >}} | [`Int`](#int) | **Introduced** in GitLab 17.2. **Status**: Experiment. Page number to fetch the results. |
| <a id="queryblobsearchperpage"></a>`perPage` {{< icon name="warning-solid" >}} | [`Int`](#int) | **Introduced** in GitLab 17.2. **Status**: Experiment. Number of results per page. |
| <a id="queryblobsearchprojectid"></a>`projectId` {{< icon name="warning-solid" >}} | [`ProjectID`](#projectid) | **Introduced** in GitLab 17.2. **Status**: Experiment. Project to search in. |
| <a id="queryblobsearchregex"></a>`regex` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 17.3. **Status**: Experiment. Uses the regular expression search mode. Default is false. |
| <a id="queryblobsearchrepositoryref"></a>`repositoryRef` {{< icon name="warning-solid" >}} | [`String`](#string) | **Introduced** in GitLab 17.2. **Status**: Experiment. Repository reference to search in. |
| <a id="queryblobsearchsearch"></a>`search` | [`String!`](#string) | Searched term. |

### `Query.boardList`

Find an issue board list.

Returns [`BoardList`](#boardlist).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryboardlistid"></a>`id` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="queryboardlistissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when getting issue metadata in the board list. |

### `Query.ciApplicationSettings`

CI related settings that apply to the entire instance.

Returns [`CiApplicationSettings`](#ciapplicationsettings).

### `Query.ciCatalogResource`

{{< details >}}
**Introduced** in GitLab 16.1.
**Status**: Experiment.
{{< /details >}}

A single CI/CD Catalog resource visible to an authorized user.

Returns [`CiCatalogResource`](#cicatalogresource).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcefullpath"></a>`fullPath` | [`ID`](#id) | CI/CD Catalog resource full path. |
| <a id="querycicatalogresourceid"></a>`id` | [`CiCatalogResourceID`](#cicatalogresourceid) | CI/CD Catalog resource global ID. |

### `Query.ciCatalogResources`

{{< details >}}
**Introduced** in GitLab 15.11.
**Status**: Experiment.
{{< /details >}}

All CI/CD Catalog resources under a common namespace, visible to an authorized user.

Returns [`CiCatalogResourceConnection`](#cicatalogresourceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcesscope"></a>`scope` | [`CiCatalogResourceScope`](#cicatalogresourcescope) | Scope of the returned catalog resources. |
| <a id="querycicatalogresourcessearch"></a>`search` | [`String`](#string) | Search term to filter the catalog resources by name or description. |
| <a id="querycicatalogresourcessort"></a>`sort` | [`CiCatalogResourceSort`](#cicatalogresourcesort) | Sort catalog resources by given criteria. |
| <a id="querycicatalogresourcestopics"></a>`topics` | [`[String!]`](#string) | Filter catalog resources by project topic names. |
| <a id="querycicatalogresourcesverificationlevel"></a>`verificationLevel` | [`CiCatalogResourceVerificationLevel`](#cicatalogresourceverificationlevel) | Filter catalog resources by verification level. |

### `Query.ciConfig`

{{< details >}}
**Deprecated** in GitLab 18.1.
Use CiLint mutation: <https://docs.gitlab.com/api/graphql/reference/#mutationcilint>.
{{< /details >}}

Linted and processed contents of a CI config.
Should not be requested more than once per request.

Returns [`CiConfig`](#ciconfig).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciconfigcontent"></a>`content` | [`String!`](#string) | Contents of `.gitlab-ci.yml`. |
| <a id="queryciconfigdryrun"></a>`dryRun` | [`Boolean`](#boolean) | Run pipeline creation simulation, or only do static check. |
| <a id="queryciconfigprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the CI config. |
| <a id="queryciconfigsha"></a>`sha` | [`String`](#string) | Sha for the pipeline. |
| <a id="queryciconfigskipverifyprojectsha"></a>`skipVerifyProjectSha` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 16.5. **Status**: Experiment. If the provided `sha` is found in the project's repository but is not associated with a Git reference (a detached commit), the verification fails and a validation error is returned. Otherwise, verification passes, even if the `sha` is invalid. Set to `true` to skip this verification process. |

### `Query.ciDedicatedHostedRunnerFilters`

Returns available filters for GitLab Dedicated runner usage data.

Returns [`CiDedicatedHostedRunnerFilters`](#cidedicatedhostedrunnerfilters).

### `Query.ciDedicatedHostedRunnerUsage`

Compute usage data for runners across namespaces on GitLab Dedicated. Defaults to the current year if no year or billing month is specified. Ultimate only.

Returns [`CiDedicatedHostedRunnerUsageConnection`](#cidedicatedhostedrunnerusageconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycidedicatedhostedrunnerusagebillingmonth"></a>`billingMonth` | [`Date`](#date) | First day of the month to retrieve data for. |
| <a id="querycidedicatedhostedrunnerusagegrouping"></a>`grouping` | [`GroupingEnum`](#groupingenum) | Groups usage data by instance aggregate or root namespace. |
| <a id="querycidedicatedhostedrunnerusagerunnerid"></a>`runnerId` | [`CiRunnerID`](#cirunnerid) | Runner ID to retrieve data for. |
| <a id="querycidedicatedhostedrunnerusageyear"></a>`year` | [`Int`](#int) | Year to retrieve data for. |

### `Query.ciMinutesUsage`

Compute usage data for a namespace.

Returns [`CiMinutesNamespaceMonthlyUsageConnection`](#ciminutesnamespacemonthlyusageconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciminutesusagedate"></a>`date` | [`Date`](#date) | Date for which to retrieve the usage data, should be the first day of a month. |
| <a id="queryciminutesusagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | Global ID of the Namespace for the monthly compute usage. |

### `Query.ciPipelineStage`

Stage belonging to a CI pipeline.

Returns [`CiStage`](#cistage).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycipipelinestageid"></a>`id` | [`CiStageID!`](#cistageid) | Global ID of the CI stage. |

### `Query.ciQueueingHistory`

Time taken for CI jobs to be picked up by runner by percentile. Enable the ClickHouse database backend to use this query.

Returns [`QueueingDelayHistory`](#queueingdelayhistory).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciqueueinghistoryfromtime"></a>`fromTime` | [`Time`](#time) | Start of the requested time. Defaults to three hours ago. |
| <a id="queryciqueueinghistoryrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Filter jobs by the type of runner that executed them. |
| <a id="queryciqueueinghistorytotime"></a>`toTime` | [`Time`](#time) | End of the requested time. Defaults to the current time. |

### `Query.ciVariables`

List of the instance's CI/CD variables.

Returns [`CiInstanceVariableConnection`](#ciinstancevariableconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycivariablessort"></a>`sort` | [`CiVariableSort`](#civariablesort) | Sort order of results. |

### `Query.cloudConnectorStatus`

{{< details >}}
**Introduced** in GitLab 17.3.
**Status**: Experiment.
{{< /details >}}

Run a series of status checks for Cloud Connector features.

Returns [`CloudConnectorStatus`](#cloudconnectorstatus).

### `Query.complianceRequirementControls`

Get the list of all the compliance requirement controls.

Returns [`ComplianceRequirementControl`](#compliancerequirementcontrol).

### `Query.containerRepository`

Find a container repository.

Returns [`ContainerRepositoryDetails`](#containerrepositorydetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | Global ID of the container repository. |

### `Query.currentLicense`

Fields related to the current license.

Returns [`CurrentLicense`](#currentlicense).

### `Query.currentUser`

Get information about current user.

Returns [`CurrentUser`](#currentuser).

### `Query.customField`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

Find a custom field by its ID.

Returns [`CustomField`](#customfield).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycustomfieldid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | Global ID of the custom field. |

### `Query.dependency`

Find a dependency.

Returns [`Dependency`](#dependency).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querydependencyid"></a>`id` | [`SbomOccurrenceID!`](#sbomoccurrenceid) | Global ID of the Dependency. |

### `Query.designManagement`

Fields related to design management.

Returns [`DesignManagement!`](#designmanagement).

### `Query.devopsAdoptionEnabledNamespaces`

Get configured DevOps adoption namespaces. **Status**: Beta. This endpoint is subject to change without notice.

Returns [`DevopsAdoptionEnabledNamespaceConnection`](#devopsadoptionenablednamespaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querydevopsadoptionenablednamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Filter by display namespace. |

### `Query.duoSettings`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Get GitLab Duo settings.

Returns [`DuoSettings`](#duosettings).

### `Query.duoWorkflowEvents`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

List the events for a Duo Agent Platform.

Returns [`DuoWorkflowEventConnection!`](#duoworkfloweventconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryduoworkfloweventsworkflowid"></a>`workflowId` | [`AiDuoWorkflowsWorkflowID!`](#aiduoworkflowsworkflowid) | Array of request IDs to fetch. |

### `Query.duoWorkflowWorkflows`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

List the workflows owned by the current user.

Returns [`DuoWorkflowConnection!`](#duoworkflowconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryduoworkflowworkflowsenvironment"></a>`environment` | [`WorkflowEnvironment`](#workflowenvironment) | Environment, for example, IDE or web. |
| <a id="queryduoworkflowworkflowsexcludetypes"></a>`excludeTypes` | [`[String!]`](#string) | Types of flows to exclude (for example, ["software_development", "chat"]). |
| <a id="queryduoworkflowworkflowsprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project that contains the flows. |
| <a id="queryduoworkflowworkflowssearch"></a>`search` | [`String`](#string) | Flow title or goal to search for. |
| <a id="queryduoworkflowworkflowssort"></a>`sort` | [`DuoWorkflowsWorkflowSort`](#duoworkflowsworkflowsort) | Sort flows by the criteria. |
| <a id="queryduoworkflowworkflowsstatusgroup"></a>`statusGroup` | [`DuoWorkflowStatusGroup`](#duoworkflowstatusgroup) | Status group to filter flow sessions by. |
| <a id="queryduoworkflowworkflowstype"></a>`type` | [`String`](#string) | Type of flow to filter by (for example, software_development or foundational_chat_agents). |
| <a id="queryduoworkflowworkflowsworkflowid"></a>`workflowId` | [`AiDuoWorkflowsWorkflowID`](#aiduoworkflowsworkflowid) | Flow ID to filter by. |

### `Query.echo`

Testing endpoint to validate the API with.

Returns [`String!`](#string).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryechotext"></a>`text` | [`String!`](#string) | Text to echo back. |

### `Query.epicBoardList`

Returns [`EpicList`](#epiclist).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryepicboardlistepicfilters"></a>`epicFilters` | [`EpicFilters`](#epicfilters) | Filters applied when getting epic metadata in the epic board list. |
| <a id="queryepicboardlistid"></a>`id` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the list. |

### `Query.featureFlagEnabled`

{{< details >}}
**Deprecated** in GitLab 17.4.
Replaced with metadata.featureFlags.
{{< /details >}}

Check if a feature flag is enabled.

Returns [`Boolean!`](#boolean).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryfeatureflagenabledname"></a>`name` | [`String!`](#string) | Name of the feature flag. |

### `Query.frecentGroups`

A user's frecently visited groups.

Returns [`[Group!]`](#group).

### `Query.frecentProjects`

A user's frecently visited projects.

Returns [`[Project!]`](#project).

### `Query.geoNode`

Find a Geo node.

Returns [`GeoNode`](#geonode).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygeonodename"></a>`name` | [`String`](#string) | Name of the Geo node. Defaults to the current Geo node name. |

### `Query.gitpodEnabled`

Whether Ona is enabled in application settings.

Returns [`Boolean`](#boolean).

### `Query.googleCloudArtifactRegistryRepositoryArtifact`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Details about an artifact in the Google Artifact Registry.

Returns [`GoogleCloudArtifactRegistryArtifactDetails`](#googlecloudartifactregistryartifactdetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygooglecloudartifactregistryrepositoryartifactgooglecloudprojectid"></a>`googleCloudProjectId` | [`String!`](#string) | ID of the Google Cloud project. |
| <a id="querygooglecloudartifactregistryrepositoryartifactimage"></a>`image` | [`String!`](#string) | Name of the image in the Google Artifact Registry. |
| <a id="querygooglecloudartifactregistryrepositoryartifactlocation"></a>`location` | [`String!`](#string) | Location of the Artifact Registry repository. |
| <a id="querygooglecloudartifactregistryrepositoryartifactprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path. |
| <a id="querygooglecloudartifactregistryrepositoryartifactrepository"></a>`repository` | [`String!`](#string) | Repository on the Google Artifact Registry. |

### `Query.group`

Find a group.

Returns [`Group`](#group).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygroupfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the group. For example, `gitlab-org/gitlab-foss`. |

### `Query.groupSecretsManager`

{{< details >}}
**Introduced** in GitLab 18.6.
**Status**: Experiment.
{{< /details >}}

Find a group secrets manager.

Returns [`GroupSecretsManager`](#groupsecretsmanager).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygroupsecretsmanagergrouppath"></a>`groupPath` | [`ID!`](#id) | Group of the secrets manager. |

### `Query.groups`

Find groups.

Returns [`GroupConnection`](#groupconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygroupsactive"></a>`active` | [`Boolean`](#boolean) | When `nil` (default value), returns all groups. When `true`, returns only groups that are not pending deletion. When `false`, only returns groups that are pending deletion. |
| <a id="querygroupsallavailable"></a>`allAvailable` | [`Boolean`](#boolean) | When `true`, returns all accessible groups. When `false`, returns only groups where the user is a member. Unauthenticated requests always return all public groups. The `owned_only` argument takes precedence. |
| <a id="querygroupsids"></a>`ids` | [`[ID!]`](#id) | Filter groups by IDs. |
| <a id="querygroupsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | Date when the group was marked for deletion. |
| <a id="querygroupsownedonly"></a>`ownedOnly` | [`Boolean`](#boolean) | Only include groups where the current user has an owner role. |
| <a id="querygroupsparentpath"></a>`parentPath` | [`ID`](#id) | Full path of the parent group. |
| <a id="querygroupssearch"></a>`search` | [`String`](#string) | Search query for group name or group full path. |
| <a id="querygroupssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. |
| <a id="querygroupstoplevelonly"></a>`topLevelOnly` | [`Boolean`](#boolean) | Only include top-level groups. |

### `Query.instanceExternalAuditEventDestinations`

Instance level external audit event destinations.

Returns [`InstanceExternalAuditEventDestinationConnection`](#instanceexternalauditeventdestinationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.instanceGoogleCloudLoggingConfigurations`

Instance level google cloud logging configurations.

Returns [`InstanceGoogleCloudLoggingConfigurationTypeConnection`](#instancegooglecloudloggingconfigurationtypeconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.instanceSecurityDashboard`

Fields related to Instance Security Dashboard.

Returns [`InstanceSecurityDashboard`](#instancesecuritydashboard).

### `Query.integrationExclusions`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Returns [`IntegrationExclusionConnection`](#integrationexclusionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryintegrationexclusionsintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | Type of integration. |

### `Query.issue`

Find an issue.

Returns [`Issue`](#issue).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryissueid"></a>`id` | [`IssueID!`](#issueid) | Global ID of the issue. |

### `Query.issues`

{{< details >}}
**Introduced** in GitLab 15.6.
**Status**: Experiment.
{{< /details >}}

Find issues visible to the current user. At least one filter must be provided.

Returns [`IssueConnection`](#issueconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryissuesassigneeid"></a>`assigneeId` | [`String`](#string) | ID of a user assigned to the issues. Wildcard values "NONE" and "ANY" are supported. |
| <a id="queryissuesassigneeusername"></a>`assigneeUsername` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated** in GitLab 13.11. Use `assigneeUsernames`. |
| <a id="queryissuesassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="queryissuesassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | Filter by assignee wildcard. Incompatible with assigneeUsername and assigneeUsernames. |
| <a id="queryissuesauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="queryissuesclosedafter"></a>`closedAfter` | [`Time`](#time) | Issues closed after the date. |
| <a id="queryissuesclosedbefore"></a>`closedBefore` | [`Time`](#time) | Issues closed before the date. |
| <a id="queryissuesconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter for confidential issues. If "false", excludes confidential issues. If "true", returns only confidential issues. |
| <a id="queryissuescreatedafter"></a>`createdAfter` | [`Time`](#time) | Issues created after the date. |
| <a id="queryissuescreatedbefore"></a>`createdBefore` | [`Time`](#time) | Issues created before the date. |
| <a id="queryissuescrmcontactid"></a>`crmContactId` | [`String`](#string) | ID of a contact assigned to the issues. |
| <a id="queryissuescrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | ID of an organization assigned to the issues. |
| <a id="queryissuescustomfield"></a>`customField` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldFilterInputType!]`](#workitemwidgetcustomfieldfilterinputtype) | **Introduced** in GitLab 17.10. **Status**: Experiment. Filter by custom fields. |
| <a id="queryissuesdueafter"></a>`dueAfter` | [`Time`](#time) | Return issues due on or after the given time. |
| <a id="queryissuesduebefore"></a>`dueBefore` | [`Time`](#time) | Return issues due on or before the given time. |
| <a id="queryissuesepicid"></a>`epicId` | [`String`](#string) | ID of an epic associated with the issues, "none" and "any" values are supported. |
| <a id="queryissuesepicwildcardid"></a>`epicWildcardId` | [`EpicWildcardId`](#epicwildcardid) | Filter by epic ID wildcard. Incompatible with epicId. |
| <a id="queryissueshealthstatusfilter"></a>`healthStatusFilter` | [`HealthStatusFilter`](#healthstatusfilter) | Health status of the issue, "none" and "any" values are supported. |
| <a id="queryissuesiid"></a>`iid` | [`String`](#string) | IID of the issue. For example, "1". |
| <a id="queryissuesiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of issues. For example, `["1", "2"]`. |
| <a id="queryissuesin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="queryissuesincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | Whether to include issues from archived projects. Defaults to `false`. |
| <a id="queryissuesincludesubepics"></a>`includeSubepics` | [`Boolean`](#boolean) | Whether to include subepics when filtering issues by epicId. |
| <a id="queryissuesiterationcadenceid"></a>`iterationCadenceId` | [`[IterationsCadenceID!]`](#iterationscadenceid) | Filter by a list of iteration cadence IDs. |
| <a id="queryissuesiterationid"></a>`iterationId` | [`[ID]`](#id) | List of iteration Global IDs applied to the issue. |
| <a id="queryissuesiterationtitle"></a>`iterationTitle` | [`String`](#string) | Filter by iteration title. |
| <a id="queryissuesiterationwildcardid"></a>`iterationWildcardId` | [`IterationWildcardId`](#iterationwildcardid) | Filter by iteration ID wildcard. |
| <a id="queryissueslabelname"></a>`labelName` | [`[String]`](#string) | Labels applied to the issue. |
| <a id="queryissuesmilestonetitle"></a>`milestoneTitle` | [`[String]`](#string) | Milestone applied to the issue. |
| <a id="queryissuesmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | Filter issues by milestone ID wildcard. |
| <a id="queryissuesmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. Wildcard values "NONE" and "ANY" are supported. |
| <a id="queryissuesnot"></a>`not` | [`NegatedIssueFilterInput`](#negatedissuefilterinput) | Negated arguments. |
| <a id="queryissuesor"></a>`or` | [`UnionedIssueFilterInput`](#unionedissuefilterinput) | List of arguments with inclusive OR. |
| <a id="queryissuessearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="queryissuessort"></a>`sort` | [`IssueSort`](#issuesort) | Sort issues by the criteria. |
| <a id="queryissuesstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of the issue. |
| <a id="queryissuesstatus"></a>`status` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusFilterInput`](#workitemwidgetstatusfilterinput) | **Introduced** in GitLab 18.0. **Status**: Experiment. Filter by status. |
| <a id="queryissuessubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | Issues the current user is subscribed to. |
| <a id="queryissuestypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter issues by the given issue types. |
| <a id="queryissuesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Issues updated after the date. |
| <a id="queryissuesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Issues updated before the date. |
| <a id="queryissuesweight"></a>`weight` | [`String`](#string) | Weight applied to the issue, "none" and "any" values are supported. |
| <a id="queryissuesweightwildcardid"></a>`weightWildcardId` | [`WeightWildcardId`](#weightwildcardid) | Filter by weight ID wildcard. Incompatible with weight. |

### `Query.iteration`

Find an iteration.

Returns [`Iteration`](#iteration).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryiterationid"></a>`id` | [`IterationID!`](#iterationid) | Find an iteration by its ID. |

### `Query.jobs`

All jobs on this GitLab instance. Returns an empty result for users without administrator access.

Returns [`CiJobInterfaceConnection`](#cijobinterfaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryjobscompatiblerunnerid"></a>`compatibleRunnerId` {{< icon name="warning-solid" >}} | [`CiRunnerID`](#cirunnerid) | **Introduced** in GitLab 18.1. **Status**: Experiment. ID of a runner that matches the requirements of the jobs returned (normally used when filtering pending jobs). |
| <a id="queryjobsfailurereason"></a>`failureReason` {{< icon name="warning-solid" >}} | [`CiJobFailureReason`](#cijobfailurereason) | **Introduced** in GitLab 16.4. **Status**: Experiment. Filter jobs by failure reason. Currently only `RUNNER_SYSTEM_FAILURE` together with `runnerTypes: INSTANCE_TYPE` is supported. |
| <a id="queryjobsrunnertypes"></a>`runnerTypes` {{< icon name="warning-solid" >}} | [`[CiRunnerType!]`](#cirunnertype) | **Introduced** in GitLab 16.4. **Status**: Experiment. Filter jobs by runner type if feature flag `:admin_jobs_filter_runner_type` is enabled. |
| <a id="queryjobsstatuses"></a>`statuses` | [`[CiJobStatus!]`](#cijobstatus) | Filter jobs by status. |

### `Query.ldapAdminRoleLinks`

{{< details >}}
**Introduced** in GitLab 17.11.
**Status**: Experiment.
{{< /details >}}

LDAP admin links. Available only for GitLab Self-Managed.

Returns [`LdapAdminRoleLinkConnection`](#ldapadminrolelinkconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.licenseHistoryEntries`

Fields related to entries in the license history.

Returns [`LicenseHistoryEntryConnection`](#licensehistoryentryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.mavenUpstreamRegistry`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Find a Maven upstream registry. Returns null if the `maven_virtual_registry` feature flag is disabled.

Returns [`MavenUpstreamDetails`](#mavenupstreamdetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymavenupstreamregistryid"></a>`id` | [`VirtualRegistriesPackagesMavenUpstreamID!`](#virtualregistriespackagesmavenupstreamid) | Global ID of the Maven upstream registry. |

### `Query.mavenVirtualRegistry`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Find a Maven virtual registry. Returns null if the `maven_virtual_registry` feature flag is disabled.

Returns [`MavenRegistryDetails`](#mavenregistrydetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymavenvirtualregistryid"></a>`id` | [`VirtualRegistriesPackagesMavenRegistryID!`](#virtualregistriespackagesmavenregistryid) | Global ID of the Maven virtual registry. |

### `Query.memberRole`

{{< details >}}
**Introduced** in GitLab 16.6.
**Status**: Experiment.
{{< /details >}}

Finds a single custom role for the instance. Available only for GitLab Self-Managed.

Returns [`MemberRole`](#memberrole).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymemberroleid"></a>`id` | [`MemberRoleID`](#memberroleid) | Global ID of the member role to look up. |
| <a id="querymemberroleids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | Global IDs of the member role to look up. |
| <a id="querymemberroleorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | Ordering column. Default is NAME. |
| <a id="querymemberrolesort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | Ordering column. Default is ASC. |

### `Query.memberRolePermissions`

{{< details >}}
**Introduced** in GitLab 16.4.
**Status**: Experiment.
{{< /details >}}

List of all standard customizable permissions.

Returns [`CustomizableStandardPermissionConnection`](#customizablestandardpermissionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.memberRoles`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Custom roles available for the instance. Available only for GitLab Self-Managed.

Returns [`MemberRoleConnection`](#memberroleconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymemberrolesid"></a>`id` | [`MemberRoleID`](#memberroleid) | Global ID of the member role to look up. |
| <a id="querymemberrolesids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | Global IDs of the member role to look up. |
| <a id="querymemberrolesorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | Ordering column. Default is NAME. |
| <a id="querymemberrolessort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | Ordering column. Default is ASC. |

### `Query.mergeRequest`

Find a merge request.

Returns [`MergeRequest`](#mergerequest).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymergerequestid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | Global ID of the merge request. |

### `Query.metadata`

Metadata about GitLab.

Returns [`Metadata`](#metadata).

### `Query.milestone`

Find a milestone.

Returns [`Milestone`](#milestone).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymilestoneid"></a>`id` | [`MilestoneID!`](#milestoneid) | Find a milestone by its ID. |

### `Query.mlExperiment`

Find a machine learning experiment.

Returns [`MlExperiment`](#mlexperiment).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymlexperimentid"></a>`id` | [`MlExperimentID!`](#mlexperimentid) | ID of the experiment. |

### `Query.mlModel`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Find machine learning models.

Returns [`MlModel`](#mlmodel).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymlmodelid"></a>`id` | [`MlModelID!`](#mlmodelid) | ID of the model. |

### `Query.namespace`

Find a namespace.

Returns [`Namespace`](#namespace).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querynamespacefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace. For example, `gitlab-org/gitlab-foss`. |

### `Query.namespaceSecurityProjects`

Security-filtered projects for a namespace.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querynamespacesecurityprojectsattributefilters"></a>`attributeFilters` | [`[AttributeFilterInput!]`](#attributefilterinput) | Filter projects by security attributes. Up to 20 items. |
| <a id="querynamespacesecurityprojectsincludesubgroups"></a>`includeSubgroups` | [`Boolean`](#boolean) | Include also subgroup projects. |
| <a id="querynamespacesecurityprojectsnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Global ID of the namespace. |
| <a id="querynamespacesecurityprojectssearch"></a>`search` | [`String`](#string) | Search projects by name. |
| <a id="querynamespacesecurityprojectssecurityanalyzerfilters"></a>`securityAnalyzerFilters` | [`[AnalyzerFilterInput!]`](#analyzerfilterinput) | Filter projects by analyzer type and status. |
| <a id="querynamespacesecurityprojectsvulnerabilitycountfilters"></a>`vulnerabilityCountFilters` | [`[VulnerabilityCountFilterInput!]`](#vulnerabilitycountfilterinput) | Filter projects by vulnerability counts using comparison operators. |

### `Query.note`

{{< details >}}
**Introduced** in GitLab 15.9.
**Status**: Experiment.
{{< /details >}}

Find a note.

Returns [`Note`](#note).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querynoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note. |

### `Query.organization`

{{< details >}}
**Introduced** in GitLab 16.4.
**Status**: Experiment.
{{< /details >}}

Find an organization.

Returns [`Organization`](#organization).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryorganizationid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | ID of the organization. |

### `Query.organizations`

{{< details >}}
**Introduced** in GitLab 16.8.
**Status**: Experiment.
{{< /details >}}

List organizations.

Returns [`OrganizationConnection`](#organizationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryorganizationssearch"></a>`search` | [`String`](#string) | Search query, which can be for the organization name or a path. |

### `Query.package`

Find a package. This field can only be resolved for one query in any single request. Returns `null` if a package has no `default` status.

Returns [`PackageDetailsType`](#packagedetailstype).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | Global ID of the package. |

### `Query.project`

Find a project.

Returns [`Project`](#project).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the project. For example, `gitlab-org/gitlab-foss`. |

### `Query.projectComplianceViolation`

Find a project compliance violation.

Returns [`ProjectComplianceViolation`](#projectcomplianceviolation).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectcomplianceviolationid"></a>`id` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | Global ID of the project compliance violation. |

### `Query.projectSecret`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

View a specific project secret.

Returns [`ProjectSecret`](#projectsecret).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretname"></a>`name` | [`String!`](#string) | Name of the project secret to view. |
| <a id="queryprojectsecretprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the secrets belong to. |

### `Query.projectSecrets`

{{< details >}}
**Introduced** in GitLab 17.8.
**Status**: Experiment.
{{< /details >}}

List project secrets.

Returns [`ProjectSecretConnection`](#projectsecretconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the secrets belong to. |

### `Query.projectSecretsManager`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

Find a project secrets manager.

Returns [`ProjectSecretsManager`](#projectsecretsmanager).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretsmanagerprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the secrets manager. |

### `Query.projectSecretsNeedingRotation`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

List project secrets that need to be rotated.

Returns [`ProjectSecretConnection`](#projectsecretconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretsneedingrotationprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the secrets belong to. |

### `Query.projects`

Find projects visible to the current user.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectsactive"></a>`active` | [`Boolean`](#boolean) | Filters by projects that are not archived and not marked for deletion. |
| <a id="queryprojectsaimedfordeletion"></a>`aimedForDeletion` | [`Boolean`](#boolean) | Return only projects marked for deletion. |
| <a id="queryprojectsarchived"></a>`archived` | [`ProjectArchived`](#projectarchived) | Filter projects by archived status. |
| <a id="queryprojectsfullpaths"></a>`fullPaths` | [`[String!]`](#string) | Filter projects by full paths. You cannot provide more than 50 full paths. |
| <a id="queryprojectsids"></a>`ids` | [`[ID!]`](#id) | Filter projects by IDs. |
| <a id="queryprojectsincludehidden"></a>`includeHidden` | [`Boolean`](#boolean) | Include hidden projects. |
| <a id="queryprojectslastrepositorycheckfailed"></a>`lastRepositoryCheckFailed` | [`Boolean`](#boolean) | Return only projects where the last repository check failed. Only available for administrators. |
| <a id="queryprojectsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | Date when the project was marked for deletion. |
| <a id="queryprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | Return only projects that the current user is a member of. |
| <a id="queryprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | Return only projects where current user has at least the specified access level. |
| <a id="queryprojectsnamespacepath"></a>`namespacePath` | [`ID`](#id) | Filter projects by their namespace's full path (group or user). |
| <a id="queryprojectsnotaimedfordeletion"></a>`notAimedForDeletion` | [`Boolean`](#boolean) | Exclude projects that are marked for deletion. |
| <a id="queryprojectspersonal"></a>`personal` | [`Boolean`](#boolean) | Return only personal projects. |
| <a id="queryprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | Filter projects by programming language name (case insensitive). For example: `css` or `ruby`. |
| <a id="queryprojectssearch"></a>`search` | [`String`](#string) | Search query, which can be for the project name, a path, or a description. |
| <a id="queryprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | Include namespace in project search. |
| <a id="queryprojectssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. Defaults to `id_desc`, or `similarity` if search used. |
| <a id="queryprojectstopics"></a>`topics` | [`[String!]`](#string) | Filter projects by topics. |
| <a id="queryprojectstrending"></a>`trending` | [`Boolean`](#boolean) | Return only projects that are trending. |
| <a id="queryprojectsvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | Filter projects by visibility level. |
| <a id="queryprojectswithcodeembeddingsindexed"></a>`withCodeEmbeddingsIndexed` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 18.2. **Status**: Experiment. Include projects with indexed code embeddings. Requires `ids` to be sent. Applies only if the feature flag `allow_with_code_embeddings_indexed_projects_filter` is enabled. |
| <a id="queryprojectswithduoeligible"></a>`withDuoEligible` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Introduced** in GitLab 18.6. **Status**: Experiment. Include only projects that are eligible for GitLab Duo and have Duo features enabled.Applies only if the feature flag `with_duo_eligible_projects_filter` is enabled. |
| <a id="queryprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | Return only projects with issues enabled. |
| <a id="queryprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | Return only projects with merge requests enabled. |

### `Query.queryComplexity`

Information about the complexity of the GraphQL query.

Returns [`QueryComplexity`](#querycomplexity).

### `Query.runner`

Find a runner.

Returns [`CiRunner`](#cirunner).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnerid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | Runner ID. |

### `Query.runnerPlatforms`

{{< details >}}
**Deprecated** in GitLab 15.9.
No longer used, use gitlab-runner documentation to learn about supported platforms.
{{< /details >}}

Supported runner platforms.

Returns [`RunnerPlatformConnection`](#runnerplatformconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.runnerSetup`

{{< details >}}
**Deprecated** in GitLab 15.9.
No longer used, use gitlab-runner documentation to learn about runner registration commands.
{{< /details >}}

Runner setup instructions.

Returns [`RunnerSetup`](#runnersetup).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnersetuparchitecture"></a>`architecture` | [`String!`](#string) | Architecture to generate the instructions for. |
| <a id="queryrunnersetupgroupid"></a>`groupId` {{< icon name="warning-solid" >}} | [`GroupID`](#groupid) | **Deprecated** in GitLab 13.11. No longer used. |
| <a id="queryrunnersetupplatform"></a>`platform` | [`String!`](#string) | Platform to generate the instructions for. |
| <a id="queryrunnersetupprojectid"></a>`projectId` {{< icon name="warning-solid" >}} | [`ProjectID`](#projectid) | **Deprecated** in GitLab 13.11. No longer used. |

### `Query.runnerUsage`

Runner usage by runner. Enable the ClickHouse database backend to use this query.

Returns [`[CiRunnerUsage!]`](#cirunnerusage).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagefromdate"></a>`fromDate` | [`Date`](#date) | Start of the requested date frame. Defaults to the start of the previous calendar month. |
| <a id="queryrunnerusagefullpath"></a>`fullPath` | [`ID`](#id) | Filter jobs by the full path of the group or project they belong to. For example, `gitlab-org` or `gitlab-org/gitlab`. Available only to administrators and users with the Maintainer role for the group (when a group is specified), or project (when a project is specified). Limited to runners from 5000 child projects. |
| <a id="queryrunnerusagerunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Filter runners by the type. |
| <a id="queryrunnerusagerunnerslimit"></a>`runnersLimit` | [`Int`](#int) | Maximum number of runners to return. Other runners will be aggregated to a `runner: null` entry. Defaults to 5 if unspecified. Maximum of 500. |
| <a id="queryrunnerusagetodate"></a>`toDate` | [`Date`](#date) | End of the requested date frame. Defaults to the end of the previous calendar month. |

### `Query.runnerUsageByProject`

Runner usage by project. Enable the ClickHouse database backend to use this query.

Returns [`[CiRunnerUsageByProject!]`](#cirunnerusagebyproject).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagebyprojectfromdate"></a>`fromDate` | [`Date`](#date) | Start of the requested date frame. Defaults to the start of the previous calendar month. |
| <a id="queryrunnerusagebyprojectfullpath"></a>`fullPath` | [`ID`](#id) | Filter jobs based on the full path of the group or project they belong to. For example, `gitlab-org` or `gitlab-org/gitlab`. Available only to administrators and users with the Maintainer role for the group (when a group is specified), or project (when a project is specified). Limited to runners from 5000 child projects. |
| <a id="queryrunnerusagebyprojectprojectslimit"></a>`projectsLimit` | [`Int`](#int) | Maximum number of projects to return. Other projects will be aggregated to a `project: null` entry. Defaults to 5 if unspecified. Maximum of 500. |
| <a id="queryrunnerusagebyprojectrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Filter jobs by the type of runner that executed them. |
| <a id="queryrunnerusagebyprojecttodate"></a>`toDate` | [`Date`](#date) | End of the requested date frame. Defaults to the end of the previous calendar month. |

### `Query.runners`

Get all runners in the GitLab instance (project and shared). Access is restricted to users with administrator access.

Returns [`CiRunnerConnection`](#cirunnerconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnersactive"></a>`active` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated** in GitLab 14.8. This was renamed. Use: `paused`. |
| <a id="queryrunnerscreatorid"></a>`creatorId` | [`UserID`](#userid) | Filter runners by creator ID. |
| <a id="queryrunnerscreatorusername"></a>`creatorUsername` | [`String`](#string) | Filter runners by creator username. |
| <a id="queryrunnersownerfullpath"></a>`ownerFullPath` {{< icon name="warning-solid" >}} | [`String`](#string) | **Introduced** in GitLab 17.8. **Status**: Experiment. Filter runners by owning project or group. |
| <a id="queryrunnerspaused"></a>`paused` | [`Boolean`](#boolean) | Filter runners by `paused` (true) or `active` (false) status. |
| <a id="queryrunnerssearch"></a>`search` | [`String`](#string) | Filter by full token or partial text in description field. |
| <a id="queryrunnerssort"></a>`sort` | [`CiRunnerSort`](#cirunnersort) | Sort order of results. |
| <a id="queryrunnersstatus"></a>`status` | [`CiRunnerStatus`](#cirunnerstatus) | Filter runners by status. |
| <a id="queryrunnerstaglist"></a>`tagList` | [`[String!]`](#string) | Filter by tags associated with the runner (comma-separated or array). |
| <a id="queryrunnerstype"></a>`type` | [`CiRunnerType`](#cirunnertype) | Filter runners by type. |
| <a id="queryrunnersupgradestatus"></a>`upgradeStatus` | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | Filter by upgrade status. |
| <a id="queryrunnersversionprefix"></a>`versionPrefix` | [`String`](#string) | Filter runners by version. Runners that contain runner managers with the version at the start of the search term are returned. For example, the search term '14.' returns runner managers with versions '14.11.1' and '14.2.3'. |

### `Query.secretPermissions`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

List secret permissions.

Returns [`SecretPermissionConnection`](#secretpermissionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysecretpermissionsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the secret permission belong to. |

### `Query.securityPoliciesSyncStatus`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Get the current security policy synchronization status.

Returns [`PoliciesSyncUpdated`](#policiessyncupdated).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysecuritypoliciessyncstatuspolicyconfigurationid"></a>`policyConfigurationId` | [`SecurityOrchestrationPolicyConfigurationID!`](#securityorchestrationpolicyconfigurationid) | ID of the security orchestration policy configuration. |

### `Query.selfManagedAddOnEligibleUsers`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Users within the self-managed instance who are eligible for add-ons.

Returns [`AddOnUserConnection`](#addonuserconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryselfmanagedaddoneligibleusersaddonpurchaseids"></a>`addOnPurchaseIds` | [`[GitlabSubscriptionsAddOnPurchaseID!]!`](#gitlabsubscriptionsaddonpurchaseid) | Global IDs of the add on purchases to find assignments for. |
| <a id="queryselfmanagedaddoneligibleusersaddontype"></a>`addOnType` | [`GitlabSubscriptionsAddOnType!`](#gitlabsubscriptionsaddontype) | Type of add on to filter the eligible users by. |
| <a id="queryselfmanagedaddoneligibleusersfilterbyassignedseat"></a>`filterByAssignedSeat` | [`String`](#string) | Filter users list by assigned seat. |
| <a id="queryselfmanagedaddoneligibleuserssearch"></a>`search` | [`String`](#string) | Search the user list. |
| <a id="queryselfmanagedaddoneligibleuserssort"></a>`sort` | [`GitlabSubscriptionsUserSort`](#gitlabsubscriptionsusersort) | Sort the user list. |

### `Query.selfManagedUsersQueuedForRolePromotion`

Fields related to users within a self-managed instance that are pending role promotion approval.

Returns [`UsersQueuedForRolePromotionConnection`](#usersqueuedforrolepromotionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.snippets`

Find Snippets visible to the current user.

Returns [`SnippetConnection`](#snippetconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysnippetsauthorid"></a>`authorId` | [`UserID`](#userid) | ID of an author. |
| <a id="querysnippetsexplore"></a>`explore` | [`Boolean`](#boolean) | Explore personal snippets. |
| <a id="querysnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | Array of global snippet IDs. For example, `gid://gitlab/ProjectSnippet/1`. |
| <a id="querysnippetsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | ID of a project. |
| <a id="querysnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | Type of snippet. |
| <a id="querysnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | Visibility of the snippet. |

### `Query.standardRole`

{{< details >}}
**Introduced** in GitLab 17.6.
**Status**: Experiment.
{{< /details >}}

Finds a single default role for the instance. Available only for GitLab Self-Managed.

Returns [`StandardRole`](#standardrole).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querystandardroleaccesslevel"></a>`accessLevel` | [`[MemberAccessLevel!]`](#memberaccesslevel) | Access level or levels to filter by. |

### `Query.standardRoles`

{{< details >}}
**Introduced** in GitLab 17.3.
**Status**: Experiment.
{{< /details >}}

Default roles available for the instance. Available only for GitLab Self-Managed.

Returns [`StandardRoleConnection`](#standardroleconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querystandardrolesaccesslevel"></a>`accessLevel` | [`[MemberAccessLevel!]`](#memberaccesslevel) | Access level or levels to filter by. |

### `Query.subscriptionFutureEntries`

Fields related to entries in future subscriptions.

Returns [`SubscriptionFutureEntryConnection`](#subscriptionfutureentryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.subscriptionUsage`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Usage data of consumables under the subscription.

Returns [`GitlabSubscriptionUsage`](#gitlabsubscriptionusage).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysubscriptionusagenamespacepath"></a>`namespacePath` | [`ID`](#id) | Path of the top-level namespace. Leave it blank if querying the instance subscription. |

### `Query.syntheticNote`

{{< details >}}
**Introduced** in GitLab 15.9.
**Status**: Experiment.
{{< /details >}}

Find a synthetic note.

Returns [`Note`](#note).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysyntheticnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to search synthetic note on. |
| <a id="querysyntheticnotesha"></a>`sha` | [`String!`](#string) | Global ID of the note. |

### `Query.timelogs`

Find timelogs visible to the current user.

Returns [`TimelogConnection`](#timelogconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytimelogsenddate"></a>`endDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or before endDate. |
| <a id="querytimelogsendtime"></a>`endTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or before endTime. |
| <a id="querytimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | List timelogs for a group. |
| <a id="querytimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | List timelogs for a project. |
| <a id="querytimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | List timelogs in a particular order. |
| <a id="querytimelogsstartdate"></a>`startDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or after startDate. |
| <a id="querytimelogsstarttime"></a>`startTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or after startTime. |
| <a id="querytimelogsusername"></a>`username` | [`String`](#string) | List timelogs for a user. |

### `Query.todo`

Retrieve a single to-do item.

Returns [`Todo`](#todo).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytodoid"></a>`id` | [`TodoID!`](#todoid) | ID of the to-do item. |

### `Query.topics`

Find project topics.

Returns [`TopicConnection`](#topicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytopicsorganizationid"></a>`organizationId` {{< icon name="warning-solid" >}} | [`OrganizationsOrganizationID`](#organizationsorganizationid) | **Introduced** in GitLab 17.7. **Status**: Experiment. Global ID of the organization. |
| <a id="querytopicssearch"></a>`search` | [`String`](#string) | Search query for topic name. |

### `Query.usageTrendsMeasurements`

Get statistics on the instance.

Returns [`UsageTrendsMeasurementConnection`](#usagetrendsmeasurementconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryusagetrendsmeasurementsidentifier"></a>`identifier` | [`MeasurementIdentifier!`](#measurementidentifier) | Type of measurement or statistics to retrieve. |
| <a id="queryusagetrendsmeasurementsrecordedafter"></a>`recordedAfter` | [`Time`](#time) | Measurement recorded after the date. |
| <a id="queryusagetrendsmeasurementsrecordedbefore"></a>`recordedBefore` | [`Time`](#time) | Measurement recorded before the date. |

### `Query.user`

Find a user.

Returns [`UserCore`](#usercore).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryuserid"></a>`id` | [`UserID`](#userid) | ID of the User. |
| <a id="queryuserusername"></a>`username` | [`String`](#string) | Username of the User. |

### `Query.users`

Find users.

Returns [`UserCoreConnection`](#usercoreconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryusersactive"></a>`active` | [`Boolean`](#boolean) | Filter by active users. When true, returns active users. When false, returns non-active users. |
| <a id="queryusersadmins"></a>`admins` | [`Boolean`](#boolean) | Return only admin users. |
| <a id="queryusersgroupid"></a>`groupId` | [`GroupID`](#groupid) | Return users member of a given group. |
| <a id="queryusershumans"></a>`humans` | [`Boolean`](#boolean) | Filter by regular users. When true, returns only users that are not bot or internal users. When false, returns only users that are bot or internal users. |
| <a id="queryusersids"></a>`ids` | [`[ID!]`](#id) | List of user Global IDs. |
| <a id="queryuserssearch"></a>`search` | [`String`](#string) | Query to search users by name, username, or primary email. |
| <a id="queryuserssort"></a>`sort` | [`Sort`](#sort) | Sort users by the criteria. |
| <a id="queryusersusertypes"></a>`userTypes` {{< icon name="warning-solid" >}} | [`[UserType!]`](#usertype) | **Introduced** in GitLab 18.3. **Status**: Experiment. Filter by user type. |
| <a id="queryusersusernames"></a>`usernames` | [`[String!]`](#string) | List of usernames. |

### `Query.virtualRegistriesPackagesMavenRegistry`

{{< details >}}
**Introduced** in GitLab 18.6.
**Status**: Experiment.
{{< /details >}}

Find a Maven virtual registry. Returns null if the `maven_virtual_registry` feature flag is disabled.

Returns [`MavenRegistryDetails`](#mavenregistrydetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvirtualregistriespackagesmavenregistryid"></a>`id` | [`VirtualRegistriesPackagesMavenRegistryID!`](#virtualregistriespackagesmavenregistryid) | Global ID of the Maven virtual registry. |

### `Query.virtualRegistriesPackagesMavenUpstream`

{{< details >}}
**Introduced** in GitLab 18.6.
**Status**: Experiment.
{{< /details >}}

Find a Maven upstream registry. Returns null if the `maven_virtual_registry` feature flag is disabled.

Returns [`MavenUpstreamDetails`](#mavenupstreamdetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvirtualregistriespackagesmavenupstreamid"></a>`id` | [`VirtualRegistriesPackagesMavenUpstreamID!`](#virtualregistriespackagesmavenupstreamid) | Global ID of the Maven upstream registry. |

### `Query.vulnerabilities`

Vulnerabilities reported on projects on the current user's instance security dashboard.

Returns [`VulnerabilityConnection`](#vulnerabilityconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiesclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | Filter vulnerabilities by `cluster_agent_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="queryvulnerabilitiesclusterid"></a>`clusterId` | [`[ClustersClusterID!]`](#clustersclusterid) | Filter vulnerabilities by `cluster_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="queryvulnerabilitiesdismissalreason"></a>`dismissalReason` | [`[VulnerabilityDismissalReason!]`](#vulnerabilitydismissalreason) | Filter by dismissal reason. Only dismissed Vulnerabilities will be included with the filter. |
| <a id="queryvulnerabilitieshasairesolution"></a>`hasAiResolution` | [`Boolean`](#boolean) | Returns only the vulnerabilities which can likely be resolved by GitLab Duo Vulnerability Resolution. |
| <a id="queryvulnerabilitieshasissues"></a>`hasIssues` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have linked issues. |
| <a id="queryvulnerabilitieshasmergerequest"></a>`hasMergeRequest` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have linked merge requests. |
| <a id="queryvulnerabilitieshasremediations"></a>`hasRemediations` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have remediations. |
| <a id="queryvulnerabilitieshasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have been resolved on default branch. |
| <a id="queryvulnerabilitiesidentifiername"></a>`identifierName` | [`String`](#string) | Filter vulnerabilities by identifier name. Ignored when applied on instance security dashboard queries. |
| <a id="queryvulnerabilitiesimage"></a>`image` | [`[String!]`](#string) | Filter vulnerabilities by location image. When this filter is present, the response only matches entries for a `reportType` that includes `container_scanning`, `cluster_image_scanning`. |
| <a id="queryvulnerabilitiesowasptopten"></a>`owaspTopTen` | [`[VulnerabilityOwaspTop10!]`](#vulnerabilityowasptop10) | Filter vulnerabilities by OWASP Top 10 2017 category. Wildcard value `NONE` is also supported but it cannot be combined with other OWASP top 10 values. |
| <a id="queryvulnerabilitiesowasptopten2021"></a>`owaspTopTen2021` {{< icon name="warning-solid" >}} | [`[VulnerabilityOwasp2021Top10!]`](#vulnerabilityowasp2021top10) | **Introduced** in GitLab 18.1. **Status**: Experiment. Filter vulnerabilities by OWASP Top 10 2021 category. Wildcard value `NONE` is also supported but it cannot be combined with other OWASP top 10 2021 values. To use this argument, you must have Elasticsearch configured and the `advanced_vulnerability_management` feature flag enabled. Not supported on Instance Security Dashboard queries. |
| <a id="queryvulnerabilitiespolicyviolations"></a>`policyViolations` {{< icon name="warning-solid" >}} | [`[PolicyViolations!]`](#policyviolations) | **Introduced** in GitLab 18.6. **Status**: Experiment. Filter by security policy violations. To use this argument, you must have Elasticsearch configured and the `advanced_vulnerability_management` feature flag enabled. Not supported on Instance Security Dashboard queries. |
| <a id="queryvulnerabilitiesprojectid"></a>`projectId` | [`[ID!]`](#id) | Filter vulnerabilities by project. |
| <a id="queryvulnerabilitiesreachability"></a>`reachability` {{< icon name="warning-solid" >}} | [`ReachabilityType`](#reachabilitytype) | **Introduced** in GitLab 18.2. **Status**: Experiment. Filter vulnerabilities by reachability. |
| <a id="queryvulnerabilitiesreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | Filter vulnerabilities by report type. |
| <a id="queryvulnerabilitiesscanner"></a>`scanner` | [`[String!]`](#string) | Filter vulnerabilities by VulnerabilityScanner.externalId. |
| <a id="queryvulnerabilitiesscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | Filter vulnerabilities by scanner ID. |
| <a id="queryvulnerabilitiesseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | Filter vulnerabilities by severity. |
| <a id="queryvulnerabilitiessort"></a>`sort` | [`VulnerabilitySort`](#vulnerabilitysort) | List vulnerabilities by sort order. |
| <a id="queryvulnerabilitiesstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | Filter vulnerabilities by state. |
| <a id="queryvulnerabilitiesvaliditycheck"></a>`validityCheck` {{< icon name="warning-solid" >}} | [`[VulnerabilityFindingTokenStatusState!]`](#vulnerabilityfindingtokenstatusstate) | **Introduced** in GitLab 18.5. **Status**: Experiment. Filter vulnerabilities by validity check. |

### `Query.vulnerabilitiesCountByDay`

The historical number of vulnerabilities per day for the projects on the current user's instance security dashboard.

Returns [`VulnerabilitiesCountByDayConnection`](#vulnerabilitiescountbydayconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiescountbydayenddate"></a>`endDate` | [`ISO8601Date!`](#iso8601date) | Last day for which to fetch vulnerability history. |
| <a id="queryvulnerabilitiescountbydaystartdate"></a>`startDate` | [`ISO8601Date!`](#iso8601date) | First day for which to fetch vulnerability history. |

### `Query.vulnerability`

Find a vulnerability.

Returns [`Vulnerability`](#vulnerability).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilityid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | Global ID of the Vulnerability. |

### `Query.wikiPage`

{{< details >}}
**Introduced** in GitLab 17.6.
**Status**: Experiment.
{{< /details >}}

Find a wiki page.

Returns [`WikiPage`](#wikipage).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querywikipagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | Wiki page namespace ID. |
| <a id="querywikipageprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Wiki page project ID. |
| <a id="querywikipageslug"></a>`slug` | [`String`](#string) | Wiki page slug. |

### `Query.workItem`

{{< details >}}
**Introduced** in GitLab 15.1.
**Status**: Experiment.
{{< /details >}}

Find a work item.

Returns [`WorkItem`](#workitem).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkitemid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |

### `Query.workItemAllowedStatuses`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Allowed work item statuses from the root groups the current user belongs to.

Returns [`WorkItemStatusConnection`](#workitemstatusconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkitemallowedstatusesname"></a>`name` | [`String`](#string) | Filter statuses by name. |

### `Query.workItemDescriptionTemplateContent`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Find a work item description template.

Returns [`WorkItemDescriptionTemplate`](#workitemdescriptiontemplate).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkitemdescriptiontemplatecontenttemplatecontentinput"></a>`templateContentInput` | [`WorkItemDescriptionTemplateContentInput!`](#workitemdescriptiontemplatecontentinput) | Input for fetching a specific description template. |

### `Query.workItemsByReference`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Find work items by their reference.

Returns [`WorkItemConnection`](#workitemconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkitemsbyreferencecontextnamespacepath"></a>`contextNamespacePath` | [`ID`](#id) | Full path of the context namespace (project or group). |
| <a id="queryworkitemsbyreferencerefs"></a>`refs` | [`[String!]!`](#string) | Work item references. Can be either a short reference or URL. |

### `Query.workspace`

Find a workspace.

Returns [`Workspace`](#workspace).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkspaceid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | Find a workspace by its ID. |

### `Query.workspaces`

Find workspaces across the entire instance. This field is only available to instance admins, it will return an empty result for all non-admins.

Returns [`WorkspaceConnection`](#workspaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | Filter workspaces by actual states. |
| <a id="queryworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | Filter workspaces by agent GlobalIDs. |
| <a id="queryworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | Filter workspaces by workspace GlobalIDs. For example, `["gid://gitlab/RemoteDevelopment::Workspace/1"]`. |
| <a id="queryworkspacesincludeactualstates"></a>`includeActualStates` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | **Deprecated** in GitLab 16.7. Use actual_states instead. |
| <a id="queryworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | Filter workspaces by project GlobalIDs. |
| <a id="queryworkspacesuserids"></a>`userIds` | [`[ProjectID!]`](#projectid) | Filter workspaces by user GlobalIDs. |

## `Mutation` type

The `Mutation` type contains all the mutations you can execute.

All mutations receive their arguments in a single input object named `input`, and all mutations
support at least a return field `errors` containing a list of error messages.

All input objects may have a `clientMutationId: String` field, identifying the mutation.

For example:

```graphql
mutation($id: NoteableID!, $body: String!) {
  createNote(input: { noteableId: $id, body: $body }) {
    errors
  }
}
```

### `Mutation.achievementsAward`

{{< details >}}
**Introduced** in GitLab 15.10.
**Status**: Experiment.
{{< /details >}}

Input type: `AchievementsAwardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being awarded. |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsawarduserid"></a>`userId` | [`UserID!`](#userid) | Global ID of the user being awarded the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsawarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationachievementsawarduserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Achievement award. |

### `Mutation.achievementsCreate`

{{< details >}}
**Introduced** in GitLab 15.8.
**Status**: Experiment.
{{< /details >}}

Input type: `AchievementsCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the achievement. |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementscreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the achievement. |
| <a id="mutationachievementscreatename"></a>`name` | [`String!`](#string) | Name for the achievement. |
| <a id="mutationachievementscreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Namespace for the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement created. |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.achievementsDelete`

{{< details >}}
**Introduced** in GitLab 15.11.
**Status**: Experiment.
{{< /details >}}

Input type: `AchievementsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being deleted. |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement. |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.achievementsRevoke`

{{< details >}}
**Introduced** in GitLab 15.10.
**Status**: Experiment.
{{< /details >}}

Input type: `AchievementsRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsrevokeuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | Global ID of the user achievement being revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationachievementsrevokeuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Achievement award. |

### `Mutation.achievementsUpdate`

{{< details >}}
**Introduced** in GitLab 15.11.
**Status**: Experiment.
{{< /details >}}

Input type: `AchievementsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being updated. |
| <a id="mutationachievementsupdateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the achievement. |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the achievement. |
| <a id="mutationachievementsupdatename"></a>`name` | [`String`](#string) | Name for the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement. |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.addProjectToSecurityDashboard`

Input type: `AddProjectToSecurityDashboardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaddprojecttosecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | ID of the project to be added to Instance Security Dashboard. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaddprojecttosecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaddprojecttosecuritydashboardproject"></a>`project` | [`Project`](#project) | Project that was added to the Instance Security Dashboard. |

### `Mutation.adminRolesLdapSync`

{{< details >}}
**Introduced** in GitLab 18.0.
**Status**: Experiment.
{{< /details >}}

Input type: `AdminRolesLdapSyncInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminrolesldapsyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminrolesldapsyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationadminrolesldapsyncerrors"></a>`errors` | [`[String!]`](#string) | Errors encountered during operation. |
| <a id="mutationadminrolesldapsyncsuccess"></a>`success` | [`Boolean`](#boolean) | Whether the sync was successfully enqueued. |

### `Mutation.adminSidekiqQueuesDeleteJobs`

Input type: `AdminSidekiqQueuesDeleteJobsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsairesource"></a>`aiResource` | [`String`](#string) | Delete jobs matching ai_resource in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsize"></a>`artifactSize` | [`String`](#string) | Delete jobs matching artifact_size in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactusedcdn"></a>`artifactUsedCdn` | [`String`](#string) | Delete jobs matching artifact_used_cdn in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciescount"></a>`artifactsDependenciesCount` | [`String`](#string) | Delete jobs matching artifacts_dependencies_count in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciessize"></a>`artifactsDependenciesSize` | [`String`](#string) | Delete jobs matching artifacts_dependencies_size in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsbulkimportentityid"></a>`bulkImportEntityId` | [`String`](#string) | Delete jobs matching bulk_import_entity_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobscallerid"></a>`callerId` | [`String`](#string) | Delete jobs matching caller_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsclientid"></a>`clientId` | [`String`](#string) | Delete jobs matching client_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobsfeaturecategory"></a>`featureCategory` | [`String`](#string) | Delete jobs matching feature_category in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsgluserid"></a>`glUserId` | [`String`](#string) | Delete jobs matching gl_user_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsjobid"></a>`jobId` | [`String`](#string) | Delete jobs matching job_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobskubernetesagentid"></a>`kubernetesAgentId` | [`String`](#string) | Delete jobs matching kubernetes_agent_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsmergeactionstatus"></a>`mergeActionStatus` | [`String`](#string) | Delete jobs matching merge_action_status in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsorganizationid"></a>`organizationId` | [`String`](#string) | Delete jobs matching organization_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobspipelineid"></a>`pipelineId` | [`String`](#string) | Delete jobs matching pipeline_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobspolicysyncconfigid"></a>`policySyncConfigId` | [`String`](#string) | Delete jobs matching policy_sync_config_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsproject"></a>`project` | [`String`](#string) | Delete jobs matching project in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsqueuename"></a>`queueName` | [`String!`](#string) | Name of the queue to delete jobs from. |
| <a id="mutationadminsidekiqqueuesdeletejobsrelatedclass"></a>`relatedClass` | [`String`](#string) | Delete jobs matching related_class in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsremoteip"></a>`remoteIp` | [`String`](#string) | Delete jobs matching remote_ip in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsrootcallerid"></a>`rootCallerId` | [`String`](#string) | Delete jobs matching root_caller_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsrootnamespace"></a>`rootNamespace` | [`String`](#string) | Delete jobs matching root_namespace in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsscopeduser"></a>`scopedUser` | [`String`](#string) | Delete jobs matching scoped_user in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsscopeduserid"></a>`scopedUserId` | [`String`](#string) | Delete jobs matching scoped_user_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobssidekiqdestinationshardredis"></a>`sidekiqDestinationShardRedis` | [`String`](#string) | Delete jobs matching sidekiq_destination_shard_redis in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobssubscriptionplan"></a>`subscriptionPlan` | [`String`](#string) | Delete jobs matching subscription_plan in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsuser"></a>`user` | [`String`](#string) | Delete jobs matching user in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsuserid"></a>`userId` | [`String`](#string) | Delete jobs matching user_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsworkerclass"></a>`workerClass` | [`String`](#string) | Delete jobs with the given worker class. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobsresult"></a>`result` | [`DeleteJobsResponse`](#deletejobsresponse) | Information about the status of the deletion request. |

### `Mutation.aiAction`

{{< details >}}
**Introduced** in GitLab 15.11.
**Status**: Experiment.
{{< /details >}}

Input type: `AiActionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiactionagenticchat"></a>`agenticChat` | [`AiAgenticChatInput`](#aiagenticchatinput) | Input for agentic_chat AI action. |
| <a id="mutationaiactionchat"></a>`chat` | [`AiChatInput`](#aichatinput) | Input for chat AI action. |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiactionclientsubscriptionid"></a>`clientSubscriptionId` | [`String`](#string) | Client generated ID that can be subscribed to, to receive a response for the mutation. |
| <a id="mutationaiactionconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | Conversation type of the thread. |
| <a id="mutationaiactiondescriptioncomposer"></a>`descriptionComposer` | [`AiDescriptionComposerInput`](#aidescriptioncomposerinput) | Input for description_composer AI action. |
| <a id="mutationaiactionexplainvulnerability"></a>`explainVulnerability` | [`AiExplainVulnerabilityInput`](#aiexplainvulnerabilityinput) | Input for explain_vulnerability AI action. |
| <a id="mutationaiactiongeneratecommitmessage"></a>`generateCommitMessage` | [`AiGenerateCommitMessageInput`](#aigeneratecommitmessageinput) | Input for generate_commit_message AI action. |
| <a id="mutationaiactiongeneratedescription"></a>`generateDescription` | [`AiGenerateDescriptionInput`](#aigeneratedescriptioninput) | Input for generate_description AI action. |
| <a id="mutationaiactionmeasurecommenttemperature"></a>`measureCommentTemperature` | [`AiMeasureCommentTemperatureInput`](#aimeasurecommenttemperatureinput) | Input for measure_comment_temperature AI action. |
| <a id="mutationaiactionplatformorigin"></a>`platformOrigin` | [`String`](#string) | Specifies the origin platform of the request. |
| <a id="mutationaiactionprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project the user is acting on. |
| <a id="mutationaiactionresolvevulnerability"></a>`resolveVulnerability` | [`AiResolveVulnerabilityInput`](#airesolvevulnerabilityinput) | Input for resolve_vulnerability AI action. |
| <a id="mutationaiactionrootnamespaceid"></a>`rootNamespaceId` | [`NamespaceID`](#namespaceid) | Global ID of the top-level namespace the user is acting on. |
| <a id="mutationaiactionsummarizenewmergerequest"></a>`summarizeNewMergeRequest` | [`AiSummarizeNewMergeRequestInput`](#aisummarizenewmergerequestinput) | Input for summarize_new_merge_request AI action. |
| <a id="mutationaiactionsummarizereview"></a>`summarizeReview` | [`AiSummarizeReviewInput`](#aisummarizereviewinput) | Input for summarize_review AI action. |
| <a id="mutationaiactionthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | Global Id of the existing thread to continue the conversation. If it is not specified, a new thread will be created for the specified conversation_type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiactionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaiactionrequestid"></a>`requestId` | [`String`](#string) | ID of the request. |
| <a id="mutationaiactionthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | Global Id of the thread. |

### `Mutation.aiAgentCreate`

{{< details >}}
**Introduced** in GitLab 16.8.
**Status**: Experiment.
{{< /details >}}

Input type: `AiAgentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentcreatename"></a>`name` | [`String!`](#string) | Name of the agent. |
| <a id="mutationaiagentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to which the agent belongs. |
| <a id="mutationaiagentcreateprompt"></a>`prompt` | [`String!`](#string) | Prompt for the agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateagent"></a>`agent` | [`AiAgent`](#aiagent) | Agent after mutation. |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiAgentDestroy`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `AiAgentDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | Global ID of the AI Agent to be deleted. |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to which the agent belongs. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagent"></a>`agent` | [`AiAgent`](#aiagent) | Agent after mutation. |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaiagentdestroymessage"></a>`message` | [`String`](#string) | AI Agent deletion result message. |

### `Mutation.aiAgentUpdate`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `AiAgentUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | ID of the agent. |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentupdatename"></a>`name` | [`String`](#string) | Name of the agent. |
| <a id="mutationaiagentupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to which the agent belongs. |
| <a id="mutationaiagentupdateprompt"></a>`prompt` | [`String`](#string) | Prompt for the agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagent"></a>`agent` | [`AiAgent`](#aiagent) | Agent after mutation. |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiCatalogAgentCreate`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogAgentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentcreateaddtoprojectwhencreated"></a>`addToProjectWhenCreated` | [`Boolean`](#boolean) | Whether to add to the project upon creation. |
| <a id="mutationaicatalogagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentcreatedescription"></a>`description` | [`String!`](#string) | Description for the agent. |
| <a id="mutationaicatalogagentcreatename"></a>`name` | [`String!`](#string) | Name for the agent. |
| <a id="mutationaicatalogagentcreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Project for the agent. |
| <a id="mutationaicatalogagentcreatepublic"></a>`public` | [`Boolean!`](#boolean) | Whether the agent is publicly visible in the catalog. |
| <a id="mutationaicatalogagentcreaterelease"></a>`release` | [`Boolean`](#boolean) | Whether to release the latest version of the agent. |
| <a id="mutationaicatalogagentcreatesystemprompt"></a>`systemPrompt` | [`String!`](#string) | System prompt for the agent. |
| <a id="mutationaicatalogagentcreatetools"></a>`tools` | [`[AiCatalogBuiltInToolID!]`](#aicatalogbuiltintoolid) | List of GitLab tools enabled for the agent. |
| <a id="mutationaicatalogagentcreateuserprompt"></a>`userPrompt` | [`String`](#string) | User prompt for the agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogagentcreateitem"></a>`item` | [`AiCatalogAgent`](#aicatalogagent) | Item created. |

### `Mutation.aiCatalogAgentDelete`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogAgentDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentdeleteforceharddelete"></a>`forceHardDelete` | [`Boolean`](#boolean) | When true, the flow will always be hard deleted and never soft deleted. Can only be used by instance admins. |
| <a id="mutationaicatalogagentdeleteid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog Agent to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogagentdeletesuccess"></a>`success` | [`Boolean!`](#boolean) | Returns true if catalog Agent was successfully deleted. |

### `Mutation.aiCatalogAgentExecute`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogAgentExecuteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentexecuteagentid"></a>`agentId` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the AI catalog agent to execute. |
| <a id="mutationaicatalogagentexecuteagentversionid"></a>`agentVersionId` | [`AiCatalogItemVersionID`](#aicatalogitemversionid) | Global ID of the specific agent version to use. If not provided, the latest version will be used. |
| <a id="mutationaicatalogagentexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentexecuteuserprompt"></a>`userPrompt` | [`String!`](#string) | User prompt that will be used for agent execution. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentexecuteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogagentexecuteflowconfig"></a>`flowConfig` | [`String`](#string) | YAML configuration that can be used in Duo workflow service for flow execution. |
| <a id="mutationaicatalogagentexecuteworkflow"></a>`workflow` | [`DuoWorkflow`](#duoworkflow) | Created workflow. |

### `Mutation.aiCatalogAgentUpdate`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogAgentUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentupdatedescription"></a>`description` | [`String`](#string) | Description for the agent. |
| <a id="mutationaicatalogagentupdateid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog Agent to update. |
| <a id="mutationaicatalogagentupdatename"></a>`name` | [`String`](#string) | Name for the agent. |
| <a id="mutationaicatalogagentupdatepublic"></a>`public` | [`Boolean`](#boolean) | Whether the agent is publicly visible in the catalog. |
| <a id="mutationaicatalogagentupdaterelease"></a>`release` | [`Boolean`](#boolean) | Whether to release the latest version of the agent. |
| <a id="mutationaicatalogagentupdatesystemprompt"></a>`systemPrompt` | [`String`](#string) | System prompt for the agent. |
| <a id="mutationaicatalogagentupdatetools"></a>`tools` | [`[AiCatalogBuiltInToolID!]`](#aicatalogbuiltintoolid) | List of GitLab tools enabled for the agent. |
| <a id="mutationaicatalogagentupdateuserprompt"></a>`userPrompt` | [`String`](#string) | User prompt for the agent. |
| <a id="mutationaicatalogagentupdateversionbump"></a>`versionBump` | [`AiCatalogVersionBump`](#aicatalogversionbump) | Bump version, calculated from the last released version name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogagentupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogagentupdateitem"></a>`item` | [`AiCatalogAgent`](#aicatalogagent) | Agent that was updated. |

### `Mutation.aiCatalogFlowCreate`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogFlowCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowcreateaddtoprojectwhencreated"></a>`addToProjectWhenCreated` | [`Boolean`](#boolean) | Whether to add to the project upon creation. |
| <a id="mutationaicatalogflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowcreatedefinition"></a>`definition` | [`String`](#string) | YAML definition for the flow. |
| <a id="mutationaicatalogflowcreatedescription"></a>`description` | [`String!`](#string) | Description for the flow. |
| <a id="mutationaicatalogflowcreatename"></a>`name` | [`String!`](#string) | Name for the flow. |
| <a id="mutationaicatalogflowcreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Project for the flow. |
| <a id="mutationaicatalogflowcreatepublic"></a>`public` | [`Boolean!`](#boolean) | Whether the flow is publicly visible in the catalog. |
| <a id="mutationaicatalogflowcreaterelease"></a>`release` | [`Boolean`](#boolean) | Whether to release the latest version of the flow. |
| <a id="mutationaicatalogflowcreatesteps"></a>`steps` | [`[AiCatalogFlowStepsInput!]`](#aicatalogflowstepsinput) | Steps for the flow. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogflowcreateitem"></a>`item` | [`AiCatalogFlow`](#aicatalogflow) | Item created. |

### `Mutation.aiCatalogFlowDelete`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogFlowDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowdeleteforceharddelete"></a>`forceHardDelete` | [`Boolean`](#boolean) | When true, the flow will always be hard deleted and never soft deleted. Can only be used by instance admins. |
| <a id="mutationaicatalogflowdeleteid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog flow to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogflowdeletesuccess"></a>`success` | [`Boolean!`](#boolean) | Returns true if catalog flow was successfully deleted. |

### `Mutation.aiCatalogFlowExecute`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogFlowExecuteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowexecuteflowid"></a>`flowId` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the AI catalog flow to execute. |
| <a id="mutationaicatalogflowexecuteflowversionid"></a>`flowVersionId` | [`AiCatalogItemVersionID`](#aicatalogitemversionid) | Global ID of the specific flow version to use. If not provided, the latest version will be used. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowexecuteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogflowexecuteflowconfig"></a>`flowConfig` | [`String`](#string) | YAML configuration that can be used in Duo workflow service for flow execution. |
| <a id="mutationaicatalogflowexecuteworkflow"></a>`workflow` | [`DuoWorkflow`](#duoworkflow) | Created workflow. |

### `Mutation.aiCatalogFlowUpdate`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogFlowUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowupdatedefinition"></a>`definition` | [`String`](#string) | YAML definition for the Flow. |
| <a id="mutationaicatalogflowupdatedescription"></a>`description` | [`String`](#string) | Description for the flow. |
| <a id="mutationaicatalogflowupdateid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog flow to update. |
| <a id="mutationaicatalogflowupdatename"></a>`name` | [`String`](#string) | Name for the flow. |
| <a id="mutationaicatalogflowupdatepublic"></a>`public` | [`Boolean`](#boolean) | Whether the flow is publicly visible in the catalog. |
| <a id="mutationaicatalogflowupdaterelease"></a>`release` | [`Boolean`](#boolean) | Whether to release the latest version of the flow. |
| <a id="mutationaicatalogflowupdatesteps"></a>`steps` | [`[AiCatalogFlowStepsInput!]`](#aicatalogflowstepsinput) | Steps for the flow. |
| <a id="mutationaicatalogflowupdateversionbump"></a>`versionBump` | [`AiCatalogVersionBump`](#aicatalogversionbump) | Bump version, calculated from the last released version name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogflowupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogflowupdateitem"></a>`item` | [`AiCatalogFlow`](#aicatalogflow) | Flow that was updated. |

### `Mutation.aiCatalogItemConsumerCreate`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogItemConsumerCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemconsumercreateitemid"></a>`itemId` | [`AiCatalogItemID!`](#aicatalogitemid) | Item to configure. |
| <a id="mutationaicatalogitemconsumercreateparentitemconsumerid"></a>`parentItemConsumerId` | [`AiCatalogItemConsumerID`](#aicatalogitemconsumerid) | Parent item consumer belonging to the top-level group. |
| <a id="mutationaicatalogitemconsumercreatepinnedversionprefix"></a>`pinnedVersionPrefix` | [`String`](#string) | Major version, minor version, or patch to pin the item to. |
| <a id="mutationaicatalogitemconsumercreatetarget"></a>`target` | [`ItemConsumerTargetInput!`](#itemconsumertargetinput) | Target project or top-level group in which the catalog item is configured. |
| <a id="mutationaicatalogitemconsumercreatetriggertypes"></a>`triggerTypes` | [`[String!]`](#string) | List of event types to create flow triggers for (values can be mention, assign or assign_reviewer). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemconsumercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogitemconsumercreateitemconsumer"></a>`itemConsumer` | [`AiCatalogItemConsumer`](#aicatalogitemconsumer) | Item configuration created. |

### `Mutation.aiCatalogItemConsumerDelete`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogItemConsumerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemconsumerdeleteid"></a>`id` | [`AiCatalogItemConsumerID!`](#aicatalogitemconsumerid) | Global ID of the catalog item consumer to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemconsumerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogitemconsumerdeletesuccess"></a>`success` | [`Boolean!`](#boolean) | Returns true if catalog item consumer was successfully deleted. |

### `Mutation.aiCatalogItemConsumerUpdate`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogItemConsumerUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemconsumerupdateid"></a>`id` | [`AiCatalogItemConsumerID!`](#aicatalogitemconsumerid) | Global ID of the catalog item consumer to update. |
| <a id="mutationaicatalogitemconsumerupdatepinnedversionprefix"></a>`pinnedVersionPrefix` | [`String`](#string) | Major version, minor version, or patch to pin the item to. |
| <a id="mutationaicatalogitemconsumerupdateserviceaccountid"></a>`serviceAccountId` | [`UserID`](#userid) | Service account to associate with the item consumer. |
| <a id="mutationaicatalogitemconsumerupdatetriggertypes"></a>`triggerTypes` | [`[String!]`](#string) | List of event types to create flow triggers for (values can be mention, assign or assign_reviewer). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemconsumerupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogitemconsumerupdateitemconsumer"></a>`itemConsumer` | [`AiCatalogItemConsumer`](#aicatalogitemconsumer) | Item consumer that was updated. |

### `Mutation.aiCatalogItemReport`

{{< details >}}
**Introduced** in GitLab 18.7.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogItemReportInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemreportbody"></a>`body` | [`String`](#string) | Additional details about the report. Limited to 1000 characters. |
| <a id="mutationaicatalogitemreportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemreportid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog item to report. |
| <a id="mutationaicatalogitemreportreason"></a>`reason` | [`AiCatalogItemReportReason!`](#aicatalogitemreportreason) | Reason for reporting the catalog item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemreportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogitemreporterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiCatalogThirdPartyFlowCreate`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogThirdPartyFlowCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogthirdpartyflowcreateaddtoprojectwhencreated"></a>`addToProjectWhenCreated` | [`Boolean`](#boolean) | Whether to add to the project upon creation. |
| <a id="mutationaicatalogthirdpartyflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogthirdpartyflowcreatedefinition"></a>`definition` | [`String!`](#string) | YAML definition for the Flow. |
| <a id="mutationaicatalogthirdpartyflowcreatedescription"></a>`description` | [`String!`](#string) | Description for the Flow. |
| <a id="mutationaicatalogthirdpartyflowcreatename"></a>`name` | [`String!`](#string) | Name for the Flow. |
| <a id="mutationaicatalogthirdpartyflowcreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Project for the Flow. |
| <a id="mutationaicatalogthirdpartyflowcreatepublic"></a>`public` | [`Boolean!`](#boolean) | Whether the Flow is publicly visible in the catalog. |
| <a id="mutationaicatalogthirdpartyflowcreaterelease"></a>`release` | [`Boolean`](#boolean) | Whether to release the latest version of the Flow. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogthirdpartyflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogthirdpartyflowcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogthirdpartyflowcreateitem"></a>`item` | [`AiCatalogThirdPartyFlow`](#aicatalogthirdpartyflow) | Item created. |

### `Mutation.aiCatalogThirdPartyFlowDelete`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogThirdPartyFlowDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogthirdpartyflowdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogthirdpartyflowdeleteforceharddelete"></a>`forceHardDelete` | [`Boolean`](#boolean) | When true, the Third Party Flow will always be hard deleted and never soft deleted. Can only be used by instance admins. |
| <a id="mutationaicatalogthirdpartyflowdeleteid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog Third Party Flow to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogthirdpartyflowdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogthirdpartyflowdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogthirdpartyflowdeletesuccess"></a>`success` | [`Boolean!`](#boolean) | Returns true if catalog Third Party Flow was successfully deleted. |

### `Mutation.aiCatalogThirdPartyFlowUpdate`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Input type: `AiCatalogThirdPartyFlowUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogthirdpartyflowupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogthirdpartyflowupdatedefinition"></a>`definition` | [`String`](#string) | YAML definition for the Flow. |
| <a id="mutationaicatalogthirdpartyflowupdatedescription"></a>`description` | [`String`](#string) | Description for the Flow. |
| <a id="mutationaicatalogthirdpartyflowupdateid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | Global ID of the catalog Flow to update. |
| <a id="mutationaicatalogthirdpartyflowupdatename"></a>`name` | [`String`](#string) | Name for the Flow. |
| <a id="mutationaicatalogthirdpartyflowupdatepublic"></a>`public` | [`Boolean`](#boolean) | Whether the Flow is publicly visible in the catalog. |
| <a id="mutationaicatalogthirdpartyflowupdaterelease"></a>`release` | [`Boolean`](#boolean) | Whether to release the latest version of the Flow. |
| <a id="mutationaicatalogthirdpartyflowupdateversionbump"></a>`versionBump` | [`AiCatalogVersionBump`](#aicatalogversionbump) | Bump version, calculated from the last released version name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogthirdpartyflowupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaicatalogthirdpartyflowupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaicatalogthirdpartyflowupdateitem"></a>`item` | [`AiCatalogThirdPartyFlow`](#aicatalogthirdpartyflow) | Flow that was updated. |

### `Mutation.aiDuoWorkflowCreate`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Input type: `AiDuoWorkflowCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiduoworkflowcreateagentprivileges"></a>`agentPrivileges` | [`[Int!]`](#int) | Actions the agent is allowed to perform. |
| <a id="mutationaiduoworkflowcreateaicatalogitemversionid"></a>`aiCatalogItemVersionId` | [`AiCatalogItemVersionID`](#aicatalogitemversionid) | ID of the catalog item the workflow is triggered from. |
| <a id="mutationaiduoworkflowcreateallowagenttorequestuser"></a>`allowAgentToRequestUser` | [`Boolean`](#boolean) | When enabled, Duo Agent Platform may stop to ask the user questions before proceeding. |
| <a id="mutationaiduoworkflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiduoworkflowcreateenvironment"></a>`environment` | [`WorkflowEnvironment`](#workflowenvironment) | Environment for the workflow. |
| <a id="mutationaiduoworkflowcreategoal"></a>`goal` | [`String`](#string) | Goal of the workflow. |
| <a id="mutationaiduoworkflowcreatenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | Global ID of the namespace the user is acting on. |
| <a id="mutationaiduoworkflowcreatepreapprovedagentprivileges"></a>`preApprovedAgentPrivileges` | [`[Int!]`](#int) | Actions the agent can perform without asking for approval. |
| <a id="mutationaiduoworkflowcreateprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project the user is acting on. |
| <a id="mutationaiduoworkflowcreateworkflowdefinition"></a>`workflowDefinition` | [`String`](#string) | Workflow type based on its capability. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiduoworkflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiduoworkflowcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the creation process. |
| <a id="mutationaiduoworkflowcreateworkflow"></a>`workflow` | [`DuoWorkflow`](#duoworkflow) | Created workflow. |

### `Mutation.aiFeatureSettingUpdate`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

Updates or creates settings for AI features.

Input type: `AiFeatureSettingUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaifeaturesettingupdateaiselfhostedmodelid"></a>`aiSelfHostedModelId` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | Global ID of the self-hosted model providing the AI setting. |
| <a id="mutationaifeaturesettingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaifeaturesettingupdatefeatures"></a>`features` | [`[AiFeatures!]!`](#aifeatures) | Array of AI features being configured (for single or batch update). |
| <a id="mutationaifeaturesettingupdateofferedmodelref"></a>`offeredModelRef` | [`String`](#string) | Identifier of the selected model for the feature. |
| <a id="mutationaifeaturesettingupdateprovider"></a>`provider` | [`AiFeatureProviders!`](#aifeatureproviders) | Provider for AI setting. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaifeaturesettingupdateaifeaturesettings"></a>`aiFeatureSettings` | [`[AiFeatureSetting!]!`](#aifeaturesetting) | List of AI feature settings after mutation. |
| <a id="mutationaifeaturesettingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaifeaturesettingupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiFlowTriggerCreate`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiFlowTriggerCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggercreateaicatalogitemconsumerid"></a>`aiCatalogItemConsumerId` | [`AiCatalogItemConsumerID`](#aicatalogitemconsumerid) | AI catalog item consumer to use instead of config_path. |
| <a id="mutationaiflowtriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiflowtriggercreateconfigpath"></a>`configPath` | [`String`](#string) | Path to the configuration file for the AI flow trigger. |
| <a id="mutationaiflowtriggercreatedescription"></a>`description` | [`String!`](#string) | Description of the AI flow trigger. |
| <a id="mutationaiflowtriggercreateeventtypes"></a>`eventTypes` | [`[Int!]`](#int) | Event types that triggers the AI flow. |
| <a id="mutationaiflowtriggercreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the AI flow trigger is associated with. |
| <a id="mutationaiflowtriggercreateuserid"></a>`userId` | [`UserID!`](#userid) | Owner of the AI flow trigger. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggercreateaiflowtrigger"></a>`aiFlowTrigger` | [`AiFlowTriggerType`](#aiflowtriggertype) | Created AI flow trigger. |
| <a id="mutationaiflowtriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiflowtriggercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiFlowTriggerDelete`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiFlowTriggerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiflowtriggerdeleteid"></a>`id` | [`AiFlowTriggerID!`](#aiflowtriggerid) | ID of the flow trigger to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiflowtriggerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiFlowTriggerUpdate`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `AiFlowTriggerUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerupdateaicatalogitemconsumerid"></a>`aiCatalogItemConsumerId` | [`AiCatalogItemConsumerID`](#aicatalogitemconsumerid) | AI catalog item consumer to use instead of config_path. |
| <a id="mutationaiflowtriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiflowtriggerupdateconfigpath"></a>`configPath` | [`String`](#string) | Path to the configuration file for the AI flow trigger. |
| <a id="mutationaiflowtriggerupdatedescription"></a>`description` | [`String`](#string) | Description of the AI flow trigger. |
| <a id="mutationaiflowtriggerupdateeventtypes"></a>`eventTypes` | [`[Int!]`](#int) | Event types that triggers the AI flow. |
| <a id="mutationaiflowtriggerupdateid"></a>`id` | [`AiFlowTriggerID!`](#aiflowtriggerid) | ID of the flow trigger to update. |
| <a id="mutationaiflowtriggerupdateuserid"></a>`userId` | [`UserID`](#userid) | Owner of the AI flow trigger. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerupdateaiflowtrigger"></a>`aiFlowTrigger` | [`AiFlowTriggerType`](#aiflowtriggertype) | Updated AI flow trigger. |
| <a id="mutationaiflowtriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiflowtriggerupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiModelSelectionNamespaceUpdate`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Updates or creates settings for AI features for a namespace.

Input type: `AiModelSelectionNamespaceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaimodelselectionnamespaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaimodelselectionnamespaceupdatefeatures"></a>`features` | [`[AiModelSelectionFeatures!]!`](#aimodelselectionfeatures) | Array of AI features being configured (for single or batch update). |
| <a id="mutationaimodelselectionnamespaceupdategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the model selection. |
| <a id="mutationaimodelselectionnamespaceupdateofferedmodelref"></a>`offeredModelRef` | [`String!`](#string) | Identifier of the selected model for the feature. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaimodelselectionnamespaceupdateaifeaturesettings"></a>`aiFeatureSettings` {{< icon name="warning-solid" >}} | [`[AiModelSelectionNamespaceFeatureSetting!]!`](#aimodelselectionnamespacefeaturesetting) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.1. |
| <a id="mutationaimodelselectionnamespaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaimodelselectionnamespaceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiSelfHostedModelConnectionCheck`

{{< details >}}
**Introduced** in GitLab 17.7.
**Status**: Experiment.
{{< /details >}}

Checks if the AI Gateway can establish a connection with the given model configuration.

Input type: `AiSelfHostedModelConnectionCheckInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelconnectioncheckapitoken"></a>`apiToken` | [`String`](#string) | API token to access the self-hosted model, if any. |
| <a id="mutationaiselfhostedmodelconnectioncheckclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodelconnectioncheckendpoint"></a>`endpoint` | [`String!`](#string) | Endpoint of the self-hosted model. |
| <a id="mutationaiselfhostedmodelconnectioncheckidentifier"></a>`identifier` | [`String`](#string) | Identifier for 3rd party model provider. |
| <a id="mutationaiselfhostedmodelconnectioncheckmodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | AI model deployed. |
| <a id="mutationaiselfhostedmodelconnectioncheckname"></a>`name` | [`String!`](#string) | Deployment name of the self-hosted model. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelconnectioncheckclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodelconnectioncheckerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaiselfhostedmodelconnectioncheckresult"></a>`result` | [`CloudConnectorProbeResult`](#cloudconnectorproberesult) | Self-hosted hosted connection check result. |

### `Mutation.aiSelfHostedModelCreate`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Input type: `AiSelfHostedModelCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelcreateapitoken"></a>`apiToken` | [`String`](#string) | API token to access the self-hosted model, if any. |
| <a id="mutationaiselfhostedmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodelcreateendpoint"></a>`endpoint` | [`String!`](#string) | Endpoint of the self-hosted model. |
| <a id="mutationaiselfhostedmodelcreateidentifier"></a>`identifier` | [`String`](#string) | Identifier for 3rd party model provider. |
| <a id="mutationaiselfhostedmodelcreatemodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | AI model deployed. |
| <a id="mutationaiselfhostedmodelcreatename"></a>`name` | [`String!`](#string) | Deployment name of the self-hosted model. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodelcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaiselfhostedmodelcreateselfhostedmodel"></a>`selfHostedModel` | [`AiSelfHostedModel`](#aiselfhostedmodel) | Self-hosted model after mutation. |

### `Mutation.aiSelfHostedModelDelete`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Deletes a self-hosted model.

Input type: `AiSelfHostedModelDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodeldeleteid"></a>`id` | [`AiSelfHostedModelID!`](#aiselfhostedmodelid) | Global ID of the self-hosted model to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodeldeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.aiSelfHostedModelUpdate`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Updates a self-hosted model.

Input type: `AiSelfHostedModelUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelupdateapitoken"></a>`apiToken` | [`String`](#string) | API token to access the self-hosted model, if any. |
| <a id="mutationaiselfhostedmodelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodelupdateendpoint"></a>`endpoint` | [`String!`](#string) | Endpoint of the self-hosted model. |
| <a id="mutationaiselfhostedmodelupdateid"></a>`id` | [`AiSelfHostedModelID!`](#aiselfhostedmodelid) | Global ID of the self-hosted model to update. |
| <a id="mutationaiselfhostedmodelupdateidentifier"></a>`identifier` | [`String`](#string) | Identifier for 3rd party model provider. |
| <a id="mutationaiselfhostedmodelupdatemodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | AI model deployed. |
| <a id="mutationaiselfhostedmodelupdatename"></a>`name` | [`String!`](#string) | Deployment name of the self-hosted model. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiselfhostedmodelupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationaiselfhostedmodelupdateselfhostedmodel"></a>`selfHostedModel` | [`AiSelfHostedModel`](#aiselfhostedmodel) | Self-hosted model after mutation. |

### `Mutation.alertSetAssignees`

Input type: `AlertSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the alert. Replaces existing assignees by default. |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalertsetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationalertsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationalertsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalertsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationalertsetassigneesissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationalertsetassigneestodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.alertTodoCreate`

Input type: `AlertTodoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalerttodocreateiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationalerttodocreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreatealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalerttodocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationalerttodocreateissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationalerttodocreatetodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.approvalProjectRuleDelete`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `approvalProjectRuleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruledeleteid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | Global ID of the approval project rule to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | Deleted approval rule. |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.approvalProjectRuleUpdate`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `approvalProjectRuleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | How many approvals are required to satify rule. |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruleupdategroupids"></a>`groupIds` | [`[ID!]`](#id) | List of IDs of Groups that can approval rule. |
| <a id="mutationapprovalprojectruleupdateid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | Global ID of the approval rule to destroy. |
| <a id="mutationapprovalprojectruleupdatename"></a>`name` | [`String!`](#string) | Name of the approval rule. |
| <a id="mutationapprovalprojectruleupdateuserids"></a>`userIds` | [`[ID!]`](#id) | List of IDs of Users that can approval rule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | Approval rule after mutation. |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.approveDeployment`

Input type: `ApproveDeploymentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovedeploymentcomment"></a>`comment` | [`String`](#string) | Comment to go with the approval. |
| <a id="mutationapprovedeploymentid"></a>`id` | [`DeploymentID!`](#deploymentid) | ID of the deployment. |
| <a id="mutationapprovedeploymentrepresentedas"></a>`representedAs` | [`String`](#string) | Name of the User/Group/Role to use for the approval, when the user belongs to multiple approval rules. |
| <a id="mutationapprovedeploymentstatus"></a>`status` | [`DeploymentsApprovalStatus!`](#deploymentsapprovalstatus) | Status of the approval (either `APPROVED` or `REJECTED`). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovedeploymentdeploymentapproval"></a>`deploymentApproval` | [`DeploymentApproval`](#deploymentapproval) | DeploymentApproval after mutation. |
| <a id="mutationapprovedeploymenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.artifactDestroy`

Input type: `ArtifactDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationartifactdestroyid"></a>`id` | [`CiJobArtifactID!`](#cijobartifactid) | ID of the artifact to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyartifact"></a>`artifact` | [`CiJobArtifact`](#cijobartifact) | Deleted artifact. |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationartifactdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsAmazonS3ConfigurationCreate`

Input type: `AuditEventsAmazonS3ConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationauditeventsamazons3configurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | configuration created. |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsAmazonS3ConfigurationDelete`

Input type: `AuditEventsAmazonS3ConfigurationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationdeleteid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | ID of the Amazon S3 configuration to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsAmazonS3ConfigurationUpdate`

Input type: `AuditEventsAmazonS3ConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsamazons3configurationupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationauditeventsamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationupdateid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | ID of the Amazon S3 configuration to update. |
| <a id="mutationauditeventsamazons3configurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | Updated Amazon S3 configuration. |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsGroupDestinationEventsAdd`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsGroupDestinationEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsGroupDestinationEventsDelete`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsGroupDestinationEventsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsgroupdestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsGroupDestinationNamespaceFilterCreate`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsGroupDestinationNamespaceFilterCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | Destination ID. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacepath"></a>`namespacePath` | [`String`](#string) | Full path of the namespace(only project or group). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacefilter"></a>`namespaceFilter` | [`GroupAuditEventNamespaceFilter`](#groupauditeventnamespacefilter) | Namespace filter created. |

### `Mutation.auditEventsGroupDestinationNamespaceFilterDelete`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsGroupDestinationNamespaceFilterDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsGroupNamespaceFilterID!`](#auditeventsgroupnamespacefilterid) | Namespace filter ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationCreate`

Input type: `AuditEventsInstanceAmazonS3ConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsinstanceamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsinstanceamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | Created instance Amazon S3 configuration. |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationDelete`

Input type: `AuditEventsInstanceAmazonS3ConfigurationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | ID of the instance-level Amazon S3 configuration to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationUpdate`

Input type: `AuditEventsInstanceAmazonS3ConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsinstanceamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | ID of the instance-level Amazon S3 configuration to update. |
| <a id="mutationauditeventsinstanceamazons3configurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsinstanceamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | Updated instance-level Amazon S3 configuration. |

### `Mutation.auditEventsInstanceDestinationEventsAdd`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsInstanceDestinationEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsInstanceDestinationEventsDelete`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsInstanceDestinationEventsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsinstancedestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsInstanceDestinationNamespaceFilterCreate`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsInstanceDestinationNamespaceFilterCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | Destination ID. |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatenamespacepath"></a>`namespacePath` | [`String`](#string) | Full path of the namespace. Project or group namespaces only. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatenamespacefilter"></a>`namespaceFilter` | [`InstanceAuditEventNamespaceFilter`](#instanceauditeventnamespacefilter) | Namespace filter to be created. |

### `Mutation.auditEventsInstanceDestinationNamespaceFilterDelete`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `AuditEventsInstanceDestinationNamespaceFilterDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsInstanceNamespaceFilterID!`](#auditeventsinstancenamespacefilterid) | Namespace filter ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsStreamingDestinationEventsAdd`

Input type: `AuditEventsStreamingDestinationEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsStreamingDestinationEventsRemove`

Input type: `AuditEventsStreamingDestinationEventsRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsremovedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsStreamingDestinationInstanceEventsAdd`

Input type: `AuditEventsStreamingDestinationInstanceEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsStreamingDestinationInstanceEventsRemove`

Input type: `AuditEventsStreamingDestinationInstanceEventsRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremovedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsStreamingHeadersCreate`

Input type: `AuditEventsStreamingHeadersCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination to associate header with. |
| <a id="mutationauditeventsstreamingheaderscreatekey"></a>`key` | [`String!`](#string) | Header key. |
| <a id="mutationauditeventsstreamingheaderscreatevalue"></a>`value` | [`String!`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsstreamingheaderscreateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | Created header. |

### `Mutation.auditEventsStreamingHeadersDestroy`

Input type: `AuditEventsStreamingHeadersDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | Header to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsStreamingHeadersUpdate`

Input type: `AuditEventsStreamingHeadersUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | Header to update. |
| <a id="mutationauditeventsstreamingheadersupdatekey"></a>`key` | [`String`](#string) | Header key. |
| <a id="mutationauditeventsstreamingheadersupdatevalue"></a>`value` | [`String`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | Updates header. |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersAdd`

Input type: `AuditEventsStreamingHTTPNamespaceFiltersAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination ID. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddnamespacefilter"></a>`namespaceFilter` | [`AuditEventStreamingHTTPNamespaceFilter`](#auditeventstreaminghttpnamespacefilter) | Namespace filter created. |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersDelete`

Input type: `AuditEventsStreamingHTTPNamespaceFiltersDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsStreamingHTTPNamespaceFilterID!`](#auditeventsstreaminghttpnamespacefilterid) | Namespace filter ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsStreamingInstanceHeadersCreate`

Input type: `AuditEventsStreamingInstanceHeadersCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | Instance level external destination to associate header with. |
| <a id="mutationauditeventsstreaminginstanceheaderscreatekey"></a>`key` | [`String!`](#string) | Header key. |
| <a id="mutationauditeventsstreaminginstanceheaderscreatevalue"></a>`value` | [`String!`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsstreaminginstanceheaderscreateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | Created header. |

### `Mutation.auditEventsStreamingInstanceHeadersDestroy`

Input type: `AuditEventsStreamingInstanceHeadersDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | Header to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.auditEventsStreamingInstanceHeadersUpdate`

Input type: `AuditEventsStreamingInstanceHeadersUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | Header to update. |
| <a id="mutationauditeventsstreaminginstanceheadersupdatekey"></a>`key` | [`String`](#string) | Header key. |
| <a id="mutationauditeventsstreaminginstanceheadersupdatevalue"></a>`value` | [`String`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | Updates header. |

### `Mutation.awardEmojiAdd`

Input type: `AwardEmojiAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiaddname"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Emoji reactions after mutation. |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.awardEmojiRemove`

Input type: `AwardEmojiRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiremovename"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Emoji reactions after mutation. |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.awardEmojiToggle`

Input type: `AwardEmojiToggleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojitogglename"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Emoji reactions after mutation. |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojitoggleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationawardemojitoggletoggledon"></a>`toggledOn` | [`Boolean!`](#boolean) | Indicates the status of the emoji. True if the toggle awarded the emoji, and false if the toggle removed the emoji. |

### `Mutation.boardEpicCreate`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `BoardEpicCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board that the epic is in. |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardepiccreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to create is in. |
| <a id="mutationboardepiccreatelistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic board list in which epic will be created. |
| <a id="mutationboardepiccreatetitle"></a>`title` | [`String!`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardepiccreateepic"></a>`epic` | [`Epic`](#epic) | Epic after creation. |
| <a id="mutationboardepiccreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.boardListCreate`

Input type: `BoardListCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateassigneeid"></a>`assigneeId` | [`UserID`](#userid) | Global ID of an existing user. |
| <a id="mutationboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | Create the backlog list. |
| <a id="mutationboardlistcreateboardid"></a>`boardId` | [`BoardID!`](#boardid) | Global ID of the issue board to mutate. |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistcreateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global ID of an existing iteration. |
| <a id="mutationboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | Global ID of an existing label. |
| <a id="mutationboardlistcreatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Global ID of an existing milestone. |
| <a id="mutationboardlistcreateposition"></a>`position` | [`Int`](#int) | Position of the list. |
| <a id="mutationboardlistcreatestatusid"></a>`statusId` {{< icon name="warning-solid" >}} | [`WorkItemsStatusesStatusID`](#workitemsstatusesstatusid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.0. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationboardlistcreatelist"></a>`list` | [`BoardList`](#boardlist) | Issue list in the issue board. |

### `Mutation.boardListUpdateLimitMetrics`

Input type: `BoardListUpdateLimitMetricsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistupdatelimitmetricslimitmetric"></a>`limitMetric` | [`ListLimitMetric`](#listlimitmetric) | New limit metric type for the list. |
| <a id="mutationboardlistupdatelimitmetricslistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="mutationboardlistupdatelimitmetricsmaxissuecount"></a>`maxIssueCount` | [`Int`](#int) | New maximum issue count limit. |
| <a id="mutationboardlistupdatelimitmetricsmaxissueweight"></a>`maxIssueWeight` | [`Int`](#int) | New maximum issue weight limit. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistupdatelimitmetricserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationboardlistupdatelimitmetricslist"></a>`list` | [`BoardList`](#boardlist) | Updated list. |

### `Mutation.branchDelete`

Input type: `BranchDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchdeletename"></a>`name` | [`String!`](#string) | Name of the branch. |
| <a id="mutationbranchdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchdeletebranch"></a>`branch` | [`Branch`](#branch) | Branch after mutation. |
| <a id="mutationbranchdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.branchRuleApprovalProjectRuleCreate`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `branchRuleApprovalProjectRuleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | How many approvals are required to satify rule. |
| <a id="mutationbranchruleapprovalprojectrulecreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to destroy. |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleapprovalprojectrulecreategroupids"></a>`groupIds` | [`[ID!]`](#id) | List of IDs of Groups that can approval rule. |
| <a id="mutationbranchruleapprovalprojectrulecreatename"></a>`name` | [`String!`](#string) | Name of the approval rule. |
| <a id="mutationbranchruleapprovalprojectrulecreateuserids"></a>`userIds` | [`[ID!]`](#id) | List of IDs of Users that can approval rule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | Approval rule after mutation. |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleapprovalprojectrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.branchRuleCreate`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Input type: `BranchRuleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchrulecreatename"></a>`name` | [`String!`](#string) | Branch name, with wildcards, for the branch rules. |
| <a id="mutationbranchrulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path to the project that the branch is associated with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | Branch rule after mutation. |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.branchRuleDelete`

{{< details >}}
**Introduced** in GitLab 16.9.
**Status**: Experiment.
{{< /details >}}

Input type: `BranchRuleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruledeleteid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeletebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | Branch rule after mutation. |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.branchRuleExternalStatusCheckCreate`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Create a new external status check from a branch rule.

Input type: `BranchRuleExternalStatusCheckCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to update. |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalurl"></a>`externalUrl` | [`String!`](#string) | URL of external status check resource. |
| <a id="mutationbranchruleexternalstatuscheckcreatename"></a>`name` | [`String!`](#string) | Name of the external status check. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | New status check after mutation. |

### `Mutation.branchRuleExternalStatusCheckDestroy`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Destroy an external status check from a branch rule.

Input type: `BranchRuleExternalStatusCheckDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroybranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule. |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckdestroyid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | Global ID of the external status check to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.branchRuleExternalStatusCheckUpdate`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Update an external status check from a branch rule.

Input type: `BranchRuleExternalStatusCheckUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule. |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalurl"></a>`externalUrl` | [`String!`](#string) | External URL of the external status check. |
| <a id="mutationbranchruleexternalstatuscheckupdateid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | Global ID of the external status check to update. |
| <a id="mutationbranchruleexternalstatuscheckupdatename"></a>`name` | [`String!`](#string) | Name of the external status check. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | Updated external status check after mutation. |

### `Mutation.branchRuleSquashOptionDelete`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Delete a squash option for a branch rule.

Input type: `BranchRuleSquashOptionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptiondeletebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule. |
| <a id="mutationbranchrulesquashoptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchrulesquashoptiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.branchRuleSquashOptionUpdate`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Update a squash option for a branch rule.

Input type: `BranchRuleSquashOptionUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptionupdatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule. |
| <a id="mutationbranchrulesquashoptionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchrulesquashoptionupdatesquashoption"></a>`squashOption` | [`SquashOptionSetting!`](#squashoptionsetting) | Squash option after mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchrulesquashoptionupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationbranchrulesquashoptionupdatesquashoption"></a>`squashOption` | [`SquashOption`](#squashoption) | Updated squash option after mutation. |

### `Mutation.branchRuleUpdate`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Input type: `BranchRuleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchprotection"></a>`branchProtection` | [`BranchProtectionInput`](#branchprotectioninput) | Branch protections configured for the branch rule. |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleupdateid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to update. |
| <a id="mutationbranchruleupdatename"></a>`name` | [`String!`](#string) | Branch name, with wildcards, for the branch rules. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | Branch rule after mutation. |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.bulkDestroyJobArtifacts`

{{< details >}}
**Introduced** in GitLab 15.10.
**Status**: Experiment.
{{< /details >}}

Input type: `BulkDestroyJobArtifactsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkdestroyjobartifactsids"></a>`ids` | [`[CiJobArtifactID!]!`](#cijobartifactid) | Global IDs of the job artifacts to destroy. |
| <a id="mutationbulkdestroyjobartifactsprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global Project ID of the job artifacts to destroy. Incompatible with projectPath. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkdestroyjobartifactsdestroyedcount"></a>`destroyedCount` | [`Int`](#int) | Number of job artifacts deleted. |
| <a id="mutationbulkdestroyjobartifactsdestroyedids"></a>`destroyedIds` | [`[CiJobArtifactID!]`](#cijobartifactid) | IDs of job artifacts that were deleted. |
| <a id="mutationbulkdestroyjobartifactserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.bulkEnableDevopsAdoptionNamespaces`

**Status**: Beta.

Input type: `BulkEnableDevopsAdoptionNamespacesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Display namespace ID. |
| <a id="mutationbulkenabledevopsadoptionnamespacesnamespaceids"></a>`namespaceIds` | [`[NamespaceID!]!`](#namespaceid) | List of Namespace IDs. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespacesenablednamespaces"></a>`enabledNamespaces` | [`[DevopsAdoptionEnabledNamespace!]`](#devopsadoptionenablednamespace) | Enabled namespaces after mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespaceserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.bulkRunnerDelete`

{{< details >}}
**Introduced** in GitLab 15.3.
**Status**: Experiment.
{{< /details >}}

Input type: `BulkRunnerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkrunnerdeleteids"></a>`ids` | [`[CiRunnerID!]`](#cirunnerid) | IDs of the runners to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkrunnerdeletedeletedcount"></a>`deletedCount` | [`Int`](#int) | Number of records effectively deleted. Only present if operation was performed synchronously. |
| <a id="mutationbulkrunnerdeletedeletedids"></a>`deletedIds` | [`[CiRunnerID!]`](#cirunnerid) | IDs of records effectively deleted. Only present if operation was performed synchronously. |
| <a id="mutationbulkrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.bulkUpdateSecurityAttributes`

Input type: `BulkUpdateSecurityAttributesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkupdatesecurityattributesattributes"></a>`attributes` | [`[SecurityAttributeID!]!`](#securityattributeid) | Global IDs of security attributes to apply. |
| <a id="mutationbulkupdatesecurityattributesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkupdatesecurityattributesitems"></a>`items` | [`[ID!]!`](#id) | Global IDs of groups and projects to update. |
| <a id="mutationbulkupdatesecurityattributesmode"></a>`mode` | [`SecurityAttributeBulkUpdateMode!`](#securityattributebulkupdatemode) | Update mode: add, remove, or replace attributes. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkupdatesecurityattributesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkupdatesecurityattributeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered while initiating the bulk update operation. |

### `Mutation.catalogResourcesCreate`

{{< details >}}
**Introduced** in GitLab 15.11.
**Status**: Experiment.
{{< /details >}}

Input type: `CatalogResourcesCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcescreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path belonging to the catalog resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcescreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.catalogResourcesDestroy`

{{< details >}}
**Introduced** in GitLab 16.6.
**Status**: Experiment.
{{< /details >}}

Input type: `CatalogResourcesDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcesdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path belonging to the catalog resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcesdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.ciJobTokenScopeAddGroupOrProject`

Input type: `CiJobTokenScopeAddGroupOrProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddgrouporprojectdefaultpermissions"></a>`defaultPermissions` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |
| <a id="mutationcijobtokenscopeaddgrouporprojectjobtokenpolicies"></a>`jobTokenPolicies` {{< icon name="warning-solid" >}} | [`[CiJobTokenScopePolicies!]`](#cijobtokenscopepolicies) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.5. |
| <a id="mutationcijobtokenscopeaddgrouporprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscopeaddgrouporprojecttargetpath"></a>`targetPath` | [`ID!`](#id) | Group or project to be added to the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscopeaddgrouporprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.6. |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddgrouporprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.ciJobTokenScopeAddProject`

Input type: `CiJobTokenScopeAddProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddprojectdirection"></a>`direction` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **Deprecated**: Outbound job token scope is being removed. This field can now only be set to INBOUND. Deprecated in GitLab 16.0. |
| <a id="mutationcijobtokenscopeaddprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscopeaddprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to be added to the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.6. |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.ciJobTokenScopeAutopopulateAllowlist`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `CiJobTokenScopeAutopopulateAllowlistInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeautopopulateallowlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeautopopulateallowlistprojectpath"></a>`projectPath` | [`ID!`](#id) | Project in which to autopopulate the allowlist. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeautopopulateallowlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeautopopulateallowlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcijobtokenscopeautopopulateallowliststatus"></a>`status` | [`String!`](#string) | Status of the autopopulation process. |

### `Mutation.ciJobTokenScopeClearAllowlistAutopopulations`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `CiJobTokenScopeClearAllowlistAutopopulationsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project in which to autopopulate the allowlist. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsstatus"></a>`status` | [`String!`](#string) | Status of the autopopulation process. |

### `Mutation.ciJobTokenScopeRemoveGroup`

Input type: `CiJobTokenScopeRemoveGroupInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemovegroupprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscoperemovegrouptargetgrouppath"></a>`targetGroupPath` | [`ID!`](#id) | Group to be removed from the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscoperemovegroupcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.6. |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemovegrouperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.ciJobTokenScopeRemoveProject`

Input type: `CiJobTokenScopeRemoveProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemoveprojectdirection"></a>`direction` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **Deprecated**: Outbound job token scope is being removed. This field can now only be set to INBOUND. Deprecated in GitLab 16.9. |
| <a id="mutationcijobtokenscoperemoveprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscoperemoveprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to be removed from the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.6. |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemoveprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.ciJobTokenScopeUpdatePolicies`

{{< details >}}
**Introduced** in GitLab 17.6.
**Status**: Experiment.
{{< /details >}}

Input type: `CiJobTokenScopeUpdatePoliciesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeupdatepoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeupdatepoliciesdefaultpermissions"></a>`defaultPermissions` | [`Boolean!`](#boolean) | Indicates whether default permissions are enabled (true) or fine-grained permissions are enabled (false). |
| <a id="mutationcijobtokenscopeupdatepoliciesjobtokenpolicies"></a>`jobTokenPolicies` | [`[CiJobTokenScopePolicies!]!`](#cijobtokenscopepolicies) | List of policies added to the CI job token scope. |
| <a id="mutationcijobtokenscopeupdatepoliciesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscopeupdatepoliciestargetpath"></a>`targetPath` | [`ID!`](#id) | Group or project that the CI job token targets. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeupdatepoliciescijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.6. |
| <a id="mutationcijobtokenscopeupdatepoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeupdatepolicieserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.ciLint`

Linted and processed contents of a CI config.
Should not be requested more than once per request.

Input type: `CiLintInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcilintclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcilintcontent"></a>`content` | [`String!`](#string) | Contents of `.gitlab-ci.yml`. |
| <a id="mutationcilintdryrun"></a>`dryRun` | [`Boolean`](#boolean) | Run pipeline creation simulation, or only do static check. |
| <a id="mutationcilintprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the CI config. |
| <a id="mutationcilintref"></a>`ref` | [`String`](#string) | Ref to use when linting. Default is the project default branch. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcilintclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcilintconfig"></a>`config` | [`CiConfigV2`](#ciconfigv2) | Linted CI config and metadata. |
| <a id="mutationcilinterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.clusterAgentDelete`

Input type: `ClusterAgentDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragentdeleteid"></a>`id` | [`ClustersAgentID!`](#clustersagentid) | Global ID of the cluster agent that will be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.clusterAgentTokenCreate`

Input type: `ClusterAgentTokenCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokencreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | Global ID of the cluster agent that will be associated with the new token. |
| <a id="mutationclusteragenttokencreatedescription"></a>`description` | [`String`](#string) | Description of the token. |
| <a id="mutationclusteragenttokencreatename"></a>`name` | [`String!`](#string) | Name of the token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokencreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationclusteragenttokencreatesecret"></a>`secret` | [`String`](#string) | Token secret value. Make sure you save it - you won't be able to access it again. |
| <a id="mutationclusteragenttokencreatetoken"></a>`token` | [`ClusterAgentToken`](#clusteragenttoken) | Token created after mutation. |

### `Mutation.clusterAgentTokenRevoke`

Input type: `ClusterAgentTokenRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokenrevokeid"></a>`id` | [`ClustersAgentTokenID!`](#clustersagenttokenid) | Global ID of the agent token that will be revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokenrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.clusterAgentUrlConfigurationCreate`

Input type: `ClusterAgentUrlConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationcreatecacert"></a>`caCert` | [`String`](#string) | Base64-encoded CA certificate in PEM format to verify the agent endpoint. |
| <a id="mutationclusteragenturlconfigurationcreateclientcert"></a>`clientCert` | [`String`](#string) | Base64-encoded client certificate in PEM format if mTLS authentication should be used. Must be provided with `client_key`. |
| <a id="mutationclusteragenturlconfigurationcreateclientkey"></a>`clientKey` | [`String`](#string) | Base64-encoded client key in PEM format if mTLS authentication should be used. Must be provided with `client_cert`. |
| <a id="mutationclusteragenturlconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenturlconfigurationcreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | Global ID of the cluster agent that will be associated with the new URL configuration. |
| <a id="mutationclusteragenturlconfigurationcreatetlshost"></a>`tlsHost` | [`String`](#string) | TLS host name to verify the server name in agent endpoint certificate. |
| <a id="mutationclusteragenturlconfigurationcreateurl"></a>`url` | [`String!`](#string) | URL for the new URL configuration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenturlconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationclusteragenturlconfigurationcreateurlconfiguration"></a>`urlConfiguration` | [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration) | URL configuration created after mutation. |

### `Mutation.clusterAgentUrlConfigurationDelete`

Input type: `ClusterAgentUrlConfigurationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenturlconfigurationdeleteid"></a>`id` | [`ClustersAgentsUrlConfigurationID!`](#clustersagentsurlconfigurationid) | Global ID of the agent URL configuration that will be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenturlconfigurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.commitCreate`

Input type: `CommitCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateactions"></a>`actions` | [`[CommitAction!]!`](#commitaction) | Array of action hashes to commit as a batch. |
| <a id="mutationcommitcreatebranch"></a>`branch` | [`String!`](#string) | Name of the branch to commit into, it can be a new branch. |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcommitcreatemessage"></a>`message` | [`String!`](#string) | Raw commit message. |
| <a id="mutationcommitcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |
| <a id="mutationcommitcreatestartbranch"></a>`startBranch` | [`String`](#string) | If on a new branch, name of the original branch. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcommitcreatecommit"></a>`commit` | [`Commit`](#commit) | Commit after mutation. |
| <a id="mutationcommitcreatecommitpipelinepath"></a>`commitPipelinePath` | [`String`](#string) | ETag path for the commit's pipeline. |
| <a id="mutationcommitcreatecontent"></a>`content` | [`[String!]`](#string) | Contents of the commit. |
| <a id="mutationcommitcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.configureContainerScanning`

Configure container scanning for a project by adding it to a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a merge request are part of the response.

Input type: `ConfigureContainerScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfigurecontainerscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfigurecontainerscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationconfigurecontainerscanningsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureDependencyScanning`

Configure Dependency Scanning for a project by enabling Dependency Scanning in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a Merge Request are a part of the response.

Input type: `ConfigureDependencyScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguredependencyscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguredependencyscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationconfiguredependencyscanningsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSast`

Configure SAST for a project by enabling SAST in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a Merge Request are a part of the response.

Input type: `ConfigureSastInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastconfiguration"></a>`configuration` | [`SastCiConfigurationInput!`](#sastciconfigurationinput) | SAST CI configuration for the project. |
| <a id="mutationconfiguresastprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresasterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationconfiguresastsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSastIac`

Enable SAST IaC for a project in a new or
modified `.gitlab-ci.yml` file in a new branch. The new
branch and a URL to create a merge request are a part of the
response.

Input type: `ConfigureSastIacInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastiacprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastiacerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationconfiguresastiacsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSecretDetection`

Configure Secret Detection for a project by enabling Secret Detection
in a new or modified `.gitlab-ci.yml` file in a new branch. The new
branch and a URL to create a Merge Request are a part of the
response.

Input type: `ConfigureSecretDetectionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresecretdetectionprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationconfiguresecretdetectionsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.corpusCreate`

Input type: `CorpusCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcorpuscreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the corpus belongs to. |
| <a id="mutationcorpuscreatepackageid"></a>`packageId` | [`PackagesPackageID!`](#packagespackageid) | ID of the corpus package. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcorpuscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createAlertIssue`

Input type: `CreateAlertIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatealertissueiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationcreatealertissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissuealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatealertissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatealertissueissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationcreatealertissuetodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.createAnnotation`

{{< details >}}
**Deprecated** in GitLab 16.0.
Underlying feature was removed in 16.0.
{{< /details >}}

Input type: `CreateAnnotationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateannotationclusterid"></a>`clusterId` | [`ClustersClusterID`](#clustersclusterid) | Global ID of the cluster to add an annotation to. |
| <a id="mutationcreateannotationdashboardpath"></a>`dashboardPath` | [`String!`](#string) | Path to a file defining the dashboard on which the annotation should be added. |
| <a id="mutationcreateannotationdescription"></a>`description` | [`String!`](#string) | Description of the annotation. |
| <a id="mutationcreateannotationendingat"></a>`endingAt` | [`Time`](#time) | Timestamp indicating ending moment to which the annotation relates. |
| <a id="mutationcreateannotationenvironmentid"></a>`environmentId` | [`EnvironmentID`](#environmentid) | Global ID of the environment to add an annotation to. |
| <a id="mutationcreateannotationstartingat"></a>`startingAt` | [`Time!`](#time) | Timestamp indicating starting moment to which the annotation relates. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationannotation"></a>`annotation` | [`MetricsDashboardAnnotation`](#metricsdashboardannotation) | Created annotation. |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateannotationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createBoard`

Input type: `CreateBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ID of user to be assigned to the board. |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateboardgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationcreateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationcreateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationcreateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ID of iteration cadence to be assigned to the board. |
| <a id="mutationcreateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ID of iteration to be assigned to the board. |
| <a id="mutationcreateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationcreateboardlabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationcreateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of milestone to be assigned to the board. |
| <a id="mutationcreateboardname"></a>`name` | [`String`](#string) | Board name. |
| <a id="mutationcreateboardprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationcreateboardweight"></a>`weight` | [`Int`](#int) | Weight value to be assigned to the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createBranch`

Input type: `CreateBranchInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatebranchname"></a>`name` | [`String!`](#string) | Name of the branch. |
| <a id="mutationcreatebranchprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |
| <a id="mutationcreatebranchref"></a>`ref` | [`String!`](#string) | Branch name or commit SHA to create branch from. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchbranch"></a>`branch` | [`Branch`](#branch) | Branch after mutation. |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatebrancherrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createClusterAgent`

Input type: `CreateClusterAgentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateclusteragentname"></a>`name` | [`String!`](#string) | Name of the cluster agent. |
| <a id="mutationcreateclusteragentprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the associated project for the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateclusteragentclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | Cluster agent created after mutation. |
| <a id="mutationcreateclusteragenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createComplianceFramework`

Input type: `CreateComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecomplianceframeworknamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace to add the compliance framework to. |
| <a id="mutationcreatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | Parameters to update the compliance framework with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatecomplianceframeworkframework"></a>`framework` | [`ComplianceFramework`](#complianceframework) | Created compliance framework. |

### `Mutation.createComplianceRequirement`

{{< details >}}
**Introduced** in GitLab 17.6.
**Status**: Experiment.
{{< /details >}}

Input type: `CreateComplianceRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecompliancerequirementcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | Global ID of the compliance framework of the new requirement. |
| <a id="mutationcreatecompliancerequirementcontrols"></a>`controls` | [`[ComplianceRequirementsControlInput!]`](#compliancerequirementscontrolinput) | Controls to add to the compliance requirement. |
| <a id="mutationcreatecompliancerequirementparams"></a>`params` | [`ComplianceRequirementInput!`](#compliancerequirementinput) | Parameters to update the compliance requirement with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatecompliancerequirementrequirement"></a>`requirement` | [`ComplianceRequirement`](#compliancerequirement) | Created compliance requirement. |

### `Mutation.createComplianceRequirementsControl`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `CreateComplianceRequirementsControlInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecompliancerequirementscontrolcompliancerequirementid"></a>`complianceRequirementId` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | Global ID of the compliance requirement of the new control. |
| <a id="mutationcreatecompliancerequirementscontrolparams"></a>`params` | [`ComplianceRequirementsControlInput!`](#compliancerequirementscontrolinput) | Parameters to create the compliance requirement control. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatecompliancerequirementscontrolrequirementscontrol"></a>`requirementsControl` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | Created compliance requirements control. |

### `Mutation.createContainerProtectionRepositoryRule`

Creates a repository protection rule to restrict access to a project's container registry.

Input type: `CreateContainerProtectionRepositoryRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecontainerprotectionrepositoryruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | Minimum GitLab access level required to delete container images from the container repository. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. If the value is `nil`, the default minimum access level is `DEVELOPER`. |
| <a id="mutationcreatecontainerprotectionrepositoryruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | Minimum GitLab access level required to push container images to the container repository. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. If the value is `nil`, the default minimum access level is `DEVELOPER`. |
| <a id="mutationcreatecontainerprotectionrepositoryruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project where a protection rule is located. |
| <a id="mutationcreatecontainerprotectionrepositoryrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String!`](#string) | Container repository path pattern protected by the protection rule. Must start with the project’s full path. For example: `my-project/*-prod-*`. Wildcard character `*` is allowed anywhere after the project’s full path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | Container repository protection rule after mutation. |
| <a id="mutationcreatecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createContainerProtectionTagRule`

{{< details >}}
**Introduced** in GitLab 17.8.
**Status**: Experiment.
{{< /details >}}

Creates a protection rule to control which user roles can modify container image tags matching a specified pattern.

Input type: `createContainerProtectionTagRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecontainerprotectiontagruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | Minimum GitLab access level required to delete container image tags from the container repository. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. Introduced in GitLab 17.8: **Status**: Experiment. If the value is `nil`, no access level can delete tags. |
| <a id="mutationcreatecontainerprotectiontagruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | Minimum GitLab access level required to push container image tags to the container repository. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. Introduced in GitLab 17.8: **Status**: Experiment. If the value is `nil`, no access level can push tags. |
| <a id="mutationcreatecontainerprotectiontagruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project containing the container image tags. |
| <a id="mutationcreatecontainerprotectiontagruletagnamepattern"></a>`tagNamePattern` | [`String!`](#string) | The pattern that matches container image tags to protect. For example, `v1.*`. Wildcard character `*` allowed. Introduced in GitLab 17.8: **Status**: Experiment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |
| <a id="mutationcreatecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createCustomEmoji`

Input type: `CreateCustomEmojiInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecustomemojigrouppath"></a>`groupPath` | [`ID!`](#id) | Namespace full path the emoji is associated with. |
| <a id="mutationcreatecustomemojiname"></a>`name` | [`String!`](#string) | Name of the emoji. |
| <a id="mutationcreatecustomemojiurl"></a>`url` | [`String!`](#string) | Location of the emoji file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | New custom emoji. |
| <a id="mutationcreatecustomemojierrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createDiffNote`

Input type: `CreateDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |
| <a id="mutationcreatediffnoteposition"></a>`position` | [`DiffPositionInput!`](#diffpositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationcreatediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.createDiscussion`

Input type: `CreateDiscussionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionbody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediscussioninternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatediscussionnoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediscussionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatediscussionnote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationcreatediscussionquickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.createEpic`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by `WorkItem` type. For more information, see [migration guide](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/).
{{< /details >}}

Input type: `CreateEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the epic. |
| <a id="mutationcreateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | Array of labels to be added to the epic. |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateepiccolor"></a>`color` | [`Color`](#color) | Color of the epic. |
| <a id="mutationcreateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="mutationcreateepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="mutationcreateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | End date of the epic. |
| <a id="mutationcreateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates end date should be sourced from due_date_fixed field not the issue milestones. |
| <a id="mutationcreateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate is in. |
| <a id="mutationcreateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the epic. |
| <a id="mutationcreateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | Start date of the epic. |
| <a id="mutationcreateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates start date should be sourced from start_date_fixed field not the issue milestones. |
| <a id="mutationcreateepictitle"></a>`title` | [`String`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateepicepic"></a>`epic` | [`Epic`](#epic) | Created epic. |
| <a id="mutationcreateepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.createImageDiffNote`

Input type: `CreateImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateimagediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreateimagediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |
| <a id="mutationcreateimagediffnoteposition"></a>`position` | [`DiffImagePositionInput!`](#diffimagepositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreateimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationcreateimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.createIssue`

Input type: `CreateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | Array of user IDs to assign to the issue. |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates the issue is confidential. |
| <a id="mutationcreateissuecreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the issue was created. Available only for admins and project owners. |
| <a id="mutationcreateissuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="mutationcreateissuediscussiontoresolve"></a>`discussionToResolve` | [`String`](#string) | ID of a discussion to resolve. Also pass `merge_request_to_resolve_discussions_of`. |
| <a id="mutationcreateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | Due date of the issue. |
| <a id="mutationcreateissueepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **Deprecated**: This will be replaced by WorkItem hierarchyWidget. Deprecated in GitLab 17.5. |
| <a id="mutationcreateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Desired health status. |
| <a id="mutationcreateissueiid"></a>`iid` | [`Int`](#int) | IID (internal ID) of a project issue. Only admins and project owners can modify. |
| <a id="mutationcreateissueiterationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global iteration cadence ID. Required when `iterationWildcardId` is provided. |
| <a id="mutationcreateissueiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global iteration ID. Mutually exlusive argument with `iterationWildcardId`. |
| <a id="mutationcreateissueiterationwildcardid"></a>`iterationWildcardId` | [`IssueCreationIterationWildcardId`](#issuecreationiterationwildcardid) | Iteration wildcard ID. Supported values are: `CURRENT`. Mutually exclusive argument with `iterationId`. iterationCadenceId also required when this argument is provided. |
| <a id="mutationcreateissuelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the issue. |
| <a id="mutationcreateissuelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationcreateissuelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="mutationcreateissuemergerequesttoresolvediscussionsof"></a>`mergeRequestToResolveDiscussionsOf` | [`MergeRequestID`](#mergerequestid) | IID of a merge request for which to resolve discussions. |
| <a id="mutationcreateissuemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of the milestone to assign to the issue. On update milestone will be removed if set to null. |
| <a id="mutationcreateissuemoveafterid"></a>`moveAfterId` | [`IssueID`](#issueid) | Global ID of issue that should be placed after the current issue. |
| <a id="mutationcreateissuemovebeforeid"></a>`moveBeforeId` | [`IssueID`](#issueid) | Global ID of issue that should be placed before the current issue. |
| <a id="mutationcreateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the issue is associated with. |
| <a id="mutationcreateissuestatusid"></a>`statusId` | [`WorkItemsStatusesStatusID`](#workitemsstatusesstatusid) | Global ID of the status. |
| <a id="mutationcreateissuetitle"></a>`title` | [`String!`](#string) | Title of the issue. |
| <a id="mutationcreateissuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="mutationcreateissueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreateissueissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.createIteration`

{{< details >}}
**Deprecated** in GitLab 14.0.
Use iterationCreate.
{{< /details >}}

Input type: `CreateIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateiterationdescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationcreateiterationduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationcreateiterationgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationcreateiterationiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global ID of the iteration cadence to be assigned to the new iteration. |
| <a id="mutationcreateiterationprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationcreateiterationstartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationcreateiterationtitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | Created iteration. |

### `Mutation.createNote`

Creates a Note.
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `CreateNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatenotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatenotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | Global ID of the discussion the note is in reply to. |
| <a id="mutationcreatenoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatenotemergerequestdiffheadsha"></a>`mergeRequestDiffHeadSha` | [`String`](#string) | SHA of the head commit which is used to ensure that the merge request has not been updated since the request was sent. |
| <a id="mutationcreatenotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatenoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatenotenote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationcreatenotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.createPackagesProtectionRule`

Creates a protection rule to restrict access to project packages.

Input type: `CreatePackagesProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatepackagesprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`PackagesProtectionRuleAccessLevelForDelete`](#packagesprotectionruleaccesslevelfordelete) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.10. |
| <a id="mutationcreatepackagesprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`PackagesProtectionRuleAccessLevel`](#packagesprotectionruleaccesslevel) | Minimum GitLab access required to push packages to the package registry. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. If the value is `nil`, the default minimum access level is `DEVELOPER`. |
| <a id="mutationcreatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String!`](#string) | Package name protected by the protection rule. For example, `@my-scope/my-package-*`. Wildcard character `*` allowed. |
| <a id="mutationcreatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType!`](#packagesprotectionrulepackagetype) | Package type protected by the protection rule. For example, `NPM`, `PYPI`. |
| <a id="mutationcreatepackagesprotectionruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project where a protection rule is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | Packages protection rule after mutation. |

### `Mutation.createRequirement`

Input type: `CreateRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreaterequirementdescription"></a>`description` | [`String`](#string) | Description of the requirement. |
| <a id="mutationcreaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirement is associated with. |
| <a id="mutationcreaterequirementtitle"></a>`title` | [`String`](#string) | Title of the requirement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | Requirement after mutation. |

### `Mutation.createSnippet`

Input type: `CreateSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | Actions to perform over the snippet repository and blobs. |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatesnippetdescription"></a>`description` | [`String`](#string) | Description of the snippet. |
| <a id="mutationcreatesnippetprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project the snippet is associated with. |
| <a id="mutationcreatesnippettitle"></a>`title` | [`String!`](#string) | Title of the snippet. |
| <a id="mutationcreatesnippetuploadedfiles"></a>`uploadedFiles` | [`[String!]`](#string) | Paths to files uploaded in the snippet description. |
| <a id="mutationcreatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum!`](#visibilitylevelsenum) | Visibility level of the snippet. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.createTestCase`

Input type: `CreateTestCaseInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatetestcaseconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the test case confidentiality. |
| <a id="mutationcreatetestcasedescription"></a>`description` | [`String`](#string) | Test case description. |
| <a id="mutationcreatetestcaselabelids"></a>`labelIds` | [`[ID!]`](#id) | IDs of labels to be added to the test case. |
| <a id="mutationcreatetestcaseprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path to create the test case in. |
| <a id="mutationcreatetestcasetitle"></a>`title` | [`String!`](#string) | Test case title. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatetestcaseerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcreatetestcasetestcase"></a>`testCase` | [`Issue`](#issue) | Test case created. |

### `Mutation.customFieldArchive`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `CustomFieldArchiveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldarchiveid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | Global ID of the custom field. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldarchivecustomfield"></a>`customField` | [`CustomField`](#customfield) | Archived custom field. |
| <a id="mutationcustomfieldarchiveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.customFieldCreate`

{{< details >}}
**Introduced** in GitLab 17.6.
**Status**: Experiment.
{{< /details >}}

Input type: `CustomFieldCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldcreatefieldtype"></a>`fieldType` | [`CustomFieldType!`](#customfieldtype) | Type of custom field. |
| <a id="mutationcustomfieldcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path where the custom field is created. |
| <a id="mutationcustomfieldcreatename"></a>`name` | [`String!`](#string) | Name of the custom field. |
| <a id="mutationcustomfieldcreateselectoptions"></a>`selectOptions` | [`[CustomFieldSelectOptionInput!]`](#customfieldselectoptioninput) | Available options for a select field. |
| <a id="mutationcustomfieldcreateworkitemtypeids"></a>`workItemTypeIds` | [`[WorkItemsTypeID!]`](#workitemstypeid) | Work item type global IDs associated to the custom field. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldcreatecustomfield"></a>`customField` | [`CustomField`](#customfield) | Created custom field. |
| <a id="mutationcustomfieldcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.customFieldUnarchive`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `CustomFieldUnarchiveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldunarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldunarchiveid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | Global ID of the custom field. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldunarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldunarchivecustomfield"></a>`customField` | [`CustomField`](#customfield) | Unarchived custom field. |
| <a id="mutationcustomfieldunarchiveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.customFieldUpdate`

{{< details >}}
**Introduced** in GitLab 17.6.
**Status**: Experiment.
{{< /details >}}

Input type: `CustomFieldUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldupdateid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | Global ID of the custom field. |
| <a id="mutationcustomfieldupdatename"></a>`name` | [`String`](#string) | Name of the custom field. |
| <a id="mutationcustomfieldupdateselectoptions"></a>`selectOptions` | [`[CustomFieldSelectOptionInput!]`](#customfieldselectoptioninput) | Available options for a select field. |
| <a id="mutationcustomfieldupdateworkitemtypeids"></a>`workItemTypeIds` | [`[WorkItemsTypeID!]`](#workitemstypeid) | Work item type global IDs associated to the custom field. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomfieldupdatecustomfield"></a>`customField` | [`CustomField`](#customfield) | Updated custom field. |
| <a id="mutationcustomfieldupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.customerRelationsContactCreate`

Input type: `CustomerRelationsContactCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactcreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the contact. |
| <a id="mutationcustomerrelationscontactcreateemail"></a>`email` | [`String`](#string) | Email address of the contact. |
| <a id="mutationcustomerrelationscontactcreatefirstname"></a>`firstName` | [`String!`](#string) | First name of the contact. |
| <a id="mutationcustomerrelationscontactcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the contact. |
| <a id="mutationcustomerrelationscontactcreatelastname"></a>`lastName` | [`String!`](#string) | Last name of the contact. |
| <a id="mutationcustomerrelationscontactcreateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | Organization for the contact. |
| <a id="mutationcustomerrelationscontactcreatephone"></a>`phone` | [`String`](#string) | Phone number of the contact. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactcreatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | Contact after the mutation. |
| <a id="mutationcustomerrelationscontactcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.customerRelationsContactUpdate`

Input type: `CustomerRelationsContactUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateactive"></a>`active` | [`Boolean`](#boolean) | State of the contact. |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the contact. |
| <a id="mutationcustomerrelationscontactupdateemail"></a>`email` | [`String`](#string) | Email address of the contact. |
| <a id="mutationcustomerrelationscontactupdatefirstname"></a>`firstName` | [`String`](#string) | First name of the contact. |
| <a id="mutationcustomerrelationscontactupdateid"></a>`id` | [`CustomerRelationsContactID!`](#customerrelationscontactid) | Global ID of the contact. |
| <a id="mutationcustomerrelationscontactupdatelastname"></a>`lastName` | [`String`](#string) | Last name of the contact. |
| <a id="mutationcustomerrelationscontactupdateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | Organization of the contact. |
| <a id="mutationcustomerrelationscontactupdatephone"></a>`phone` | [`String`](#string) | Phone number of the contact. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactupdatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | Contact after the mutation. |
| <a id="mutationcustomerrelationscontactupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.customerRelationsOrganizationCreate`

Input type: `CustomerRelationsOrganizationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationcreatedefaultrate"></a>`defaultRate` | [`Float`](#float) | Standard billing rate for the organization. |
| <a id="mutationcustomerrelationsorganizationcreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the organization. |
| <a id="mutationcustomerrelationsorganizationcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the organization. |
| <a id="mutationcustomerrelationsorganizationcreatename"></a>`name` | [`String!`](#string) | Name of the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcustomerrelationsorganizationcreateorganization"></a>`organization` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | Organization after the mutation. |

### `Mutation.customerRelationsOrganizationUpdate`

Input type: `CustomerRelationsOrganizationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateactive"></a>`active` | [`Boolean`](#boolean) | State of the organization. |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationupdatedefaultrate"></a>`defaultRate` | [`Float`](#float) | Standard billing rate for the organization. |
| <a id="mutationcustomerrelationsorganizationupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the organization. |
| <a id="mutationcustomerrelationsorganizationupdateid"></a>`id` | [`CustomerRelationsOrganizationID!`](#customerrelationsorganizationid) | Global ID of the organization. |
| <a id="mutationcustomerrelationsorganizationupdatename"></a>`name` | [`String`](#string) | Name of the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationcustomerrelationsorganizationupdateorganization"></a>`organization` | [`CustomerRelationsOrganization!`](#customerrelationsorganization) | Organization after the mutation. |

### `Mutation.dastOnDemandScanCreate`

Input type: `DastOnDemandScanCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastondemandscancreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | ID of the scanner profile to be used for the scan. |
| <a id="mutationdastondemandscancreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be used for the scan. |
| <a id="mutationdastondemandscancreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastondemandscancreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastondemandscancreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. |

### `Mutation.dastProfileCreate`

Input type: `DastProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreatebranchname"></a>`branchName` | [`String`](#string) | Associated branch. |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilecreatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | Represents a DAST Profile Schedule. |
| <a id="mutationdastprofilecreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be associated. |
| <a id="mutationdastprofilecreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be associated. |
| <a id="mutationdastprofilecreatedescription"></a>`description` | [`String`](#string) | Description of the profile. Defaults to an empty string. |
| <a id="mutationdastprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the profile belongs to. |
| <a id="mutationdastprofilecreatename"></a>`name` | [`String!`](#string) | Name of the profile. |
| <a id="mutationdastprofilecreaterunaftercreate"></a>`runAfterCreate` | [`Boolean`](#boolean) | Run scan using profile after creation. Defaults to false. |
| <a id="mutationdastprofilecreatetaglist"></a>`tagList` | [`[String!]`](#string) | Indicates the runner tags associated with the profile. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilecreatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | Created profile. |
| <a id="mutationdastprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastprofilecreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. Requires `runAfterCreate` to be set to `true`. |

### `Mutation.dastProfileDelete`

Input type: `DastProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofiledeleteid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.dastProfileRun`

Input type: `DastProfileRunInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilerunfullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastprofilerunid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be used for the scan. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilerunerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastprofilerunpipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. |

### `Mutation.dastProfileUpdate`

Input type: `DastProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdatebranchname"></a>`branchName` | [`String`](#string) | Associated branch. |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofileupdatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | Represents a DAST profile schedule. |
| <a id="mutationdastprofileupdatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | ID of the scanner profile to be associated. |
| <a id="mutationdastprofileupdatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID`](#dastsiteprofileid) | ID of the site profile to be associated. |
| <a id="mutationdastprofileupdatedescription"></a>`description` | [`String`](#string) | Description of the profile. Defaults to an empty string. |
| <a id="mutationdastprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastprofileupdateid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be deleted. |
| <a id="mutationdastprofileupdatename"></a>`name` | [`String`](#string) | Name of the profile. |
| <a id="mutationdastprofileupdaterunafterupdate"></a>`runAfterUpdate` | [`Boolean`](#boolean) | Run scan using profile after update. Defaults to false. |
| <a id="mutationdastprofileupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Indicates the runner tags associated with the profile. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofileupdatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | Updated profile. |
| <a id="mutationdastprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastprofileupdatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | The URL of the pipeline that was created. Requires the input argument `runAfterUpdate` to be set to `true` when calling the mutation, otherwise no pipeline will be created. |

### `Mutation.dastScannerProfileCreate`

Input type: `DastScannerProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the scanner profile belongs to. |
| <a id="mutationdastscannerprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | Name of the scanner profile. |
| <a id="mutationdastscannerprofilecreatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | Indicates the type of DAST scan that will run. Either a Passive Scan or an Active Scan. |
| <a id="mutationdastscannerprofilecreateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | Indicates if debug messages should be included in DAST console output. True to include the debug messages. |
| <a id="mutationdastscannerprofilecreatespidertimeout"></a>`spiderTimeout` | [`Int`](#int) | Maximum number of minutes allowed for the spider to traverse the site. |
| <a id="mutationdastscannerprofilecreatetaglist"></a>`tagList` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | **Deprecated**: Moved to DastProfile. Deprecated in GitLab 15.8. |
| <a id="mutationdastscannerprofilecreatetargettimeout"></a>`targetTimeout` | [`Int`](#int) | Maximum number of seconds allowed for the site under test to respond to a request. |
| <a id="mutationdastscannerprofilecreateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | Indicates if the AJAX spider should be used to crawl the target site. True to run the AJAX spider in addition to the traditional spider, and false to run only the traditional spider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofilecreatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | Created scanner profile. |
| <a id="mutationdastscannerprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastscannerprofilecreateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastScannerProfileID`](#dastscannerprofileid) | **Deprecated**: use `dastScannerProfile` field. Deprecated in GitLab 14.10. |

### `Mutation.dastScannerProfileDelete`

Input type: `DastScannerProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofiledeletefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastscannerprofiledeleteid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.dastScannerProfileUpdate`

Input type: `DastScannerProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastscannerprofileupdateid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be updated. |
| <a id="mutationdastscannerprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | Name of the scanner profile. |
| <a id="mutationdastscannerprofileupdatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | Indicates the type of DAST scan that will run. Either a Passive Scan or an Active Scan. |
| <a id="mutationdastscannerprofileupdateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | Indicates if debug messages should be included in DAST console output. True to include the debug messages. |
| <a id="mutationdastscannerprofileupdatespidertimeout"></a>`spiderTimeout` | [`Int!`](#int) | Maximum number of minutes allowed for the spider to traverse the site. |
| <a id="mutationdastscannerprofileupdatetaglist"></a>`tagList` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | **Deprecated**: Moved to DastProfile. Deprecated in GitLab 15.8. |
| <a id="mutationdastscannerprofileupdatetargettimeout"></a>`targetTimeout` | [`Int!`](#int) | Maximum number of seconds allowed for the site under test to respond to a request. |
| <a id="mutationdastscannerprofileupdateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | Indicates if the AJAX spider should be used to crawl the target site. True to run the AJAX spider in addition to the traditional spider, and false to run only the traditional spider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofileupdatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | Updated scanner profile. |
| <a id="mutationdastscannerprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastscannerprofileupdateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastScannerProfileID`](#dastscannerprofileid) | **Deprecated**: use `dastScannerProfile` field. Deprecated in GitLab 14.10. |

### `Mutation.dastSiteProfileCreate`

Input type: `DastSiteProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | Parameters for authentication. |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofilecreateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | URLs to skip during an authenticated scan. Defaults to `[]`. |
| <a id="mutationdastsiteprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |
| <a id="mutationdastsiteprofilecreateoptionalvariables"></a>`optionalVariables` | [`[JSON!]`](#json) | Optional variables that can be configured for DAST scans. |
| <a id="mutationdastsiteprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | Name of the site profile. |
| <a id="mutationdastsiteprofilecreaterequestheaders"></a>`requestHeaders` | [`String`](#string) | Comma-separated list of request header names and values to be added to every request made by DAST. |
| <a id="mutationdastsiteprofilecreatescanfilepath"></a>`scanFilePath` | [`String`](#string) | File Path or URL used as input for the scan method. |
| <a id="mutationdastsiteprofilecreatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | Scan method by the scanner. |
| <a id="mutationdastsiteprofilecreatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | Type of target to be scanned. |
| <a id="mutationdastsiteprofilecreatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be scanned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofilecreatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | Site Profile object. |
| <a id="mutationdastsiteprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastsiteprofilecreateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastSiteProfileID`](#dastsiteprofileid) | **Deprecated**: use `dastSiteProfile.id` field. Deprecated in GitLab 14.10. |

### `Mutation.dastSiteProfileDelete`

Input type: `DastSiteProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofiledeletefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastsiteprofiledeleteid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.dastSiteProfileUpdate`

Input type: `DastSiteProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | Parameters for authentication. |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofileupdateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | URLs to skip during an authenticated scan. |
| <a id="mutationdastsiteprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastsiteprofileupdateid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be updated. |
| <a id="mutationdastsiteprofileupdateoptionalvariables"></a>`optionalVariables` | [`[JSON!]`](#json) | Optional variables that can be configured for DAST scans. |
| <a id="mutationdastsiteprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | Name of the site profile. |
| <a id="mutationdastsiteprofileupdaterequestheaders"></a>`requestHeaders` | [`String`](#string) | Comma-separated list of request header names and values to be added to every request made by DAST. |
| <a id="mutationdastsiteprofileupdatescanfilepath"></a>`scanFilePath` | [`String`](#string) | File Path or URL used as input for the scan method. |
| <a id="mutationdastsiteprofileupdatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | Scan method by the scanner. |
| <a id="mutationdastsiteprofileupdatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | Type of target to be scanned. |
| <a id="mutationdastsiteprofileupdatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be scanned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofileupdatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | Site profile object. |
| <a id="mutationdastsiteprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastsiteprofileupdateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastSiteProfileID`](#dastsiteprofileid) | **Deprecated**: use `dastSiteProfile.id` field. Deprecated in GitLab 14.10. |

### `Mutation.dastSiteTokenCreate`

Input type: `DastSiteTokenCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitetokencreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site token belongs to. |
| <a id="mutationdastsitetokencreatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be validated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitetokencreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastsitetokencreateid"></a>`id` | [`DastSiteTokenID`](#dastsitetokenid) | ID of the site token. |
| <a id="mutationdastsitetokencreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | Current validation status of the target. |
| <a id="mutationdastsitetokencreatetoken"></a>`token` | [`String`](#string) | Token string. |

### `Mutation.dastSiteValidationCreate`

Input type: `DastSiteValidationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationcreatedastsitetokenid"></a>`dastSiteTokenId` | [`DastSiteTokenID!`](#dastsitetokenid) | ID of the site token. |
| <a id="mutationdastsitevalidationcreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |
| <a id="mutationdastsitevalidationcreatestrategy"></a>`strategy` | [`DastSiteValidationStrategyEnum`](#dastsitevalidationstrategyenum) | Validation strategy to be used. |
| <a id="mutationdastsitevalidationcreatevalidationpath"></a>`validationPath` | [`String!`](#string) | Path to be requested during validation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdastsitevalidationcreateid"></a>`id` | [`DastSiteValidationID`](#dastsitevalidationid) | ID of the site validation. |
| <a id="mutationdastsitevalidationcreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | Current validation status. |

### `Mutation.dastSiteValidationRevoke`

Input type: `DastSiteValidationRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationrevokefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site validation belongs to. |
| <a id="mutationdastsitevalidationrevokenormalizedtargeturl"></a>`normalizedTargetUrl` | [`String!`](#string) | Normalized URL of the target to be revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.deleteAnnotation`

{{< details >}}
**Deprecated** in GitLab 16.0.
Underlying feature was removed in 16.0.
{{< /details >}}

Input type: `DeleteAnnotationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteannotationid"></a>`id` | [`String!`](#string) | Global ID of the annotation to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteannotationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.deleteContainerProtectionRepositoryRule`

Deletes a container repository protection rule.

Input type: `DeleteContainerProtectionRepositoryRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletecontainerprotectionrepositoryruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | Global ID of the container repository protection rule to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | Container repository protection rule that was deleted successfully. |
| <a id="mutationdeletecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.deleteContainerProtectionTagRule`

{{< details >}}
**Introduced** in GitLab 17.8.
**Status**: Experiment.
{{< /details >}}

Deletes a protection rule that controls which user roles can modify container image tags matching a specified pattern.

Input type: `DeleteContainerProtectionTagRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletecontainerprotectiontagruleid"></a>`id` | [`ContainerRegistryProtectionTagRuleID!`](#containerregistryprotectiontagruleid) | Global ID of the tag protection rule to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |
| <a id="mutationdeletecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.deleteConversationThread`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `DeleteConversationThreadInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteconversationthreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteconversationthreadthreadid"></a>`threadId` | [`AiConversationThreadID!`](#aiconversationthreadid) | Global ID of the thread to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteconversationthreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteconversationthreaderrors"></a>`errors` | [`[String!]!`](#string) | List of errors that occurred whilst trying to delete the thread. |
| <a id="mutationdeleteconversationthreadsuccess"></a>`success` | [`Boolean!`](#boolean) | Returns true if thread was successfully deleted. |

### `Mutation.deleteDuoWorkflowsWorkflow`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Input type: `DeleteDuoWorkflowsWorkflowInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteduoworkflowsworkflowclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteduoworkflowsworkflowworkflowid"></a>`workflowId` | [`AiDuoWorkflowsWorkflowID!`](#aiduoworkflowsworkflowid) | Global ID of the workflow to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteduoworkflowsworkflowclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteduoworkflowsworkflowerrors"></a>`errors` | [`[String!]!`](#string) | List of errors that occurred whilst trying to delete the workflow. |
| <a id="mutationdeleteduoworkflowsworkflowsuccess"></a>`success` | [`Boolean!`](#boolean) | Returns true if workflow was successfully deleted. |

### `Mutation.deletePackagesProtectionRule`

Deletes a protection rule for packages.

Input type: `DeletePackagesProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | Global ID of the package protection rule to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdeletepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | Packages protection rule that was deleted successfully. |

### `Mutation.deletePagesDeployment`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Deletes a Pages deployment.

Input type: `DeletePagesDeploymentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletepagesdeploymentid"></a>`id` | [`PagesDeploymentID!`](#pagesdeploymentid) | ID of the Pages Deployment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletepagesdeploymenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdeletepagesdeploymentpagesdeployment"></a>`pagesDeployment` | [`PagesDeployment!`](#pagesdeployment) | Deleted Pages Deployment. |

### `Mutation.designManagementDelete`

Input type: `DesignManagementDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementdeletefilenames"></a>`filenames` | [`[String!]!`](#string) | Filenames of the designs to delete. |
| <a id="mutationdesignmanagementdeleteiid"></a>`iid` | [`ID!`](#id) | IID of the issue to modify designs for. |
| <a id="mutationdesignmanagementdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project where the issue is to upload designs for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdesignmanagementdeleteversion"></a>`version` | [`DesignVersion`](#designversion) | New version in which the designs are deleted. |

### `Mutation.designManagementMove`

Input type: `DesignManagementMoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementmoveid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | ID of the design to move. |
| <a id="mutationdesignmanagementmovenext"></a>`next` | [`DesignManagementDesignID`](#designmanagementdesignid) | ID of the immediately following design. |
| <a id="mutationdesignmanagementmoveprevious"></a>`previous` | [`DesignManagementDesignID`](#designmanagementdesignid) | ID of the immediately preceding design. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementmovedesigncollection"></a>`designCollection` | [`DesignCollection`](#designcollection) | Current state of the collection. |
| <a id="mutationdesignmanagementmoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.designManagementUpdate`

Input type: `DesignManagementUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementupdatedescription"></a>`description` | [`String`](#string) | Description of the design. |
| <a id="mutationdesignmanagementupdateid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | ID of the design to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementupdatedesign"></a>`design` | [`Design!`](#design) | Updated design. |
| <a id="mutationdesignmanagementupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.designManagementUpload`

Input type: `DesignManagementUploadInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementuploadfiles"></a>`files` | [`[Upload!]!`](#upload) | Files to upload. |
| <a id="mutationdesignmanagementuploadiid"></a>`iid` | [`ID!`](#id) | IID of the issue to modify designs for. |
| <a id="mutationdesignmanagementuploadprojectpath"></a>`projectPath` | [`ID!`](#id) | Project where the issue is to upload designs for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementuploaddesigns"></a>`designs` | [`[Design!]!`](#design) | Designs that were uploaded by the mutation. |
| <a id="mutationdesignmanagementuploaderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdesignmanagementuploadskippeddesigns"></a>`skippedDesigns` | [`[Design!]!`](#design) | Any designs that were skipped from the upload due to there being no change to their content since their last version. |

### `Mutation.destroyBoard`

Input type: `DestroyBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardid"></a>`id` | [`BoardID!`](#boardid) | Global ID of the board to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyBoardList`

Input type: `DestroyBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardlistlistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list to destroy. Only label lists are accepted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdestroyboardlistlist"></a>`list` | [`BoardList`](#boardlist) | List after mutation. |

### `Mutation.destroyComplianceFramework`

Input type: `DestroyComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | Global ID of the compliance framework to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyComplianceRequirement`

{{< details >}}
**Introduced** in GitLab 17.7.
**Status**: Experiment.
{{< /details >}}

Input type: `DestroyComplianceRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycompliancerequirementid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | Global ID of the compliance requirement to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyComplianceRequirementsControl`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `DestroyComplianceRequirementsControlInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycompliancerequirementscontrolid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementsControlID!`](#compliancemanagementcomplianceframeworkcompliancerequirementscontrolid) | Global ID of the compliance requirement control to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyContainerRepository`

Input type: `DestroyContainerRepositoryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | ID of the container repository. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorycontainerrepository"></a>`containerRepository` | [`ContainerRepository!`](#containerrepository) | Container repository policy after scheduling the deletion. |
| <a id="mutationdestroycontainerrepositoryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyContainerRepositoryTags`

Input type: `DestroyContainerRepositoryTagsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorytagsid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | ID of the container repository. |
| <a id="mutationdestroycontainerrepositorytagstagnames"></a>`tagNames` | [`[String!]!`](#string) | Container repository tag(s) to delete. Total number can't be greater than 20. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorytagsdeletedtagnames"></a>`deletedTagNames` | [`[String!]!`](#string) | Deleted container repository tags. |
| <a id="mutationdestroycontainerrepositorytagserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyCustomEmoji`

Input type: `DestroyCustomEmojiInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycustomemojiid"></a>`id` | [`CustomEmojiID!`](#customemojiid) | Global ID of the custom emoji to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | Deleted custom emoji. |
| <a id="mutationdestroycustomemojierrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyEpicBoard`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `DestroyEpicBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyepicboardid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyepicboardepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Epic board after mutation. |
| <a id="mutationdestroyepicboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyNote`

Input type: `DestroyNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroynoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroynoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdestroynotenote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationdestroynotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.destroyPackage`

Input type: `DestroyPackageInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | ID of the Package. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyPackageFile`

Input type: `DestroyPackageFileInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileid"></a>`id` | [`PackagesPackageFileID!`](#packagespackagefileid) | ID of the Package file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyPackageFiles`

Input type: `DestroyPackageFilesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefilesids"></a>`ids` | [`[PackagesPackageFileID!]!`](#packagespackagefileid) | IDs of the Package file. |
| <a id="mutationdestroypackagefilesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the packages cleanup policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroyPackages`

Input type: `DestroyPackagesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagesids"></a>`ids` | [`[PackagesPackageID!]!`](#packagespackageid) | Global IDs of the Packages. Max 100. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.destroySnippet`

Input type: `DestroySnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroysnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroysnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdestroysnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.devfileValidate`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Input type: `DevfileValidateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdevfilevalidateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdevfilevalidatedevfileyaml"></a>`devfileYaml` | [`String!`](#string) | Input devfile. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdevfilevalidateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdevfilevalidateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdevfilevalidatevalid"></a>`valid` | [`Boolean`](#boolean) | Status whether devfile is valid or not. |

### `Mutation.disableDevopsAdoptionNamespace`

**Status**: Beta.

Input type: `DisableDevopsAdoptionNamespaceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdisabledevopsadoptionnamespaceid"></a>`id` | [`[AnalyticsDevopsAdoptionEnabledNamespaceID!]!`](#analyticsdevopsadoptionenablednamespaceid) | One or many IDs of the enabled namespaces to disable. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdisabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.discussionToggleResolve`

Toggles the resolved state of a discussion.

Input type: `DiscussionToggleResolveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdiscussiontoggleresolveid"></a>`id` | [`DiscussionID!`](#discussionid) | Global ID of the discussion. |
| <a id="mutationdiscussiontoggleresolveresolve"></a>`resolve` | [`Boolean!`](#boolean) | Will resolve the discussion when true, and unresolve the discussion when false. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdiscussiontoggleresolvediscussion"></a>`discussion` | [`Discussion`](#discussion) | Discussion after mutation. |
| <a id="mutationdiscussiontoggleresolveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.dismissPolicyViolations`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Dismisses policy violations linked to a merge request.

Input type: `DismissPolicyViolationsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdismisspolicyviolationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdismisspolicyviolationscomment"></a>`comment` | [`String!`](#string) | Comment explaining the dismissal of the policy violations. |
| <a id="mutationdismisspolicyviolationsdismissaltypes"></a>`dismissalTypes` | [`[DismissalType!]!`](#dismissaltype) | Type of dismissal for the policy violations. |
| <a id="mutationdismisspolicyviolationsiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationdismisspolicyviolationsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationdismisspolicyviolationssecuritypolicyids"></a>`securityPolicyIds` | [`[ID!]!`](#id) | IDs of warn mode policies with violations to dismiss. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdismisspolicyviolationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdismisspolicyviolationserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationdismisspolicyviolationsmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.duoSettingsUpdate`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Updates GitLab Duo settings.

Input type: `DuoSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationduosettingsupdateaigatewaytimeoutseconds"></a>`aiGatewayTimeoutSeconds` | [`Int`](#int) | Timeout for AI gateway request. |
| <a id="mutationduosettingsupdateaigatewayurl"></a>`aiGatewayUrl` | [`String`](#string) | URL for local AI gateway server. |
| <a id="mutationduosettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationduosettingsupdateduoagentplatformserviceurl"></a>`duoAgentPlatformServiceUrl` | [`String`](#string) | URL for the local Duo Agent Platform service. |
| <a id="mutationduosettingsupdateduocorefeaturesenabled"></a>`duoCoreFeaturesEnabled` | [`Boolean`](#boolean) | Indicates whether GitLab Duo Core features are enabled. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationduosettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationduosettingsupdateduosettings"></a>`duoSettings` | [`DuoSettings!`](#duosettings) | GitLab Duo settings after mutation. |
| <a id="mutationduosettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.duoUserFeedback`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `DuoUserFeedbackInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | Global ID of the agent to answer the chat. |
| <a id="mutationduouserfeedbackaimessageid"></a>`aiMessageId` | [`String!`](#string) | ID of the AI Message. |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationduouserfeedbacktrackingevent"></a>`trackingEvent` | [`TrackingEventInput`](#trackingeventinput) | Tracking event data. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationduouserfeedbackerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.echoCreate`

A mutation that does not perform any changes.

This is expected to be used for testing of endpoints, to verify
that a user has mutation access.

Input type: `EchoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]`](#string) | Errors to return to the user. |
| <a id="mutationechocreatemessages"></a>`messages` | [`[String!]`](#string) | Messages to return to the user. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationechocreateechoes"></a>`echoes` | [`[String!]`](#string) | Messages returned to the user. |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.enableDevopsAdoptionNamespace`

**Status**: Beta.

Input type: `EnableDevopsAdoptionNamespaceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenabledevopsadoptionnamespacedisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Display namespace ID. |
| <a id="mutationenabledevopsadoptionnamespacenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Namespace ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenabledevopsadoptionnamespaceenablednamespace"></a>`enabledNamespace` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | Enabled namespace after mutation. |
| <a id="mutationenabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.environmentCreate`

Create an environment.

Input type: `EnvironmentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateautostopsetting"></a>`autoStopSetting` | [`AutoStopSetting`](#autostopsetting) | Auto stop setting of the environment. |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentcreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | Cluster agent of the environment. |
| <a id="mutationenvironmentcreatedescription"></a>`description` | [`String`](#string) | Description of the environment. |
| <a id="mutationenvironmentcreateexternalurl"></a>`externalUrl` | [`String`](#string) | External URL of the environment. |
| <a id="mutationenvironmentcreatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | Flux resource path of the environment. |
| <a id="mutationenvironmentcreatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | Kubernetes namespace of the environment. |
| <a id="mutationenvironmentcreatename"></a>`name` | [`String!`](#string) | Name of the environment. |
| <a id="mutationenvironmentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |
| <a id="mutationenvironmentcreatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | Tier of the environment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentcreateenvironment"></a>`environment` | [`Environment`](#environment) | Created environment. |
| <a id="mutationenvironmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.environmentDelete`

Delete an environment.

Input type: `EnvironmentDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentdeleteid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to Delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.environmentStop`

Stop an environment.

Input type: `EnvironmentStopInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentstopforce"></a>`force` | [`Boolean`](#boolean) | Force environment to stop without executing on_stop actions. |
| <a id="mutationenvironmentstopid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to stop. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentstopenvironment"></a>`environment` | [`Environment`](#environment) | Environment after attempt to stop. |
| <a id="mutationenvironmentstoperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.environmentUpdate`

Update an environment.

Input type: `EnvironmentUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateautostopsetting"></a>`autoStopSetting` | [`AutoStopSetting`](#autostopsetting) | Auto stop setting of the environment. |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentupdateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | Cluster agent of the environment. |
| <a id="mutationenvironmentupdatedescription"></a>`description` | [`String`](#string) | Description of the environment. |
| <a id="mutationenvironmentupdateexternalurl"></a>`externalUrl` | [`String`](#string) | External URL of the environment. |
| <a id="mutationenvironmentupdatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | Flux resource path of the environment. |
| <a id="mutationenvironmentupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to update. |
| <a id="mutationenvironmentupdatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | Kubernetes namespace of the environment. |
| <a id="mutationenvironmentupdatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | Tier of the environment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentupdateenvironment"></a>`environment` | [`Environment`](#environment) | Environment after attempt to update. |
| <a id="mutationenvironmentupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.environmentsCanaryIngressUpdate`

**Deprecated** This endpoint is planned to be removed along with certificate-based clusters. [See this epic](https://gitlab.com/groups/gitlab-org/configure/-/epics/8) for more information.

Input type: `EnvironmentsCanaryIngressUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentscanaryingressupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to update. |
| <a id="mutationenvironmentscanaryingressupdateweight"></a>`weight` | [`Int!`](#int) | Weight of the Canary Ingress. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentscanaryingressupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.epicAddIssue`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by `WorkItem` type. For more information, see [migration guide](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/).
{{< /details >}}

Input type: `EpicAddIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicaddissuegrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate belongs to. |
| <a id="mutationepicaddissueiid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationepicaddissueissueiid"></a>`issueIid` | [`String!`](#string) | IID of the issue to be added. |
| <a id="mutationepicaddissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the issue belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicaddissueepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicaddissueepicissue"></a>`epicIssue` | [`EpicIssue`](#epicissue) | Epic-issue relationship. |
| <a id="mutationepicaddissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.epicBoardCreate`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `EpicBoardCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardcreatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | Whether or not display epic colors. |
| <a id="mutationepicboardcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationepicboardcreatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationepicboardcreatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationepicboardcreatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationepicboardcreatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationepicboardcreatename"></a>`name` | [`String`](#string) | Board name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardcreateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Created epic board. |
| <a id="mutationepicboardcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.epicBoardListCreate`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `EpicBoardListCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | Create the backlog list. |
| <a id="mutationepicboardlistcreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the issue board to mutate. |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | Global ID of an existing label. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationepicboardlistcreatelist"></a>`list` | [`EpicList`](#epiclist) | Epic list in the epic board. |

### `Mutation.epicBoardListDestroy`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Destroys an epic board list.

Input type: `EpicBoardListDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistdestroylistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic board list to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationepicboardlistdestroylist"></a>`list` | [`EpicList`](#epiclist) | Epic board list. `null` if the board was destroyed successfully. |

### `Mutation.epicBoardUpdate`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `EpicBoardUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardupdatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | Whether or not display epic colors. |
| <a id="mutationepicboardupdatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationepicboardupdatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationepicboardupdateid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Epic board global ID. |
| <a id="mutationepicboardupdatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationepicboardupdatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationepicboardupdatename"></a>`name` | [`String`](#string) | Board name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardupdateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Updated epic board. |
| <a id="mutationepicboardupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.epicMoveList`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `EpicMoveListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board that the epic is in. |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicmovelistepicid"></a>`epicId` | [`EpicID!`](#epicid) | ID of the epic to mutate. |
| <a id="mutationepicmovelistfromlistid"></a>`fromListId` | [`BoardsEpicListID`](#boardsepiclistid) | ID of the board list that the epic will be moved from. Required if moving between lists. |
| <a id="mutationepicmovelistmoveafterid"></a>`moveAfterId` | [`EpicID`](#epicid) | ID of epic that should be placed after the current epic. |
| <a id="mutationepicmovelistmovebeforeid"></a>`moveBeforeId` | [`EpicID`](#epicid) | ID of epic that should be placed before the current epic. |
| <a id="mutationepicmovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | Position of epics within the board list. Positions start at 0. Use -1 to move to the end of the list. |
| <a id="mutationepicmovelisttolistid"></a>`toListId` | [`BoardsEpicListID!`](#boardsepiclistid) | ID of the list the epic will be in after mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicmovelistepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicmovelisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.epicSetSubscription`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by `WorkItem` type. For more information, see [migration guide](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/).
{{< /details >}}

Input type: `EpicSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicsetsubscriptiongrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate belongs to. |
| <a id="mutationepicsetsubscriptioniid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationepicsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicsetsubscriptionepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.epicTreeReorder`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `EpicTreeReorderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderbaseepicid"></a>`baseEpicId` | [`EpicID!`](#epicid) | ID of the base epic of the tree. |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepictreereordermoved"></a>`moved` | [`EpicTreeNodeFieldsInputType!`](#epictreenodefieldsinputtype) | Parameters for updating the tree positions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepictreereordererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.escalationPolicyCreate`

Input type: `EscalationPolicyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicycreatedescription"></a>`description` | [`String`](#string) | Description of the escalation policy. |
| <a id="mutationescalationpolicycreatename"></a>`name` | [`String!`](#string) | Name of the escalation policy. |
| <a id="mutationescalationpolicycreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the escalation policy for. |
| <a id="mutationescalationpolicycreaterules"></a>`rules` | [`[EscalationRuleInput!]!`](#escalationruleinput) | Steps of the escalation policy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationescalationpolicycreateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.escalationPolicyDestroy`

Input type: `EscalationPolicyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicydestroyid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | Escalation policy internal ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationescalationpolicydestroyescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.escalationPolicyUpdate`

Input type: `EscalationPolicyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicyupdatedescription"></a>`description` | [`String`](#string) | Description of the escalation policy. |
| <a id="mutationescalationpolicyupdateid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | ID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationescalationpolicyupdatename"></a>`name` | [`String`](#string) | Name of the escalation policy. |
| <a id="mutationescalationpolicyupdaterules"></a>`rules` | [`[EscalationRuleInput!]`](#escalationruleinput) | Steps of the escalation policy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationescalationpolicyupdateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.exportRequirements`

Input type: `ExportRequirementsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsauthorusername"></a>`authorUsername` | [`[String!]`](#string) | Filter requirements by author username. |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexportrequirementsprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirements are associated with. |
| <a id="mutationexportrequirementssearch"></a>`search` | [`String`](#string) | Search query for requirement title. |
| <a id="mutationexportrequirementsselectedfields"></a>`selectedFields` | [`[String!]`](#string) | List of selected requirements fields to be exported. |
| <a id="mutationexportrequirementssort"></a>`sort` | [`Sort`](#sort) | List requirements by sort order. |
| <a id="mutationexportrequirementsstate"></a>`state` | [`RequirementState`](#requirementstate) | Filter requirements by state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexportrequirementserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.externalAuditEventDestinationCreate`

Input type: `ExternalAuditEventDestinationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | Destination URL. |
| <a id="mutationexternalauditeventdestinationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationexternalauditeventdestinationcreateverificationtoken"></a>`verificationToken` | [`String`](#string) | Verification token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationexternalauditeventdestinationcreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | Destination created. |

### `Mutation.externalAuditEventDestinationDestroy`

Input type: `ExternalAuditEventDestinationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ID of external audit event destination to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.externalAuditEventDestinationUpdate`

Input type: `ExternalAuditEventDestinationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | Destination URL to change. |
| <a id="mutationexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ID of external audit event destination to update. |
| <a id="mutationexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | Destination name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationexternalauditeventdestinationupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | Updated destination. |

### `Mutation.geoRegistriesBulkUpdate`

{{< details >}}
**Introduced** in GitLab 16.4.
**Status**: Experiment.
{{< /details >}}

Mutates multiple Geo registries for a given registry class.

Input type: `GeoRegistriesBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateaction"></a>`action` | [`GeoRegistriesBulkAction!`](#georegistriesbulkaction) | Action to be executed on Geo registries. |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesbulkupdateids"></a>`ids` | [`[GeoBaseRegistryID!]`](#geobaseregistryid) | Execute the action on registries selected by their ID. |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass!`](#georegistryclass) | Class of the Geo registries to be updated. |
| <a id="mutationgeoregistriesbulkupdatereplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Execute the action on registries selected by their replication state. |
| <a id="mutationgeoregistriesbulkupdateverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Execute the action on registries selected by their verification state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass`](#georegistryclass) | Updated Geo registry class. |

### `Mutation.geoRegistriesUpdate`

{{< details >}}
**Introduced** in GitLab 16.1.
**Status**: Experiment.
{{< /details >}}

Mutates a Geo registry.

Input type: `GeoRegistriesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateaction"></a>`action` | [`GeoRegistryAction!`](#georegistryaction) | Action to be executed on a Geo registry. |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesupdateregistryid"></a>`registryId` | [`GeoBaseRegistryID!`](#geobaseregistryid) | ID of the Geo registry entry to be updated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgeoregistriesupdateregistry"></a>`registry` | [`Registrable`](#registrable) | Updated Geo registry entry. |

### `Mutation.gitlabSubscriptionActivate`

Input type: `GitlabSubscriptionActivateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateactivationcode"></a>`activationCode` | [`String!`](#string) | Activation code received after purchasing a GitLab subscription. |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgitlabsubscriptionactivateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgitlabsubscriptionactivatefuturesubscriptions"></a>`futureSubscriptions` | [`[SubscriptionFutureEntry!]`](#subscriptionfutureentry) | Array of future subscriptions. |
| <a id="mutationgitlabsubscriptionactivatelicense"></a>`license` | [`CurrentLicense`](#currentlicense) | Current license. |

### `Mutation.googleCloudLoggingConfigurationCreate`

Input type: `GoogleCloudLoggingConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationgooglecloudloggingconfigurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationgooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project.(defaults to `audit_events`). |
| <a id="mutationgooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | configuration created. |

### `Mutation.googleCloudLoggingConfigurationDestroy`

Input type: `GoogleCloudLoggingConfigurationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | ID of the Google Cloud logging configuration to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.googleCloudLoggingConfigurationUpdate`

Input type: `GoogleCloudLoggingConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationgooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationgooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | ID of the google Cloud configuration to update. |
| <a id="mutationgooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project. |
| <a id="mutationgooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgooglecloudloggingconfigurationupdategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | configuration updated. |

### `Mutation.groupAuditEventStreamingDestinationsCreate`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `GroupAuditEventStreamingDestinationsCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | Destination category. |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | Destination config. |
| <a id="mutationgroupauditeventstreamingdestinationscreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationgroupauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgroupauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | Destination created. |

### `Mutation.groupAuditEventStreamingDestinationsDelete`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `GroupAuditEventStreamingDestinationsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | ID of the audit events external streaming destination to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.groupAuditEventStreamingDestinationsUpdate`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `GroupAuditEventStreamingDestinationsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationgroupauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | Destination category. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | Destination config. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | ID of external audit event destination to update. |
| <a id="mutationgroupauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgroupauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | Updated destination. |

### `Mutation.groupMemberBulkUpdate`

Input type: `GroupMemberBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | Access level to update the members to. |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | Date and time the membership expires. |
| <a id="mutationgroupmemberbulkupdategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Global ID of the group. |
| <a id="mutationgroupmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of the members. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupmemberbulkupdategroupmembers"></a>`groupMembers` | [`[GroupMember!]`](#groupmember) | Group members after mutation. |

### `Mutation.groupMembersExport`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

Input type: `GroupMembersExportInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmembersexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmembersexportgroupid"></a>`groupId` | [`GroupID!`](#groupid) | Global ID of the group. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmembersexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmembersexporterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupmembersexportmessage"></a>`message` | [`String`](#string) | Export request result message. |

### `Mutation.groupSavedReplyCreate`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `GroupSavedReplyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplycreatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationgroupsavedreplycreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the save reply. |
| <a id="mutationgroupsavedreplycreatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupsavedreplycreatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | Saved reply after mutation. |

### `Mutation.groupSavedReplyDestroy`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `GroupSavedReplyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplydestroyid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | Global ID of the group-level saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupsavedreplydestroysavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | Saved reply after mutation. |

### `Mutation.groupSavedReplyUpdate`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `GroupSavedReplyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationgroupsavedreplyupdateid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | Global ID of the group-level saved reply. |
| <a id="mutationgroupsavedreplyupdatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupsavedreplyupdatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | Saved reply after mutation. |

### `Mutation.groupSecretsManagerDeprovision`

Input type: `GroupSecretsManagerDeprovisionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsecretsmanagerdeprovisionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsecretsmanagerdeprovisiongrouppath"></a>`groupPath` | [`ID!`](#id) | Group of the secrets manager. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsecretsmanagerdeprovisionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsecretsmanagerdeprovisionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupsecretsmanagerdeprovisiongroupsecretsmanager"></a>`groupSecretsManager` | [`GroupSecretsManager`](#groupsecretsmanager) | Group secrets manager. |

### `Mutation.groupSecretsManagerInitialize`

Input type: `GroupSecretsManagerInitializeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsecretsmanagerinitializegrouppath"></a>`groupPath` | [`ID!`](#id) | Group of the secrets manager. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsecretsmanagerinitializeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupsecretsmanagerinitializegroupsecretsmanager"></a>`groupSecretsManager` | [`GroupSecretsManager`](#groupsecretsmanager) | Group secrets manager. |

### `Mutation.groupUpdate`

Input type: `GroupUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean`](#boolean) | Indicates whether GitLab Duo features are enabled for the group. Introduced in GitLab 16.10: **Status**: Experiment. |
| <a id="mutationgroupupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the group that will be updated. |
| <a id="mutationgroupupdatelockduofeaturesenabled"></a>`lockDuoFeaturesEnabled` | [`Boolean`](#boolean) | Indicates if the GitLab Duo features enabled setting is enforced for all subgroups. Introduced in GitLab 16.10: **Status**: Experiment. |
| <a id="mutationgroupupdatelockmathrenderinglimitsenabled"></a>`lockMathRenderingLimitsEnabled` | [`Boolean`](#boolean) | Indicates if math rendering limits are locked for all descendant groups. |
| <a id="mutationgroupupdatemathrenderinglimitsenabled"></a>`mathRenderingLimitsEnabled` | [`Boolean`](#boolean) | Indicates if math rendering limits are used for the group. |
| <a id="mutationgroupupdatename"></a>`name` | [`String`](#string) | Name of the group. |
| <a id="mutationgroupupdatepath"></a>`path` | [`String`](#string) | Path of the namespace. |
| <a id="mutationgroupupdatesharedrunnerssetting"></a>`sharedRunnersSetting` | [`SharedRunnersSetting`](#sharedrunnerssetting) | Shared runners availability for the namespace and its descendants. |
| <a id="mutationgroupupdatestepupauthrequiredoauthprovider"></a>`stepUpAuthRequiredOauthProvider` | [`String`](#string) | OAuth provider required for step-up authentication. |
| <a id="mutationgroupupdatevisibility"></a>`visibility` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | Visibility of the namespace. |
| <a id="mutationgroupupdatewebbasedcommitsigningenabled"></a>`webBasedCommitSigningEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationgroupupdategroup"></a>`group` | [`Group`](#group) | Group after update. |

### `Mutation.httpIntegrationCreate`

Input type: `HttpIntegrationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationcreatename"></a>`name` | [`String!`](#string) | Name of the integration. |
| <a id="mutationhttpintegrationcreatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationhttpintegrationcreatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |
| <a id="mutationhttpintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the integration in. |
| <a id="mutationhttpintegrationcreatetype"></a>`type` | [`AlertManagementIntegrationType`](#alertmanagementintegrationtype) | Type of integration to create. Cannot be changed after creation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationhttpintegrationcreateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | Alerting integration. |

### `Mutation.httpIntegrationDestroy`

Input type: `HttpIntegrationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationdestroyid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationhttpintegrationdestroyintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | Alerting integration. |

### `Mutation.httpIntegrationResetToken`

Input type: `HttpIntegrationResetTokenInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationresettokenid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationhttpintegrationresettokenintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | Alerting integration. |

### `Mutation.httpIntegrationUpdate`

Input type: `HttpIntegrationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationupdateid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to mutate. |
| <a id="mutationhttpintegrationupdatename"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="mutationhttpintegrationupdatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationhttpintegrationupdatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationhttpintegrationupdateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | Alerting integration. |

### `Mutation.importSourceUserCancelReassignment`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `ImportSourceUserCancelReassignmentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceusercancelreassignmentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceusercancelreassignmentid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | Global ID of the mapping of a user on source instance to a user on destination instance. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceusercancelreassignmentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceusercancelreassignmenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationimportsourceusercancelreassignmentimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | Mapping of a user on source instance to a user on destination instance after mutation. |

### `Mutation.importSourceUserKeepAllAsPlaceholder`

{{< details >}}
**Introduced** in GitLab 17.6.
**Status**: Experiment.
{{< /details >}}

Input type: `ImportSourceUserKeepAllAsPlaceholderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepallasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserkeepallasplaceholdernamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Global ID of the namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepallasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserkeepallasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationimportsourceuserkeepallasplaceholderupdatedimportsourceusercount"></a>`updatedImportSourceUserCount` | [`Int`](#int) | Number of successfully updated mappings of users on source instance to their destination users. |

### `Mutation.importSourceUserKeepAsPlaceholder`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `ImportSourceUserKeepAsPlaceholderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserkeepasplaceholderid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | Global ID of the mapping of a user on source instance to a user on destination instance. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserkeepasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationimportsourceuserkeepasplaceholderimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | Mapping of a user on source instance to a user on destination instance after mutation. |

### `Mutation.importSourceUserReassign`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `ImportSourceUserReassignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserreassignassigneeuserid"></a>`assigneeUserId` | [`UserID!`](#userid) | Global ID of the assignee user. |
| <a id="mutationimportsourceuserreassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserreassignid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | Global ID of the mapping of a user on source instance to a user on destination instance. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserreassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserreassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationimportsourceuserreassignimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | Mapping of a user on source instance to a user on destination instance after mutation. |

### `Mutation.importSourceUserResendNotification`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `ImportSourceUserResendNotificationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserresendnotificationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserresendnotificationid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | Global ID of the mapping of a user on source instance to a user on destination instance. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserresendnotificationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserresendnotificationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationimportsourceuserresendnotificationimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | Mapping of a user on source instance to a user on destination instance after mutation. |

### `Mutation.importSourceUserUndoKeepAsPlaceholder`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Input type: `ImportSourceUserUndoKeepAsPlaceholderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserundokeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserundokeepasplaceholderid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | Global ID of the mapping of a user on source instance to a user on destination instance. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserundokeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationimportsourceuserundokeepasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationimportsourceuserundokeepasplaceholderimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | Mapping of a user on source instance to a user on destination instance after mutation. |

### `Mutation.instanceAuditEventStreamingDestinationsCreate`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `InstanceAuditEventStreamingDestinationsCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | Destination category. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | Destination config. |
| <a id="mutationinstanceauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstanceauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | Destination created. |

### `Mutation.instanceAuditEventStreamingDestinationsDelete`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `InstanceAuditEventStreamingDestinationsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | ID of the audit events external streaming destination to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.instanceAuditEventStreamingDestinationsUpdate`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `InstanceAuditEventStreamingDestinationsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | Destination category. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | Destination config. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | ID of external audit event destination to update. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | Updated destination. |

### `Mutation.instanceExternalAuditEventDestinationCreate`

Input type: `InstanceExternalAuditEventDestinationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | Destination URL. |
| <a id="mutationinstanceexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | Destination name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | Destination created. |

### `Mutation.instanceExternalAuditEventDestinationDestroy`

Input type: `InstanceExternalAuditEventDestinationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ID of the external instance audit event destination to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.instanceExternalAuditEventDestinationUpdate`

Input type: `InstanceExternalAuditEventDestinationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | Destination URL to change. |
| <a id="mutationinstanceexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ID of the external instance audit event destination to update. |
| <a id="mutationinstanceexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | Destination name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | Updated destination. |

### `Mutation.instanceGoogleCloudLoggingConfigurationCreate`

Input type: `InstanceGoogleCloudLoggingConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project.(defaults to `audit_events`). |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | configuration created. |

### `Mutation.instanceGoogleCloudLoggingConfigurationDestroy`

Input type: `InstanceGoogleCloudLoggingConfigurationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | ID of the Google Cloud logging configuration to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.instanceGoogleCloudLoggingConfigurationUpdate`

Input type: `InstanceGoogleCloudLoggingConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateactive"></a>`active` | [`Boolean`](#boolean) | Active status of the destination. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | ID of the instance google Cloud configuration to update. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | configuration updated. |

### `Mutation.integrationExclusionCreate`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `IntegrationExclusionCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusioncreategroupids"></a>`groupIds` | [`[GroupID!]`](#groupid) | IDs of groups to exclude up to a maximum of 100. |
| <a id="mutationintegrationexclusioncreateintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | Type of integration to exclude. |
| <a id="mutationintegrationexclusioncreateprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | IDs of projects to exclude up to a maximum of 100. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusioncreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationintegrationexclusioncreateexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | Integration exclusions created by the mutation. |

### `Mutation.integrationExclusionDelete`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `IntegrationExclusionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusiondeletegroupids"></a>`groupIds` | [`[GroupID!]`](#groupid) | IDs of excluded groups. |
| <a id="mutationintegrationexclusiondeleteintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | Type of integration. |
| <a id="mutationintegrationexclusiondeleteprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | IDs of excluded projects. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationintegrationexclusiondeleteexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | Project no longer excluded due to the mutation. |

### `Mutation.issuableResourceLinkCreate`

Input type: `IssuableResourceLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkcreateid"></a>`id` | [`IssueID!`](#issueid) | Incident id to associate the resource link with. |
| <a id="mutationissuableresourcelinkcreatelink"></a>`link` | [`String!`](#string) | Link of the resource. |
| <a id="mutationissuableresourcelinkcreatelinktext"></a>`linkText` | [`String`](#string) | Link text of the resource. |
| <a id="mutationissuableresourcelinkcreatelinktype"></a>`linkType` | [`IssuableResourceLinkType`](#issuableresourcelinktype) | Link type of the resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuableresourcelinkcreateissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | Issuable resource link. |

### `Mutation.issuableResourceLinkDestroy`

Input type: `IssuableResourceLinkDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkdestroyid"></a>`id` | [`IncidentManagementIssuableResourceLinkID!`](#incidentmanagementissuableresourcelinkid) | Issuable resource link ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuableresourcelinkdestroyissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | Issuable resource link. |

### `Mutation.issueLinkAlerts`

Input type: `IssueLinkAlertsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsalertreferences"></a>`alertReferences` | [`[String!]!`](#string) | Alerts references to be linked to the incident. |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuelinkalertsiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuelinkalertsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuelinkalertserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuelinkalertsissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueMove`

Input type: `IssueMoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemoveiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuemoveprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuemovetargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to move the issue to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuemoveissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueMoveList`

Input type: `IssueMoveListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistboardid"></a>`boardId` | [`BoardID!`](#boardid) | Global ID of the board that the issue is in. |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemovelistepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **Deprecated**: This will be replaced by WorkItem hierarchyWidget. Deprecated in GitLab 17.5. |
| <a id="mutationissuemovelistfromlistid"></a>`fromListId` | [`ID`](#id) | ID of the board list that the issue will be moved from. |
| <a id="mutationissuemovelistiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuemovelistmoveafterid"></a>`moveAfterId` | [`ID`](#id) | ID of issue that should be placed after the current issue. |
| <a id="mutationissuemovelistmovebeforeid"></a>`moveBeforeId` | [`ID`](#id) | ID of issue that should be placed before the current issue. |
| <a id="mutationissuemovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | Position of issue within the board list. Positions start at 0. Use -1 to move to the end of the list. |
| <a id="mutationissuemovelistprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuemovelisttolistid"></a>`toListId` | [`ID`](#id) | ID of the board list that the issue will be moved to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemovelisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuemovelistissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetAssignees`

Input type: `IssueSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the resource. Replaces existing assignees by default. |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationissuesetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetassigneesissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetConfidential`

Input type: `IssueSetConfidentialInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetconfidentialconfidential"></a>`confidential` | [`Boolean!`](#boolean) | Whether or not to set the issue as a confidential. |
| <a id="mutationissuesetconfidentialiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetconfidentialprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetconfidentialerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetconfidentialissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetCrmContacts`

Input type: `IssueSetCrmContactsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetcrmcontactscontactids"></a>`contactIds` | [`[CustomerRelationsContactID!]!`](#customerrelationscontactid) | Customer relations contact IDs to set. Replaces existing contacts by default. |
| <a id="mutationissuesetcrmcontactsiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetcrmcontactsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Changes the operation mode. Defaults to REPLACE. |
| <a id="mutationissuesetcrmcontactsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetcrmcontactserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetcrmcontactsissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetDueDate`

Input type: `IssueSetDueDateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetduedateduedate"></a>`dueDate` | [`Time`](#time) | Desired due date for the issue. Due date is removed if null. |
| <a id="mutationissuesetduedateiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetduedateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetduedateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetduedateissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEpic`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `IssueSetEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetepicepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **Deprecated**: This will be replaced by WorkItem hierarchyWidget. Deprecated in GitLab 17.5. |
| <a id="mutationissuesetepiciid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetepicprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetepicissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEscalationPolicy`

Input type: `IssueSetEscalationPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationpolicyescalationpolicyid"></a>`escalationPolicyId` | [`IncidentManagementEscalationPolicyID`](#incidentmanagementescalationpolicyid) | Global ID of the escalation policy to assign to the issue. Policy will be removed if absent or set to null. |
| <a id="mutationissuesetescalationpolicyiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetescalationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetescalationpolicyissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEscalationStatus`

Input type: `IssueSetEscalationStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationstatusiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetescalationstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetescalationstatusstatus"></a>`status` | [`IssueEscalationStatus!`](#issueescalationstatus) | Set the escalation status. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetescalationstatusissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetIteration`

Input type: `IssueSetIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetiterationiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetiterationiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Iteration to assign to the issue. |
| <a id="mutationissuesetiterationprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetiterationissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetLocked`

Input type: `IssueSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetlockediid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | Whether or not to lock discussion on the issue. |
| <a id="mutationissuesetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetlockedissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetSeverity`

Input type: `IssueSetSeverityInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetseverityiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetseverityprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetseverityseverity"></a>`severity` | [`IssuableSeverity!`](#issuableseverity) | Set the incident severity level. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetseverityerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetseverityissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetSubscription`

Input type: `IssueSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetsubscriptioniid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetsubscriptionissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetWeight`

Input type: `IssueSetWeightInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetweightiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetweightprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetweightweight"></a>`weight` | [`Int`](#int) | The desired weight for the issue. If set to null, weight is removed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetweighterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissuesetweightissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueUnlinkAlert`

Input type: `IssueUnlinkAlertInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertalertid"></a>`alertId` | [`AlertManagementAlertID!`](#alertmanagementalertid) | Global ID of the alert to unlink from the incident. |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissueunlinkalertiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissueunlinkalertprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissueunlinkalerterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationissueunlinkalertissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.iterationCadenceCreate`

Input type: `IterationCadenceCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the iteration cadence is active. |
| <a id="mutationiterationcadencecreateautomatic"></a>`automatic` | [`Boolean!`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencecreatedescription"></a>`description` | [`String`](#string) | Description of the iteration cadence. Maximum length is 5000 characters. |
| <a id="mutationiterationcadencecreatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within the cadence. |
| <a id="mutationiterationcadencecreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group where the iteration cadence is created. |
| <a id="mutationiterationcadencecreateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | Upcoming iterations to be created when iteration cadence is set to automatic. |
| <a id="mutationiterationcadencecreaterollover"></a>`rollOver` | [`Boolean`](#boolean) | Whether the iteration cadence should roll over issues to the next iteration or not. |
| <a id="mutationiterationcadencecreatestartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the automation start date. |
| <a id="mutationiterationcadencecreatetitle"></a>`title` | [`String`](#string) | Title of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationiterationcadencecreateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Created iteration cadence. |

### `Mutation.iterationCadenceDestroy`

Input type: `IterationCadenceDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencedestroyid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | Global ID of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencedestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationiterationcadencedestroygroup"></a>`group` | [`Group!`](#group) | Group the iteration cadence belongs to. |

### `Mutation.iterationCadenceUpdate`

Input type: `IterationCadenceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the iteration cadence is active. |
| <a id="mutationiterationcadenceupdateautomatic"></a>`automatic` | [`Boolean`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadenceupdatedescription"></a>`description` | [`String`](#string) | Description of the iteration cadence. Maximum length is 5000 characters. |
| <a id="mutationiterationcadenceupdatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within the cadence. |
| <a id="mutationiterationcadenceupdateid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | Global ID of the iteration cadence. |
| <a id="mutationiterationcadenceupdateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | Upcoming iterations to be created when iteration cadence is set to automatic. |
| <a id="mutationiterationcadenceupdaterollover"></a>`rollOver` | [`Boolean`](#boolean) | Whether the iteration cadence should roll over issues to the next iteration or not. |
| <a id="mutationiterationcadenceupdatestartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the automation start date. |
| <a id="mutationiterationcadenceupdatetitle"></a>`title` | [`String`](#string) | Title of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationiterationcadenceupdateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Updated iteration cadence. |

### `Mutation.iterationCreate`

Input type: `iterationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcreatedescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationiterationcreateduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationiterationcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationiterationcreateiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global ID of the iteration cadence to be assigned to the new iteration. |
| <a id="mutationiterationcreateprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationiterationcreatestartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationiterationcreatetitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationiterationcreateiteration"></a>`iteration` | [`Iteration`](#iteration) | Created iteration. |

### `Mutation.iterationDelete`

Input type: `IterationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationdeleteid"></a>`id` | [`IterationID!`](#iterationid) | ID of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationiterationdeletegroup"></a>`group` | [`Group!`](#group) | Group the iteration belongs to. |

### `Mutation.jiraImportStart`

Input type: `JiraImportStartInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportstartjiraprojectkey"></a>`jiraProjectKey` | [`String!`](#string) | Project key of the importer Jira project. |
| <a id="mutationjiraimportstartjiraprojectname"></a>`jiraProjectName` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: Argument is not used. Deprecated in GitLab 17.4. |
| <a id="mutationjiraimportstartprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to import the Jira project into. |
| <a id="mutationjiraimportstartusersmapping"></a>`usersMapping` | [`[JiraUsersMappingInputType!]`](#jirausersmappinginputtype) | Mapping of Jira to GitLab users. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportstarterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationjiraimportstartjiraimport"></a>`jiraImport` | [`JiraImport`](#jiraimport) | Jira import data after mutation. |

### `Mutation.jiraImportUsers`

Input type: `JiraImportUsersInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportusersprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to import the Jira users into. |
| <a id="mutationjiraimportusersstartat"></a>`startAt` | [`Int`](#int) | Index of the record the import should started at, default 0 (50 records returned). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportuserserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationjiraimportusersjirausers"></a>`jiraUsers` | [`[JiraUser!]`](#jirauser) | Users returned from Jira, matched by email and name if possible. |

### `Mutation.jobArtifactsDestroy`

Input type: `JobArtifactsDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobartifactsdestroyid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobartifactsdestroydestroyedartifactscount"></a>`destroyedArtifactsCount` | [`Int!`](#int) | Number of artifacts deleted. |
| <a id="mutationjobartifactsdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationjobartifactsdestroyjob"></a>`job` | [`CiJob`](#cijob) | Job with artifacts to be deleted. |

### `Mutation.jobCancel`

Input type: `JobCancelInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobcancelid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobcancelerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationjobcanceljob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobPlay`

Input type: `JobPlayInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobplayid"></a>`id` | [`CiProcessableID!`](#ciprocessableid) | ID of the job to mutate. |
| <a id="mutationjobplayvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | Variables to use when playing a manual job. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobplayerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationjobplayjob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobRetry`

Input type: `JobRetryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobretryid"></a>`id` | [`CiProcessableID!`](#ciprocessableid) | ID of the job to mutate. |
| <a id="mutationjobretryinputs"></a>`inputs` | [`[CiInputsInput!]`](#ciinputsinput) | Inputs to use when retrying the job. |
| <a id="mutationjobretryvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | Variables to use when retrying a manual job. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobretryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationjobretryjob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobUnschedule`

Input type: `JobUnscheduleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobunscheduleid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobunscheduleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationjobunschedulejob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.labelCreate`

Input type: `LabelCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelcreatecolor"></a>`color` | [`String`](#string) | The color of the label given in 6-digit hex notation with leading '#' sign (for example, `#FFAABB`) or one of the CSS color names. |
| <a id="mutationlabelcreatedescription"></a>`description` | [`String`](#string) | Description of the label. |
| <a id="mutationlabelcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationlabelcreateprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationlabelcreatetitle"></a>`title` | [`String!`](#string) | Title of the label. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationlabelcreatelabel"></a>`label` | [`Label`](#label) | Label after mutation. |

### `Mutation.labelUpdate`

Input type: `LabelUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelupdatearchived"></a>`archived` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.4. |
| <a id="mutationlabelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelupdateid"></a>`id` | [`LabelID!`](#labelid) | Global ID of the label to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationlabelupdatelabel"></a>`label` | [`Label`](#label) | Label after mutation. |

### `Mutation.ldapAdminRoleLinkCreate`

{{< details >}}
**Introduced** in GitLab 17.11.
**Status**: Experiment.
{{< /details >}}

Creates an instance-level custom admin role LDAP link.

Input type: `LdapAdminRoleLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkcreateadminmemberroleid"></a>`adminMemberRoleId` | [`MemberRoleID!`](#memberroleid) | Global ID of the custom admin role to be assigned to a user. |
| <a id="mutationldapadminrolelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationldapadminrolelinkcreatecn"></a>`cn` | [`String`](#string) | Common Name (CN) of the LDAP group. |
| <a id="mutationldapadminrolelinkcreatefilter"></a>`filter` | [`String`](#string) | Search filter for the LDAP group. |
| <a id="mutationldapadminrolelinkcreateprovider"></a>`provider` | [`String!`](#string) | LDAP provider for the LDAP link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationldapadminrolelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationldapadminrolelinkcreateldapadminrolelink"></a>`ldapAdminRoleLink` | [`LdapAdminRoleLink`](#ldapadminrolelink) | Created instance-level LDAP link. |

### `Mutation.ldapAdminRoleLinkDestroy`

{{< details >}}
**Introduced** in GitLab 18.0.
**Status**: Experiment.
{{< /details >}}

Destroys an instance-level custom admin role LDAP link.

Input type: `LdapAdminRoleLinkDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationldapadminrolelinkdestroyid"></a>`id` | [`AuthzLdapAdminRoleLinkID!`](#authzldapadminrolelinkid) | Global ID of the instance-level LDAP link to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationldapadminrolelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationldapadminrolelinkdestroyldapadminrolelink"></a>`ldapAdminRoleLink` | [`LdapAdminRoleLink`](#ldapadminrolelink) | Deleted instance-level LDAP link. |

### `Mutation.lifecycleAttachWorkItemType`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Input type: `LifecycleAttachWorkItemTypeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleattachworkitemtypeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecycleattachworkitemtypelifecycleid"></a>`lifecycleId` | [`WorkItemsStatusesLifecycleID!`](#workitemsstatuseslifecycleid) | Global ID of the lifecycle to attach the work item type to. |
| <a id="mutationlifecycleattachworkitemtypenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Namespace path where the lifecycle exists. |
| <a id="mutationlifecycleattachworkitemtypestatusmappings"></a>`statusMappings` | [`[StatusMappingInput!]`](#statusmappinginput) | Status mappings from the old lifecycle to the new lifecycle. |
| <a id="mutationlifecycleattachworkitemtypeworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | Global ID of the work item type to attach to the lifecycle. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleattachworkitemtypeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecycleattachworkitemtypeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationlifecycleattachworkitemtypelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | Lifecycle after attaching the work item type. |

### `Mutation.lifecycleCreate`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Input type: `LifecycleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecyclecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecyclecreatedefaultclosedstatusindex"></a>`defaultClosedStatusIndex` | [`Int!`](#int) | Index of the default closed status in the statuses array. |
| <a id="mutationlifecyclecreatedefaultduplicatestatusindex"></a>`defaultDuplicateStatusIndex` | [`Int!`](#int) | Index of the default duplicated status in the statuses array. |
| <a id="mutationlifecyclecreatedefaultopenstatusindex"></a>`defaultOpenStatusIndex` | [`Int!`](#int) | Index of the default open status in the statuses array. |
| <a id="mutationlifecyclecreatename"></a>`name` | [`String!`](#string) | Name of the lifecycle. |
| <a id="mutationlifecyclecreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Namespace path where the lifecycle will be created. |
| <a id="mutationlifecyclecreatestatuses"></a>`statuses` | [`[WorkItemStatusInput!]!`](#workitemstatusinput) | Statuses of the lifecycle. Can be existing (with id) or new (without id). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecyclecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecyclecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationlifecyclecreatelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | Lifecycle created. |

### `Mutation.lifecycleDelete`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Input type: `LifecycleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecycledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecycledeleteid"></a>`id` | [`WorkItemsStatusesLifecycleID!`](#workitemsstatuseslifecycleid) | Global ID of the lifecycle to delete. |
| <a id="mutationlifecycledeletenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Namespace path where the lifecycle exists. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecycledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecycledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationlifecycledeletelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | Deleted lifecycle. |

### `Mutation.lifecycleUpdate`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Input type: `LifecycleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecycleupdatedefaultclosedstatusindex"></a>`defaultClosedStatusIndex` | [`Int`](#int) | Index of the default closed status in the statuses array. |
| <a id="mutationlifecycleupdatedefaultduplicatestatusindex"></a>`defaultDuplicateStatusIndex` | [`Int`](#int) | Index of the default duplicated status in the statuses array. |
| <a id="mutationlifecycleupdatedefaultopenstatusindex"></a>`defaultOpenStatusIndex` | [`Int`](#int) | Index of the default open status in the statuses array. |
| <a id="mutationlifecycleupdateid"></a>`id` | [`WorkItemsStatusesLifecycleID!`](#workitemsstatuseslifecycleid) | Global ID of the lifecycle to be updated. |
| <a id="mutationlifecycleupdatename"></a>`name` | [`String`](#string) | Name of the lifecycle. |
| <a id="mutationlifecycleupdatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Namespace path where the lifecycle exists. |
| <a id="mutationlifecycleupdatestatusmappings"></a>`statusMappings` | [`[StatusMappingInput!]`](#statusmappinginput) | Mappings for statuses being removed from the lifecycle. Maps old status to replacement status. |
| <a id="mutationlifecycleupdatestatuses"></a>`statuses` | [`[WorkItemStatusInput!]`](#workitemstatusinput) | Statuses of the lifecycle. Can be existing (with id) or new (without id). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlifecycleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationlifecycleupdatelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | Lifecycle updated. |

### `Mutation.linkProjectComplianceViolationIssue`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `LinkProjectComplianceViolationIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlinkprojectcomplianceviolationissueissueiid"></a>`issueIid` | [`String!`](#string) | IID of the issue to be linked. |
| <a id="mutationlinkprojectcomplianceviolationissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the issue belongs to. |
| <a id="mutationlinkprojectcomplianceviolationissueviolationid"></a>`violationId` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | Global ID of the project compliance violation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlinkprojectcomplianceviolationissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationlinkprojectcomplianceviolationissueviolation"></a>`violation` | [`ProjectComplianceViolation`](#projectcomplianceviolation) | Updated project compliance violation. |

### `Mutation.markAsSpamSnippet`

Input type: `MarkAsSpamSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmarkasspamsnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmarkasspamsnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmarkasspamsnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.mavenUpstreamCreate`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Input type: `MavenUpstreamCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmavenupstreamcreatecachevalidityhours"></a>`cacheValidityHours` | [`Int`](#int) | Cache validity period. Defaults to 24 hours. |
| <a id="mutationmavenupstreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmavenupstreamcreatedescription"></a>`description` | [`String`](#string) | Description of the upstream registry. |
| <a id="mutationmavenupstreamcreateid"></a>`id` | [`VirtualRegistriesPackagesMavenRegistryID!`](#virtualregistriespackagesmavenregistryid) | ID of the upstream registry. |
| <a id="mutationmavenupstreamcreatemetadatacachevalidityhours"></a>`metadataCacheValidityHours` {{< icon name="warning-solid" >}} | [`Int`](#int) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.4. |
| <a id="mutationmavenupstreamcreatename"></a>`name` | [`String!`](#string) | Name of upstream registry. |
| <a id="mutationmavenupstreamcreatepassword"></a>`password` | [`String`](#string) | Password of the upstream registry. |
| <a id="mutationmavenupstreamcreateurl"></a>`url` | [`String!`](#string) | URL of the upstream registry. |
| <a id="mutationmavenupstreamcreateusername"></a>`username` | [`String`](#string) | Username of the upstream registry. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmavenupstreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmavenupstreamcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmavenupstreamcreateupstream"></a>`upstream` | [`MavenUpstreamDetails`](#mavenupstreamdetails) | Maven upstream after the mutation. |

### `Mutation.memberRoleAdminCreate`

{{< details >}}
**Introduced** in GitLab 17.7.
**Status**: Experiment.
{{< /details >}}

Input type: `MemberRoleAdminCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmincreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleadmincreatedescription"></a>`description` | [`String`](#string) | Description of the member role. |
| <a id="mutationmemberroleadmincreatename"></a>`name` | [`String`](#string) | Name of the member role. |
| <a id="mutationmemberroleadmincreatepermissions"></a>`permissions` | [`[MemberRoleAdminPermission!]`](#memberroleadminpermission) | List of all customizable admin permissions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmincreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleadmincreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmemberroleadmincreatememberrole"></a>`memberRole` | [`AdminMemberRole`](#adminmemberrole) | Member role. |

### `Mutation.memberRoleAdminDelete`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

Input type: `MemberRoleAdminDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmindeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleadmindeleteid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ID of the admin member role to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmindeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleadmindeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmemberroleadmindeletememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | Deleted admin member role. |

### `Mutation.memberRoleAdminUpdate`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

Input type: `MemberRoleAdminUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadminupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleadminupdatedescription"></a>`description` | [`String`](#string) | Description of the member role. |
| <a id="mutationmemberroleadminupdateid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ID of the member role to mutate. |
| <a id="mutationmemberroleadminupdatename"></a>`name` | [`String`](#string) | Name of the member role. |
| <a id="mutationmemberroleadminupdatepermissions"></a>`permissions` | [`[MemberRoleAdminPermission!]`](#memberroleadminpermission) | List of all customizable admin permissions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadminupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleadminupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmemberroleadminupdatememberrole"></a>`memberRole` | [`AdminMemberRole`](#adminmemberrole) | Member role. |

### `Mutation.memberRoleCreate`

{{< details >}}
**Introduced** in GitLab 16.5.
**Status**: Experiment.
{{< /details >}}

Input type: `MemberRoleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreatebaseaccesslevel"></a>`baseAccessLevel` | [`MemberRolesAccessLevel!`](#memberrolesaccesslevel) | Base access level for the custom role. |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberrolecreatedescription"></a>`description` | [`String`](#string) | Description of the member role. |
| <a id="mutationmemberrolecreategrouppath"></a>`groupPath` | [`ID`](#id) | Group the member role to mutate is in. Required for SaaS. |
| <a id="mutationmemberrolecreatename"></a>`name` | [`String`](#string) | Name of the member role. |
| <a id="mutationmemberrolecreatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | List of all customizable permissions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberrolecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmemberrolecreatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | Member role. |

### `Mutation.memberRoleDelete`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Input type: `MemberRoleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroledeleteid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ID of the member role to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmemberroledeletememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | Deleted member role. |

### `Mutation.memberRoleToUserAssign`

{{< details >}}
**Introduced** in GitLab 17.7.
**Status**: Experiment.
{{< /details >}}

Input type: `MemberRoleToUserAssignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroletouserassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroletouserassignmemberroleid"></a>`memberRoleId` | [`MemberRoleID`](#memberroleid) | Global ID of the custom role to be assigned to a user. Admin roles will be unassigned from the user if omitted or set as NULL. |
| <a id="mutationmemberroletouserassignuserid"></a>`userId` | [`UserID!`](#userid) | Global ID of the user to be assigned to a custom role. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroletouserassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroletouserassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmemberroletouserassignusermemberrole"></a>`userMemberRole` | [`UserMemberRole`](#usermemberrole) | Created user member role or nil if the relation was deleted. |

### `Mutation.memberRoleUpdate`

Input type: `MemberRoleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleupdatedescription"></a>`description` | [`String`](#string) | Description of the member role. |
| <a id="mutationmemberroleupdateid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ID of the member role to mutate. |
| <a id="mutationmemberroleupdatename"></a>`name` | [`String`](#string) | Name of the member role. |
| <a id="mutationmemberroleupdatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | List of all customizable permissions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmemberroleupdatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | Member role. |

### `Mutation.mergeRequestAccept`

Accepts a merge request.
When accepted, the source branch will be scheduled to merge into the target branch, either
immediately if possible, or using one of the automatic merge strategies.

[In GitLab 16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/421510), the merging happens asynchronously.
This results in `mergeRequest` and `state` not updating after a mutation request,
because the merging may not have happened yet.

Input type: `MergeRequestAcceptInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestacceptcommitmessage"></a>`commitMessage` | [`String`](#string) | Custom merge commit message. |
| <a id="mutationmergerequestacceptiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestacceptprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestacceptsha"></a>`sha` | [`String!`](#string) | HEAD SHA at the time when the merge was requested. |
| <a id="mutationmergerequestacceptshouldremovesourcebranch"></a>`shouldRemoveSourceBranch` | [`Boolean`](#boolean) | Should the source branch be removed. |
| <a id="mutationmergerequestacceptsquash"></a>`squash` | [`Boolean`](#boolean) | Squash commits on the source branch before merge. |
| <a id="mutationmergerequestacceptsquashcommitmessage"></a>`squashCommitMessage` | [`String`](#string) | Custom squash commit message (if squash is true). |
| <a id="mutationmergerequestacceptstrategy"></a>`strategy` | [`MergeStrategyEnum`](#mergestrategyenum) | How to merge the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestaccepterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestacceptmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestBypassSecurityPolicy`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Bypasses security policies for a merge request.

Input type: `MergeRequestBypassSecurityPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestbypasssecuritypolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestbypasssecuritypolicyiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestbypasssecuritypolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestbypasssecuritypolicyreason"></a>`reason` | [`String!`](#string) | Reason for bypassing the security policy. |
| <a id="mutationmergerequestbypasssecuritypolicysecuritypolicyids"></a>`securityPolicyIds` | [`[ID!]!`](#id) | ID of the security policy to bypass. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestbypasssecuritypolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestbypasssecuritypolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestbypasssecuritypolicymergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestCreate`

Input type: `MergeRequestCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestcreatedescription"></a>`description` | [`String`](#string) | Description of the merge request (Markdown rendered as HTML for caching). |
| <a id="mutationmergerequestcreatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the merge request. |
| <a id="mutationmergerequestcreatemergeafter"></a>`mergeAfter` | [`Time`](#time) | Date after which the merge request can be merged. |
| <a id="mutationmergerequestcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the merge request is associated with. |
| <a id="mutationmergerequestcreateremovesourcebranch"></a>`removeSourceBranch` | [`Boolean`](#boolean) | Indicates if the source branch of the merge request will be deleted after merge. |
| <a id="mutationmergerequestcreatesourcebranch"></a>`sourceBranch` | [`String!`](#string) | Source branch of the merge request. |
| <a id="mutationmergerequestcreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | Target branch of the merge request. |
| <a id="mutationmergerequestcreatetitle"></a>`title` | [`String!`](#string) | Title of the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestcreatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestDestroyRequestedChanges`

Input type: `MergeRequestDestroyRequestedChangesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestdestroyrequestedchangesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestdestroyrequestedchangesiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestdestroyrequestedchangesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestdestroyrequestedchangesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestdestroyrequestedchangeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestdestroyrequestedchangesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestReviewerRereview`

Input type: `MergeRequestReviewerRereviewInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestreviewerrereviewiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestreviewerrereviewprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestreviewerrereviewuserid"></a>`userId` | [`UserID!`](#userid) | User ID for the user that has been requested for a new review. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestreviewerrereviewerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestreviewerrereviewmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetAssignees`

Input type: `MergeRequestSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the resource. Replaces existing assignees by default. |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationmergerequestsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestsetassigneesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetDraft`

Input type: `MergeRequestSetDraftInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetdraftdraft"></a>`draft` | [`Boolean!`](#boolean) | Whether or not to set the merge request as a draft. |
| <a id="mutationmergerequestsetdraftiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetdraftprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetdrafterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestsetdraftmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetLabels`

Input type: `MergeRequestSetLabelsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlabelsiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetlabelslabelids"></a>`labelIds` | [`[LabelID!]!`](#labelid) | Label IDs to set. Replaces existing labels by default. |
| <a id="mutationmergerequestsetlabelsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Changes the operation mode. Defaults to REPLACE. |
| <a id="mutationmergerequestsetlabelsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlabelserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestsetlabelsmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetLocked`

Input type: `MergeRequestSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlockediid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | Whether or not to lock the merge request. |
| <a id="mutationmergerequestsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestsetlockedmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetMilestone`

Input type: `MergeRequestSetMilestoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetmilestoneiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetmilestonemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Milestone to assign to the merge request. |
| <a id="mutationmergerequestsetmilestoneprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetmilestoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestsetmilestonemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetReviewers`

Input type: `MergeRequestSetReviewersInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetreviewersiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetreviewersoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationmergerequestsetreviewersprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestsetreviewersreviewerusernames"></a>`reviewerUsernames` | [`[String!]!`](#string) | Usernames of reviewers to assign. Replaces existing reviewers by default. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetreviewerserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestsetreviewersmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetSubscription`

Input type: `MergeRequestSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetsubscriptioniid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestsetsubscriptionmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestUpdate`

Update attributes of a merge request.

Input type: `MergeRequestUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdatedescription"></a>`description` | [`String`](#string) | Description of the merge request (Markdown rendered as HTML for caching). |
| <a id="mutationmergerequestupdateiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestupdatemergeafter"></a>`mergeAfter` | [`Time`](#time) | Date after which the merge request can be merged. |
| <a id="mutationmergerequestupdateoverriderequestedchanges"></a>`overrideRequestedChanges` | [`Boolean`](#boolean) | Override all requested changes. Can only be set by users who have permissionto merge this merge request. |
| <a id="mutationmergerequestupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestupdateremovesourcebranch"></a>`removeSourceBranch` | [`Boolean`](#boolean) | Indicates if the source branch of the merge request will be deleted after merge. |
| <a id="mutationmergerequestupdatestate"></a>`state` | [`MergeRequestNewState`](#mergerequestnewstate) | Action to perform to change the state. |
| <a id="mutationmergerequestupdatetargetbranch"></a>`targetBranch` | [`String`](#string) | Target branch of the merge request. |
| <a id="mutationmergerequestupdatetimeestimate"></a>`timeEstimate` | [`String`](#string) | Estimated time to complete the merge request. Use `null` or `0` to remove the current estimate. |
| <a id="mutationmergerequestupdatetitle"></a>`title` | [`String`](#string) | Title of the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestupdatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestUpdateApprovalRule`

Input type: `MergeRequestUpdateApprovalRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleapprovalruleid"></a>`approvalRuleId` | [`Int!`](#int) | ID of an approval rule. |
| <a id="mutationmergerequestupdateapprovalruleapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | Number of required approvals for a given rule. |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateapprovalrulegroupids"></a>`groupIds` | [`[String!]`](#string) | IDs of groups as approvers. |
| <a id="mutationmergerequestupdateapprovalruleiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestupdateapprovalrulename"></a>`name` | [`String!`](#string) | Name of the approval rule. |
| <a id="mutationmergerequestupdateapprovalruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestupdateapprovalruleremovehiddengroups"></a>`removeHiddenGroups` | [`Boolean`](#boolean) | Whether hidden groups should be removed. |
| <a id="mutationmergerequestupdateapprovalruleuserids"></a>`userIds` | [`[String!]`](#string) | IDs of users as approvers. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateapprovalruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmergerequestupdateapprovalrulemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeTrainsDeleteCar`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `MergeTrainsDeleteCarInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergetrainsdeletecarcarid"></a>`carId` | [`MergeTrainsCarID!`](#mergetrainscarid) | Global ID of the car. |
| <a id="mutationmergetrainsdeletecarclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergetrainsdeletecarclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergetrainsdeletecarerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.mlModelCreate`

{{< details >}}
**Introduced** in GitLab 16.8.
**Status**: Experiment.
{{< /details >}}

Input type: `MlModelCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelcreatedescription"></a>`description` | [`String`](#string) | Description of the model. |
| <a id="mutationmlmodelcreatename"></a>`name` | [`String!`](#string) | Name of the model. |
| <a id="mutationmlmodelcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmlmodelcreatemodel"></a>`model` | [`MlModel`](#mlmodel) | Model after mutation. |

### `Mutation.mlModelDelete`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `MlModelDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodeldeleteid"></a>`id` | [`MlModelID!`](#mlmodelid) | Global ID of the model to be deleted. |
| <a id="mutationmlmodeldeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodeldeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmlmodeldeletemodel"></a>`model` | [`MlModel`](#mlmodel) | Model after mutation. |

### `Mutation.mlModelDestroy`

{{< details >}}
**Introduced** in GitLab 16.10.
**Status**: Experiment.
{{< /details >}}

Input type: `MlModelDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodeldestroyid"></a>`id` | [`MlModelID!`](#mlmodelid) | Global ID of the model to be deleted. |
| <a id="mutationmlmodeldestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodeldestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmlmodeldestroymessage"></a>`message` | [`String`](#string) | Model deletion result message. |
| <a id="mutationmlmodeldestroymodel"></a>`model` | [`MlModel`](#mlmodel) | Model after mutation. |

### `Mutation.mlModelEdit`

{{< details >}}
**Introduced** in GitLab 17.3.
**Status**: Experiment.
{{< /details >}}

Input type: `MlModelEditInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeleditclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodeleditdescription"></a>`description` | [`String`](#string) | Description of the model. |
| <a id="mutationmlmodeleditmodelid"></a>`modelId` | [`Int`](#int) | Id of the model. |
| <a id="mutationmlmodeleditname"></a>`name` | [`String!`](#string) | Name of the model. |
| <a id="mutationmlmodeleditprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeleditclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelediterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmlmodeleditmodel"></a>`model` | [`MlModel`](#mlmodel) | Model after mutation. |

### `Mutation.mlModelVersionCreate`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Input type: `MlModelVersionCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioncreatecandidateid"></a>`candidateId` | [`MlCandidateID`](#mlcandidateid) | Global ID of a candidate to promote optionally. |
| <a id="mutationmlmodelversioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversioncreatedescription"></a>`description` | [`String`](#string) | Description of the model version. |
| <a id="mutationmlmodelversioncreatemodelid"></a>`modelId` | [`MlModelID!`](#mlmodelid) | Global ID of the model the version belongs to. |
| <a id="mutationmlmodelversioncreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |
| <a id="mutationmlmodelversioncreateversion"></a>`version` | [`String`](#string) | Model version. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversioncreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmlmodelversioncreatemodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | Model after mutation. |

### `Mutation.mlModelVersionDelete`

{{< details >}}
**Introduced** in GitLab 17.0.
**Status**: Experiment.
{{< /details >}}

Input type: `MlModelVersionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversiondeleteid"></a>`id` | [`MlModelVersionID!`](#mlmodelversionid) | Global ID of the model version to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmlmodelversiondeletemodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | Deleted model version. |

### `Mutation.mlModelVersionEdit`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

Input type: `MlModelVersionEditInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioneditclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversioneditdescription"></a>`description` | [`String!`](#string) | Description of the model version. |
| <a id="mutationmlmodelversioneditmodelid"></a>`modelId` | [`MlModelID!`](#mlmodelid) | Global ID of the model the version belongs to. |
| <a id="mutationmlmodelversioneditprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |
| <a id="mutationmlmodelversioneditversion"></a>`version` | [`String!`](#string) | Model version. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioneditclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversionediterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationmlmodelversioneditmodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | Model after mutation. |

### `Mutation.namespaceBanDestroy`

Input type: `NamespaceBanDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacebandestroyid"></a>`id` | [`NamespacesNamespaceBanID!`](#namespacesnamespacebanid) | Global ID of the namespace ban to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacebandestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationnamespacebandestroynamespaceban"></a>`namespaceBan` | [`NamespaceBan`](#namespaceban) | Namespace Ban. |

### `Mutation.namespaceCiCdSettingsUpdate`

Input type: `NamespaceCiCdSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdateallowstalerunnerpruning"></a>`allowStaleRunnerPruning` | [`Boolean`](#boolean) | Indicates if stale runners directly belonging to the namespace should be periodically pruned. |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace the settings belong to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`NamespaceCiCdSetting!`](#namespacecicdsetting) | CI/CD settings after mutation. |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.namespaceCreateRemoteDevelopmentClusterAgentMapping`

Input type: `NamespaceCreateRemoteDevelopmentClusterAgentMappingInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent to be associated with the namespace. |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | GlobalID of the namespace to be associated with the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingnamespaceclusteragentmapping"></a>`namespaceClusterAgentMapping` {{< icon name="warning-solid" >}} | [`NamespaceClusterAgentMapping`](#namespaceclusteragentmapping) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.10. |

### `Mutation.namespaceDeleteRemoteDevelopmentClusterAgentMapping`

Input type: `NamespaceDeleteRemoteDevelopmentClusterAgentMappingInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent to be un-associated from the namespace. |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | GlobalID of the namespace to be un-associated from the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingnamespaceclusteragentmapping"></a>`namespaceClusterAgentMapping` {{< icon name="warning-solid" >}} | [`NamespaceClusterAgentMapping`](#namespaceclusteragentmapping) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.11. |

### `Mutation.namespaceSettingsUpdate`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `NamespaceSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacesettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace the settings belong to. |
| <a id="mutationnamespacesettingsupdatepipelinevariablesdefaultrole"></a>`pipelineVariablesDefaultRole` | [`PipelineVariablesDefaultRoleType`](#pipelinevariablesdefaultroletype) | Indicates the default minimum role required to override pipeline variables in the namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesettingsupdatecicdsettings"></a>`ciCdSettings` | [`CiCdSettings!`](#cicdsettings) | Namespace CI/CD settings after mutation. |
| <a id="mutationnamespacesettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacesettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.namespacesRegenerateNewWorkItemEmailAddress`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Input type: `NamespacesRegenerateNewWorkItemEmailAddressInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesregeneratenewworkitememailaddressclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacesregeneratenewworkitememailaddressfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace to regenerate the new work item email address for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesregeneratenewworkitememailaddressclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacesregeneratenewworkitememailaddresserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationnamespacesregeneratenewworkitememailaddressnamespace"></a>`namespace` | [`Namespace`](#namespace) | Namespace after regenerating the new work item email address. |

### `Mutation.noteConvertToThread`

Convert a standard comment to a resolvable thread.

Input type: `NoteConvertToThreadInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnoteconverttothreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnoteconverttothreadid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the Note to convert. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnoteconverttothreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnoteconverttothreaderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationnoteconverttothreadnote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationnoteconverttothreadquickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.oncallRotationCreate`

Input type: `OncallRotationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | Active period of time that the on-call rotation should take place. |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationcreateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | End date and time of the on-call rotation, in the timezone of the on-call schedule. |
| <a id="mutationoncallrotationcreatename"></a>`name` | [`String!`](#string) | Name of the on-call rotation. |
| <a id="mutationoncallrotationcreateparticipants"></a>`participants` | [`[OncallUserInputType!]!`](#oncalluserinputtype) | Usernames of users participating in the on-call rotation. A maximum limit of 100 participants applies. |
| <a id="mutationoncallrotationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the on-call schedule in. |
| <a id="mutationoncallrotationcreaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType!`](#oncallrotationlengthinputtype) | Rotation length of the on-call rotation. |
| <a id="mutationoncallrotationcreatescheduleiid"></a>`scheduleIid` | [`String!`](#string) | IID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationoncallrotationcreatestartsat"></a>`startsAt` | [`OncallRotationDateInputType!`](#oncallrotationdateinputtype) | Start date and time of the on-call rotation, in the timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationoncallrotationcreateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallRotationDestroy`

Input type: `OncallRotationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationdestroyid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call rotation to remove. |
| <a id="mutationoncallrotationdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to remove the on-call schedule from. |
| <a id="mutationoncallrotationdestroyscheduleiid"></a>`scheduleIid` | [`String!`](#string) | IID of the on-call schedule to the on-call rotation belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationoncallrotationdestroyoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallRotationUpdate`

Input type: `OncallRotationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | Active period of time that the on-call rotation should take place. |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationupdateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | End date and time of the on-call rotation, in the timezone of the on-call schedule. |
| <a id="mutationoncallrotationupdateid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationoncallrotationupdatename"></a>`name` | [`String`](#string) | Name of the on-call rotation. |
| <a id="mutationoncallrotationupdateparticipants"></a>`participants` | [`[OncallUserInputType!]`](#oncalluserinputtype) | Usernames of users participating in the on-call rotation. A maximum limit of 100 participants applies. |
| <a id="mutationoncallrotationupdaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType`](#oncallrotationlengthinputtype) | Rotation length of the on-call rotation. |
| <a id="mutationoncallrotationupdatestartsat"></a>`startsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | Start date and time of the on-call rotation, in the timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationoncallrotationupdateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallScheduleCreate`

Input type: `OncallScheduleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallschedulecreatedescription"></a>`description` | [`String`](#string) | Description of the on-call schedule. |
| <a id="mutationoncallschedulecreatename"></a>`name` | [`String!`](#string) | Name of the on-call schedule. |
| <a id="mutationoncallschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the on-call schedule in. |
| <a id="mutationoncallschedulecreatetimezone"></a>`timezone` | [`String!`](#string) | Timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationoncallschedulecreateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.oncallScheduleDestroy`

Input type: `OncallScheduleDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduledestroyiid"></a>`iid` | [`String!`](#string) | On-call schedule internal ID to remove. |
| <a id="mutationoncallscheduledestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to remove the on-call schedule from. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduledestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationoncallscheduledestroyoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.oncallScheduleUpdate`

Input type: `OncallScheduleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduleupdatedescription"></a>`description` | [`String`](#string) | Description of the on-call schedule. |
| <a id="mutationoncallscheduleupdateiid"></a>`iid` | [`String!`](#string) | On-call schedule internal ID to update. |
| <a id="mutationoncallscheduleupdatename"></a>`name` | [`String`](#string) | Name of the on-call schedule. |
| <a id="mutationoncallscheduleupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to update the on-call schedule in. |
| <a id="mutationoncallscheduleupdatetimezone"></a>`timezone` | [`String`](#string) | Timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationoncallscheduleupdateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.organizationCreate`

{{< details >}}
**Introduced** in GitLab 16.6.
**Status**: Experiment.
{{< /details >}}

Input type: `OrganizationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the organization. |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationcreatedescription"></a>`description` | [`String`](#string) | Description of the organization. |
| <a id="mutationorganizationcreatename"></a>`name` | [`String!`](#string) | Name for the organization. |
| <a id="mutationorganizationcreatepath"></a>`path` | [`String!`](#string) | Path for the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationorganizationcreateorganization"></a>`organization` | [`Organization`](#organization) | Organization after mutation. |

### `Mutation.organizationCreateClusterAgentMapping`

{{< details >}}
**Introduced** in GitLab 17.11.
**Status**: Experiment.
{{< /details >}}

Input type: `OrganizationCreateClusterAgentMappingInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationcreateclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent to be associated with the organization. |
| <a id="mutationorganizationcreateclusteragentmappingorganizationid"></a>`organizationId` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | GlobalID of the organization to be associated with the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationcreateclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.organizationDeleteClusterAgentMapping`

{{< details >}}
**Introduced** in GitLab 17.11.
**Status**: Experiment.
{{< /details >}}

Input type: `OrganizationDeleteClusterAgentMappingInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationdeleteclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationdeleteclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent to be dissociated with the organization. |
| <a id="mutationorganizationdeleteclusteragentmappingorganizationid"></a>`organizationId` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | GlobalID of the organization to be dissociated with the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationdeleteclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationdeleteclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.organizationUpdate`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Input type: `OrganizationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the organization. |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationupdatedescription"></a>`description` | [`String`](#string) | Description of the organization. |
| <a id="mutationorganizationupdateid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | ID of the organization to mutate. |
| <a id="mutationorganizationupdatename"></a>`name` | [`String`](#string) | Name for the organization. |
| <a id="mutationorganizationupdatepath"></a>`path` | [`String`](#string) | Path for the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationorganizationupdateorganization"></a>`organization` | [`Organization`](#organization) | Organization after mutation. |

### `Mutation.organizationUserUpdate`

{{< details >}}
**Introduced** in GitLab 17.5.
**Status**: Experiment.
{{< /details >}}

Input type: `OrganizationUserUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationuserupdateaccesslevel"></a>`accessLevel` | [`OrganizationUserAccessLevel!`](#organizationuseraccesslevel) | Access level to update the organization user to. |
| <a id="mutationorganizationuserupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationuserupdateid"></a>`id` | [`OrganizationsOrganizationUserID!`](#organizationsorganizationuserid) | ID of the organization user to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationuserupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationuserupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationorganizationuserupdateorganizationuser"></a>`organizationUser` {{< icon name="warning-solid" >}} | [`OrganizationUser`](#organizationuser) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.5. |

### `Mutation.pagesMarkOnboardingComplete`

Input type: `PagesMarkOnboardingCompleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpagesmarkonboardingcompleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpagesmarkonboardingcompleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpagesmarkonboardingcompleteonboardingcomplete"></a>`onboardingComplete` | [`Boolean!`](#boolean) | Indicates the new onboarding_complete state of the project's Pages metadata. |

### `Mutation.pipelineCancel`

Input type: `PipelineCancelInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecancelid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecancelerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelinecancelpipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | Pipeline after mutation. |

### `Mutation.pipelineCreate`

Input type: `PipelineCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecreateasync"></a>`async` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |
| <a id="mutationpipelinecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecreateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInput!]`](#ciinputsinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.10. |
| <a id="mutationpipelinecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project that is triggering the pipeline. |
| <a id="mutationpipelinecreateref"></a>`ref` | [`String!`](#string) | Ref on which to run the pipeline. |
| <a id="mutationpipelinecreatevariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | Variables for the pipeline. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelinecreatepipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | Pipeline created after mutation. Null if `async: true`. |
| <a id="mutationpipelinecreaterequestid"></a>`requestId` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |

### `Mutation.pipelineDestroy`

Input type: `PipelineDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinedestroyid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinedestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.pipelineRetry`

Input type: `PipelineRetryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineretryid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineretryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelineretrypipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | Pipeline after mutation. |

### `Mutation.pipelineScheduleCreate`

Input type: `PipelineScheduleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the pipeline schedule should be active or not. |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineschedulecreatecron"></a>`cron` | [`String!`](#string) | Cron expression of the pipeline schedule. |
| <a id="mutationpipelineschedulecreatecrontimezone"></a>`cronTimezone` | [`String`](#string) | Cron time zone supported by `ActiveSupport::TimeZone`. For example: `Pacific Time (US & Canada)` (default: `UTC`). |
| <a id="mutationpipelineschedulecreatedescription"></a>`description` | [`String!`](#string) | Description of the pipeline schedule. |
| <a id="mutationpipelineschedulecreateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInput!]`](#ciinputsinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.10. |
| <a id="mutationpipelineschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the pipeline schedule is associated with. |
| <a id="mutationpipelineschedulecreateref"></a>`ref` | [`String!`](#string) | Ref of the pipeline schedule. |
| <a id="mutationpipelineschedulecreatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | Variables for the pipeline schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelineschedulecreatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Created pipeline schedule. |

### `Mutation.pipelineScheduleDelete`

Input type: `PipelineScheduleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduledeleteid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.pipelineSchedulePlay`

Input type: `PipelineSchedulePlayInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleplayid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleplayerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelinescheduleplaypipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Pipeline schedule after mutation. |

### `Mutation.pipelineScheduleTakeOwnership`

Input type: `PipelineScheduleTakeOwnershipInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduletakeownershipid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduletakeownershiperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelinescheduletakeownershippipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Updated pipeline schedule ownership. |

### `Mutation.pipelineScheduleUpdate`

Input type: `PipelineScheduleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the pipeline schedule should be active or not. |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleupdatecron"></a>`cron` | [`String`](#string) | Cron expression of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdatecrontimezone"></a>`cronTimezone` | [`String`](#string) | Cron time zone supported by `ActiveSupport::TimeZone`. For example: `Pacific Time (US & Canada)` (default: `UTC`). |
| <a id="mutationpipelinescheduleupdatedescription"></a>`description` | [`String`](#string) | Description of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdateid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |
| <a id="mutationpipelinescheduleupdateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInput!]`](#ciinputsinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.11. |
| <a id="mutationpipelinescheduleupdateref"></a>`ref` | [`String`](#string) | Ref of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | Variables for the pipeline schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelinescheduleupdatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Updated pipeline schedule. |

### `Mutation.pipelineTriggerCreate`

{{< details >}}
**Introduced** in GitLab 16.3.
**Status**: Experiment.
{{< /details >}}

Input type: `PipelineTriggerCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggercreatedescription"></a>`description` | [`String!`](#string) | Description of the pipeline trigger token. |
| <a id="mutationpipelinetriggercreateexpiresat"></a>`expiresAt` | [`Time`](#time) | Timestamp of when the pipeline trigger token expires. |
| <a id="mutationpipelinetriggercreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project that the pipeline trigger token to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelinetriggercreatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | Mutated pipeline trigger token. |

### `Mutation.pipelineTriggerDelete`

{{< details >}}
**Introduced** in GitLab 16.3.
**Status**: Experiment.
{{< /details >}}

Input type: `PipelineTriggerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerdeleteid"></a>`id` | [`CiTriggerID!`](#citriggerid) | ID of the pipeline trigger token to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.pipelineTriggerUpdate`

{{< details >}}
**Introduced** in GitLab 16.3.
**Status**: Experiment.
{{< /details >}}

Input type: `PipelineTriggerUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerupdatedescription"></a>`description` | [`String!`](#string) | Description of the pipeline trigger token. |
| <a id="mutationpipelinetriggerupdateid"></a>`id` | [`CiTriggerID!`](#citriggerid) | ID of the pipeline trigger token to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpipelinetriggerupdatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | Mutated pipeline trigger token. |

### `Mutation.processUserBillablePromotionRequest`

{{< details >}}
**Introduced** in GitLab 17.2.
**Status**: Experiment.
{{< /details >}}

Input type: `ProcessUserBillablePromotionRequestInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprocessuserbillablepromotionrequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprocessuserbillablepromotionrequeststatus"></a>`status` | [`MemberApprovalStatusType!`](#memberapprovalstatustype) | Status for the member approval request (approved, denied, pending). |
| <a id="mutationprocessuserbillablepromotionrequestuserid"></a>`userId` | [`UserID!`](#userid) | Global ID of user to be promoted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprocessuserbillablepromotionrequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprocessuserbillablepromotionrequesterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprocessuserbillablepromotionrequestresult"></a>`result` | [`UserPromotionStatusType`](#userpromotionstatustype) | Status of the user promotion process (success, partial_success, failed). |

### `Mutation.productAnalyticsProjectSettingsUpdate`

Input type: `ProductAnalyticsProjectSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationproductanalyticsprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapibaseurl"></a>`cubeApiBaseUrl` | [`String`](#string) | Base URL for the Cube API. |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapikey"></a>`cubeApiKey` | [`String`](#string) | API key for the Cube API. |
| <a id="mutationproductanalyticsprojectsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the project the settings belong to. |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsconfiguratorconnectionstring"></a>`productAnalyticsConfiguratorConnectionString` | [`String`](#string) | Connection string for the product analytics configurator. |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsdatacollectorhost"></a>`productAnalyticsDataCollectorHost` | [`String`](#string) | Host for the product analytics data collector. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationproductanalyticsprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapibaseurl"></a>`cubeApiBaseUrl` | [`String`](#string) | Base URL for the Cube API. |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapikey"></a>`cubeApiKey` | [`String`](#string) | API key for the Cube API. |
| <a id="mutationproductanalyticsprojectsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsconfiguratorconnectionstring"></a>`productAnalyticsConfiguratorConnectionString` | [`String`](#string) | Connection string for the product analytics configurator. |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsdatacollectorhost"></a>`productAnalyticsDataCollectorHost` | [`String`](#string) | Host for the product analytics data collector. |

### `Mutation.projectBlobsRemove`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Input type: `projectBlobsRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectblobsremovebloboids"></a>`blobOids` | [`[String!]!`](#string) | List of blob oids. |
| <a id="mutationprojectblobsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectblobsremoveprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to replace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectblobsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectblobsremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.projectCiCdSettingsUpdate`

Input type: `ProjectCiCdSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectcicdsettingsupdatedisplaypipelinevariables"></a>`displayPipelineVariables` | [`Boolean`](#boolean) | Indicates whether pipeline variables can be displayed in the UI. |
| <a id="mutationprojectcicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full Path of the project the settings belong to. |
| <a id="mutationprojectcicdsettingsupdategrouprunnersenabled"></a>`groupRunnersEnabled` | [`Boolean`](#boolean) | Indicates whether group runners are enabled for the project. |
| <a id="mutationprojectcicdsettingsupdateinboundjobtokenscopeenabled"></a>`inboundJobTokenScopeEnabled` | [`Boolean`](#boolean) | Indicates whether CI/CD job tokens generated in other projects have restricted access to this project. |
| <a id="mutationprojectcicdsettingsupdatejobtokenscopeenabled"></a>`jobTokenScopeEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: Outbound job token scope is being removed. This field can now only be set to false. Deprecated in GitLab 16.0. |
| <a id="mutationprojectcicdsettingsupdatekeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | Indicates whether the latest artifact should be kept for the project. |
| <a id="mutationprojectcicdsettingsupdatemergepipelinesenabled"></a>`mergePipelinesEnabled` | [`Boolean`](#boolean) | Indicates if merged results pipelines are enabled for the project. |
| <a id="mutationprojectcicdsettingsupdatemergetrainsenabled"></a>`mergeTrainsEnabled` | [`Boolean`](#boolean) | Indicates if merge trains are enabled for the project. |
| <a id="mutationprojectcicdsettingsupdatemergetrainsskiptrainallowed"></a>`mergeTrainsSkipTrainAllowed` | [`Boolean`](#boolean) | Indicates whether an option is allowed to merge without refreshing the merge train. Ignored unless the `merge_trains_skip_train` feature flag is also enabled. |
| <a id="mutationprojectcicdsettingsupdatepipelinevariablesminimumoverriderole"></a>`pipelineVariablesMinimumOverrideRole` | [`String`](#string) | Minimum role required to set variables when creating a pipeline or running a job. |
| <a id="mutationprojectcicdsettingsupdatepushrepositoryforjobtokenallowed"></a>`pushRepositoryForJobTokenAllowed` | [`Boolean`](#boolean) | Indicates the ability to push to the original project repository using a job token. |
| <a id="mutationprojectcicdsettingsupdateresourcegroupdefaultprocessmode"></a>`resourceGroupDefaultProcessMode` | [`ResourceGroupsProcessMode`](#resourcegroupsprocessmode) | Default process mode for resource groups in the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`ProjectCiCdSetting!`](#projectcicdsetting) | CI/CD settings after mutation. |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectcicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.projectInitializeProductAnalytics`

Input type: `ProjectInitializeProductAnalyticsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectinitializeproductanalyticsprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to initialize. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectinitializeproductanalyticserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectinitializeproductanalyticsproject"></a>`project` | [`Project`](#project) | Project on which the initialization took place. |

### `Mutation.projectMemberBulkUpdate`

Updates multiple members of a project. To use this mutation, you must have at least the Maintainer role.

Input type: `ProjectMemberBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | Access level to update the members to. |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | Date and time the membership expires. |
| <a id="mutationprojectmemberbulkupdateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global ID of the project. |
| <a id="mutationprojectmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of the members. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectmemberbulkupdateprojectmembers"></a>`projectMembers` | [`[ProjectMember!]`](#projectmember) | Project members after mutation. |

### `Mutation.projectSavedReplyCreate`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `ProjectSavedReplyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplycreatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationprojectsavedreplycreatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |
| <a id="mutationprojectsavedreplycreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Project for the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsavedreplycreatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | Saved reply after mutation. |

### `Mutation.projectSavedReplyDestroy`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `ProjectSavedReplyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplydestroyid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | Global ID of the project-level saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsavedreplydestroysavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | Saved reply after mutation. |

### `Mutation.projectSavedReplyUpdate`

{{< details >}}
**Introduced** in GitLab 16.11.
**Status**: Experiment.
{{< /details >}}

Input type: `ProjectSavedReplyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationprojectsavedreplyupdateid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | Global ID of the project-level saved reply. |
| <a id="mutationprojectsavedreplyupdatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsavedreplyupdatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | Saved reply after mutation. |

### `Mutation.projectSecretCreate`

Input type: `ProjectSecretCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretcreatebranch"></a>`branch` | [`String!`](#string) | Branches that can access the secret. |
| <a id="mutationprojectsecretcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretcreatedescription"></a>`description` | [`String`](#string) | Description of the project secret. |
| <a id="mutationprojectsecretcreateenvironment"></a>`environment` | [`String!`](#string) | Environments that can access the secret. |
| <a id="mutationprojectsecretcreatename"></a>`name` | [`String!`](#string) | Name of the project secret. |
| <a id="mutationprojectsecretcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the secret. |
| <a id="mutationprojectsecretcreaterotationintervaldays"></a>`rotationIntervalDays` | [`Int`](#int) | Number of days between rotation reminders for the secret. |
| <a id="mutationprojectsecretcreatesecret"></a>`secret` | [`String!`](#string) | Value of the project secret. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsecretcreateprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | Project secret. |

### `Mutation.projectSecretDelete`

Input type: `ProjectSecretDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretdeletename"></a>`name` | [`String!`](#string) | Name of the project secret. |
| <a id="mutationprojectsecretdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the secret. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsecretdeleteprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | Deleted project secret. |

### `Mutation.projectSecretUpdate`

Input type: `ProjectSecretUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretupdatebranch"></a>`branch` | [`String`](#string) | New branches that can access the secret. |
| <a id="mutationprojectsecretupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretupdatedescription"></a>`description` | [`String`](#string) | New description of the project secret. |
| <a id="mutationprojectsecretupdateenvironment"></a>`environment` | [`String`](#string) | New environments that can access the secret. |
| <a id="mutationprojectsecretupdatemetadatacas"></a>`metadataCas` | [`Int!`](#int) | This should match the current metadata version of the project secret being updated. |
| <a id="mutationprojectsecretupdatename"></a>`name` | [`String!`](#string) | Name of the project secret to update. |
| <a id="mutationprojectsecretupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the secret. |
| <a id="mutationprojectsecretupdaterotationintervaldays"></a>`rotationIntervalDays` | [`Int`](#int) | Number of days between rotation reminders for the secret. |
| <a id="mutationprojectsecretupdatesecret"></a>`secret` | [`String`](#string) | New value of the project secret. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsecretupdateprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | Updated project secret. |

### `Mutation.projectSecretsManagerDeprovision`

Input type: `ProjectSecretsManagerDeprovisionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerdeprovisionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretsmanagerdeprovisionprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the secrets manager. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerdeprovisionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretsmanagerdeprovisionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsecretsmanagerdeprovisionprojectsecretsmanager"></a>`projectSecretsManager` | [`ProjectSecretsManager`](#projectsecretsmanager) | Project secrets manager. |

### `Mutation.projectSecretsManagerInitialize`

Input type: `ProjectSecretsManagerInitializeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretsmanagerinitializeprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the secrets manager. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecretsmanagerinitializeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsecretsmanagerinitializeprojectsecretsmanager"></a>`projectSecretsManager` | [`ProjectSecretsManager`](#projectsecretsmanager) | Project secrets manager. |

### `Mutation.projectSecurityExclusionCreate`

Input type: `ProjectSecurityExclusionCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusioncreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the exclusion is active. |
| <a id="mutationprojectsecurityexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecurityexclusioncreatedescription"></a>`description` | [`String`](#string) | Optional description for the exclusion. |
| <a id="mutationprojectsecurityexclusioncreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the exclusion will be associated with. |
| <a id="mutationprojectsecurityexclusioncreatescanner"></a>`scanner` | [`ExclusionScannerEnum!`](#exclusionscannerenum) | Scanner to ignore values for based on the exclusion. |
| <a id="mutationprojectsecurityexclusioncreatetype"></a>`type` | [`ExclusionTypeEnum!`](#exclusiontypeenum) | Type of the exclusion. |
| <a id="mutationprojectsecurityexclusioncreatevalue"></a>`value` | [`String!`](#string) | Value of the exclusion. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecurityexclusioncreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsecurityexclusioncreatesecurityexclusion"></a>`securityExclusion` | [`ProjectSecurityExclusion`](#projectsecurityexclusion) | Project security exclusion created. |

### `Mutation.projectSecurityExclusionDelete`

Input type: `ProjectSecurityExclusionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecurityexclusiondeleteid"></a>`id` | [`SecurityProjectSecurityExclusionID!`](#securityprojectsecurityexclusionid) | Global ID of the exclusion to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecurityexclusiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.projectSecurityExclusionUpdate`

Input type: `ProjectSecurityExclusionUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusionupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the exclusion is active. |
| <a id="mutationprojectsecurityexclusionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecurityexclusionupdatedescription"></a>`description` | [`String`](#string) | Optional description for the exclusion. |
| <a id="mutationprojectsecurityexclusionupdateid"></a>`id` | [`SecurityProjectSecurityExclusionID!`](#securityprojectsecurityexclusionid) | Global ID of the exclusion to be updated. |
| <a id="mutationprojectsecurityexclusionupdatescanner"></a>`scanner` | [`ExclusionScannerEnum`](#exclusionscannerenum) | Scanner to ignore values for based on the exclusion. |
| <a id="mutationprojectsecurityexclusionupdatetype"></a>`type` | [`ExclusionTypeEnum`](#exclusiontypeenum) | Type of the exclusion. |
| <a id="mutationprojectsecurityexclusionupdatevalue"></a>`value` | [`String`](#string) | Value of the exclusion. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsecurityexclusionupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsecurityexclusionupdatesecurityexclusion"></a>`securityExclusion` | [`ProjectSecurityExclusion`](#projectsecurityexclusion) | Project security exclusion updated. |

### `Mutation.projectSetComplianceFramework`

{{< details >}}
**Deprecated** in GitLab 17.11.
Use mutation ProjectUpdateComplianceFrameworks instead of this.
{{< /details >}}

Assign (or unset) a compliance framework to a project. This mutation raises an error if the project has more than one compliance framework associated with it.

Input type: `ProjectSetComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcomplianceframeworkcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID`](#compliancemanagementframeworkid) | ID of the compliance framework to assign to the project. Set to `null` to unset. |
| <a id="mutationprojectsetcomplianceframeworkprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project to change the compliance framework of. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsetcomplianceframeworkproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSetContinuousVulnerabilityScanning`

{{< details >}}
**Deprecated** in GitLab 17.3.
CVS has been enabled permanently. See [this epic](https://gitlab.com/groups/gitlab-org/-/epics/11474) for more information.
{{< /details >}}

Enable or disable continuous vulnerability scanning for the given project.

Input type: `ProjectSetContinuousVulnerabilityScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for continuous vulnerability scanning feature. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningcontinuousvulnerabilityscanningenabled"></a>`continuousVulnerabilityScanningEnabled` | [`Boolean!`](#boolean) | Whether feature is enabled. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.projectSetLocked`

Input type: `ProjectSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetlockedfilepath"></a>`filePath` | [`String!`](#string) | Full path to the file. |
| <a id="mutationprojectsetlockedlock"></a>`lock` | [`Boolean!`](#boolean) | Whether or not to lock the file path. |
| <a id="mutationprojectsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsetlockedproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSettingsUpdate`

{{< details >}}
**Introduced** in GitLab 16.9.
**Status**: Experiment.
{{< /details >}}

Input type: `ProjectSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsettingsupdateduocontextexclusionsettings"></a>`duoContextExclusionSettings` | [`DuoContextExclusionSettingsInput`](#duocontextexclusionsettingsinput) | Settings for excluding files from Duo context. |
| <a id="mutationprojectsettingsupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean`](#boolean) | Indicates whether GitLab Duo features are enabled for the project. |
| <a id="mutationprojectsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full Path of the project the settings belong to. |
| <a id="mutationprojectsettingsupdatewebbasedcommitsigningenabled"></a>`webBasedCommitSigningEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsettingsupdateprojectsettings"></a>`projectSettings` | [`ProjectSetting!`](#projectsetting) | Project settings after mutation. |

### `Mutation.projectSubscriptionCreate`

Input type: `ProjectSubscriptionCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptioncreateprojectpath"></a>`projectPath` | [`String!`](#string) | Full path of the downstream project of the Project Subscription. |
| <a id="mutationprojectsubscriptioncreateupstreampath"></a>`upstreamPath` | [`String!`](#string) | Full path of the upstream project of the Project Subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptioncreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsubscriptioncreatesubscription"></a>`subscription` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | Project Subscription created by the mutation. |

### `Mutation.projectSubscriptionDelete`

Input type: `ProjectSubscriptionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptiondeletesubscriptionid"></a>`subscriptionId` | [`CiSubscriptionsProjectID!`](#cisubscriptionsprojectid) | ID of the subscription to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectsubscriptiondeleteproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSyncFork`

{{< details >}}
**Introduced** in GitLab 15.9.
**Status**: Experiment.
{{< /details >}}

Input type: `ProjectSyncForkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsyncforkprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to initialize. |
| <a id="mutationprojectsyncforktargetbranch"></a>`targetBranch` | [`String!`](#string) | Ref of the fork to fetch into. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsyncforkdetails"></a>`details` | [`ForkDetails`](#forkdetails) | Updated fork details. |
| <a id="mutationprojectsyncforkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.projectTargetBranchRuleCreate`

Input type: `ProjectTargetBranchRuleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojecttargetbranchrulecreatename"></a>`name` | [`String!`](#string) | Name for the target branch rule. |
| <a id="mutationprojecttargetbranchrulecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Project ID for the target branch rule. |
| <a id="mutationprojecttargetbranchrulecreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | Target branch for the target branch rule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojecttargetbranchrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojecttargetbranchrulecreatetargetbranchrule"></a>`targetBranchRule` | [`ProjectTargetBranchRule`](#projecttargetbranchrule) | Target branch rule after mutation. |

### `Mutation.projectTargetBranchRuleDestroy`

Input type: `ProjectTargetBranchRuleDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchruledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojecttargetbranchruledestroyid"></a>`id` | [`ProjectsTargetBranchRuleID!`](#projectstargetbranchruleid) | ID for the target branch rule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchruledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojecttargetbranchruledestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.projectTextReplace`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Input type: `projectTextReplaceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojecttextreplaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojecttextreplaceprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to replace. |
| <a id="mutationprojecttextreplacereplacements"></a>`replacements` | [`[String!]!`](#string) | List of text patterns to replace project-wide. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojecttextreplaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojecttextreplaceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.projectUpdateComplianceFrameworks`

Update compliance frameworks for a project.

Input type: `ProjectUpdateComplianceFrameworksInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectupdatecomplianceframeworksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectupdatecomplianceframeworkscomplianceframeworkids"></a>`complianceFrameworkIds` | [`[ComplianceManagementFrameworkID!]!`](#compliancemanagementframeworkid) | IDs of the compliance framework to update for the project. |
| <a id="mutationprojectupdatecomplianceframeworksprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project to change the compliance framework of. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectupdatecomplianceframeworksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectupdatecomplianceframeworkserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprojectupdatecomplianceframeworksproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.prometheusIntegrationCreate`

{{< details >}}
**Deprecated** in GitLab 18.2.
Use HttpIntegrationCreate.
{{< /details >}}

Input type: `PrometheusIntegrationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationprometheusintegrationcreateapiurl"></a>`apiUrl` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: Feature removed in 16.0. Deprecated in GitLab 18.2. |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationcreatename"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="mutationprometheusintegrationcreatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationprometheusintegrationcreatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |
| <a id="mutationprometheusintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the integration in. |
| <a id="mutationprometheusintegrationcreatetype"></a>`type` | [`AlertManagementIntegrationType`](#alertmanagementintegrationtype) | Type of integration to create. Cannot be changed after creation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprometheusintegrationcreateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Newly created integration. |

### `Mutation.prometheusIntegrationResetToken`

{{< details >}}
**Deprecated** in GitLab 18.2.
Use HttpIntegrationResetToken.
{{< /details >}}

Input type: `PrometheusIntegrationResetTokenInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationresettokenid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprometheusintegrationresettokenintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Updated integration. |

### `Mutation.prometheusIntegrationUpdate`

{{< details >}}
**Deprecated** in GitLab 18.2.
Use HttpIntegrationUpdate.
{{< /details >}}

Input type: `PrometheusIntegrationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationprometheusintegrationupdateapiurl"></a>`apiUrl` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: Feature removed in 16.0. Deprecated in GitLab 18.2. |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationupdateid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ID of the integration to mutate. |
| <a id="mutationprometheusintegrationupdatename"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="mutationprometheusintegrationupdatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationprometheusintegrationupdatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationprometheusintegrationupdateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Updated integration. |

### `Mutation.promoteToEpic`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by `WorkItem` type. For more information, see [migration guide](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/).
{{< /details >}}

Input type: `PromoteToEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpromotetoepicgrouppath"></a>`groupPath` | [`ID`](#id) | Group the promoted epic will belong to. |
| <a id="mutationpromotetoepiciid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationpromotetoepicprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpromotetoepicepic"></a>`epic` | [`Epic`](#epic) | Epic after issue promotion. |
| <a id="mutationpromotetoepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationpromotetoepicissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.refreshFindingTokenStatus`

Input type: `RefreshFindingTokenStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshfindingtokenstatusvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | Global ID of the Vulnerability whose token status should be refreshed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshfindingtokenstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrefreshfindingtokenstatusfindingtokenstatus"></a>`findingTokenStatus` | [`VulnerabilityFindingTokenStatus`](#vulnerabilityfindingtokenstatus) | Updated token status record for the given finding. |

### `Mutation.refreshSecurityFindingTokenStatus`

Input type: `RefreshSecurityFindingTokenStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshsecurityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshsecurityfindingtokenstatussecurityfindinguuid"></a>`securityFindingUuid` | [`String!`](#string) | UUID of the Security::Finding whose token status should be refreshed (MR context). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshsecurityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshsecurityfindingtokenstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrefreshsecurityfindingtokenstatusfindingtokenstatus"></a>`findingTokenStatus` | [`SecurityFindingTokenStatus`](#securityfindingtokenstatus) | Updated token status record for the given Security::Finding. |

### `Mutation.refreshStandardsAdherenceChecks`

Input type: `RefreshStandardsAdherenceChecksInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshstandardsadherencechecksgrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksadherencechecksstatus"></a>`adherenceChecksStatus` | [`StandardsAdherenceChecksStatus`](#standardsadherencechecksstatus) | Progress of standards adherence checks. |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshstandardsadherencecheckserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.refreshVulnerabilityFindingTokenStatus`

Input type: `RefreshVulnerabilityFindingTokenStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | Global ID of the Vulnerability whose token status should be refreshed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshvulnerabilityfindingtokenstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusfindingtokenstatus"></a>`findingTokenStatus` | [`VulnerabilityFindingTokenStatus`](#vulnerabilityfindingtokenstatus) | Updated token status record for the given Vulnerabilities::Finding. |

### `Mutation.releaseAssetLinkCreate`

Input type: `ReleaseAssetLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkcreatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | Relative path for a direct asset link. |
| <a id="mutationreleaseassetlinkcreatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | Type of the asset link. |
| <a id="mutationreleaseassetlinkcreatename"></a>`name` | [`String!`](#string) | Name of the asset link. |
| <a id="mutationreleaseassetlinkcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the asset link is associated with. |
| <a id="mutationreleaseassetlinkcreatetagname"></a>`tagName` | [`String!`](#string) | Name of the associated release's tag. |
| <a id="mutationreleaseassetlinkcreateurl"></a>`url` | [`String!`](#string) | URL of the asset link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationreleaseassetlinkcreatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Asset link after mutation. |

### `Mutation.releaseAssetLinkDelete`

Input type: `ReleaseAssetLinkDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkdeleteid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | ID of the release asset link to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationreleaseassetlinkdeletelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Deleted release asset link. |

### `Mutation.releaseAssetLinkUpdate`

Input type: `ReleaseAssetLinkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkupdatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | Relative path for a direct asset link. |
| <a id="mutationreleaseassetlinkupdateid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | ID of the release asset link to update. |
| <a id="mutationreleaseassetlinkupdatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | Type of the asset link. |
| <a id="mutationreleaseassetlinkupdatename"></a>`name` | [`String`](#string) | Name of the asset link. |
| <a id="mutationreleaseassetlinkupdateurl"></a>`url` | [`String`](#string) | URL of the asset link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationreleaseassetlinkupdatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Asset link after mutation. |

### `Mutation.releaseCreate`

Input type: `ReleaseCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateassets"></a>`assets` | [`ReleaseAssetsInput`](#releaseassetsinput) | Assets associated to the release. |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasecreatedescription"></a>`description` | [`String`](#string) | Description (also known as "release notes") of the release. |
| <a id="mutationreleasecreatemilestones"></a>`milestones` | [`[String!]`](#string) | Title of each milestone the release is associated with. GitLab Premium customers can specify group milestones. |
| <a id="mutationreleasecreatename"></a>`name` | [`String`](#string) | Name of the release. |
| <a id="mutationreleasecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleasecreateref"></a>`ref` | [`String`](#string) | Commit SHA or branch name to use if creating a new tag. |
| <a id="mutationreleasecreatereleasedat"></a>`releasedAt` | [`Time`](#time) | Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (`2019-03-15T08:00:00Z`). Only provide this field if creating an upcoming or historical release. |
| <a id="mutationreleasecreatetagmessage"></a>`tagMessage` | [`String`](#string) | Message to use if creating a new annotated tag. |
| <a id="mutationreleasecreatetagname"></a>`tagName` | [`String!`](#string) | Name of the tag to associate with the release. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationreleasecreaterelease"></a>`release` | [`Release`](#release) | Release after mutation. |

### `Mutation.releaseDelete`

Input type: `ReleaseDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasedeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleasedeletetagname"></a>`tagName` | [`String!`](#string) | Name of the tag associated with the release to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasedeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationreleasedeleterelease"></a>`release` | [`Release`](#release) | Deleted release. |

### `Mutation.releaseUpdate`

Input type: `ReleaseUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseupdatedescription"></a>`description` | [`String`](#string) | Description (release notes) of the release. |
| <a id="mutationreleaseupdatemilestones"></a>`milestones` | [`[String!]`](#string) | Title of each milestone the release is associated with. GitLab Premium customers can specify group milestones. |
| <a id="mutationreleaseupdatename"></a>`name` | [`String`](#string) | Name of the release. |
| <a id="mutationreleaseupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleaseupdatereleasedat"></a>`releasedAt` | [`Time`](#time) | Release date. |
| <a id="mutationreleaseupdatetagname"></a>`tagName` | [`String!`](#string) | Name of the tag associated with the release. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationreleaseupdaterelease"></a>`release` | [`Release`](#release) | Release after mutation. |

### `Mutation.removeProjectFromSecurityDashboard`

Input type: `RemoveProjectFromSecurityDashboardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationremoveprojectfromsecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | ID of the project to remove from the Instance Security Dashboard. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationremoveprojectfromsecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.repositionImageDiffNote`

Repositions a DiffNote on an image (a `Note` where the `position.positionType` is `"image"`).

Input type: `RepositionImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrepositionimagediffnoteid"></a>`id` | [`DiffNoteID!`](#diffnoteid) | Global ID of the DiffNote to update. |
| <a id="mutationrepositionimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput!`](#updatediffimagepositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrepositionimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrepositionimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationrepositionimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.restorePagesDeployment`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Restores a Pages deployment that has been scheduled for deletion.

Input type: `RestorePagesDeploymentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrestorepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrestorepagesdeploymentid"></a>`id` | [`PagesDeploymentID!`](#pagesdeploymentid) | ID of the Pages Deployment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrestorepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrestorepagesdeploymenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrestorepagesdeploymentpagesdeployment"></a>`pagesDeployment` | [`PagesDeployment!`](#pagesdeployment) | Restored Pages Deployment. |

### `Mutation.resyncSecurityPolicies`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Triggers a resynchronization of security policies linked to the given project or group (`full_path`).

Input type: `ResyncSecurityPoliciesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationresyncsecuritypoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationresyncsecuritypoliciesfullpath"></a>`fullPath` | [`String!`](#string) | Full path of the project or group. |
| <a id="mutationresyncsecuritypoliciesrelationship"></a>`relationship` | [`RelationshipType`](#relationshiptype) | Relationship of the policies to resync. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationresyncsecuritypoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationresyncsecuritypolicieserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.runnerAssignToProject`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Input type: `RunnerAssignToProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerassigntoprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerassigntoprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to which the runner will be assigned. |
| <a id="mutationrunnerassigntoprojectrunnerid"></a>`runnerId` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to assign to the project . |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerassigntoprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerassigntoprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.runnerBulkPause`

{{< details >}}
**Introduced** in GitLab 17.11.
**Status**: Experiment.
{{< /details >}}

Input type: `RunnerBulkPauseInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerbulkpauseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerbulkpauseids"></a>`ids` | [`[CiRunnerID!]!`](#cirunnerid) | IDs of the runners to pause or unpause. |
| <a id="mutationrunnerbulkpausepaused"></a>`paused` | [`Boolean!`](#boolean) | Indicates the runner is not allowed to receive jobs. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerbulkpauseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerbulkpauseerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrunnerbulkpauseupdatedcount"></a>`updatedCount` | [`Int`](#int) | Number of records effectively updated. Only present if operation was performed synchronously. |
| <a id="mutationrunnerbulkpauseupdatedrunners"></a>`updatedRunners` | [`[CiRunner!]`](#cirunner) | Runners after mutation. |

### `Mutation.runnerCacheClear`

Input type: `RunnerCacheClearInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercacheclearprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global ID of the project that will have its runner cache cleared. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercacheclearerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.runnerCreate`

{{< details >}}
**Introduced** in GitLab 15.10.
**Status**: Experiment.
{{< /details >}}

Input type: `RunnerCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercreatedescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="mutationrunnercreategroupid"></a>`groupId` | [`GroupID`](#groupid) | Global ID of the group that the runner is created in (valid only for group runner). |
| <a id="mutationrunnercreatelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="mutationrunnercreatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="mutationrunnercreatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="mutationrunnercreatepaused"></a>`paused` | [`Boolean`](#boolean) | Indicates the runner is not allowed to receive jobs. |
| <a id="mutationrunnercreateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.7. |
| <a id="mutationrunnercreateprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project that the runner is created in (valid only for project runner). |
| <a id="mutationrunnercreatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.7. |
| <a id="mutationrunnercreaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="mutationrunnercreaterunnertype"></a>`runnerType` | [`CiRunnerType!`](#cirunnertype) | Type of the runner to create. |
| <a id="mutationrunnercreatetaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrunnercreaterunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner after mutation. |

### `Mutation.runnerDelete`

Input type: `RunnerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerdeleteid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.runnerUnassignFromProject`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Input type: `RunnerUnassignFromProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerunassignfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerunassignfromprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project from which the runner will be unassigned. |
| <a id="mutationrunnerunassignfromprojectrunnerid"></a>`runnerId` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to unassign from the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerunassignfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerunassignfromprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.runnerUpdate`

Input type: `RunnerUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="mutationrunnerupdateactive"></a>`active` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: This was renamed. Please use `paused`. Deprecated in GitLab 14.8. |
| <a id="mutationrunnerupdateassociatedprojects"></a>`associatedProjects` | [`[ProjectID!]`](#projectid) | Projects associated with the runner. Available only for project runners. |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerupdatedescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="mutationrunnerupdateid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to update. |
| <a id="mutationrunnerupdatelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="mutationrunnerupdatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="mutationrunnerupdatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="mutationrunnerupdatepaused"></a>`paused` | [`Boolean`](#boolean) | Indicates the runner is not allowed to receive jobs. |
| <a id="mutationrunnerupdateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.7. |
| <a id="mutationrunnerupdatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.7. |
| <a id="mutationrunnerupdaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="mutationrunnerupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrunnerupdaterunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner after mutation. |

### `Mutation.runnersExportUsage`

Input type: `RunnersExportUsageInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersexportusagefromdate"></a>`fromDate` | [`ISO8601Date`](#iso8601date) | UTC start date of the period to report on. Defaults to the start of last full month. |
| <a id="mutationrunnersexportusagefullpath"></a>`fullPath` | [`ID`](#id) | Filter jobs by the full path of the group or project they belong to. For example, `gitlab-org` or `gitlab-org/gitlab`. Available only to administrators and users with the Maintainer role for the group (when a group is specified), or project (when a project is specified). Limited to runners from 5000 child projects. |
| <a id="mutationrunnersexportusagemaxprojectcount"></a>`maxProjectCount` | [`Int`](#int) | Maximum number of projects to return. All other runner usage will be attributed to an `<Other projects>` entry. Defaults to 1000 projects. |
| <a id="mutationrunnersexportusagerunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Scope of the runners to include in the report. |
| <a id="mutationrunnersexportusagetodate"></a>`toDate` | [`ISO8601Date`](#iso8601date) | UTC end date of the period to report on. " \ "Defaults to the end of the month specified by `fromDate`. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersexportusageerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.runnersRegistrationTokenReset`

{{< details >}}
**Deprecated** in GitLab 17.7.
Underlying feature was deprecated in 15.6 and will be removed in 18.0.
{{< /details >}}

Input type: `RunnersRegistrationTokenResetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersregistrationtokenresetid"></a>`id` | [`ID`](#id) | ID of the project or group to reset the token for. Omit if resetting instance runner token. |
| <a id="mutationrunnersregistrationtokenresettype"></a>`type` | [`CiRunnerType!`](#cirunnertype) | Scope of the object to reset the token for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersregistrationtokenreseterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationrunnersregistrationtokenresettoken"></a>`token` | [`String`](#string) | Runner token after mutation. |

### `Mutation.safeDisablePipelineVariables`

Input type: `SafeDisablePipelineVariablesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsafedisablepipelinevariablesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsafedisablepipelinevariablesfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the group to disable pipeline variables for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsafedisablepipelinevariablesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsafedisablepipelinevariableserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsafedisablepipelinevariablessuccess"></a>`success` | [`Boolean!`](#boolean) | Indicates whether the migration was successfully enqueued. |

### `Mutation.savedReplyCreate`

Input type: `SavedReplyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplycreatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationsavedreplycreatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsavedreplycreatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.savedReplyDestroy`

Input type: `SavedReplyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplydestroyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | Global ID of the user saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsavedreplydestroysavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.savedReplyUpdate`

Input type: `SavedReplyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationsavedreplyupdateid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | Global ID of the user saved reply. |
| <a id="mutationsavedreplyupdatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsavedreplyupdatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.scanExecutionPolicyCommit`

Commits the `policy_yaml` content to the assigned security policy project for the given project (`full_path`).

Input type: `ScanExecutionPolicyCommitInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationscanexecutionpolicycommitfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project. |
| <a id="mutationscanexecutionpolicycommitname"></a>`name` | [`String!`](#string) | Name of the policy. If the name is null, the `name` field from `policy_yaml` is used. |
| <a id="mutationscanexecutionpolicycommitoperationmode"></a>`operationMode` | [`MutationOperationMode!`](#mutationoperationmode) | Changes the operation mode. |
| <a id="mutationscanexecutionpolicycommitpolicyyaml"></a>`policyYaml` | [`String!`](#string) | YAML snippet of the policy. |
| <a id="mutationscanexecutionpolicycommitprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Use `fullPath`. Deprecated in GitLab 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitbranch"></a>`branch` | [`String`](#string) | Name of the branch to which the policy changes are committed. |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationscanexecutionpolicycommiterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationscanexecutionpolicycommitvalidationerrors"></a>`validationErrors` | [`[SecurityPolicyValidationError!]`](#securitypolicyvalidationerror) | Validation errors encountered during execution of the mutation. |

### `Mutation.secretPermissionDelete`

Input type: `SecretPermissionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecretpermissiondeleteprincipal"></a>`principal` | [`PrincipalInput!`](#principalinput) | Whose permission to be deleted. |
| <a id="mutationsecretpermissiondeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project permissions for the secret. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecretpermissiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecretpermissiondeletesecretpermission"></a>`secretPermission` | [`SecretPermission`](#secretpermission) | Deleted Secret Permission. |

### `Mutation.secretPermissionUpdate`

Input type: `SecretPermissionUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecretpermissionupdateexpiredat"></a>`expiredAt` | [`ISO8601Date`](#iso8601date) | Expiration date for Secret Permission (optional). |
| <a id="mutationsecretpermissionupdatepermissions"></a>`permissions` | [`[String!]!`](#string) | Permissions to be provided. ['create', 'update', 'read', 'delete']. |
| <a id="mutationsecretpermissionupdateprincipal"></a>`principal` | [`PrincipalInput!`](#principalinput) | User/MemberRole/Role/Group that is provided access. |
| <a id="mutationsecretpermissionupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to which the permissions are added. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecretpermissionupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecretpermissionupdatesecretpermission"></a>`secretPermission` | [`SecretPermission`](#secretpermission) | Secret Permission that was created. |

### `Mutation.securityAttributeCreate`

Input type: `SecurityAttributeCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributecreateattributes"></a>`attributes` | [`[SecurityAttributeInput!]!`](#securityattributeinput) | Attributes to create. |
| <a id="mutationsecurityattributecreatecategoryid"></a>`categoryId` | [`SecurityCategoryID!`](#securitycategoryid) | Global ID of the security category. |
| <a id="mutationsecurityattributecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributecreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Global ID of the namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityattributecreatesecurityattributes"></a>`securityAttributes` | [`[SecurityAttribute!]`](#securityattribute) | Created security attributes. |

### `Mutation.securityAttributeDestroy`

Input type: `SecurityAttributeDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributedestroyid"></a>`id` | [`SecurityAttributeID!`](#securityattributeid) | Global ID of the security attribute to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributedestroydeletedattributegid"></a>`deletedAttributeGid` | [`SecurityAttributeID`](#securityattributeid) | Global ID of the destroyed security attribute. |
| <a id="mutationsecurityattributedestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.securityAttributeProjectUpdate`

Input type: `SecurityAttributeProjectUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributeprojectupdateaddattributeids"></a>`addAttributeIds` | [`[SecurityAttributeID!]`](#securityattributeid) | Global IDs of the security attributes to add to the project. |
| <a id="mutationsecurityattributeprojectupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributeprojectupdateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global ID of the project. |
| <a id="mutationsecurityattributeprojectupdateremoveattributeids"></a>`removeAttributeIds` | [`[SecurityAttributeID!]`](#securityattributeid) | Global IDs of the security attributes to remove from the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributeprojectupdateaddedcount"></a>`addedCount` | [`Int`](#int) | Number of attributes added. |
| <a id="mutationsecurityattributeprojectupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributeprojectupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityattributeprojectupdateproject"></a>`project` | [`Project`](#project) | Updated project. |
| <a id="mutationsecurityattributeprojectupdateremovedcount"></a>`removedCount` | [`Int`](#int) | Number of attributes removed. |

### `Mutation.securityAttributeUpdate`

Input type: `SecurityAttributeUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributeupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributeupdatecolor"></a>`color` | [`Color`](#color) | Color of the security attribute. |
| <a id="mutationsecurityattributeupdatedescription"></a>`description` | [`String`](#string) | Description of the security attribute. |
| <a id="mutationsecurityattributeupdateid"></a>`id` | [`SecurityAttributeID!`](#securityattributeid) | Global ID of the security attribute. |
| <a id="mutationsecurityattributeupdatename"></a>`name` | [`String`](#string) | Name of the security attribute. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributeupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityattributeupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityattributeupdatesecurityattribute"></a>`securityAttribute` | [`SecurityAttribute`](#securityattribute) | Updated security attribute. |

### `Mutation.securityCategoryCreate`

Input type: `SecurityCategoryCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategorycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritycategorycreatedescription"></a>`description` | [`String`](#string) | Description of the security category. |
| <a id="mutationsecuritycategorycreatemultipleselection"></a>`multipleSelection` | [`Boolean`](#boolean) | Whether multiple attributes can be selected. |
| <a id="mutationsecuritycategorycreatename"></a>`name` | [`String!`](#string) | Name of the security category. |
| <a id="mutationsecuritycategorycreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Global ID of the category namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategorycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritycategorycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecuritycategorycreatesecuritycategory"></a>`securityCategory` | [`SecurityCategory`](#securitycategory) | Created security category. |

### `Mutation.securityCategoryDestroy`

Input type: `SecurityCategoryDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategorydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritycategorydestroyid"></a>`id` | [`SecurityCategoryID!`](#securitycategoryid) | Global ID of the security category to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategorydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritycategorydestroydeletedattributesgid"></a>`deletedAttributesGid` | [`[SecurityAttributeID!]`](#securityattributeid) | Global IDs of the deleted security attributes. |
| <a id="mutationsecuritycategorydestroydeletedcategorygid"></a>`deletedCategoryGid` | [`SecurityCategoryID`](#securitycategoryid) | Global ID of the deleted security category. |
| <a id="mutationsecuritycategorydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.securityCategoryUpdate`

Input type: `SecurityCategoryUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategoryupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritycategoryupdatedescription"></a>`description` | [`String`](#string) | Description of the security category. |
| <a id="mutationsecuritycategoryupdateid"></a>`id` | [`SecurityCategoryID!`](#securitycategoryid) | Global ID of the security category. |
| <a id="mutationsecuritycategoryupdatename"></a>`name` | [`String`](#string) | Name of the security category. |
| <a id="mutationsecuritycategoryupdatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Global ID of the category namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategoryupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritycategoryupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecuritycategoryupdatesecuritycategory"></a>`securityCategory` | [`SecurityCategory`](#securitycategory) | Updated security category. |

### `Mutation.securityFindingCreateIssue`

Input type: `SecurityFindingCreateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the issue to. |
| <a id="mutationsecurityfindingcreateissueuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create an issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityfindingcreateissueissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |

### `Mutation.securityFindingCreateMergeRequest`

Input type: `SecurityFindingCreateMergeRequestInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatemergerequestuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create a merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatemergerequesterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityfindingcreatemergerequestmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge Request created after mutation. |

### `Mutation.securityFindingCreateVulnerability`

{{< details >}}
**Introduced** in GitLab 17.5.
**Status**: Experiment.
{{< /details >}}

Input type: `SecurityFindingCreateVulnerabilityInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatevulnerabilityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatevulnerabilityuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create a vulnerability. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatevulnerabilityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatevulnerabilityerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityfindingcreatevulnerabilityvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability created after mutation. |

### `Mutation.securityFindingDismiss`

Input type: `SecurityFindingDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingdismisscomment"></a>`comment` | [`String`](#string) | Comment why finding should be dismissed. |
| <a id="mutationsecurityfindingdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why finding should be dismissed. |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String!`](#string) | UUID of the finding to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingdismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityfindingdismisssecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | Dismissed finding. |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String`](#string) | UUID of dismissed finding. |

### `Mutation.securityFindingExternalIssueLinkCreate`

Input type: `SecurityFindingExternalIssueLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingexternalissuelinkcreateexternaltracker"></a>`externalTracker` | [`VulnerabilityExternalIssueLinkExternalTracker!`](#vulnerabilityexternalissuelinkexternaltracker) | External tracker type of the external issue link. |
| <a id="mutationsecurityfindingexternalissuelinkcreatelinktype"></a>`linkType` | [`VulnerabilityExternalIssueLinkType!`](#vulnerabilityexternalissuelinktype) | Type of the external issue link. |
| <a id="mutationsecurityfindingexternalissuelinkcreateproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the issue to. |
| <a id="mutationsecurityfindingexternalissuelinkcreateuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create an issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingexternalissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityfindingexternalissuelinkcreateexternalissuelink"></a>`externalIssueLink` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | Created external issue link. |

### `Mutation.securityFindingRevertToDetected`

Input type: `SecurityFindingRevertToDetectedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingreverttodetectedcomment"></a>`comment` | [`String`](#string) | Comment that explains why finding was reverted to detected status. |
| <a id="mutationsecurityfindingreverttodetecteduuid"></a>`uuid` | [`String!`](#string) | UUID of the finding to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityfindingreverttodetectedsecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | Finding reverted to detected. |

### `Mutation.securityFindingSeverityOverride`

Input type: `SecurityFindingSeverityOverrideInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingseverityoverrideseverity"></a>`severity` | [`VulnerabilitySeverity!`](#vulnerabilityseverity) | New severity value for the finding. |
| <a id="mutationsecurityfindingseverityoverrideuuid"></a>`uuid` | [`String!`](#string) | UUID of the finding to modify. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingseverityoverrideerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecurityfindingseverityoverridesecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | Finding of which the severity was modified. |

### `Mutation.securityPolicyProjectAssign`

Assigns the specified project(`security_policy_project_id`) as security policy project for the given project(`full_path`). If the project already has a security policy project, this reassigns the project's security policy project with the given `security_policy_project_id`.

Input type: `SecurityPolicyProjectAssignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectassignfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectassignprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Use `fullPath`. Deprecated in GitLab 14.10. |
| <a id="mutationsecuritypolicyprojectassignsecuritypolicyprojectid"></a>`securityPolicyProjectId` | [`ProjectID!`](#projectid) | ID of the security policy project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.securityPolicyProjectCreate`

Creates and assigns a security policy project for the given project or group (`full_path`).

Input type: `SecurityPolicyProjectCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreatefullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectcreateprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Use `fullPath`. Deprecated in GitLab 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecuritypolicyprojectcreateproject"></a>`project` | [`Project`](#project) | Security Policy Project that was created. |

### `Mutation.securityPolicyProjectCreateAsync`

{{< details >}}
**Introduced** in GitLab 17.3.
**Status**: Experiment.
{{< /details >}}

Creates and assigns a security policy project for the given project or group (`full_path`) async.

Input type: `SecurityPolicyProjectCreateAsyncInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateasyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreateasyncfullpath"></a>`fullPath` | [`String!`](#string) | Full path of the project or group. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateasyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreateasyncerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.securityPolicyProjectUnassign`

Unassigns the security policy project for the given project (`full_path`).

Input type: `SecurityPolicyProjectUnassignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectunassignfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectunassignprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Use `fullPath`. Deprecated in GitLab 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectunassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.securityTrainingUpdate`

Input type: `SecurityTrainingUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritytrainingupdateisenabled"></a>`isEnabled` | [`Boolean!`](#boolean) | Sets the training provider as enabled for the project. |
| <a id="mutationsecuritytrainingupdateisprimary"></a>`isPrimary` | [`Boolean`](#boolean) | Sets the training provider as primary for the project. |
| <a id="mutationsecuritytrainingupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |
| <a id="mutationsecuritytrainingupdateproviderid"></a>`providerId` | [`SecurityTrainingProviderID!`](#securitytrainingproviderid) | ID of the provider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritytrainingupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsecuritytrainingupdatetraining"></a>`training` | [`ProjectSecurityTraining`](#projectsecuritytraining) | Represents the training entity subject to mutation. |

### `Mutation.setContainerScanningForRegistry`

Enable/disable Container Scanning for Registry for the given project.

Input type: `SetContainerScanningForRegistryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetcontainerscanningforregistryenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for Container Scanning for Registry feature. |
| <a id="mutationsetcontainerscanningforregistrynamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace (project). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetcontainerscanningforregistrycontainerscanningforregistryenabled"></a>`containerScanningForRegistryEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |
| <a id="mutationsetcontainerscanningforregistryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.setGroupSecretPushProtection`

Enable or disable Secret Push Protection for a group.

Input type: `SetGroupSecretPushProtectionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetgroupsecretpushprotectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the group. |
| <a id="mutationsetgroupsecretpushprotectionprojectstoexclude"></a>`projectsToExclude` | [`[Int!]`](#int) | IDs of projects to exclude from the feature. |
| <a id="mutationsetgroupsecretpushprotectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean!`](#boolean) | Whether to enable the feature. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetgroupsecretpushprotectionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.setGroupValidityChecks`

Enable or disable Validity Checks for a group.

Input type: `SetGroupValidityChecksInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupvaliditychecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetgroupvaliditychecksnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the group. |
| <a id="mutationsetgroupvaliditychecksprojectstoexclude"></a>`projectsToExclude` | [`[Int!]`](#int) | IDs of projects to exclude from validity checks configuration. |
| <a id="mutationsetgroupvaliditychecksvaliditychecksenabled"></a>`validityChecksEnabled` | [`Boolean!`](#boolean) | Whether to enable validity checks for all projects in the group. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupvaliditychecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetgroupvaliditycheckserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsetgroupvaliditychecksvaliditychecksenabled"></a>`validityChecksEnabled` | [`Boolean!`](#boolean) | Indicates whether validity checks have been enabled for the group. |

### `Mutation.setLicenseConfigurationSource`

Set the license information source for a given project.

Input type: `SetLicenseConfigurationSourceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetlicenseconfigurationsourceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetlicenseconfigurationsourceprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |
| <a id="mutationsetlicenseconfigurationsourcesource"></a>`source` | [`SecurityPreferredLicenseSourceConfiguration!`](#securitypreferredlicensesourceconfiguration) | Preferred source of license information for dependencies. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetlicenseconfigurationsourceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetlicenseconfigurationsourceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsetlicenseconfigurationsourcelicenseconfigurationsource"></a>`licenseConfigurationSource` | [`SecurityPreferredLicenseSourceConfiguration`](#securitypreferredlicensesourceconfiguration) | Preferred source of license information for dependencies. |

### `Mutation.setPagesForceHttps`

Input type: `SetPagesForceHttpsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesforcehttpsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetpagesforcehttpsprojectpath"></a>`projectPath` | [`ID!`](#id) | Path of the project to set the pages force HTTPS. |
| <a id="mutationsetpagesforcehttpsvalue"></a>`value` | [`Boolean!`](#boolean) | Indicates user wants to enforce HTTPS on their pages. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesforcehttpsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetpagesforcehttpserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsetpagesforcehttpsproject"></a>`project` | [`Project`](#project) | Project that was updated. |

### `Mutation.setPagesUseUniqueDomain`

Input type: `SetPagesUseUniqueDomainInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesuseuniquedomainclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetpagesuseuniquedomainprojectpath"></a>`projectPath` | [`ID!`](#id) | Path of the project to set the pages to use unique domains. |
| <a id="mutationsetpagesuseuniquedomainvalue"></a>`value` | [`Boolean!`](#boolean) | Indicates user wants to use unique subdomains for their pages. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesuseuniquedomainclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetpagesuseuniquedomainerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsetpagesuseuniquedomainproject"></a>`project` | [`Project`](#project) | Project that was updated. |

### `Mutation.setPreReceiveSecretDetection`

Enable/disable secret push protection for the given project.

Input type: `SetPreReceiveSecretDetectionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetprereceivesecretdetectionenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for secret push protection feature. |
| <a id="mutationsetprereceivesecretdetectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace (project). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetprereceivesecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsetprereceivesecretdetectionprereceivesecretdetectionenabled"></a>`preReceiveSecretDetectionEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |
| <a id="mutationsetprereceivesecretdetectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |

### `Mutation.setSecretPushProtection`

Enable/disable secret push protection for the given project.

Input type: `SetSecretPushProtectionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetsecretpushprotectionenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for secret push protection feature. |
| <a id="mutationsetsecretpushprotectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace (project). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetsecretpushprotectionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsetsecretpushprotectionprereceivesecretdetectionenabled"></a>`preReceiveSecretDetectionEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |
| <a id="mutationsetsecretpushprotectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |

### `Mutation.setValidityChecks`

Enable/disable secret detection validity checks for the given project.

Input type: `SetValidityChecksInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetvaliditychecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetvaliditychecksenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for validity checks feature. |
| <a id="mutationsetvaliditychecksnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace (project). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetvaliditychecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetvaliditycheckserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationsetvaliditychecksvaliditychecksenabled"></a>`validityChecksEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |

### `Mutation.starProject`

{{< details >}}
**Introduced** in GitLab 16.7.
**Status**: Experiment.
{{< /details >}}

Input type: `StarProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationstarprojectprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Full path of the project to star or unstar. |
| <a id="mutationstarprojectstarred"></a>`starred` | [`Boolean!`](#boolean) | Indicates whether to star or unstar the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationstarprojectcount"></a>`count` | [`String!`](#string) | Number of stars for the project. |
| <a id="mutationstarprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.tagCreate`

Input type: `TagCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtagcreatemessage"></a>`message` | [`String`](#string) | Tagging message. |
| <a id="mutationtagcreatename"></a>`name` | [`String!`](#string) | Name of the tag. |
| <a id="mutationtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |
| <a id="mutationtagcreateref"></a>`ref` | [`String!`](#string) | Tag name or commit SHA to create tag from. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtagcreatetag"></a>`tag` | [`Tag`](#tag) | Tag after mutation. |

### `Mutation.tagDelete`

Input type: `TagDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtagdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtagdeletename"></a>`name` | [`String!`](#string) | Name of the tag. |
| <a id="mutationtagdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtagdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtagdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtagdeletetag"></a>`tag` | [`Tag`](#tag) | Tag after mutation. |

### `Mutation.terraformStateDelete`

Input type: `TerraformStateDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatedeleteid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatedeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.terraformStateLock`

Input type: `TerraformStateLockInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatelockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatelockerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.terraformStateUnlock`

Input type: `TerraformStateUnlockInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstateunlockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstateunlockerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.timelineEventCreate`

{{< details >}}
**Introduced** in GitLab 15.6.
**Status**: Experiment.
{{< /details >}}

Input type: `TimelineEventCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventcreateincidentid"></a>`incidentId` | [`IssueID!`](#issueid) | Incident ID of the timeline event. |
| <a id="mutationtimelineeventcreatenote"></a>`note` | [`String!`](#string) | Text note of the timeline event. |
| <a id="mutationtimelineeventcreateoccurredat"></a>`occurredAt` | [`Time!`](#time) | Timestamp of when the event occurred. |
| <a id="mutationtimelineeventcreatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | Tags for the incident timeline event. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtimelineeventcreatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventDestroy`

Input type: `TimelineEventDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventdestroyid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | Timeline event ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtimelineeventdestroytimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventPromoteFromNote`

Input type: `TimelineEventPromoteFromNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventpromotefromnotenoteid"></a>`noteId` | [`NoteID!`](#noteid) | Note ID from which the timeline event promoted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventpromotefromnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtimelineeventpromotefromnotetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventTagCreate`

Input type: `TimelineEventTagCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventtagcreatename"></a>`name` | [`String!`](#string) | Name of the tag. |
| <a id="mutationtimelineeventtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the timeline event tag in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtimelineeventtagcreatetimelineeventtag"></a>`timelineEventTag` | [`TimelineEventTagType`](#timelineeventtagtype) | Timeline event tag. |

### `Mutation.timelineEventUpdate`

Input type: `TimelineEventUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventupdateid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | ID of the timeline event to update. |
| <a id="mutationtimelineeventupdatenote"></a>`note` | [`String`](#string) | Text note of the timeline event. |
| <a id="mutationtimelineeventupdateoccurredat"></a>`occurredAt` | [`Time`](#time) | Timestamp when the event occurred. |
| <a id="mutationtimelineeventupdatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | Tags for the incident timeline event. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtimelineeventupdatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelogCreate`

Input type: `TimelogCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogcreateissuableid"></a>`issuableId` | [`IssuableID!`](#issuableid) | Global ID of the issuable (Issue, WorkItem or MergeRequest). |
| <a id="mutationtimelogcreatespentat"></a>`spentAt` | [`Time`](#time) | Timestamp of when the time was spent. If empty, defaults to current time. |
| <a id="mutationtimelogcreatesummary"></a>`summary` | [`String!`](#string) | Summary of time spent. |
| <a id="mutationtimelogcreatetimespent"></a>`timeSpent` | [`String!`](#string) | Amount of time spent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtimelogcreatetimelog"></a>`timelog` | [`Timelog`](#timelog) | Timelog. |

### `Mutation.timelogDelete`

Input type: `TimelogDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogdeleteid"></a>`id` | [`TimelogID!`](#timelogid) | Global ID of the timelog. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtimelogdeletetimelog"></a>`timelog` | [`Timelog`](#timelog) | Timelog. |

### `Mutation.todoCreate`

Input type: `TodoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodocreatetargetid"></a>`targetId` | [`TodoableID!`](#todoableid) | Global ID of the to-do item's parent. Issues, merge requests, designs, and epics are supported. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodocreatetodo"></a>`todo` | [`Todo`](#todo) | To-do item created. |

### `Mutation.todoDeleteAllDone`

{{< details >}}
**Introduced** in GitLab 17.11.
**Status**: Experiment.
{{< /details >}}

Input type: `TodoDeleteAllDoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtododeletealldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtododeletealldoneupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | To-do items marked as done before the timestamp will be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtododeletealldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtododeletealldoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.todoDeleteMany`

{{< details >}}
**Introduced** in GitLab 17.11.
**Status**: Experiment.
{{< /details >}}

Input type: `TodoDeleteManyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtododeletemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtododeletemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | Global IDs of the to-do items to process (a maximum of 100 is supported at once). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtododeletemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtododeletemanyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.todoMarkDone`

Input type: `TodoMarkDoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodomarkdoneid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to mark as done. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodomarkdoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodomarkdonetodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoResolveMany`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `TodoResolveManyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodoresolvemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodoresolvemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | Global IDs of the to-do items to process (a maximum of 100 is supported at once). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodoresolvemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodoresolvemanyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodoresolvemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | Resolved to-do items. |

### `Mutation.todoRestore`

Input type: `TodoRestoreInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoreid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to restore. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoreerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodorestoretodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoRestoreMany`

Input type: `TodoRestoreManyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoremanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | Global IDs of the to-do items to process (a maximum of 100 is supported at once). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoremanyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodorestoremanytodos"></a>`todos` | [`[Todo!]!`](#todo) | Restored to-do items. |

### `Mutation.todoSnooze`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

Input type: `TodoSnoozeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosnoozeid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to be snoozed. |
| <a id="mutationtodosnoozesnoozeuntil"></a>`snoozeUntil` | [`Time!`](#time) | Time until which the todo should be snoozed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosnoozeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodosnoozetodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoSnoozeMany`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `TodoSnoozeManyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosnoozemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | Global IDs of the to-do items to process (a maximum of 100 is supported at once). |
| <a id="mutationtodosnoozemanysnoozeuntil"></a>`snoozeUntil` | [`Time!`](#time) | Time until which the todos should be snoozed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosnoozemanyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodosnoozemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | Snoozed to-do items. |

### `Mutation.todoUnSnooze`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

Input type: `TodoUnSnoozeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodounsnoozeid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to be snoozed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodounsnoozeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodounsnoozetodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoUnsnoozeMany`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `TodoUnsnoozeManyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodounsnoozemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | Global IDs of the to-do items to process (a maximum of 100 is supported at once). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodounsnoozemanyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodounsnoozemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | Unsnoozed to-do items. |

### `Mutation.todosMarkAllDone`

Input type: `TodosMarkAllDoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | Action to be filtered. |
| <a id="mutationtodosmarkalldoneauthorid"></a>`authorId` | [`[ID!]`](#id) | ID of an author. |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosmarkalldonegroupid"></a>`groupId` | [`[ID!]`](#id) | ID of a group. |
| <a id="mutationtodosmarkalldoneprojectid"></a>`projectId` | [`[ID!]`](#id) | ID of a project. |
| <a id="mutationtodosmarkalldonetargetid"></a>`targetId` | [`TodoableID`](#todoableid) | Global ID of the to-do item's parent. Issues, merge requests, designs, and epics are supported. If argument is omitted, all pending to-do items of the current user are marked as done. |
| <a id="mutationtodosmarkalldonetype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | Type of the todo. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosmarkalldoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationtodosmarkalldonetodos"></a>`todos` | [`[Todo!]!`](#todo) | Updated to-do items. |

### `Mutation.unlinkProjectComplianceViolationIssue`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Input type: `UnlinkProjectComplianceViolationIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationunlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationunlinkprojectcomplianceviolationissueissueiid"></a>`issueIid` | [`String!`](#string) | IID of the issue to be unlinked. |
| <a id="mutationunlinkprojectcomplianceviolationissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the issue belongs to. |
| <a id="mutationunlinkprojectcomplianceviolationissueviolationid"></a>`violationId` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | Global ID of the project compliance violation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationunlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationunlinkprojectcomplianceviolationissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationunlinkprojectcomplianceviolationissueviolation"></a>`violation` | [`ProjectComplianceViolation`](#projectcomplianceviolation) | Updated project compliance violation. |

### `Mutation.updateAlertStatus`

Input type: `UpdateAlertStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatealertstatusiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationupdatealertstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |
| <a id="mutationupdatealertstatusstatus"></a>`status` | [`AlertManagementStatus!`](#alertmanagementstatus) | Status to set the alert. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatealertstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatealertstatusissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationupdatealertstatustodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.updateBoard`

Input type: `UpdateBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ID of user to be assigned to the board. |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationupdateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationupdateboardid"></a>`id` | [`BoardID!`](#boardid) | Board global ID. |
| <a id="mutationupdateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ID of iteration cadence to be assigned to the board. |
| <a id="mutationupdateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ID of iteration to be assigned to the board. |
| <a id="mutationupdateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationupdateboardlabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationupdateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of milestone to be assigned to the board. |
| <a id="mutationupdateboardname"></a>`name` | [`String`](#string) | Board name. |
| <a id="mutationupdateboardweight"></a>`weight` | [`Int`](#int) | Weight value to be assigned to the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateBoardEpicUserPreferences`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `UpdateBoardEpicUserPreferencesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesboardid"></a>`boardId` | [`BoardID!`](#boardid) | Board global ID. |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | Whether the epic should be collapsed in the board. |
| <a id="mutationupdateboardepicuserpreferencesepicid"></a>`epicId` | [`EpicID!`](#epicid) | ID of an epic to set preferences for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardepicuserpreferencesepicuserpreferences"></a>`epicUserPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | User preferences for the epic in the board after mutation. |
| <a id="mutationupdateboardepicuserpreferenceserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateBoardList`

Input type: `UpdateBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for the user. |
| <a id="mutationupdateboardlistlistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="mutationupdateboardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdateboardlistlist"></a>`list` | [`BoardList`](#boardlist) | Mutated list. |

### `Mutation.updateComplianceFramework`

Input type: `UpdateComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | Global ID of the compliance framework to update. |
| <a id="mutationupdatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | Parameters to update the compliance framework with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecomplianceframeworkcomplianceframework"></a>`complianceFramework` | [`ComplianceFramework`](#complianceframework) | Compliance framework after mutation. |
| <a id="mutationupdatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateComplianceRequirement`

{{< details >}}
**Introduced** in GitLab 17.7.
**Status**: Experiment.
{{< /details >}}

Input type: `UpdateComplianceRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecompliancerequirementcontrols"></a>`controls` | [`[ComplianceRequirementsControlInput!]`](#compliancerequirementscontrolinput) | Controls to add or update to the compliance requirement. |
| <a id="mutationupdatecompliancerequirementid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | Global ID of the compliance requirement to update. |
| <a id="mutationupdatecompliancerequirementparams"></a>`params` | [`ComplianceRequirementInput!`](#compliancerequirementinput) | Parameters to update the compliance requirement with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatecompliancerequirementrequirement"></a>`requirement` | [`ComplianceRequirement`](#compliancerequirement) | Compliance requirement after updation. |

### `Mutation.updateComplianceRequirementsControl`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `UpdateComplianceRequirementsControlInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecompliancerequirementscontrolid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementsControlID!`](#compliancemanagementcomplianceframeworkcompliancerequirementscontrolid) | Global ID of the compliance requirement control to update. |
| <a id="mutationupdatecompliancerequirementscontrolparams"></a>`params` | [`ComplianceRequirementsControlInput!`](#compliancerequirementscontrolinput) | Parameters to update the compliance requirement control with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatecompliancerequirementscontrolrequirementscontrol"></a>`requirementsControl` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | Compliance requirement control after updation. |

### `Mutation.updateContainerExpirationPolicy`

Input type: `UpdateContainerExpirationPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicycadence"></a>`cadence` | [`ContainerExpirationPolicyCadenceEnum`](#containerexpirationpolicycadenceenum) | Schedule of the container expiration policy. |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerexpirationpolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the container expiration policy is enabled. |
| <a id="mutationupdatecontainerexpirationpolicykeepn"></a>`keepN` | [`ContainerExpirationPolicyKeepEnum`](#containerexpirationpolicykeepenum) | Number of tags to retain. |
| <a id="mutationupdatecontainerexpirationpolicynameregex"></a>`nameRegex` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching the regex pattern will expire. |
| <a id="mutationupdatecontainerexpirationpolicynameregexkeep"></a>`nameRegexKeep` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching the regex pattern will be preserved. |
| <a id="mutationupdatecontainerexpirationpolicyolderthan"></a>`olderThan` | [`ContainerExpirationPolicyOlderThanEnum`](#containerexpirationpolicyolderthanenum) | Tags older than the given age will expire. |
| <a id="mutationupdatecontainerexpirationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the container expiration policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerexpirationpolicycontainerexpirationpolicy"></a>`containerExpirationPolicy` {{< icon name="warning-solid" >}} | [`ContainerExpirationPolicy`](#containerexpirationpolicy) | **Deprecated**: Use `container_tags_expiration_policy`. Deprecated in GitLab 17.5. |
| <a id="mutationupdatecontainerexpirationpolicycontainertagsexpirationpolicy"></a>`containerTagsExpirationPolicy` | [`ContainerTagsExpirationPolicy`](#containertagsexpirationpolicy) | Container tags expiration policy after mutation. |
| <a id="mutationupdatecontainerexpirationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateContainerProtectionRepositoryRule`

Updates a container repository protection rule that controls who can modify container images based on user roles.

Input type: `UpdateContainerProtectionRepositoryRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerprotectionrepositoryruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | Global ID of the container repository protection rule to be updated. |
| <a id="mutationupdatecontainerprotectionrepositoryruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | Minimum GitLab access level required to delete container images from the container repository. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. If the value is `nil`, the default minimum access level is `DEVELOPER`. |
| <a id="mutationupdatecontainerprotectionrepositoryruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | Minimum GitLab access level required to push container images to the container repository. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. If the value is `nil`, the default minimum access level is `DEVELOPER`. |
| <a id="mutationupdatecontainerprotectionrepositoryrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String`](#string) | Container repository path pattern protected by the protection rule. Must start with the project’s full path. For example: `my-project/*-prod-*`. Wildcard character `*` is allowed anywhere after the project’s full path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | Container repository protection rule after mutation. |
| <a id="mutationupdatecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateContainerProtectionTagRule`

{{< details >}}
**Introduced** in GitLab 17.8.
**Status**: Experiment.
{{< /details >}}

Updates a protection rule that controls which user roles can modify container image tags matching a specified pattern.

Input type: `UpdateContainerProtectionTagRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerprotectiontagruleid"></a>`id` | [`ContainerRegistryProtectionTagRuleID!`](#containerregistryprotectiontagruleid) | Global ID of the tag protection rule to update. |
| <a id="mutationupdatecontainerprotectiontagruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |
| <a id="mutationupdatecontainerprotectiontagruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |
| <a id="mutationupdatecontainerprotectiontagruletagnamepattern"></a>`tagNamePattern` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.8. |
| <a id="mutationupdatecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateDependencyProxyImageTtlGroupPolicy`

These settings can be adjusted only by the group Owner.

Input type: `UpdateDependencyProxyImageTtlGroupPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the policy is enabled or disabled. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicygrouppath"></a>`groupPath` | [`ID!`](#id) | Group path for the group dependency proxy image TTL policy. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyttl"></a>`ttl` | [`Int`](#int) | Number of days to retain a cached image file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicydependencyproxyimagettlpolicy"></a>`dependencyProxyImageTtlPolicy` | [`DependencyProxyImageTtlGroupPolicy`](#dependencyproxyimagettlgrouppolicy) | Group image TTL policy after mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateDependencyProxyPackagesSettings`

Updates or creates dependency proxy for packages settings.
Requires the packages and dependency proxy to be enabled in the config.
Requires the packages feature to be enabled at the project level.

Input type: `UpdateDependencyProxyPackagesSettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxypackagessettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the dependency proxy for packages is enabled for the project. |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistrypassword"></a>`mavenExternalRegistryPassword` | [`String`](#string) | Password for the external Maven packages registry. Introduced in 16.5: This feature is an Experiment. It can be changed or removed at any time. |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryurl"></a>`mavenExternalRegistryUrl` | [`String`](#string) | URL for the external Maven packages registry. |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryusername"></a>`mavenExternalRegistryUsername` | [`String`](#string) | Username for the external Maven packages registry. |
| <a id="mutationupdatedependencyproxypackagessettingsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path for the dependency proxy for packages settings. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxypackagessettingsdependencyproxypackagessetting"></a>`dependencyProxyPackagesSetting` | [`DependencyProxyPackagesSetting`](#dependencyproxypackagessetting) | Dependency proxy for packages settings after mutation. |
| <a id="mutationupdatedependencyproxypackagessettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateDependencyProxySettings`

These settings can be adjusted only by the group Owner.

Input type: `UpdateDependencyProxySettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxysettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the policy is enabled or disabled. |
| <a id="mutationupdatedependencyproxysettingsgrouppath"></a>`groupPath` | [`ID!`](#id) | Group path for the group dependency proxy. |
| <a id="mutationupdatedependencyproxysettingsidentity"></a>`identity` | [`String`](#string) | Identity credential used to authenticate with Docker Hub when pulling images. Can be a username (for password or personal access token (PAT)) or organization name (for organization access token (OAT)). |
| <a id="mutationupdatedependencyproxysettingssecret"></a>`secret` | [`String`](#string) | Secret credential used to authenticate with Docker Hub when pulling images. Can be a password, personal access token (PAT), or organization access token (OAT). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxysettingsdependencyproxysetting"></a>`dependencyProxySetting` | [`DependencyProxySetting`](#dependencyproxysetting) | Group dependency proxy settings after mutation. |
| <a id="mutationupdatedependencyproxysettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateEpic`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by `WorkItem` type. For more information, see [migration guide](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/).
{{< /details >}}

Input type: `UpdateEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the epic. |
| <a id="mutationupdateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | Array of labels to be added to the epic. |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepiccolor"></a>`color` | [`Color`](#color) | Color of the epic. |
| <a id="mutationupdateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="mutationupdateepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="mutationupdateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | End date of the epic. |
| <a id="mutationupdateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates end date should be sourced from due_date_fixed field not the issue milestones. |
| <a id="mutationupdateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate is in. |
| <a id="mutationupdateepiciid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationupdateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the epic. |
| <a id="mutationupdateepicremovelabels"></a>`removeLabels` | [`[String!]`](#string) | Array of labels to be removed from the epic. |
| <a id="mutationupdateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | Start date of the epic. |
| <a id="mutationupdateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates start date should be sourced from start_date_fixed field not the issue milestones. |
| <a id="mutationupdateepicstateevent"></a>`stateEvent` | [`EpicStateEvent`](#epicstateevent) | State event for the epic. |
| <a id="mutationupdateepictitle"></a>`title` | [`String`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationupdateepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateEpicBoardList`

{{< details >}}
**Deprecated** in GitLab 17.5.
Replaced by WorkItem type.
{{< /details >}}

Input type: `UpdateEpicBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for the user. |
| <a id="mutationupdateepicboardlistlistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic list. |
| <a id="mutationupdateepicboardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdateepicboardlistlist"></a>`list` | [`EpicList`](#epiclist) | Mutated epic list. |

### `Mutation.updateImageDiffNote`

Updates a DiffNote on an image (a `Note` where the `position.positionType` is `"image"`).
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `UpdateImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnotebody"></a>`body` | [`String`](#string) | Content of the note. |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateimagediffnoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to update. |
| <a id="mutationupdateimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput`](#updatediffimagepositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdateimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationupdateimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.updateIssue`

Input type: `UpdateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the issue. |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates the issue is confidential. |
| <a id="mutationupdateissuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="mutationupdateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | Due date of the issue. |
| <a id="mutationupdateissueepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **Deprecated**: This will be replaced by WorkItem hierarchyWidget. Deprecated in GitLab 17.5. |
| <a id="mutationupdateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Desired health status. |
| <a id="mutationupdateissueiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationupdateissuelabelids"></a>`labelIds` | [`[ID!]`](#id) | IDs of labels to be set. Replaces existing issue labels. |
| <a id="mutationupdateissuelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="mutationupdateissuemilestoneid"></a>`milestoneId` | [`ID`](#id) | ID of the milestone to assign to the issue. On update milestone will be removed if set to null. |
| <a id="mutationupdateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationupdateissueremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the issue. |
| <a id="mutationupdateissuestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | Close or reopen an issue. |
| <a id="mutationupdateissuetimeestimate"></a>`timeEstimate` | [`String`](#string) | Estimated time to complete the issue. Use `null` or `0` to remove the current estimate. |
| <a id="mutationupdateissuetitle"></a>`title` | [`String`](#string) | Title of the issue. |
| <a id="mutationupdateissuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="mutationupdateissueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdateissueissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.updateIteration`

Input type: `UpdateIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateiterationdescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationupdateiterationduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationupdateiterationgrouppath"></a>`groupPath` | [`ID!`](#id) | Group of the iteration. |
| <a id="mutationupdateiterationid"></a>`id` | [`ID!`](#id) | Global ID of the iteration. |
| <a id="mutationupdateiterationstartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationupdateiterationtitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | Updated iteration. |

### `Mutation.updateNamespacePackageSettings`

These settings can be adjusted only by the group Owner.

Input type: `UpdateNamespacePackageSettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsauditeventsenabled"></a>`auditEventsEnabled` | [`Boolean`](#boolean) | Indicates whether audit events are created when publishing or deleting a package in the namespace (Premium and Ultimate only). |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicateexceptionregex"></a>`genericDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When generic_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicatesallowed"></a>`genericDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate generic packages are allowed for the namespace. |
| <a id="mutationupdatenamespacepackagesettingslockmavenpackagerequestsforwarding"></a>`lockMavenPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether Maven package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingslocknpmpackagerequestsforwarding"></a>`lockNpmPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether npm package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingslockpypipackagerequestsforwarding"></a>`lockPypiPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether PyPI package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicateexceptionregex"></a>`mavenDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When maven_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicatesallowed"></a>`mavenDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate Maven packages are allowed for the namespace. |
| <a id="mutationupdatenamespacepackagesettingsmavenpackagerequestsforwarding"></a>`mavenPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether Maven package forwarding is allowed for the namespace. |
| <a id="mutationupdatenamespacepackagesettingsnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Namespace path where the namespace package setting is located. |
| <a id="mutationupdatenamespacepackagesettingsnpmpackagerequestsforwarding"></a>`npmPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether npm package forwarding is allowed for the namespace. |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicateexceptionregex"></a>`nugetDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When nuget_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicatesallowed"></a>`nugetDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate NuGet packages are allowed for the namespace. |
| <a id="mutationupdatenamespacepackagesettingsnugetsymbolserverenabled"></a>`nugetSymbolServerEnabled` | [`Boolean`](#boolean) | Indicates whether the NuGet symbol server is enabled for the namespace. |
| <a id="mutationupdatenamespacepackagesettingspypipackagerequestsforwarding"></a>`pypiPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether PyPI package forwarding is allowed for the namespace. |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicateexceptionregex"></a>`terraformModuleDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When terraform_module_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicatesallowed"></a>`terraformModuleDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate Terraform packages are allowed for the namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenamespacepackagesettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatenamespacepackagesettingspackagesettings"></a>`packageSettings` | [`PackageSettings`](#packagesettings) | Namespace package setting after mutation. |

### `Mutation.updateNote`

Updates a Note.
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `UpdateNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenotebody"></a>`body` | [`String`](#string) | Content of the note. |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatenotenote"></a>`note` | [`Note`](#note) | Note after mutation. |
| <a id="mutationupdatenotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | Status of quick actions after mutation. |

### `Mutation.updatePackagesCleanupPolicy`

Input type: `UpdatePackagesCleanupPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagescleanuppolicykeepnduplicatedpackagefiles"></a>`keepNDuplicatedPackageFiles` | [`PackagesCleanupKeepDuplicatedPackageFilesEnum`](#packagescleanupkeepduplicatedpackagefilesenum) | Number of duplicated package files to retain. |
| <a id="mutationupdatepackagescleanuppolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the packages cleanup policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagescleanuppolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatepackagescleanuppolicypackagescleanuppolicy"></a>`packagesCleanupPolicy` | [`PackagesCleanupPolicy`](#packagescleanuppolicy) | Packages cleanup policy after mutation. |

### `Mutation.updatePackagesProtectionRule`

Updates a package protection rule to restrict access to project packages. You can prevent users without certain permissions from altering packages.

Input type: `UpdatePackagesProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | Global ID of the package protection rule to be updated. |
| <a id="mutationupdatepackagesprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`PackagesProtectionRuleAccessLevelForDelete`](#packagesprotectionruleaccesslevelfordelete) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.10. |
| <a id="mutationupdatepackagesprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`PackagesProtectionRuleAccessLevel`](#packagesprotectionruleaccesslevel) | Minimum GitLab access required to push packages to the package registry. Valid values include `MAINTAINER`, `OWNER`, or `ADMIN`. If the value is `nil`, the default minimum access level is `DEVELOPER`. |
| <a id="mutationupdatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String`](#string) | Package name protected by the protection rule. For example, `@my-scope/my-package-*`. Wildcard character `*` allowed. |
| <a id="mutationupdatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType`](#packagesprotectionrulepackagetype) | Package type protected by the protection rule. For example, `NPM`, `PYPI`. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | Packages protection rule after mutation. |

### `Mutation.updateProjectComplianceViolation`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Input type: `UpdateProjectComplianceViolationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateprojectcomplianceviolationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateprojectcomplianceviolationid"></a>`id` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | Global ID of the project compliance violation to update. |
| <a id="mutationupdateprojectcomplianceviolationstatus"></a>`status` | [`ComplianceViolationStatus!`](#complianceviolationstatus) | New status for the project compliance violation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateprojectcomplianceviolationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateprojectcomplianceviolationcomplianceviolation"></a>`complianceViolation` | [`ProjectComplianceViolation`](#projectcomplianceviolation) | Compliance violation after status update. |
| <a id="mutationupdateprojectcomplianceviolationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.updateRequirement`

Input type: `UpdateRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdaterequirementdescription"></a>`description` | [`String`](#string) | Description of the requirement. |
| <a id="mutationupdaterequirementiid"></a>`iid` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: Use work_item_iid instead. Deprecated in GitLab 15.8. |
| <a id="mutationupdaterequirementlasttestreportstate"></a>`lastTestReportState` | [`TestReportState`](#testreportstate) | Creates a test report for the requirement with the given state. |
| <a id="mutationupdaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirement is associated with. |
| <a id="mutationupdaterequirementstate"></a>`state` | [`RequirementState`](#requirementstate) | State of the requirement. |
| <a id="mutationupdaterequirementtitle"></a>`title` | [`String`](#string) | Title of the requirement. |
| <a id="mutationupdaterequirementworkitemiid"></a>`workItemIid` | [`String`](#string) | IID of the requirement work item to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | Requirement after mutation. |

### `Mutation.updateSnippet`

Input type: `UpdateSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | Actions to perform over the snippet repository and blobs. |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatesnippetdescription"></a>`description` | [`String`](#string) | Description of the snippet. |
| <a id="mutationupdatesnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to update. |
| <a id="mutationupdatesnippettitle"></a>`title` | [`String`](#string) | Title of the snippet. |
| <a id="mutationupdatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | Visibility level of the snippet. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.updateVirtualRegistriesSetting`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Updates or creates virtual registries settings for a root group.

Input type: `UpdateVirtualRegistriesSettingInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatevirtualregistriessettingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatevirtualregistriessettingenabled"></a>`enabled` | [`Boolean`](#boolean) | Enable or disable the virtual registries. |
| <a id="mutationupdatevirtualregistriessettingfullpath"></a>`fullPath` | [`ID!`](#id) | Group path for the group virtual registries. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatevirtualregistriessettingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatevirtualregistriessettingerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationupdatevirtualregistriessettingvirtualregistriessetting"></a>`virtualRegistriesSetting` | [`VirtualRegistriesSetting`](#virtualregistriessetting) | Virtual registries settings after mutation. |

### `Mutation.uploadDelete`

Deletes an upload.

Input type: `UploadDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuploaddeletefilename"></a>`filename` | [`String!`](#string) | Upload filename. |
| <a id="mutationuploaddeletegrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationuploaddeleteprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationuploaddeletesecret"></a>`secret` | [`String!`](#string) | Secret part of upload path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuploaddeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationuploaddeleteupload"></a>`upload` | [`FileUpload`](#fileupload) | Deleted upload. |

### `Mutation.userAchievementPrioritiesUpdate`

{{< details >}}
**Introduced** in GitLab 16.5.
**Status**: Experiment.
{{< /details >}}

Input type: `UserAchievementPrioritiesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementprioritiesupdateuserachievementids"></a>`userAchievementIds` | [`[AchievementsUserAchievementID!]!`](#achievementsuserachievementid) | Global IDs of the user achievements being prioritized, ordered from highest to lowest priority. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementprioritiesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationuserachievementprioritiesupdateuserachievements"></a>`userAchievements` | [`[UserAchievement!]!`](#userachievement) | Updated user achievements. |

### `Mutation.userAchievementsDelete`

{{< details >}}
**Introduced** in GitLab 16.1.
**Status**: Experiment.
{{< /details >}}

Input type: `UserAchievementsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementsdeleteuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | Global ID of the user achievement being deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationuserachievementsdeleteuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Deleted user achievement. |

### `Mutation.userAchievementsUpdate`

{{< details >}}
**Introduced** in GitLab 17.3.
**Status**: Experiment.
{{< /details >}}

Input type: `UserAchievementsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementsupdateshowonprofile"></a>`showOnProfile` | [`Boolean!`](#boolean) | Indicates whether or not the user achievement is visible on the profile. |
| <a id="mutationuserachievementsupdateuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | Global ID of the user achievement being updated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationuserachievementsupdateuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Achievement award. |

### `Mutation.userAddOnAssignmentBulkCreate`

Input type: `UserAddOnAssignmentBulkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase to be assigned to. |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkcreateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of user to be assigned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.userAddOnAssignmentBulkRemove`

Input type: `UserAddOnAssignmentBulkRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase to be unassigned from. |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkremoveuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of user to be unassigned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.userAddOnAssignmentCreate`

Input type: `UserAddOnAssignmentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase to be assigned to. |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentcreateuserid"></a>`userId` | [`UserID!`](#userid) | Global ID of user to be assigned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationuseraddonassignmentcreateuser"></a>`user` | [`AddOnUser`](#addonuser) | User who the add-on purchase was assigned to. |

### `Mutation.userAddOnAssignmentRemove`

Input type: `UserAddOnAssignmentRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase assignment belongs to. |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentremoveuserid"></a>`userId` | [`UserID!`](#userid) | Global ID of user whose assignment will be removed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationuseraddonassignmentremoveuser"></a>`user` | [`AddOnUser`](#addonuser) | User that the add-on was removed from. |

### `Mutation.userCalloutCreate`

Input type: `UserCalloutCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusercalloutcreatefeaturename"></a>`featureName` | [`String!`](#string) | Feature name you want to dismiss the callout for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusercalloutcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationusercalloutcreateusercallout"></a>`userCallout` | [`UserCallout!`](#usercallout) | User callout dismissed. |

### `Mutation.userGroupCalloutCreate`

Input type: `UserGroupCalloutCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusergroupcalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusergroupcalloutcreatefeaturename"></a>`featureName` | [`String!`](#string) | Feature name you want to dismiss the callout for. |
| <a id="mutationusergroupcalloutcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the callout. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusergroupcalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusergroupcalloutcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationusergroupcalloutcreateusergroupcallout"></a>`userGroupCallout` | [`UserGroupCallout!`](#usergroupcallout) | User group callout dismissed. |

### `Mutation.userPreferencesUpdate`

Input type: `UserPreferencesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserpreferencesupdateextensionsmarketplaceoptinstatus"></a>`extensionsMarketplaceOptInStatus` | [`ExtensionsMarketplaceOptInStatus`](#extensionsmarketplaceoptinstatus) | Status of the Web IDE Extension Marketplace opt-in for the user. |
| <a id="mutationuserpreferencesupdateissuessort"></a>`issuesSort` | [`IssueSort`](#issuesort) | Sort order for issue lists. |
| <a id="mutationuserpreferencesupdatemergerequestdashboardlisttype"></a>`mergeRequestDashboardListType` | [`MergeRequestsDashboardListType`](#mergerequestsdashboardlisttype) | Merge request dashboard list rendering type. |
| <a id="mutationuserpreferencesupdatemergerequestdashboardshowdrafts"></a>`mergeRequestDashboardShowDrafts` | [`Boolean`](#boolean) | Show draft merge requests on the merge request dashboard. |
| <a id="mutationuserpreferencesupdatemergerequestssort"></a>`mergeRequestsSort` | [`MergeRequestSort`](#mergerequestsort) | Sort order for issue lists. |
| <a id="mutationuserpreferencesupdatenewuienabled"></a>`newUiEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.6. |
| <a id="mutationuserpreferencesupdateorganizationgroupsprojectsdisplay"></a>`organizationGroupsProjectsDisplay` {{< icon name="warning-solid" >}} | [`OrganizationGroupProjectDisplay`](#organizationgroupprojectdisplay) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.2. |
| <a id="mutationuserpreferencesupdateorganizationgroupsprojectssort"></a>`organizationGroupsProjectsSort` {{< icon name="warning-solid" >}} | [`OrganizationGroupProjectSort`](#organizationgroupprojectsort) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.2. |
| <a id="mutationuserpreferencesupdateprojectstudioenabled"></a>`projectStudioEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.4. |
| <a id="mutationuserpreferencesupdateprojectssort"></a>`projectsSort` | [`ProjectSort`](#projectsort) | Sort order for projects. |
| <a id="mutationuserpreferencesupdateuseworkitemsview"></a>`useWorkItemsView` | [`Boolean`](#boolean) | Use work item view instead of legacy issue view. |
| <a id="mutationuserpreferencesupdatevisibilitypipelineidtype"></a>`visibilityPipelineIdType` | [`VisibilityPipelineIdType`](#visibilitypipelineidtype) | Determines whether the pipeline list shows ID or IID. |
| <a id="mutationuserpreferencesupdateworkitemsdisplaysettings"></a>`workItemsDisplaySettings` {{< icon name="warning-solid" >}} | [`JSON`](#json) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.1. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserpreferencesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationuserpreferencesupdateuserpreferences"></a>`userPreferences` | [`UserPreferences`](#userpreferences) | User preferences after mutation. |

### `Mutation.userSetNamespaceCommitEmail`

Input type: `UserSetNamespaceCommitEmailInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusersetnamespacecommitemailemailid"></a>`emailId` | [`EmailID`](#emailid) | ID of the email to set. |
| <a id="mutationusersetnamespacecommitemailnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ID of the namespace to set the namespace commit email for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusersetnamespacecommitemailerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationusersetnamespacecommitemailnamespacecommitemail"></a>`namespaceCommitEmail` | [`NamespaceCommitEmail`](#namespacecommitemail) | User namespace commit email after mutation. |

### `Mutation.valueStreamCreate`

{{< details >}}
**Introduced** in GitLab 16.6.
**Status**: Experiment.
{{< /details >}}

Creates a value stream.

Input type: `ValueStreamCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamcreatename"></a>`name` | [`String!`](#string) | Value stream name. |
| <a id="mutationvaluestreamcreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace(project or group) the value stream is created in. |
| <a id="mutationvaluestreamcreatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | Value stream configuration. |
| <a id="mutationvaluestreamcreatestages"></a>`stages` | [`[CreateValueStreamStageInput!]`](#createvaluestreamstageinput) | Value stream stages. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvaluestreamcreatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | Created value stream. |

### `Mutation.valueStreamDestroy`

{{< details >}}
**Introduced** in GitLab 16.6.
**Status**: Experiment.
{{< /details >}}

Destroy a value stream.

Input type: `ValueStreamDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamdestroyid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | Global ID of the value stream to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvaluestreamdestroyvaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | Value stream deleted after mutation. |

### `Mutation.valueStreamUpdate`

{{< details >}}
**Introduced** in GitLab 16.6.
**Status**: Experiment.
{{< /details >}}

Updates a value stream.

Input type: `ValueStreamUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamupdateid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | Global ID of the value stream to update. |
| <a id="mutationvaluestreamupdatename"></a>`name` | [`String`](#string) | Value stream name. |
| <a id="mutationvaluestreamupdatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | Value stream configuration. |
| <a id="mutationvaluestreamupdatestages"></a>`stages` | [`[UpdateValueStreamStageInput!]`](#updatevaluestreamstageinput) | Value stream stages. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvaluestreamupdatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | Updated value stream. |

### `Mutation.verifiedNamespaceCreate`

Create a verified namespace and mark all child catalog resources with the passed verification level info.

Input type: `VerifiedNamespaceCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationverifiednamespacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationverifiednamespacecreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Root namespace path. |
| <a id="mutationverifiednamespacecreateverificationlevel"></a>`verificationLevel` | [`CiCatalogResourceVerificationLevel!`](#cicatalogresourceverificationlevel) | Verification level for a root namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationverifiednamespacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationverifiednamespacecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.vulnerabilitiesArchive`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

Input type: `VulnerabilitiesArchiveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesarchivedate"></a>`date` | [`Date!`](#date) | Last update date of vulnerabilities being archived. |
| <a id="mutationvulnerabilitiesarchiveprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project to attach the vulnerability to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesarchiveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitiesarchivestatus"></a>`status` | [`String!`](#string) | Status of the action. |

### `Mutation.vulnerabilitiesCreateIssue`

{{< details >}}
**Introduced** in GitLab 17.9.
**Status**: Experiment.
{{< /details >}}

Input type: `VulnerabilitiesCreateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiescreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiescreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the issue to. |
| <a id="mutationvulnerabilitiescreateissuevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | IDs of vulnerabilities to link to the given issue. Up to 100 can be provided. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiescreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiescreateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitiescreateissueissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |

### `Mutation.vulnerabilitiesDismiss`

Input type: `VulnerabilitiesDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesdismisscomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was dismissed (maximum 50,000 characters). |
| <a id="mutationvulnerabilitiesdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why vulnerability should be dismissed. |
| <a id="mutationvulnerabilitiesdismissvulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | IDs of the vulnerabilities to be dismissed (maximum 100 entries). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesdismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitiesdismissvulnerabilities"></a>`vulnerabilities` | [`[Vulnerability!]!`](#vulnerability) | Vulnerabilities after state change. |

### `Mutation.vulnerabilitiesRemoveAllFromProject`

Remove all Vulnerabilities and related information from a given project. [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/412602) in GitLab 16.7.

Input type: `VulnerabilitiesRemoveAllFromProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojectids"></a>`projectIds` | [`[ProjectID!]!`](#projectid) | IDs of project for which all Vulnerabilities should be removed. The deletion will happen in the background so the changes will not be visible immediately. |
| <a id="mutationvulnerabilitiesremoveallfromprojectresolvedondefaultbranch"></a>`resolvedOnDefaultBranch` | [`Boolean`](#boolean) | When set as `true`, deletes only the vulnerabilities no longer detected. When set as `false`, deletes only the vulnerabilities still detected. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesremoveallfromprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojects"></a>`projects` | [`[Project!]!`](#project) | Projects for which the deletion was scheduled. |

### `Mutation.vulnerabilitiesSeverityOverride`

Input type: `vulnerabilitiesSeverityOverrideInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesseverityoverridecomment"></a>`comment` | [`String!`](#string) | Comment why vulnerability severity was changed (maximum 50,000 characters). |
| <a id="mutationvulnerabilitiesseverityoverrideseverity"></a>`severity` | [`VulnerabilitySeverity!`](#vulnerabilityseverity) | New severity value for the severities. |
| <a id="mutationvulnerabilitiesseverityoverridevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | IDs of the vulnerabilities for which severity needs to be changed (maximum 100 entries). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesseverityoverrideerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitiesseverityoverridevulnerabilities"></a>`vulnerabilities` | [`[Vulnerability!]!`](#vulnerability) | Vulnerabilities after severity change. |

### `Mutation.vulnerabilityConfirm`

Input type: `VulnerabilityConfirmInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityconfirmcomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was confirmed (maximum 50,000 characters). |
| <a id="mutationvulnerabilityconfirmid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be confirmed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityconfirmerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilityconfirmvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityCreate`

Input type: `VulnerabilityCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitycreateconfirmedat"></a>`confirmedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to confirmed (defaults to creation time if status is `confirmed`). |
| <a id="mutationvulnerabilitycreatedescription"></a>`description` | [`String!`](#string) | Long text section that describes the vulnerability in more detail. |
| <a id="mutationvulnerabilitycreatedetectedat"></a>`detectedAt` | [`Time`](#time) | Timestamp of when the vulnerability was first detected (defaults to creation time). |
| <a id="mutationvulnerabilitycreatedismissedat"></a>`dismissedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to dismissed (defaults to creation time if status is `dismissed`). |
| <a id="mutationvulnerabilitycreateidentifiers"></a>`identifiers` | [`[VulnerabilityIdentifierInput!]!`](#vulnerabilityidentifierinput) | Array of CVE or CWE identifiers for the vulnerability. |
| <a id="mutationvulnerabilitycreatename"></a>`name` | [`String!`](#string) | Name of the vulnerability. |
| <a id="mutationvulnerabilitycreateproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the vulnerability to. |
| <a id="mutationvulnerabilitycreateresolvedat"></a>`resolvedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to resolved (defaults to creation time if status is `resolved`). |
| <a id="mutationvulnerabilitycreatescanner"></a>`scanner` | [`VulnerabilityScannerInput!`](#vulnerabilityscannerinput) | Information about the scanner used to discover the vulnerability. |
| <a id="mutationvulnerabilitycreateseverity"></a>`severity` | [`VulnerabilitySeverity`](#vulnerabilityseverity) | Severity of the vulnerability (defaults to `unknown`). |
| <a id="mutationvulnerabilitycreatesolution"></a>`solution` | [`String`](#string) | Instructions for how to fix the vulnerability. |
| <a id="mutationvulnerabilitycreatestate"></a>`state` | [`VulnerabilityState`](#vulnerabilitystate) | State of the vulnerability (defaults to `detected`). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitycreatevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability created. |

### `Mutation.vulnerabilityDismiss`

Input type: `VulnerabilityDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismisscomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was dismissed (maximum 50,000 characters). |
| <a id="mutationvulnerabilitydismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why vulnerability should be dismissed. |
| <a id="mutationvulnerabilitydismissid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitydismissvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityDismissFalsePositiveFlag`

{{< details >}}
**Introduced** in GitLab 18.6.
**Status**: Experiment.
{{< /details >}}

Dismiss a vulnerability false positive flag.

Input type: `VulnerabilityDismissFalsePositiveFlagInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissfalsepositiveflagclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismissfalsepositiveflagid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to dismiss false positive flag for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissfalsepositiveflagclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismissfalsepositiveflagerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitydismissfalsepositiveflagvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after dismissing false positive flag. |

### `Mutation.vulnerabilityExternalIssueLinkCreate`

Input type: `VulnerabilityExternalIssueLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternaltracker"></a>`externalTracker` | [`VulnerabilityExternalIssueLinkExternalTracker!`](#vulnerabilityexternalissuelinkexternaltracker) | External tracker type of the external issue link. |
| <a id="mutationvulnerabilityexternalissuelinkcreateid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability. |
| <a id="mutationvulnerabilityexternalissuelinkcreatelinktype"></a>`linkType` | [`VulnerabilityExternalIssueLinkType!`](#vulnerabilityexternalissuelinktype) | Type of the external issue link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternalissuelink"></a>`externalIssueLink` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | Created external issue link. |

### `Mutation.vulnerabilityExternalIssueLinkDestroy`

Input type: `VulnerabilityExternalIssueLinkDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkdestroyid"></a>`id` | [`VulnerabilitiesExternalIssueLinkID!`](#vulnerabilitiesexternalissuelinkid) | Global ID of the vulnerability external issue link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.vulnerabilityIssueLinkCreate`

Input type: `VulnerabilityIssueLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateissueid"></a>`issueId` | [`IssueID!`](#issueid) | ID of the issue to link to. |
| <a id="mutationvulnerabilityissuelinkcreatevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | IDs of vulnerabilities to link to the given issue. Up to 100 can be provided. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateissuelinks"></a>`issueLinks` | [`[VulnerabilityIssueLink!]`](#vulnerabilityissuelink) | Created issue links. |

### `Mutation.vulnerabilityLinkMergeRequest`

{{< details >}}
**Introduced** in GitLab 18.4.
**Status**: Experiment.
{{< /details >}}

Link a merge request to a vulnerability.

Input type: `VulnerabilityLinkMergeRequestInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitylinkmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitylinkmergerequestmergerequestid"></a>`mergeRequestId` | [`MergeRequestID!`](#mergerequestid) | ID of the merge request. |
| <a id="mutationvulnerabilitylinkmergerequestreadinessscore"></a>`readinessScore` | [`Float`](#float) | Confidence rating representing the estimated accuracy of the fix in the AI generated merge request. Decimal value between 0 and 1, with 1 being the highest. |
| <a id="mutationvulnerabilitylinkmergerequestvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitylinkmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitylinkmergerequesterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilitylinkmergerequestvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Updated vulnerability. |

### `Mutation.vulnerabilityResolve`

Input type: `VulnerabilityResolveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityresolvecomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was resolved (maximum 50,000 characters). |
| <a id="mutationvulnerabilityresolveid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be resolved. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityresolveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilityresolvevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityRevertToDetected`

Input type: `VulnerabilityRevertToDetectedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityreverttodetectedcomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was reverted to detected (maximum 50,000 characters). |
| <a id="mutationvulnerabilityreverttodetectedid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be reverted to detected. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilityreverttodetectedvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityUnlinkMergeRequest`

{{< details >}}
**Introduced** in GitLab 18.5.
**Status**: Experiment.
{{< /details >}}

Unlink a merge request from a vulnerability.

Input type: `VulnerabilityUnlinkMergeRequestInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityunlinkmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityunlinkmergerequestmergerequestid"></a>`mergeRequestId` | [`MergeRequestID!`](#mergerequestid) | ID of the merge request. |
| <a id="mutationvulnerabilityunlinkmergerequestvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityunlinkmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityunlinkmergerequesterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationvulnerabilityunlinkmergerequestvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Updated vulnerability. |

### `Mutation.wikiPageSubscribe`

{{< details >}}
**Introduced** in GitLab 18.1.
**Status**: Experiment.
{{< /details >}}

Input type: `WikiPageSubscribeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationwikipagesubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationwikipagesubscribeid"></a>`id` | [`WikiPageMetaID!`](#wikipagemetaid) | Global ID of the wiki page meta record. |
| <a id="mutationwikipagesubscribesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationwikipagesubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationwikipagesubscribeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationwikipagesubscribewikipage"></a>`wikiPage` | [`WikiPage`](#wikipage) | Wiki page after mutation. |

### `Mutation.workItemAddClosingMergeRequest`

{{< details >}}
**Introduced** in GitLab 17.1.
**Status**: Experiment.
{{< /details >}}

Adds a closing merge request to a work item.

Input type: `WorkItemAddClosingMergeRequestInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddclosingmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemaddclosingmergerequestcontextnamespacepath"></a>`contextNamespacePath` | [`ID`](#id) | Full path of the context namespace (project or group). Only project full paths are used to find a merge request using a short reference syntax like `!1`. Ignored for full references and URLs. Defaults to the namespace of the work item if not provided. |
| <a id="mutationworkitemaddclosingmergerequestid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemaddclosingmergerequestmergerequestreference"></a>`mergeRequestReference` | [`String!`](#string) | Merge request reference (short, full or URL). Example: `!1`, `project_full_path!1` or `https://gitlab.com/gitlab-org/gitlab/-/merge_requests/1`. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddclosingmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemaddclosingmergerequestclosingmergerequest"></a>`closingMergeRequest` | [`WorkItemClosingMergeRequest`](#workitemclosingmergerequest) | Closing merge request added to the work item. |
| <a id="mutationworkitemaddclosingmergerequesterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemaddclosingmergerequestworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Work item with new closing merge requests. |

### `Mutation.workItemAddLinkedItems`

{{< details >}}
**Introduced** in GitLab 16.3.
**Status**: Experiment.
{{< /details >}}

Add linked items to the work item.

Input type: `WorkItemAddLinkedItemsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemaddlinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemaddlinkeditemslinktype"></a>`linkType` | [`WorkItemRelatedLinkType`](#workitemrelatedlinktype) | Type of link. Defaults to `RELATED`. |
| <a id="mutationworkitemaddlinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | Global IDs of the items to link. Maximum number of IDs you can provide: 10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemaddlinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemaddlinkeditemsmessage"></a>`message` | [`String`](#string) | Linked items update result message. |
| <a id="mutationworkitemaddlinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemBulkMove`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Moves work items between projects or groups.

Input type: `WorkItemBulkMoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitembulkmoveids"></a>`ids` | [`[WorkItemID!]!`](#workitemid) | Global ID array of the work items that will be moved. IDs that the user can't move will be ignored. A max of 100 can be provided. |
| <a id="mutationworkitembulkmovesourcefullpath"></a>`sourceFullPath` | [`String!`](#string) | Full path of the source namespace. For example, `gitlab-org/gitlab-foss`. |
| <a id="mutationworkitembulkmovetargetfullpath"></a>`targetFullPath` | [`String!`](#string) | Full path of the target namespace. For example, `gitlab-org/gitlab-foss`. User paths are not supported. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitembulkmoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitembulkmovemovedworkitemcount"></a>`movedWorkItemCount` | [`Int`](#int) | Number of work items that were successfully moved. |

### `Mutation.workItemBulkUpdate`

{{< details >}}
**Introduced** in GitLab 17.4.
**Status**: Experiment.
{{< /details >}}

Allows updating several properties for a set of work items.

Input type: `WorkItemBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkupdateassigneeswidget"></a>`assigneesWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitembulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitembulkupdateconfidential"></a>`confidential` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitembulkupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the project or group (Premium and Ultimate only) containing the work items that will be updated. User paths are not supported. |
| <a id="mutationworkitembulkupdatehealthstatuswidget"></a>`healthStatusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitembulkupdatehierarchywidget"></a>`hierarchyWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetHierarchyCreateInput`](#workitemwidgethierarchycreateinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitembulkupdateids"></a>`ids` | [`[WorkItemID!]!`](#workitemid) | Global ID array of the work items that will be updated. IDs that the user can't update will be ignored. A max of 100 can be provided. |
| <a id="mutationworkitembulkupdateiterationwidget"></a>`iterationWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitembulkupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | Input for labels widget. |
| <a id="mutationworkitembulkupdatemilestonewidget"></a>`milestoneWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitembulkupdatestateevent"></a>`stateEvent` {{< icon name="warning-solid" >}} | [`WorkItemStateEvent`](#workitemstateevent) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitembulkupdatestatuswidget"></a>`statusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusInput`](#workitemwidgetstatusinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.3. |
| <a id="mutationworkitembulkupdatesubscriptionevent"></a>`subscriptionEvent` {{< icon name="warning-solid" >}} | [`WorkItemSubscriptionEvent`](#workitemsubscriptionevent) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitembulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitembulkupdateupdatedworkitemcount"></a>`updatedWorkItemCount` | [`Int`](#int) | Number of work items that were successfully updated. |

### `Mutation.workItemConvert`

{{< details >}}
**Introduced** in GitLab 15.11.
**Status**: Experiment.
{{< /details >}}

Converts the work item to a new type.

Input type: `WorkItemConvertInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemconvertid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemconvertworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | Global ID of the new work item type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemconverterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemconvertworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemCreate`

{{< details >}}
**Introduced** in GitLab 15.1.
**Status**: Experiment.
{{< /details >}}

Creates a work item.

Input type: `WorkItemCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | Input for assignees widget. |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | Input for color widget. |
| <a id="mutationworkitemcreateconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the work item confidentiality. |
| <a id="mutationworkitemcreatecreatesource"></a>`createSource` | [`String`](#string) | Source which triggered the creation of the work item. Used only for tracking purposes. |
| <a id="mutationworkitemcreatecreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the work item was created. Available only for admins and project owners. |
| <a id="mutationworkitemcreatecrmcontactswidget"></a>`crmContactsWidget` | [`WorkItemWidgetCrmContactsCreateInput`](#workitemwidgetcrmcontactscreateinput) | Input for CRM contacts widget. |
| <a id="mutationworkitemcreatecustomfieldswidget"></a>`customFieldsWidget` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldValueInputType!]`](#workitemwidgetcustomfieldvalueinputtype) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.10. |
| <a id="mutationworkitemcreatedescription"></a>`description` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: use description widget instead. Deprecated in GitLab 16.9. |
| <a id="mutationworkitemcreatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | Input for description widget. |
| <a id="mutationworkitemcreatediscussionstoresolve"></a>`discussionsToResolve` | [`WorkItemResolveDiscussionsInput`](#workitemresolvediscussionsinput) | Information required to resolve discussions in a noteable, when the work item is created. |
| <a id="mutationworkitemcreatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | Input for health status widget. |
| <a id="mutationworkitemcreatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyCreateInput`](#workitemwidgethierarchycreateinput) | Input for hierarchy widget. |
| <a id="mutationworkitemcreateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | Iteration widget of the work item. |
| <a id="mutationworkitemcreatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsCreateInput`](#workitemwidgetlabelscreateinput) | Input for labels widget. |
| <a id="mutationworkitemcreatelinkeditemswidget"></a>`linkedItemsWidget` | [`WorkItemWidgetLinkedItemsCreateInput`](#workitemwidgetlinkeditemscreateinput) | Input for linked items widget. |
| <a id="mutationworkitemcreatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | Input for milestone widget. |
| <a id="mutationworkitemcreatenamespacepath"></a>`namespacePath` | [`ID`](#id) | Full path of the namespace(project or group) the work item is created in. |
| <a id="mutationworkitemcreateprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **Deprecated**: Please use namespacePath instead. That will cover for both projects and groups. Deprecated in GitLab 15.10. |
| <a id="mutationworkitemcreatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | Input for start and due date widget. |
| <a id="mutationworkitemcreatestatuswidget"></a>`statusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusInput`](#workitemwidgetstatusinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.11. |
| <a id="mutationworkitemcreatetitle"></a>`title` | [`String!`](#string) | Title of the work item. |
| <a id="mutationworkitemcreatevulnerabilityid"></a>`vulnerabilityId` {{< icon name="warning-solid" >}} | [`VulnerabilityID`](#vulnerabilityid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.9. |
| <a id="mutationworkitemcreateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | Input for weight widget. |
| <a id="mutationworkitemcreateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | Global ID of a work item type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemcreateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Created work item. |

### `Mutation.workItemCreateFromTask`

{{< details >}}
**Introduced** in GitLab 15.1.
**Status**: Experiment.
{{< /details >}}

Creates a work item from a task in another work item's description.

Input type: `WorkItemCreateFromTaskInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatefromtaskid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemcreatefromtaskworkitemdata"></a>`workItemData` | [`WorkItemConvertTaskInput!`](#workitemconverttaskinput) | Arguments necessary to convert a task into a work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatefromtaskerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemcreatefromtasknewworkitem"></a>`newWorkItem` | [`WorkItem`](#workitem) | New work item created from task. |
| <a id="mutationworkitemcreatefromtaskworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemDelete`

{{< details >}}
**Introduced** in GitLab 15.1.
**Status**: Experiment.
{{< /details >}}

Deletes a work item.

Input type: `WorkItemDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeleteid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemdeletenamespace"></a>`namespace` | [`Namespace`](#namespace) | Namespace the deleted work item belonged to. |
| <a id="mutationworkitemdeleteproject"></a>`project` {{< icon name="warning-solid" >}} | [`Project`](#project) | **Deprecated**: Use `namespace`. Deprecated in GitLab 16.9. |

### `Mutation.workItemExport`

{{< details >}}
**Deprecated** in GitLab 18.0.
Use WorkItemsCsvExport.
{{< /details >}}

Input type: `WorkItemExportInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the work item (maximum is 100 usernames). |
| <a id="mutationworkitemexportassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | Filter by assignee wildcard. Incompatible with `assigneeUsernames`. |
| <a id="mutationworkitemexportauthorusername"></a>`authorUsername` | [`String`](#string) | Filter work items by author username. |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemexportclosedafter"></a>`closedAfter` | [`Time`](#time) | Work items closed after the date. |
| <a id="mutationworkitemexportclosedbefore"></a>`closedBefore` | [`Time`](#time) | Work items closed before the date. |
| <a id="mutationworkitemexportconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter for confidential work items. If `false`, excludes confidential work items. If `true`, returns only confidential work items. |
| <a id="mutationworkitemexportcreatedafter"></a>`createdAfter` | [`Time`](#time) | Work items created after the timestamp. |
| <a id="mutationworkitemexportcreatedbefore"></a>`createdBefore` | [`Time`](#time) | Work items created before the timestamp. |
| <a id="mutationworkitemexportcrmcontactid"></a>`crmContactId` | [`String`](#string) | Filter by ID of CRM contact. |
| <a id="mutationworkitemexportcrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | Filter by ID of CRM contact organization. |
| <a id="mutationworkitemexportdueafter"></a>`dueAfter` | [`Time`](#time) | Work items due after the timestamp. |
| <a id="mutationworkitemexportduebefore"></a>`dueBefore` | [`Time`](#time) | Work items due before the timestamp. |
| <a id="mutationworkitemexporthealthstatusfilter"></a>`healthStatusFilter` {{< icon name="warning-solid" >}} | [`HealthStatusFilter`](#healthstatusfilter) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemexporthierarchyfilters"></a>`hierarchyFilters` {{< icon name="warning-solid" >}} | [`HierarchyFilterInput`](#hierarchyfilterinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.3. |
| <a id="mutationworkitemexportids"></a>`ids` | [`[WorkItemID!]`](#workitemid) | Filter by global IDs of work items (maximum is 100 IDs). |
| <a id="mutationworkitemexportiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of work items. For example, `["1", "2"]` (maximum is 100 IIDs). |
| <a id="mutationworkitemexportin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="mutationworkitemexportincludedescendantworkitems"></a>`includeDescendantWorkItems` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.3. |
| <a id="mutationworkitemexportiterationcadenceid"></a>`iterationCadenceId` {{< icon name="warning-solid" >}} | [`[IterationsCadenceID!]`](#iterationscadenceid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemexportiterationid"></a>`iterationId` {{< icon name="warning-solid" >}} | [`[ID]`](#id) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemexportiterationwildcardid"></a>`iterationWildcardId` {{< icon name="warning-solid" >}} | [`IterationWildcardId`](#iterationwildcardid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemexportlabelname"></a>`labelName` | [`[String!]`](#string) | Labels applied to the work item (maximum is 100 labels). |
| <a id="mutationworkitemexportmilestonetitle"></a>`milestoneTitle` | [`[String!]`](#string) | Milestone applied to the work item (maximum is 100 milestones). |
| <a id="mutationworkitemexportmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | Filter by milestone ID wildcard. Incompatible with `milestoneTitle`. |
| <a id="mutationworkitemexportmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. Wildcard values `NONE` and `ANY` are supported. |
| <a id="mutationworkitemexportnot"></a>`not` | [`NegatedWorkItemFilterInput`](#negatedworkitemfilterinput) | Negated work item arguments. |
| <a id="mutationworkitemexportor"></a>`or` | [`UnionedWorkItemFilterInput`](#unionedworkitemfilterinput) | List of arguments with inclusive `OR`. |
| <a id="mutationworkitemexportparentids"></a>`parentIds` | [`[WorkItemID!]`](#workitemid) | Filter work items by global IDs of their parent items (maximum is 100 IDs). |
| <a id="mutationworkitemexportparentwildcardid"></a>`parentWildcardId` {{< icon name="warning-solid" >}} | [`WorkItemParentWildcardId`](#workitemparentwildcardid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.5. |
| <a id="mutationworkitemexportprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path. |
| <a id="mutationworkitemexportreleasetag"></a>`releaseTag` | [`[String!]`](#string) | Release tag associated with the work item's milestone (maximum is 100 tags). Ignored when parent is a group. |
| <a id="mutationworkitemexportreleasetagwildcardid"></a>`releaseTagWildcardId` | [`ReleaseTagWildcardId`](#releasetagwildcardid) | Filter by release tag wildcard. |
| <a id="mutationworkitemexportsearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="mutationworkitemexportselectedfields"></a>`selectedFields` | [`[AvailableExportFields!]`](#availableexportfields) | List of selected fields to be exported. Omit to export all available fields. |
| <a id="mutationworkitemexportstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of the work item. |
| <a id="mutationworkitemexportsubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | Work items the current user is subscribed to. |
| <a id="mutationworkitemexporttypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter work items by the given work item types. |
| <a id="mutationworkitemexportupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Work items updated after the timestamp. |
| <a id="mutationworkitemexportupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Work items updated before the timestamp. |
| <a id="mutationworkitemexportweight"></a>`weight` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemexportweightwildcardid"></a>`weightWildcardId` {{< icon name="warning-solid" >}} | [`WeightWildcardId`](#weightwildcardid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemexporterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemexportmessage"></a>`message` | [`String`](#string) | Export request result message. |

### `Mutation.workItemHierarchyAddChildrenItems`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Adds children to a given work item's hierarchy by Global ID.

Input type: `WorkItemHierarchyAddChildrenItemsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemhierarchyaddchildrenitemschildrenids"></a>`childrenIds` | [`[WorkItemID!]!`](#workitemid) | Global IDs of children work items. |
| <a id="mutationworkitemhierarchyaddchildrenitemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemhierarchyaddchildrenitemsid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemhierarchyaddchildrenitemsaddedchildren"></a>`addedChildren` | [`[WorkItem!]!`](#workitem) | Work items that were added as children. |
| <a id="mutationworkitemhierarchyaddchildrenitemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemhierarchyaddchildrenitemserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |

### `Mutation.workItemRemoveLinkedItems`

{{< details >}}
**Introduced** in GitLab 16.3.
**Status**: Experiment.
{{< /details >}}

Remove items linked to the work item.

Input type: `WorkItemRemoveLinkedItemsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemremovelinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemremovelinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | Global IDs of the items to unlink. Maximum number of IDs you can provide: 10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemremovelinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemremovelinkeditemsmessage"></a>`message` | [`String`](#string) | Linked items update result message. |
| <a id="mutationworkitemremovelinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemSubscribe`

{{< details >}}
**Introduced** in GitLab 16.3.
**Status**: Experiment.
{{< /details >}}

Input type: `WorkItemSubscribeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemsubscribeid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemsubscribesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemsubscribeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemsubscribeworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Work item after mutation. |

### `Mutation.workItemUpdate`

{{< details >}}
**Introduced** in GitLab 15.1.
**Status**: Experiment.
{{< /details >}}

Updates a work item by Global ID.

Input type: `WorkItemUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | Input for assignees widget. |
| <a id="mutationworkitemupdateawardemojiwidget"></a>`awardEmojiWidget` | [`WorkItemWidgetAwardEmojiUpdateInput`](#workitemwidgetawardemojiupdateinput) | Input for emoji reactions widget. |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | Input for color widget. |
| <a id="mutationworkitemupdateconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the work item confidentiality. |
| <a id="mutationworkitemupdatecrmcontactswidget"></a>`crmContactsWidget` | [`WorkItemWidgetCrmContactsUpdateInput`](#workitemwidgetcrmcontactsupdateinput) | Input for CRM contacts widget. |
| <a id="mutationworkitemupdatecurrentusertodoswidget"></a>`currentUserTodosWidget` | [`WorkItemWidgetCurrentUserTodosInput`](#workitemwidgetcurrentusertodosinput) | Input for to-dos widget. |
| <a id="mutationworkitemupdatecustomfieldswidget"></a>`customFieldsWidget` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldValueInputType!]`](#workitemwidgetcustomfieldvalueinputtype) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.10. |
| <a id="mutationworkitemupdatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | Input for description widget. |
| <a id="mutationworkitemupdatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | Input for health status widget. |
| <a id="mutationworkitemupdatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyUpdateInput`](#workitemwidgethierarchyupdateinput) | Input for hierarchy widget. |
| <a id="mutationworkitemupdateid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemupdateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | Input for iteration widget. |
| <a id="mutationworkitemupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | Input for labels widget. |
| <a id="mutationworkitemupdatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | Input for milestone widget. |
| <a id="mutationworkitemupdatenoteswidget"></a>`notesWidget` | [`WorkItemWidgetNotesInput`](#workitemwidgetnotesinput) | Input for notes widget. |
| <a id="mutationworkitemupdatenotificationswidget"></a>`notificationsWidget` | [`WorkItemWidgetNotificationsUpdateInput`](#workitemwidgetnotificationsupdateinput) | Input for notifications widget. |
| <a id="mutationworkitemupdateprogresswidget"></a>`progressWidget` | [`WorkItemWidgetProgressInput`](#workitemwidgetprogressinput) | Input for progress widget. |
| <a id="mutationworkitemupdatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | Input for start and due date widget. |
| <a id="mutationworkitemupdatestateevent"></a>`stateEvent` | [`WorkItemStateEvent`](#workitemstateevent) | Close or reopen a work item. |
| <a id="mutationworkitemupdatestatuswidget"></a>`statusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusInput`](#workitemwidgetstatusinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 17.11. |
| <a id="mutationworkitemupdatetimetrackingwidget"></a>`timeTrackingWidget` | [`WorkItemWidgetTimeTrackingInput`](#workitemwidgettimetrackinginput) | Input for time tracking widget. |
| <a id="mutationworkitemupdatetitle"></a>`title` | [`String`](#string) | Title of the work item. |
| <a id="mutationworkitemupdateverificationstatuswidget"></a>`verificationStatusWidget` | [`VerificationStatusInput`](#verificationstatusinput) | Input for verification status widget. |
| <a id="mutationworkitemupdateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | Input for weight widget. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemupdateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemUserPreferenceUpdate`

{{< details >}}
**Introduced** in GitLab 17.10.
**Status**: Experiment.
{{< /details >}}

Create or Update user preferences for a work item type and namespace.

Input type: `WorkItemUserPreferenceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemuserpreferenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemuserpreferenceupdatedisplaysettings"></a>`displaySettings` | [`JSON`](#json) | Display settings for the work item lists. |
| <a id="mutationworkitemuserpreferenceupdatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace on which the preference is set. |
| <a id="mutationworkitemuserpreferenceupdatesort"></a>`sort` | [`WorkItemSort`](#workitemsort) | Sort order for work item lists. |
| <a id="mutationworkitemuserpreferenceupdateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID`](#workitemstypeid) | Global ID of a work item type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemuserpreferenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemuserpreferenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemuserpreferenceupdateuserpreferences"></a>`userPreferences` | [`WorkItemTypesUserPreference`](#workitemtypesuserpreference) | User preferences. |

### `Mutation.workItemsCsvExport`

{{< details >}}
**Introduced** in GitLab 15.10.
**Status**: Experiment.
{{< /details >}}

Input type: `WorkItemsCsvExportInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvexportassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the work item (maximum is 100 usernames). |
| <a id="mutationworkitemscsvexportassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | Filter by assignee wildcard. Incompatible with `assigneeUsernames`. |
| <a id="mutationworkitemscsvexportauthorusername"></a>`authorUsername` | [`String`](#string) | Filter work items by author username. |
| <a id="mutationworkitemscsvexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemscsvexportclosedafter"></a>`closedAfter` | [`Time`](#time) | Work items closed after the date. |
| <a id="mutationworkitemscsvexportclosedbefore"></a>`closedBefore` | [`Time`](#time) | Work items closed before the date. |
| <a id="mutationworkitemscsvexportconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter for confidential work items. If `false`, excludes confidential work items. If `true`, returns only confidential work items. |
| <a id="mutationworkitemscsvexportcreatedafter"></a>`createdAfter` | [`Time`](#time) | Work items created after the timestamp. |
| <a id="mutationworkitemscsvexportcreatedbefore"></a>`createdBefore` | [`Time`](#time) | Work items created before the timestamp. |
| <a id="mutationworkitemscsvexportcrmcontactid"></a>`crmContactId` | [`String`](#string) | Filter by ID of CRM contact. |
| <a id="mutationworkitemscsvexportcrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | Filter by ID of CRM contact organization. |
| <a id="mutationworkitemscsvexportdueafter"></a>`dueAfter` | [`Time`](#time) | Work items due after the timestamp. |
| <a id="mutationworkitemscsvexportduebefore"></a>`dueBefore` | [`Time`](#time) | Work items due before the timestamp. |
| <a id="mutationworkitemscsvexporthealthstatusfilter"></a>`healthStatusFilter` {{< icon name="warning-solid" >}} | [`HealthStatusFilter`](#healthstatusfilter) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemscsvexporthierarchyfilters"></a>`hierarchyFilters` {{< icon name="warning-solid" >}} | [`HierarchyFilterInput`](#hierarchyfilterinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.3. |
| <a id="mutationworkitemscsvexportids"></a>`ids` | [`[WorkItemID!]`](#workitemid) | Filter by global IDs of work items (maximum is 100 IDs). |
| <a id="mutationworkitemscsvexportiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of work items. For example, `["1", "2"]` (maximum is 100 IIDs). |
| <a id="mutationworkitemscsvexportin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="mutationworkitemscsvexportincludedescendantworkitems"></a>`includeDescendantWorkItems` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.3. |
| <a id="mutationworkitemscsvexportiterationcadenceid"></a>`iterationCadenceId` {{< icon name="warning-solid" >}} | [`[IterationsCadenceID!]`](#iterationscadenceid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemscsvexportiterationid"></a>`iterationId` {{< icon name="warning-solid" >}} | [`[ID]`](#id) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemscsvexportiterationwildcardid"></a>`iterationWildcardId` {{< icon name="warning-solid" >}} | [`IterationWildcardId`](#iterationwildcardid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemscsvexportlabelname"></a>`labelName` | [`[String!]`](#string) | Labels applied to the work item (maximum is 100 labels). |
| <a id="mutationworkitemscsvexportmilestonetitle"></a>`milestoneTitle` | [`[String!]`](#string) | Milestone applied to the work item (maximum is 100 milestones). |
| <a id="mutationworkitemscsvexportmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | Filter by milestone ID wildcard. Incompatible with `milestoneTitle`. |
| <a id="mutationworkitemscsvexportmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. Wildcard values `NONE` and `ANY` are supported. |
| <a id="mutationworkitemscsvexportnot"></a>`not` | [`NegatedWorkItemFilterInput`](#negatedworkitemfilterinput) | Negated work item arguments. |
| <a id="mutationworkitemscsvexportor"></a>`or` | [`UnionedWorkItemFilterInput`](#unionedworkitemfilterinput) | List of arguments with inclusive `OR`. |
| <a id="mutationworkitemscsvexportparentids"></a>`parentIds` | [`[WorkItemID!]`](#workitemid) | Filter work items by global IDs of their parent items (maximum is 100 IDs). |
| <a id="mutationworkitemscsvexportparentwildcardid"></a>`parentWildcardId` {{< icon name="warning-solid" >}} | [`WorkItemParentWildcardId`](#workitemparentwildcardid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.5. |
| <a id="mutationworkitemscsvexportprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path. |
| <a id="mutationworkitemscsvexportreleasetag"></a>`releaseTag` | [`[String!]`](#string) | Release tag associated with the work item's milestone (maximum is 100 tags). Ignored when parent is a group. |
| <a id="mutationworkitemscsvexportreleasetagwildcardid"></a>`releaseTagWildcardId` | [`ReleaseTagWildcardId`](#releasetagwildcardid) | Filter by release tag wildcard. |
| <a id="mutationworkitemscsvexportsearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="mutationworkitemscsvexportselectedfields"></a>`selectedFields` | [`[AvailableExportFields!]`](#availableexportfields) | List of selected fields to be exported. Omit to export all available fields. |
| <a id="mutationworkitemscsvexportstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of the work item. |
| <a id="mutationworkitemscsvexportsubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | Work items the current user is subscribed to. |
| <a id="mutationworkitemscsvexporttypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter work items by the given work item types. |
| <a id="mutationworkitemscsvexportupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Work items updated after the timestamp. |
| <a id="mutationworkitemscsvexportupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Work items updated before the timestamp. |
| <a id="mutationworkitemscsvexportweight"></a>`weight` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |
| <a id="mutationworkitemscsvexportweightwildcardid"></a>`weightWildcardId` {{< icon name="warning-solid" >}} | [`WeightWildcardId`](#weightwildcardid) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.2. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemscsvexporterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemscsvexportmessage"></a>`message` | [`String`](#string) | Export request result message. |

### `Mutation.workItemsCsvImport`

{{< details >}}
**Introduced** in GitLab 18.2.
**Status**: Experiment.
{{< /details >}}

Input type: `WorkItemsCsvImportInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvimportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemscsvimportfile"></a>`file` | [`Upload!`](#upload) | CSV file to import work items from. |
| <a id="mutationworkitemscsvimportprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvimportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemscsvimporterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemscsvimportmessage"></a>`message` | [`String`](#string) | Import request result message. |

### `Mutation.workItemsHierarchyReorder`

{{< details >}}
**Introduced** in GitLab 17.3.
**Status**: Experiment.
{{< /details >}}

Reorder a work item in the hierarchy tree.

Input type: `workItemsHierarchyReorderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemshierarchyreorderadjacentworkitemid"></a>`adjacentWorkItemId` | [`WorkItemID`](#workitemid) | ID of the work item to move next to. For example, the item above or below. |
| <a id="mutationworkitemshierarchyreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemshierarchyreorderid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item to be reordered. |
| <a id="mutationworkitemshierarchyreorderparentid"></a>`parentId` | [`WorkItemID`](#workitemid) | Global ID of the new parent work item. |
| <a id="mutationworkitemshierarchyreorderrelativeposition"></a>`relativePosition` | [`RelativePositionType`](#relativepositiontype) | Position relative to the adjacent work item. Valid values are `BEFORE` or `AFTER`. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemshierarchyreorderadjacentworkitem"></a>`adjacentWorkItem` | [`WorkItem`](#workitem) | Adjacent work item after mutation. |
| <a id="mutationworkitemshierarchyreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemshierarchyreordererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemshierarchyreorderparentworkitem"></a>`parentWorkItem` | [`WorkItem`](#workitem) | Work item's parent after mutation. |
| <a id="mutationworkitemshierarchyreorderworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Work item after mutation. |

### `Mutation.workItemsReorder`

{{< details >}}
**Introduced** in GitLab 18.3.
**Status**: Experiment.
{{< /details >}}

Reorders a work item.

Input type: `workItemsReorderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemsreorderid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item to be reordered. |
| <a id="mutationworkitemsreordermoveafterid"></a>`moveAfterId` | [`WorkItemID`](#workitemid) | Global ID of a work item that should be placed after the work item. |
| <a id="mutationworkitemsreordermovebeforeid"></a>`moveBeforeId` | [`WorkItemID`](#workitemid) | Global ID of a work item that should be placed before the work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemsreordererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkitemsreorderworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Work item after mutation. |

### `Mutation.workspaceCreate`

Input type: `WorkspaceCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspacecreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent the created workspace will be associated with. |
| <a id="mutationworkspacecreatedesiredstate"></a>`desiredState` | [`String!`](#string) | Desired state of the created workspace. |
| <a id="mutationworkspacecreatedevfilepath"></a>`devfilePath` | [`String`](#string) | Project path containing the devfile used to configure the workspace. If not provided, the GitLab default devfile is used. |
| <a id="mutationworkspacecreatedevfileref"></a>`devfileRef` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: Argument is renamed to project_ref. Deprecated in GitLab 17.8. |
| <a id="mutationworkspacecreateeditor"></a>`editor` {{< icon name="warning-solid" >}} | [`String`](#string) | **Deprecated**: Argument is not used. Deprecated in GitLab 17.5. |
| <a id="mutationworkspacecreatemaxhoursbeforetermination"></a>`maxHoursBeforeTermination` {{< icon name="warning-solid" >}} | [`Int`](#int) | **Deprecated**: Field is not used. Deprecated in GitLab 17.9. |
| <a id="mutationworkspacecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project that will provide the Devfile for the created workspace. |
| <a id="mutationworkspacecreateprojectref"></a>`projectRef` | [`String`](#string) | Project repo git ref. |
| <a id="mutationworkspacecreatevariables"></a>`variables` {{< icon name="warning-solid" >}} | [`[WorkspaceVariableInput!]`](#workspacevariableinput) | **Deprecated**: Argument is renamed to workspace_variables. Deprecated in GitLab 18.0. |
| <a id="mutationworkspacecreateworkspacevariables"></a>`workspaceVariables` {{< icon name="warning-solid" >}} | [`[WorkspaceVariableInput!]`](#workspacevariableinput) | **Deprecated**: **Status**: Experiment. Introduced in GitLab 18.0. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspacecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkspacecreateworkspace"></a>`workspace` | [`Workspace`](#workspace) | Created workspace. |

### `Mutation.workspaceUpdate`

Input type: `WorkspaceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspaceupdatedesiredstate"></a>`desiredState` | [`String!`](#string) | Desired state of the created workspace. |
| <a id="mutationworkspaceupdateid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | Global ID of the workspace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspaceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during the mutation. |
| <a id="mutationworkspaceupdateworkspace"></a>`workspace` | [`Workspace`](#workspace) | Created workspace. |

## Connections

Some types in our schema are `Connection` types - they represent a paginated
collection of edges between two nodes in the graph. These follow the
[Relay cursor connections specification](https://relay.dev/graphql/connections.htm).

### Pagination arguments

All connection fields support the following pagination arguments:

| Name | Type | Description |
|------|------|-------------|
| `after` | [`String`](#string) | Returns the elements in the list that come after the specified cursor. |
| `before` | [`String`](#string) | Returns the elements in the list that come before the specified cursor. |
| `first` | [`Int`](#int) | Returns the first _n_ elements from the list. |
| `last` | [`Int`](#int) | Returns the last _n_ elements from the list. |

Since these arguments are common to all connection fields, they are not repeated for each connection.

### Connection fields

All connections have at least the following fields:

| Name | Type | Description |
|------|------|-------------|
| `pageInfo` | [`PageInfo!`](#pageinfo) | Pagination information. |
| `edges` | `[edge!]` | The edges. |
| `nodes` | `[item!]` | The items in the current page. |

The precise type of `Edge` and `Item` depends on the kind of connection. A
[`ProjectConnection`](#projectconnection) will have nodes that have the type
[`[Project!]`](#project), and edges that have the type [`ProjectEdge`](#projectedge).

### Connection types

Some of the types in the schema exist solely to model connections. Each connection
has a distinct, named type, with a distinct named edge type. These are listed separately
below.

#### `AccessLevelDeployKeyConnection`

The connection type for [`AccessLevelDeployKey`](#accessleveldeploykey).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyconnectionedges"></a>`edges` | [`[AccessLevelDeployKeyEdge]`](#accessleveldeploykeyedge) | A list of edges. |
| <a id="accessleveldeploykeyconnectionnodes"></a>`nodes` | [`[AccessLevelDeployKey]`](#accessleveldeploykey) | A list of nodes. |
| <a id="accessleveldeploykeyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AccessLevelDeployKeyEdge`

The edge type for [`AccessLevelDeployKey`](#accessleveldeploykey).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="accessleveldeploykeyedgenode"></a>`node` | [`AccessLevelDeployKey`](#accessleveldeploykey) | The item at the end of the edge. |

#### `AchievementConnection`

The connection type for [`Achievement`](#achievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="achievementconnectionedges"></a>`edges` | [`[AchievementEdge]`](#achievementedge) | A list of edges. |
| <a id="achievementconnectionnodes"></a>`nodes` | [`[Achievement]`](#achievement) | A list of nodes. |
| <a id="achievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AchievementEdge`

The edge type for [`Achievement`](#achievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="achievementedgenode"></a>`node` | [`Achievement`](#achievement) | The item at the end of the edge. |

#### `AddOnUserConnection`

The connection type for [`AddOnUser`](#addonuser).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="addonuserconnectionedges"></a>`edges` | [`[AddOnUserEdge]`](#addonuseredge) | A list of edges. |
| <a id="addonuserconnectionnodes"></a>`nodes` | [`[AddOnUser]`](#addonuser) | A list of nodes. |
| <a id="addonuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AddOnUserEdge`

The edge type for [`AddOnUser`](#addonuser).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuseredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="addonuseredgenode"></a>`node` | [`AddOnUser`](#addonuser) | The item at the end of the edge. |

#### `AdminMemberRoleConnection`

The connection type for [`AdminMemberRole`](#adminmemberrole).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="adminmemberroleconnectionedges"></a>`edges` | [`[AdminMemberRoleEdge]`](#adminmemberroleedge) | A list of edges. |
| <a id="adminmemberroleconnectionnodes"></a>`nodes` | [`[AdminMemberRole]`](#adminmemberrole) | A list of nodes. |
| <a id="adminmemberroleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AdminMemberRoleEdge`

The edge type for [`AdminMemberRole`](#adminmemberrole).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="adminmemberroleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="adminmemberroleedgenode"></a>`node` | [`AdminMemberRole`](#adminmemberrole) | The item at the end of the edge. |

#### `AgentConfigurationConnection`

The connection type for [`AgentConfiguration`](#agentconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationconnectionedges"></a>`edges` | [`[AgentConfigurationEdge]`](#agentconfigurationedge) | A list of edges. |
| <a id="agentconfigurationconnectionnodes"></a>`nodes` | [`[AgentConfiguration]`](#agentconfiguration) | A list of nodes. |
| <a id="agentconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AgentConfigurationEdge`

The edge type for [`AgentConfiguration`](#agentconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="agentconfigurationedgenode"></a>`node` | [`AgentConfiguration`](#agentconfiguration) | The item at the end of the edge. |

#### `AiAgentConnection`

The connection type for [`AiAgent`](#aiagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiagentconnectionedges"></a>`edges` | [`[AiAgentEdge]`](#aiagentedge) | A list of edges. |
| <a id="aiagentconnectionnodes"></a>`nodes` | [`[AiAgent]`](#aiagent) | A list of nodes. |
| <a id="aiagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiAgentEdge`

The edge type for [`AiAgent`](#aiagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiagentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aiagentedgenode"></a>`node` | [`AiAgent`](#aiagent) | The item at the end of the edge. |

#### `AiCatalogBuiltInToolConnection`

The connection type for [`AiCatalogBuiltInTool`](#aicatalogbuiltintool).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogbuiltintoolconnectionedges"></a>`edges` | [`[AiCatalogBuiltInToolEdge]`](#aicatalogbuiltintooledge) | A list of edges. |
| <a id="aicatalogbuiltintoolconnectionnodes"></a>`nodes` | [`[AiCatalogBuiltInTool]`](#aicatalogbuiltintool) | A list of nodes. |
| <a id="aicatalogbuiltintoolconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiCatalogBuiltInToolEdge`

The edge type for [`AiCatalogBuiltInTool`](#aicatalogbuiltintool).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogbuiltintooledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aicatalogbuiltintooledgenode"></a>`node` | [`AiCatalogBuiltInTool`](#aicatalogbuiltintool) | The item at the end of the edge. |

#### `AiCatalogFlowStepsConnection`

The connection type for [`AiCatalogFlowSteps`](#aicatalogflowsteps).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogflowstepsconnectionedges"></a>`edges` | [`[AiCatalogFlowStepsEdge]`](#aicatalogflowstepsedge) | A list of edges. |
| <a id="aicatalogflowstepsconnectionnodes"></a>`nodes` | [`[AiCatalogFlowSteps]`](#aicatalogflowsteps) | A list of nodes. |
| <a id="aicatalogflowstepsconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiCatalogFlowStepsEdge`

The edge type for [`AiCatalogFlowSteps`](#aicatalogflowsteps).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogflowstepsedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aicatalogflowstepsedgenode"></a>`node` | [`AiCatalogFlowSteps`](#aicatalogflowsteps) | The item at the end of the edge. |

#### `AiCatalogItemConnection`

The connection type for [`AiCatalogItem`](#aicatalogitem).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogitemconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="aicatalogitemconnectionedges"></a>`edges` | [`[AiCatalogItemEdge]`](#aicatalogitemedge) | A list of edges. |
| <a id="aicatalogitemconnectionnodes"></a>`nodes` | [`[AiCatalogItem]`](#aicatalogitem) | A list of nodes. |
| <a id="aicatalogitemconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiCatalogItemConsumerConnection`

The connection type for [`AiCatalogItemConsumer`](#aicatalogitemconsumer).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogitemconsumerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="aicatalogitemconsumerconnectionedges"></a>`edges` | [`[AiCatalogItemConsumerEdge]`](#aicatalogitemconsumeredge) | A list of edges. |
| <a id="aicatalogitemconsumerconnectionnodes"></a>`nodes` | [`[AiCatalogItemConsumer]`](#aicatalogitemconsumer) | A list of nodes. |
| <a id="aicatalogitemconsumerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiCatalogItemConsumerEdge`

The edge type for [`AiCatalogItemConsumer`](#aicatalogitemconsumer).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogitemconsumeredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aicatalogitemconsumeredgenode"></a>`node` | [`AiCatalogItemConsumer`](#aicatalogitemconsumer) | The item at the end of the edge. |

#### `AiCatalogItemEdge`

The edge type for [`AiCatalogItem`](#aicatalogitem).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogitemedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aicatalogitemedgenode"></a>`node` | [`AiCatalogItem`](#aicatalogitem) | The item at the end of the edge. |

#### `AiCatalogItemVersionConnection`

The connection type for [`AiCatalogItemVersion`](#aicatalogitemversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogitemversionconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="aicatalogitemversionconnectionedges"></a>`edges` | [`[AiCatalogItemVersionEdge]`](#aicatalogitemversionedge) | A list of edges. |
| <a id="aicatalogitemversionconnectionnodes"></a>`nodes` | [`[AiCatalogItemVersion]`](#aicatalogitemversion) | A list of nodes. |
| <a id="aicatalogitemversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiCatalogItemVersionEdge`

The edge type for [`AiCatalogItemVersion`](#aicatalogitemversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aicatalogitemversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aicatalogitemversionedgenode"></a>`node` | [`AiCatalogItemVersion`](#aicatalogitemversion) | The item at the end of the edge. |

#### `AiConversationsThreadConnection`

The connection type for [`AiConversationsThread`](#aiconversationsthread).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiconversationsthreadconnectionedges"></a>`edges` | [`[AiConversationsThreadEdge]`](#aiconversationsthreadedge) | A list of edges. |
| <a id="aiconversationsthreadconnectionnodes"></a>`nodes` | [`[AiConversationsThread]`](#aiconversationsthread) | A list of nodes. |
| <a id="aiconversationsthreadconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiConversationsThreadEdge`

The edge type for [`AiConversationsThread`](#aiconversationsthread).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiconversationsthreadedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aiconversationsthreadedgenode"></a>`node` | [`AiConversationsThread`](#aiconversationsthread) | The item at the end of the edge. |

#### `AiFeatureSettingConnection`

The connection type for [`AiFeatureSetting`](#aifeaturesetting).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aifeaturesettingconnectionedges"></a>`edges` | [`[AiFeatureSettingEdge]`](#aifeaturesettingedge) | A list of edges. |
| <a id="aifeaturesettingconnectionnodes"></a>`nodes` | [`[AiFeatureSetting]`](#aifeaturesetting) | A list of nodes. |
| <a id="aifeaturesettingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiFeatureSettingEdge`

The edge type for [`AiFeatureSetting`](#aifeaturesetting).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aifeaturesettingedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aifeaturesettingedgenode"></a>`node` | [`AiFeatureSetting`](#aifeaturesetting) | The item at the end of the edge. |

#### `AiFlowTriggerTypeConnection`

The connection type for [`AiFlowTriggerType`](#aiflowtriggertype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiflowtriggertypeconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="aiflowtriggertypeconnectionedges"></a>`edges` | [`[AiFlowTriggerTypeEdge]`](#aiflowtriggertypeedge) | A list of edges. |
| <a id="aiflowtriggertypeconnectionnodes"></a>`nodes` | [`[AiFlowTriggerType]`](#aiflowtriggertype) | A list of nodes. |
| <a id="aiflowtriggertypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiFlowTriggerTypeEdge`

The edge type for [`AiFlowTriggerType`](#aiflowtriggertype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiflowtriggertypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aiflowtriggertypeedgenode"></a>`node` | [`AiFlowTriggerType`](#aiflowtriggertype) | The item at the end of the edge. |

#### `AiFoundationalChatAgentConnection`

The connection type for [`AiFoundationalChatAgent`](#aifoundationalchatagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aifoundationalchatagentconnectionedges"></a>`edges` | [`[AiFoundationalChatAgentEdge]`](#aifoundationalchatagentedge) | A list of edges. |
| <a id="aifoundationalchatagentconnectionnodes"></a>`nodes` | [`[AiFoundationalChatAgent]`](#aifoundationalchatagent) | A list of nodes. |
| <a id="aifoundationalchatagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiFoundationalChatAgentEdge`

The edge type for [`AiFoundationalChatAgent`](#aifoundationalchatagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aifoundationalchatagentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aifoundationalchatagentedgenode"></a>`node` | [`AiFoundationalChatAgent`](#aifoundationalchatagent) | The item at the end of the edge. |

#### `AiMessageConnection`

The connection type for [`AiMessage`](#aimessage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessageconnectionedges"></a>`edges` | [`[AiMessageEdge]`](#aimessageedge) | A list of edges. |
| <a id="aimessageconnectionnodes"></a>`nodes` | [`[AiMessage]`](#aimessage) | A list of nodes. |
| <a id="aimessageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiMessageEdge`

The edge type for [`AiMessage`](#aimessage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aimessageedgenode"></a>`node` | [`AiMessage`](#aimessage) | The item at the end of the edge. |

#### `AiModelSelectionNamespaceFeatureSettingConnection`

The connection type for [`AiModelSelectionNamespaceFeatureSetting`](#aimodelselectionnamespacefeaturesetting).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimodelselectionnamespacefeaturesettingconnectionedges"></a>`edges` | [`[AiModelSelectionNamespaceFeatureSettingEdge]`](#aimodelselectionnamespacefeaturesettingedge) | A list of edges. |
| <a id="aimodelselectionnamespacefeaturesettingconnectionnodes"></a>`nodes` | [`[AiModelSelectionNamespaceFeatureSetting]`](#aimodelselectionnamespacefeaturesetting) | A list of nodes. |
| <a id="aimodelselectionnamespacefeaturesettingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiModelSelectionNamespaceFeatureSettingEdge`

The edge type for [`AiModelSelectionNamespaceFeatureSetting`](#aimodelselectionnamespacefeaturesetting).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimodelselectionnamespacefeaturesettingedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aimodelselectionnamespacefeaturesettingedgenode"></a>`node` | [`AiModelSelectionNamespaceFeatureSetting`](#aimodelselectionnamespacefeaturesetting) | The item at the end of the edge. |

#### `AiModelSelectionOfferedModelConnection`

The connection type for [`AiModelSelectionOfferedModel`](#aimodelselectionofferedmodel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimodelselectionofferedmodelconnectionedges"></a>`edges` | [`[AiModelSelectionOfferedModelEdge]`](#aimodelselectionofferedmodeledge) | A list of edges. |
| <a id="aimodelselectionofferedmodelconnectionnodes"></a>`nodes` | [`[AiModelSelectionOfferedModel]`](#aimodelselectionofferedmodel) | A list of nodes. |
| <a id="aimodelselectionofferedmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiModelSelectionOfferedModelEdge`

The edge type for [`AiModelSelectionOfferedModel`](#aimodelselectionofferedmodel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimodelselectionofferedmodeledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aimodelselectionofferedmodeledgenode"></a>`node` | [`AiModelSelectionOfferedModel`](#aimodelselectionofferedmodel) | The item at the end of the edge. |

#### `AiSelfHostedModelConnection`

The connection type for [`AiSelfHostedModel`](#aiselfhostedmodel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiselfhostedmodelconnectionedges"></a>`edges` | [`[AiSelfHostedModelEdge]`](#aiselfhostedmodeledge) | A list of edges. |
| <a id="aiselfhostedmodelconnectionnodes"></a>`nodes` | [`[AiSelfHostedModel]`](#aiselfhostedmodel) | A list of nodes. |
| <a id="aiselfhostedmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiSelfHostedModelEdge`

The edge type for [`AiSelfHostedModel`](#aiselfhostedmodel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiselfhostedmodeledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aiselfhostedmodeledgenode"></a>`node` | [`AiSelfHostedModel`](#aiselfhostedmodel) | The item at the end of the edge. |

#### `AiUsageEventConnection`

The connection type for [`AiUsageEvent`](#aiusageevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiusageeventconnectionedges"></a>`edges` | [`[AiUsageEventEdge]`](#aiusageeventedge) | A list of edges. |
| <a id="aiusageeventconnectionnodes"></a>`nodes` | [`[AiUsageEvent]`](#aiusageevent) | A list of nodes. |
| <a id="aiusageeventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiUsageEventEdge`

The edge type for [`AiUsageEvent`](#aiusageevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiusageeventedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aiusageeventedgenode"></a>`node` | [`AiUsageEvent`](#aiusageevent) | The item at the end of the edge. |

#### `AiUserMetricsConnection`

The connection type for [`AiUserMetrics`](#aiusermetrics).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiusermetricsconnectionedges"></a>`edges` | [`[AiUserMetricsEdge]`](#aiusermetricsedge) | A list of edges. |
| <a id="aiusermetricsconnectionnodes"></a>`nodes` | [`[AiUserMetrics]`](#aiusermetrics) | A list of nodes. |
| <a id="aiusermetricsconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiUserMetricsEdge`

The edge type for [`AiUserMetrics`](#aiusermetrics).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiusermetricsedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aiusermetricsedgenode"></a>`node` | [`AiUserMetrics`](#aiusermetrics) | The item at the end of the edge. |

#### `AiXrayReportConnection`

The connection type for [`AiXrayReport`](#aixrayreport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aixrayreportconnectionedges"></a>`edges` | [`[AiXrayReportEdge]`](#aixrayreportedge) | A list of edges. |
| <a id="aixrayreportconnectionnodes"></a>`nodes` | [`[AiXrayReport]`](#aixrayreport) | A list of nodes. |
| <a id="aixrayreportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiXrayReportEdge`

The edge type for [`AiXrayReport`](#aixrayreport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aixrayreportedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aixrayreportedgenode"></a>`node` | [`AiXrayReport`](#aixrayreport) | The item at the end of the edge. |

#### `AlertManagementAlertConnection`

The connection type for [`AlertManagementAlert`](#alertmanagementalert).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertconnectionedges"></a>`edges` | [`[AlertManagementAlertEdge]`](#alertmanagementalertedge) | A list of edges. |
| <a id="alertmanagementalertconnectionnodes"></a>`nodes` | [`[AlertManagementAlert]`](#alertmanagementalert) | A list of nodes. |
| <a id="alertmanagementalertconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementAlertEdge`

The edge type for [`AlertManagementAlert`](#alertmanagementalert).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementalertedgenode"></a>`node` | [`AlertManagementAlert`](#alertmanagementalert) | The item at the end of the edge. |

#### `AlertManagementHttpIntegrationConnection`

The connection type for [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationconnectionedges"></a>`edges` | [`[AlertManagementHttpIntegrationEdge]`](#alertmanagementhttpintegrationedge) | A list of edges. |
| <a id="alertmanagementhttpintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementHttpIntegration]`](#alertmanagementhttpintegration) | A list of nodes. |
| <a id="alertmanagementhttpintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementHttpIntegrationEdge`

The edge type for [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementhttpintegrationedgenode"></a>`node` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | The item at the end of the edge. |

#### `AlertManagementIntegrationConnection`

The connection type for [`AlertManagementIntegration`](#alertmanagementintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationconnectionedges"></a>`edges` | [`[AlertManagementIntegrationEdge]`](#alertmanagementintegrationedge) | A list of edges. |
| <a id="alertmanagementintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementIntegration]`](#alertmanagementintegration) | A list of nodes. |
| <a id="alertmanagementintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementIntegrationEdge`

The edge type for [`AlertManagementIntegration`](#alertmanagementintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementintegrationedgenode"></a>`node` | [`AlertManagementIntegration`](#alertmanagementintegration) | The item at the end of the edge. |

#### `AmazonS3ConfigurationTypeConnection`

The connection type for [`AmazonS3ConfigurationType`](#amazons3configurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeconnectionedges"></a>`edges` | [`[AmazonS3ConfigurationTypeEdge]`](#amazons3configurationtypeedge) | A list of edges. |
| <a id="amazons3configurationtypeconnectionnodes"></a>`nodes` | [`[AmazonS3ConfigurationType]`](#amazons3configurationtype) | A list of nodes. |
| <a id="amazons3configurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AmazonS3ConfigurationTypeEdge`

The edge type for [`AmazonS3ConfigurationType`](#amazons3configurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="amazons3configurationtypeedgenode"></a>`node` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | The item at the end of the edge. |

#### `ApprovalPolicyConnection`

The connection type for [`ApprovalPolicy`](#approvalpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalpolicyconnectionedges"></a>`edges` | [`[ApprovalPolicyEdge]`](#approvalpolicyedge) | A list of edges. |
| <a id="approvalpolicyconnectionnodes"></a>`nodes` | [`[ApprovalPolicy]`](#approvalpolicy) | A list of nodes. |
| <a id="approvalpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ApprovalPolicyEdge`

The edge type for [`ApprovalPolicy`](#approvalpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="approvalpolicyedgenode"></a>`node` | [`ApprovalPolicy`](#approvalpolicy) | The item at the end of the edge. |

#### `ApprovalProjectRuleConnection`

The connection type for [`ApprovalProjectRule`](#approvalprojectrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleconnectionedges"></a>`edges` | [`[ApprovalProjectRuleEdge]`](#approvalprojectruleedge) | A list of edges. |
| <a id="approvalprojectruleconnectionnodes"></a>`nodes` | [`[ApprovalProjectRule]`](#approvalprojectrule) | A list of nodes. |
| <a id="approvalprojectruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ApprovalProjectRuleEdge`

The edge type for [`ApprovalProjectRule`](#approvalprojectrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="approvalprojectruleedgenode"></a>`node` | [`ApprovalProjectRule`](#approvalprojectrule) | The item at the end of the edge. |

#### `AuditEventDefinitionConnection`

The connection type for [`AuditEventDefinition`](#auditeventdefinition).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionconnectionedges"></a>`edges` | [`[AuditEventDefinitionEdge]`](#auditeventdefinitionedge) | A list of edges. |
| <a id="auditeventdefinitionconnectionnodes"></a>`nodes` | [`[AuditEventDefinition]`](#auditeventdefinition) | A list of nodes. |
| <a id="auditeventdefinitionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AuditEventDefinitionEdge`

The edge type for [`AuditEventDefinition`](#auditeventdefinition).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="auditeventdefinitionedgenode"></a>`node` | [`AuditEventDefinition`](#auditeventdefinition) | The item at the end of the edge. |

#### `AuditEventStreamingHeaderConnection`

The connection type for [`AuditEventStreamingHeader`](#auditeventstreamingheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderconnectionedges"></a>`edges` | [`[AuditEventStreamingHeaderEdge]`](#auditeventstreamingheaderedge) | A list of edges. |
| <a id="auditeventstreamingheaderconnectionnodes"></a>`nodes` | [`[AuditEventStreamingHeader]`](#auditeventstreamingheader) | A list of nodes. |
| <a id="auditeventstreamingheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AuditEventStreamingHeaderEdge`

The edge type for [`AuditEventStreamingHeader`](#auditeventstreamingheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="auditeventstreamingheaderedgenode"></a>`node` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | The item at the end of the edge. |

#### `AuditEventsStreamingInstanceHeaderConnection`

The connection type for [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderconnectionedges"></a>`edges` | [`[AuditEventsStreamingInstanceHeaderEdge]`](#auditeventsstreaminginstanceheaderedge) | A list of edges. |
| <a id="auditeventsstreaminginstanceheaderconnectionnodes"></a>`nodes` | [`[AuditEventsStreamingInstanceHeader]`](#auditeventsstreaminginstanceheader) | A list of nodes. |
| <a id="auditeventsstreaminginstanceheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AuditEventsStreamingInstanceHeaderEdge`

The edge type for [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="auditeventsstreaminginstanceheaderedgenode"></a>`node` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | The item at the end of the edge. |

#### `AwardEmojiConnection`

The connection type for [`AwardEmoji`](#awardemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojiconnectionedges"></a>`edges` | [`[AwardEmojiEdge]`](#awardemojiedge) | A list of edges. |
| <a id="awardemojiconnectionnodes"></a>`nodes` | [`[AwardEmoji]`](#awardemoji) | A list of nodes. |
| <a id="awardemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AwardEmojiEdge`

The edge type for [`AwardEmoji`](#awardemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojiedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="awardemojiedgenode"></a>`node` | [`AwardEmoji`](#awardemoji) | The item at the end of the edge. |

#### `BlobConnection`

The connection type for [`Blob`](#blob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobconnectionedges"></a>`edges` | [`[BlobEdge]`](#blobedge) | A list of edges. |
| <a id="blobconnectionnodes"></a>`nodes` | [`[Blob]`](#blob) | A list of nodes. |
| <a id="blobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BlobEdge`

The edge type for [`Blob`](#blob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="blobedgenode"></a>`node` | [`Blob`](#blob) | The item at the end of the edge. |

#### `BoardConnection`

The connection type for [`Board`](#board).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardconnectionedges"></a>`edges` | [`[BoardEdge]`](#boardedge) | A list of edges. |
| <a id="boardconnectionnodes"></a>`nodes` | [`[Board]`](#board) | A list of nodes. |
| <a id="boardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardEdge`

The edge type for [`Board`](#board).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardedgenode"></a>`node` | [`Board`](#board) | The item at the end of the edge. |

#### `BoardEpicConnection`

The connection type for [`BoardEpic`](#boardepic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="boardepicconnectionedges"></a>`edges` | [`[BoardEpicEdge]`](#boardepicedge) | A list of edges. |
| <a id="boardepicconnectionnodes"></a>`nodes` | [`[BoardEpic]`](#boardepic) | A list of nodes. |
| <a id="boardepicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardEpicEdge`

The edge type for [`BoardEpic`](#boardepic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardepicedgenode"></a>`node` | [`BoardEpic`](#boardepic) | The item at the end of the edge. |

#### `BoardListConnection`

The connection type for [`BoardList`](#boardlist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistconnectionedges"></a>`edges` | [`[BoardListEdge]`](#boardlistedge) | A list of edges. |
| <a id="boardlistconnectionnodes"></a>`nodes` | [`[BoardList]`](#boardlist) | A list of nodes. |
| <a id="boardlistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardListEdge`

The edge type for [`BoardList`](#boardlist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardlistedgenode"></a>`node` | [`BoardList`](#boardlist) | The item at the end of the edge. |

#### `BranchRuleConnection`

The connection type for [`BranchRule`](#branchrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleconnectionedges"></a>`edges` | [`[BranchRuleEdge]`](#branchruleedge) | A list of edges. |
| <a id="branchruleconnectionnodes"></a>`nodes` | [`[BranchRule]`](#branchrule) | A list of nodes. |
| <a id="branchruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BranchRuleEdge`

The edge type for [`BranchRule`](#branchrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="branchruleedgenode"></a>`node` | [`BranchRule`](#branchrule) | The item at the end of the edge. |

#### `CiBuildNeedConnection`

The connection type for [`CiBuildNeed`](#cibuildneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneedconnectionedges"></a>`edges` | [`[CiBuildNeedEdge]`](#cibuildneededge) | A list of edges. |
| <a id="cibuildneedconnectionnodes"></a>`nodes` | [`[CiBuildNeed]`](#cibuildneed) | A list of nodes. |
| <a id="cibuildneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiBuildNeedEdge`

The edge type for [`CiBuildNeed`](#cibuildneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneededgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cibuildneededgenode"></a>`node` | [`CiBuildNeed`](#cibuildneed) | The item at the end of the edge. |

#### `CiCatalogResourceComponentConnection`

The connection type for [`CiCatalogResourceComponent`](#cicatalogresourcecomponent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentconnectionedges"></a>`edges` | [`[CiCatalogResourceComponentEdge]`](#cicatalogresourcecomponentedge) | A list of edges. |
| <a id="cicatalogresourcecomponentconnectionnodes"></a>`nodes` | [`[CiCatalogResourceComponent]`](#cicatalogresourcecomponent) | A list of nodes. |
| <a id="cicatalogresourcecomponentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceComponentEdge`

The edge type for [`CiCatalogResourceComponent`](#cicatalogresourcecomponent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourcecomponentedgenode"></a>`node` | [`CiCatalogResourceComponent`](#cicatalogresourcecomponent) | The item at the end of the edge. |

#### `CiCatalogResourceComponentUsageConnection`

The connection type for [`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentusageconnectionedges"></a>`edges` | [`[CiCatalogResourceComponentUsageEdge]`](#cicatalogresourcecomponentusageedge) | A list of edges. |
| <a id="cicatalogresourcecomponentusageconnectionnodes"></a>`nodes` | [`[CiCatalogResourceComponentUsage]`](#cicatalogresourcecomponentusage) | A list of nodes. |
| <a id="cicatalogresourcecomponentusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceComponentUsageEdge`

The edge type for [`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourcecomponentusageedgenode"></a>`node` | [`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage) | The item at the end of the edge. |

#### `CiCatalogResourceConnection`

The connection type for [`CiCatalogResource`](#cicatalogresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cicatalogresourceconnectionedges"></a>`edges` | [`[CiCatalogResourceEdge]`](#cicatalogresourceedge) | A list of edges. |
| <a id="cicatalogresourceconnectionnodes"></a>`nodes` | [`[CiCatalogResource]`](#cicatalogresource) | A list of nodes. |
| <a id="cicatalogresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceEdge`

The edge type for [`CiCatalogResource`](#cicatalogresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourceedgenode"></a>`node` | [`CiCatalogResource`](#cicatalogresource) | The item at the end of the edge. |

#### `CiCatalogResourceVersionConnection`

The connection type for [`CiCatalogResourceVersion`](#cicatalogresourceversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cicatalogresourceversionconnectionedges"></a>`edges` | [`[CiCatalogResourceVersionEdge]`](#cicatalogresourceversionedge) | A list of edges. |
| <a id="cicatalogresourceversionconnectionnodes"></a>`nodes` | [`[CiCatalogResourceVersion]`](#cicatalogresourceversion) | A list of nodes. |
| <a id="cicatalogresourceversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceVersionEdge`

The edge type for [`CiCatalogResourceVersion`](#cicatalogresourceversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourceversionedgenode"></a>`node` | [`CiCatalogResourceVersion`](#cicatalogresourceversion) | The item at the end of the edge. |

#### `CiConfigGroupConnection`

The connection type for [`CiConfigGroup`](#ciconfiggroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupconnectionedges"></a>`edges` | [`[CiConfigGroupEdge]`](#ciconfiggroupedge) | A list of edges. |
| <a id="ciconfiggroupconnectionnodes"></a>`nodes` | [`[CiConfigGroup]`](#ciconfiggroup) | A list of nodes. |
| <a id="ciconfiggroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigGroupEdge`

The edge type for [`CiConfigGroup`](#ciconfiggroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfiggroupedgenode"></a>`node` | [`CiConfigGroup`](#ciconfiggroup) | The item at the end of the edge. |

#### `CiConfigJobConnection`

The connection type for [`CiConfigJob`](#ciconfigjob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobconnectionedges"></a>`edges` | [`[CiConfigJobEdge]`](#ciconfigjobedge) | A list of edges. |
| <a id="ciconfigjobconnectionnodes"></a>`nodes` | [`[CiConfigJob]`](#ciconfigjob) | A list of nodes. |
| <a id="ciconfigjobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigJobEdge`

The edge type for [`CiConfigJob`](#ciconfigjob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigjobedgenode"></a>`node` | [`CiConfigJob`](#ciconfigjob) | The item at the end of the edge. |

#### `CiConfigNeedConnection`

The connection type for [`CiConfigNeed`](#ciconfigneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneedconnectionedges"></a>`edges` | [`[CiConfigNeedEdge]`](#ciconfigneededge) | A list of edges. |
| <a id="ciconfigneedconnectionnodes"></a>`nodes` | [`[CiConfigNeed]`](#ciconfigneed) | A list of nodes. |
| <a id="ciconfigneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigNeedEdge`

The edge type for [`CiConfigNeed`](#ciconfigneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneededgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigneededgenode"></a>`node` | [`CiConfigNeed`](#ciconfigneed) | The item at the end of the edge. |

#### `CiConfigStageConnection`

The connection type for [`CiConfigStage`](#ciconfigstage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstageconnectionedges"></a>`edges` | [`[CiConfigStageEdge]`](#ciconfigstageedge) | A list of edges. |
| <a id="ciconfigstageconnectionnodes"></a>`nodes` | [`[CiConfigStage]`](#ciconfigstage) | A list of nodes. |
| <a id="ciconfigstageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigStageEdge`

The edge type for [`CiConfigStage`](#ciconfigstage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigstageedgenode"></a>`node` | [`CiConfigStage`](#ciconfigstage) | The item at the end of the edge. |

#### `CiDedicatedHostedRunnerUsageConnection`

The connection type for [`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cidedicatedhostedrunnerusageconnectionedges"></a>`edges` | [`[CiDedicatedHostedRunnerUsageEdge]`](#cidedicatedhostedrunnerusageedge) | A list of edges. |
| <a id="cidedicatedhostedrunnerusageconnectionnodes"></a>`nodes` | [`[CiDedicatedHostedRunnerUsage]`](#cidedicatedhostedrunnerusage) | A list of nodes. |
| <a id="cidedicatedhostedrunnerusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiDedicatedHostedRunnerUsageEdge`

The edge type for [`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cidedicatedhostedrunnerusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cidedicatedhostedrunnerusageedgenode"></a>`node` | [`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage) | The item at the end of the edge. |

#### `CiDeletedRunnerConnection`

The connection type for [`CiDeletedRunner`](#cideletedrunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cideletedrunnerconnectionedges"></a>`edges` | [`[CiDeletedRunnerEdge]`](#cideletedrunneredge) | A list of edges. |
| <a id="cideletedrunnerconnectionnodes"></a>`nodes` | [`[CiDeletedRunner]`](#cideletedrunner) | A list of nodes. |
| <a id="cideletedrunnerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiDeletedRunnerEdge`

The edge type for [`CiDeletedRunner`](#cideletedrunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cideletedrunneredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cideletedrunneredgenode"></a>`node` | [`CiDeletedRunner`](#cideletedrunner) | The item at the end of the edge. |

#### `CiGroupConnection`

The connection type for [`CiGroup`](#cigroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupconnectionedges"></a>`edges` | [`[CiGroupEdge]`](#cigroupedge) | A list of edges. |
| <a id="cigroupconnectionnodes"></a>`nodes` | [`[CiGroup]`](#cigroup) | A list of nodes. |
| <a id="cigroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupEdge`

The edge type for [`CiGroup`](#cigroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupedgenode"></a>`node` | [`CiGroup`](#cigroup) | The item at the end of the edge. |

#### `CiGroupEnvironmentScopeConnection`

The connection type for [`CiGroupEnvironmentScope`](#cigroupenvironmentscope).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeconnectionedges"></a>`edges` | [`[CiGroupEnvironmentScopeEdge]`](#cigroupenvironmentscopeedge) | A list of edges. |
| <a id="cigroupenvironmentscopeconnectionnodes"></a>`nodes` | [`[CiGroupEnvironmentScope]`](#cigroupenvironmentscope) | A list of nodes. |
| <a id="cigroupenvironmentscopeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupEnvironmentScopeEdge`

The edge type for [`CiGroupEnvironmentScope`](#cigroupenvironmentscope).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupenvironmentscopeedgenode"></a>`node` | [`CiGroupEnvironmentScope`](#cigroupenvironmentscope) | The item at the end of the edge. |

#### `CiGroupVariableConnection`

The connection type for [`CiGroupVariable`](#cigroupvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariableconnectionedges"></a>`edges` | [`[CiGroupVariableEdge]`](#cigroupvariableedge) | A list of edges. |
| <a id="cigroupvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | Maximum amount of group CI/CD variables. |
| <a id="cigroupvariableconnectionnodes"></a>`nodes` | [`[CiGroupVariable]`](#cigroupvariable) | A list of nodes. |
| <a id="cigroupvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupVariableEdge`

The edge type for [`CiGroupVariable`](#cigroupvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupvariableedgenode"></a>`node` | [`CiGroupVariable`](#cigroupvariable) | The item at the end of the edge. |

#### `CiInputsFieldConnection`

The connection type for [`CiInputsField`](#ciinputsfield).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinputsfieldconnectionedges"></a>`edges` | [`[CiInputsFieldEdge]`](#ciinputsfieldedge) | A list of edges. |
| <a id="ciinputsfieldconnectionnodes"></a>`nodes` | [`[CiInputsField]`](#ciinputsfield) | A list of nodes. |
| <a id="ciinputsfieldconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiInputsFieldEdge`

The edge type for [`CiInputsField`](#ciinputsfield).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinputsfieldedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciinputsfieldedgenode"></a>`node` | [`CiInputsField`](#ciinputsfield) | The item at the end of the edge. |

#### `CiInstanceVariableConnection`

The connection type for [`CiInstanceVariable`](#ciinstancevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableconnectionedges"></a>`edges` | [`[CiInstanceVariableEdge]`](#ciinstancevariableedge) | A list of edges. |
| <a id="ciinstancevariableconnectionnodes"></a>`nodes` | [`[CiInstanceVariable]`](#ciinstancevariable) | A list of nodes. |
| <a id="ciinstancevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiInstanceVariableEdge`

The edge type for [`CiInstanceVariable`](#ciinstancevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciinstancevariableedgenode"></a>`node` | [`CiInstanceVariable`](#ciinstancevariable) | The item at the end of the edge. |

#### `CiJobAnalyticsConnection`

The connection type for [`CiJobAnalytics`](#cijobanalytics).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobanalyticsconnectionedges"></a>`edges` | [`[CiJobAnalyticsEdge]`](#cijobanalyticsedge) | A list of edges. |
| <a id="cijobanalyticsconnectionnodes"></a>`nodes` | [`[CiJobAnalytics]`](#cijobanalytics) | A list of nodes. |
| <a id="cijobanalyticsconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobAnalyticsEdge`

The edge type for [`CiJobAnalytics`](#cijobanalytics).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobanalyticsedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobanalyticsedgenode"></a>`node` | [`CiJobAnalytics`](#cijobanalytics) | The item at the end of the edge. |

#### `CiJobArtifactConnection`

The connection type for [`CiJobArtifact`](#cijobartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactconnectionedges"></a>`edges` | [`[CiJobArtifactEdge]`](#cijobartifactedge) | A list of edges. |
| <a id="cijobartifactconnectionnodes"></a>`nodes` | [`[CiJobArtifact]`](#cijobartifact) | A list of nodes. |
| <a id="cijobartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobArtifactEdge`

The edge type for [`CiJobArtifact`](#cijobartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobartifactedgenode"></a>`node` | [`CiJobArtifact`](#cijobartifact) | The item at the end of the edge. |

#### `CiJobConnection`

The connection type for [`CiJob`](#cijob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobconnectionedges"></a>`edges` | [`[CiJobEdge]`](#cijobedge) | A list of edges. |
| <a id="cijobconnectionnodes"></a>`nodes` | [`[CiJob]`](#cijob) | A list of nodes. |
| <a id="cijobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `CiJobConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `CiJobEdge`

The edge type for [`CiJob`](#cijob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobedgenode"></a>`node` | [`CiJob`](#cijob) | The item at the end of the edge. |

#### `CiJobInterfaceConnection`

The connection type for [`CiJobInterface`](#cijobinterface).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobinterfaceconnectionedges"></a>`edges` | [`[CiJobInterfaceEdge]`](#cijobinterfaceedge) | A list of edges. |
| <a id="cijobinterfaceconnectionnodes"></a>`nodes` | [`[CiJobInterface]`](#cijobinterface) | A list of nodes. |
| <a id="cijobinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `CiJobInterfaceConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobinterfaceconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `CiJobInterfaceEdge`

The edge type for [`CiJobInterface`](#cijobinterface).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobinterfaceedgenode"></a>`node` | [`CiJobInterface`](#cijobinterface) | The item at the end of the edge. |

#### `CiJobTokenAccessibleGroupConnection`

The connection type for [`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessiblegroupconnectionedges"></a>`edges` | [`[CiJobTokenAccessibleGroupEdge]`](#cijobtokenaccessiblegroupedge) | A list of edges. |
| <a id="cijobtokenaccessiblegroupconnectionnodes"></a>`nodes` | [`[CiJobTokenAccessibleGroup]`](#cijobtokenaccessiblegroup) | A list of nodes. |
| <a id="cijobtokenaccessiblegroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobTokenAccessibleGroupEdge`

The edge type for [`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessiblegroupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobtokenaccessiblegroupedgenode"></a>`node` | [`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup) | The item at the end of the edge. |

#### `CiJobTokenAccessibleProjectConnection`

The connection type for [`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessibleprojectconnectionedges"></a>`edges` | [`[CiJobTokenAccessibleProjectEdge]`](#cijobtokenaccessibleprojectedge) | A list of edges. |
| <a id="cijobtokenaccessibleprojectconnectionnodes"></a>`nodes` | [`[CiJobTokenAccessibleProject]`](#cijobtokenaccessibleproject) | A list of nodes. |
| <a id="cijobtokenaccessibleprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobTokenAccessibleProjectEdge`

The edge type for [`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessibleprojectedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobtokenaccessibleprojectedgenode"></a>`node` | [`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject) | The item at the end of the edge. |

#### `CiJobTokenAuthLogConnection`

The connection type for [`CiJobTokenAuthLog`](#cijobtokenauthlog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenauthlogconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cijobtokenauthlogconnectionedges"></a>`edges` | [`[CiJobTokenAuthLogEdge]`](#cijobtokenauthlogedge) | A list of edges. |
| <a id="cijobtokenauthlogconnectionnodes"></a>`nodes` | [`[CiJobTokenAuthLog]`](#cijobtokenauthlog) | A list of nodes. |
| <a id="cijobtokenauthlogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobTokenAuthLogEdge`

The edge type for [`CiJobTokenAuthLog`](#cijobtokenauthlog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenauthlogedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobtokenauthlogedgenode"></a>`node` | [`CiJobTokenAuthLog`](#cijobtokenauthlog) | The item at the end of the edge. |

#### `CiJobTokenScopeAllowlistEntryConnection`

The connection type for [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopeallowlistentryconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cijobtokenscopeallowlistentryconnectionedges"></a>`edges` | [`[CiJobTokenScopeAllowlistEntryEdge]`](#cijobtokenscopeallowlistentryedge) | A list of edges. |
| <a id="cijobtokenscopeallowlistentryconnectionnodes"></a>`nodes` | [`[CiJobTokenScopeAllowlistEntry]`](#cijobtokenscopeallowlistentry) | A list of nodes. |
| <a id="cijobtokenscopeallowlistentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobTokenScopeAllowlistEntryEdge`

The edge type for [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopeallowlistentryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobtokenscopeallowlistentryedgenode"></a>`node` | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | The item at the end of the edge. |

#### `CiManualVariableConnection`

The connection type for [`CiManualVariable`](#cimanualvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableconnectionedges"></a>`edges` | [`[CiManualVariableEdge]`](#cimanualvariableedge) | A list of edges. |
| <a id="cimanualvariableconnectionnodes"></a>`nodes` | [`[CiManualVariable]`](#cimanualvariable) | A list of nodes. |
| <a id="cimanualvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiManualVariableEdge`

The edge type for [`CiManualVariable`](#cimanualvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cimanualvariableedgenode"></a>`node` | [`CiManualVariable`](#cimanualvariable) | The item at the end of the edge. |

#### `CiMinutesNamespaceMonthlyUsageConnection`

The connection type for [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesNamespaceMonthlyUsageEdge]`](#ciminutesnamespacemonthlyusageedge) | A list of edges. |
| <a id="ciminutesnamespacemonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesNamespaceMonthlyUsage]`](#ciminutesnamespacemonthlyusage) | A list of nodes. |
| <a id="ciminutesnamespacemonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiMinutesNamespaceMonthlyUsageEdge`

The edge type for [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciminutesnamespacemonthlyusageedgenode"></a>`node` | [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage) | The item at the end of the edge. |

#### `CiMinutesProjectMonthlyUsageConnection`

The connection type for [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesProjectMonthlyUsageEdge]`](#ciminutesprojectmonthlyusageedge) | A list of edges. |
| <a id="ciminutesprojectmonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesProjectMonthlyUsage]`](#ciminutesprojectmonthlyusage) | A list of nodes. |
| <a id="ciminutesprojectmonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiMinutesProjectMonthlyUsageEdge`

The edge type for [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciminutesprojectmonthlyusageedgenode"></a>`node` | [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage) | The item at the end of the edge. |

#### `CiProjectSubscriptionConnection`

The connection type for [`CiProjectSubscription`](#ciprojectsubscription).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectsubscriptionconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="ciprojectsubscriptionconnectionedges"></a>`edges` | [`[CiProjectSubscriptionEdge]`](#ciprojectsubscriptionedge) | A list of edges. |
| <a id="ciprojectsubscriptionconnectionnodes"></a>`nodes` | [`[CiProjectSubscription]`](#ciprojectsubscription) | A list of nodes. |
| <a id="ciprojectsubscriptionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiProjectSubscriptionEdge`

The edge type for [`CiProjectSubscription`](#ciprojectsubscription).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectsubscriptionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciprojectsubscriptionedgenode"></a>`node` | [`CiProjectSubscription`](#ciprojectsubscription) | The item at the end of the edge. |

#### `CiProjectVariableConnection`

The connection type for [`CiProjectVariable`](#ciprojectvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableconnectionedges"></a>`edges` | [`[CiProjectVariableEdge]`](#ciprojectvariableedge) | A list of edges. |
| <a id="ciprojectvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | Maximum amount of project CI/CD variables. |
| <a id="ciprojectvariableconnectionnodes"></a>`nodes` | [`[CiProjectVariable]`](#ciprojectvariable) | A list of nodes. |
| <a id="ciprojectvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiProjectVariableEdge`

The edge type for [`CiProjectVariable`](#ciprojectvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciprojectvariableedgenode"></a>`node` | [`CiProjectVariable`](#ciprojectvariable) | The item at the end of the edge. |

#### `CiRunnerConnection`

The connection type for [`CiRunner`](#cirunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cirunnerconnectionedges"></a>`edges` | [`[CiRunnerEdge]`](#cirunneredge) | A list of edges. |
| <a id="cirunnerconnectionjobsstatistics"></a>`jobsStatistics` | [`CiJobsStatistics`](#cijobsstatistics) | Jobs statistics for jobs executed by a collection of runners. Available only to admins. |
| <a id="cirunnerconnectionnodes"></a>`nodes` | [`[CiRunner]`](#cirunner) | A list of nodes. |
| <a id="cirunnerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiRunnerEdge`

The edge type for [`CiRunner`](#cirunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunneredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cirunneredgeediturl"></a>`editUrl` | [`String`](#string) | Web URL of the runner edit page. The value depends on where you put the field in the query. You can use it for projects or groups. |
| <a id="cirunneredgenode"></a>`node` | [`CiRunner`](#cirunner) | The item at the end of the edge. |
| <a id="cirunneredgeweburl"></a>`webUrl` | [`String`](#string) | Web URL of the runner. The value depends on where you put the field in the query. You can use it for projects or groups. |

#### `CiRunnerManagerConnection`

The connection type for [`CiRunnerManager`](#cirunnermanager).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanagerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cirunnermanagerconnectionedges"></a>`edges` | [`[CiRunnerManagerEdge]`](#cirunnermanageredge) | A list of edges. |
| <a id="cirunnermanagerconnectionnodes"></a>`nodes` | [`[CiRunnerManager]`](#cirunnermanager) | A list of nodes. |
| <a id="cirunnermanagerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiRunnerManagerEdge`

The edge type for [`CiRunnerManager`](#cirunnermanager).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanageredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cirunnermanageredgenode"></a>`node` | [`CiRunnerManager`](#cirunnermanager) | The item at the end of the edge. |

#### `CiSecureFileRegistryConnection`

The connection type for [`CiSecureFileRegistry`](#cisecurefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectionedges"></a>`edges` | [`[CiSecureFileRegistryEdge]`](#cisecurefileregistryedge) | A list of edges. |
| <a id="cisecurefileregistryconnectionnodes"></a>`nodes` | [`[CiSecureFileRegistry]`](#cisecurefileregistry) | A list of nodes. |
| <a id="cisecurefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `CiSecureFileRegistryConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `CiSecureFileRegistryEdge`

The edge type for [`CiSecureFileRegistry`](#cisecurefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cisecurefileregistryedgenode"></a>`node` | [`CiSecureFileRegistry`](#cisecurefileregistry) | The item at the end of the edge. |

#### `CiStageConnection`

The connection type for [`CiStage`](#cistage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistageconnectionedges"></a>`edges` | [`[CiStageEdge]`](#cistageedge) | A list of edges. |
| <a id="cistageconnectionnodes"></a>`nodes` | [`[CiStage]`](#cistage) | A list of nodes. |
| <a id="cistageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiStageEdge`

The edge type for [`CiStage`](#cistage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cistageedgenode"></a>`node` | [`CiStage`](#cistage) | The item at the end of the edge. |

#### `CiSubscriptionsProjectConnection`

The connection type for [`CiSubscriptionsProject`](#cisubscriptionsproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cisubscriptionsprojectconnectionedges"></a>`edges` | [`[CiSubscriptionsProjectEdge]`](#cisubscriptionsprojectedge) | A list of edges. |
| <a id="cisubscriptionsprojectconnectionnodes"></a>`nodes` | [`[CiSubscriptionsProject]`](#cisubscriptionsproject) | A list of nodes. |
| <a id="cisubscriptionsprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiSubscriptionsProjectEdge`

The edge type for [`CiSubscriptionsProject`](#cisubscriptionsproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cisubscriptionsprojectedgenode"></a>`node` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | The item at the end of the edge. |

#### `ClusterAgentActivityEventConnection`

The connection type for [`ClusterAgentActivityEvent`](#clusteragentactivityevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragentactivityeventconnectionedges"></a>`edges` | [`[ClusterAgentActivityEventEdge]`](#clusteragentactivityeventedge) | A list of edges. |
| <a id="clusteragentactivityeventconnectionnodes"></a>`nodes` | [`[ClusterAgentActivityEvent]`](#clusteragentactivityevent) | A list of nodes. |
| <a id="clusteragentactivityeventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentActivityEventEdge`

The edge type for [`ClusterAgentActivityEvent`](#clusteragentactivityevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentactivityeventedgenode"></a>`node` | [`ClusterAgentActivityEvent`](#clusteragentactivityevent) | The item at the end of the edge. |

#### `ClusterAgentAuthorizationCiAccessConnection`

The connection type for [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationCiAccessEdge]`](#clusteragentauthorizationciaccessedge) | A list of edges. |
| <a id="clusteragentauthorizationciaccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationCiAccess]`](#clusteragentauthorizationciaccess) | A list of nodes. |
| <a id="clusteragentauthorizationciaccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentAuthorizationCiAccessEdge`

The edge type for [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentauthorizationciaccessedgenode"></a>`node` | [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess) | The item at the end of the edge. |

#### `ClusterAgentAuthorizationUserAccessConnection`

The connection type for [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationUserAccessEdge]`](#clusteragentauthorizationuseraccessedge) | A list of edges. |
| <a id="clusteragentauthorizationuseraccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationUserAccess]`](#clusteragentauthorizationuseraccess) | A list of nodes. |
| <a id="clusteragentauthorizationuseraccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentAuthorizationUserAccessEdge`

The edge type for [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentauthorizationuseraccessedgenode"></a>`node` | [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess) | The item at the end of the edge. |

#### `ClusterAgentConnection`

The connection type for [`ClusterAgent`](#clusteragent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragentconnectionedges"></a>`edges` | [`[ClusterAgentEdge]`](#clusteragentedge) | A list of edges. |
| <a id="clusteragentconnectionnodes"></a>`nodes` | [`[ClusterAgent]`](#clusteragent) | A list of nodes. |
| <a id="clusteragentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentEdge`

The edge type for [`ClusterAgent`](#clusteragent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentedgenode"></a>`node` | [`ClusterAgent`](#clusteragent) | The item at the end of the edge. |

#### `ClusterAgentTokenConnection`

The connection type for [`ClusterAgentToken`](#clusteragenttoken).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragenttokenconnectionedges"></a>`edges` | [`[ClusterAgentTokenEdge]`](#clusteragenttokenedge) | A list of edges. |
| <a id="clusteragenttokenconnectionnodes"></a>`nodes` | [`[ClusterAgentToken]`](#clusteragenttoken) | A list of nodes. |
| <a id="clusteragenttokenconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentTokenEdge`

The edge type for [`ClusterAgentToken`](#clusteragenttoken).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragenttokenedgenode"></a>`node` | [`ClusterAgentToken`](#clusteragenttoken) | The item at the end of the edge. |

#### `ClusterAgentUrlConfigurationConnection`

The connection type for [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenturlconfigurationconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragenturlconfigurationconnectionedges"></a>`edges` | [`[ClusterAgentUrlConfigurationEdge]`](#clusteragenturlconfigurationedge) | A list of edges. |
| <a id="clusteragenturlconfigurationconnectionnodes"></a>`nodes` | [`[ClusterAgentUrlConfiguration]`](#clusteragenturlconfiguration) | A list of nodes. |
| <a id="clusteragenturlconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentUrlConfigurationEdge`

The edge type for [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenturlconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragenturlconfigurationedgenode"></a>`node` | [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration) | The item at the end of the edge. |

#### `CodeCoverageActivityConnection`

The connection type for [`CodeCoverageActivity`](#codecoverageactivity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityconnectionedges"></a>`edges` | [`[CodeCoverageActivityEdge]`](#codecoverageactivityedge) | A list of edges. |
| <a id="codecoverageactivityconnectionnodes"></a>`nodes` | [`[CodeCoverageActivity]`](#codecoverageactivity) | A list of nodes. |
| <a id="codecoverageactivityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CodeCoverageActivityEdge`

The edge type for [`CodeCoverageActivity`](#codecoverageactivity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="codecoverageactivityedgenode"></a>`node` | [`CodeCoverageActivity`](#codecoverageactivity) | The item at the end of the edge. |

#### `CodeQualityDegradationConnection`

The connection type for [`CodeQualityDegradation`](#codequalitydegradation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="codequalitydegradationconnectionedges"></a>`edges` | [`[CodeQualityDegradationEdge]`](#codequalitydegradationedge) | A list of edges. |
| <a id="codequalitydegradationconnectionnodes"></a>`nodes` | [`[CodeQualityDegradation]`](#codequalitydegradation) | A list of nodes. |
| <a id="codequalitydegradationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CodeQualityDegradationEdge`

The edge type for [`CodeQualityDegradation`](#codequalitydegradation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="codequalitydegradationedgenode"></a>`node` | [`CodeQualityDegradation`](#codequalitydegradation) | The item at the end of the edge. |

#### `CodeSuggestionEventConnection`

The connection type for [`CodeSuggestionEvent`](#codesuggestionevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codesuggestioneventconnectionedges"></a>`edges` | [`[CodeSuggestionEventEdge]`](#codesuggestioneventedge) | A list of edges. |
| <a id="codesuggestioneventconnectionnodes"></a>`nodes` | [`[CodeSuggestionEvent]`](#codesuggestionevent) | A list of nodes. |
| <a id="codesuggestioneventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CodeSuggestionEventEdge`

The edge type for [`CodeSuggestionEvent`](#codesuggestionevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codesuggestioneventedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="codesuggestioneventedgenode"></a>`node` | [`CodeSuggestionEvent`](#codesuggestionevent) | The item at the end of the edge. |

#### `CommitConnection`

The connection type for [`Commit`](#commit).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitconnectionedges"></a>`edges` | [`[CommitEdge]`](#commitedge) | A list of edges. |
| <a id="commitconnectionnodes"></a>`nodes` | [`[Commit]`](#commit) | A list of nodes. |
| <a id="commitconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CommitEdge`

The edge type for [`Commit`](#commit).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="commitedgenode"></a>`node` | [`Commit`](#commit) | The item at the end of the edge. |

#### `ComplianceFrameworkConnection`

The connection type for [`ComplianceFramework`](#complianceframework).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="complianceframeworkconnectionedges"></a>`edges` | [`[ComplianceFrameworkEdge]`](#complianceframeworkedge) | A list of edges. |
| <a id="complianceframeworkconnectionnodes"></a>`nodes` | [`[ComplianceFramework]`](#complianceframework) | A list of nodes. |
| <a id="complianceframeworkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceFrameworkCoverageDetailConnection`

The connection type for [`ComplianceFrameworkCoverageDetail`](#complianceframeworkcoveragedetail).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkcoveragedetailconnectionedges"></a>`edges` | [`[ComplianceFrameworkCoverageDetailEdge]`](#complianceframeworkcoveragedetailedge) | A list of edges. |
| <a id="complianceframeworkcoveragedetailconnectionnodes"></a>`nodes` | [`[ComplianceFrameworkCoverageDetail]`](#complianceframeworkcoveragedetail) | A list of nodes. |
| <a id="complianceframeworkcoveragedetailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceFrameworkCoverageDetailEdge`

The edge type for [`ComplianceFrameworkCoverageDetail`](#complianceframeworkcoveragedetail).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkcoveragedetailedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceframeworkcoveragedetailedgenode"></a>`node` | [`ComplianceFrameworkCoverageDetail`](#complianceframeworkcoveragedetail) | The item at the end of the edge. |

#### `ComplianceFrameworkEdge`

The edge type for [`ComplianceFramework`](#complianceframework).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceframeworkedgenode"></a>`node` | [`ComplianceFramework`](#complianceframework) | The item at the end of the edge. |

#### `ComplianceFrameworksNeedingAttentionConnection`

The connection type for [`ComplianceFrameworksNeedingAttention`](#complianceframeworksneedingattention).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworksneedingattentionconnectionedges"></a>`edges` | [`[ComplianceFrameworksNeedingAttentionEdge]`](#complianceframeworksneedingattentionedge) | A list of edges. |
| <a id="complianceframeworksneedingattentionconnectionnodes"></a>`nodes` | [`[ComplianceFrameworksNeedingAttention]`](#complianceframeworksneedingattention) | A list of nodes. |
| <a id="complianceframeworksneedingattentionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceFrameworksNeedingAttentionEdge`

The edge type for [`ComplianceFrameworksNeedingAttention`](#complianceframeworksneedingattention).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworksneedingattentionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceframeworksneedingattentionedgenode"></a>`node` | [`ComplianceFrameworksNeedingAttention`](#complianceframeworksneedingattention) | The item at the end of the edge. |

#### `ComplianceRequirementConnection`

The connection type for [`ComplianceRequirement`](#compliancerequirement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancerequirementconnectionedges"></a>`edges` | [`[ComplianceRequirementEdge]`](#compliancerequirementedge) | A list of edges. |
| <a id="compliancerequirementconnectionnodes"></a>`nodes` | [`[ComplianceRequirement]`](#compliancerequirement) | A list of nodes. |
| <a id="compliancerequirementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceRequirementEdge`

The edge type for [`ComplianceRequirement`](#compliancerequirement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancerequirementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="compliancerequirementedgenode"></a>`node` | [`ComplianceRequirement`](#compliancerequirement) | The item at the end of the edge. |

#### `ComplianceRequirementsControlConnection`

The connection type for [`ComplianceRequirementsControl`](#compliancerequirementscontrol).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancerequirementscontrolconnectionedges"></a>`edges` | [`[ComplianceRequirementsControlEdge]`](#compliancerequirementscontroledge) | A list of edges. |
| <a id="compliancerequirementscontrolconnectionnodes"></a>`nodes` | [`[ComplianceRequirementsControl]`](#compliancerequirementscontrol) | A list of nodes. |
| <a id="compliancerequirementscontrolconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceRequirementsControlEdge`

The edge type for [`ComplianceRequirementsControl`](#compliancerequirementscontrol).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancerequirementscontroledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="compliancerequirementscontroledgenode"></a>`node` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | The item at the end of the edge. |

#### `ComplianceStandardsAdherenceConnection`

The connection type for [`ComplianceStandardsAdherence`](#compliancestandardsadherence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceconnectionedges"></a>`edges` | [`[ComplianceStandardsAdherenceEdge]`](#compliancestandardsadherenceedge) | A list of edges. |
| <a id="compliancestandardsadherenceconnectionnodes"></a>`nodes` | [`[ComplianceStandardsAdherence]`](#compliancestandardsadherence) | A list of nodes. |
| <a id="compliancestandardsadherenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceStandardsAdherenceEdge`

The edge type for [`ComplianceStandardsAdherence`](#compliancestandardsadherence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="compliancestandardsadherenceedgenode"></a>`node` | [`ComplianceStandardsAdherence`](#compliancestandardsadherence) | The item at the end of the edge. |

#### `ComplianceViolationConnection`

The connection type for [`ComplianceViolation`](#complianceviolation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceviolationconnectionedges"></a>`edges` | [`[ComplianceViolationEdge]`](#complianceviolationedge) | A list of edges. |
| <a id="complianceviolationconnectionnodes"></a>`nodes` | [`[ComplianceViolation]`](#complianceviolation) | A list of nodes. |
| <a id="complianceviolationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceViolationEdge`

The edge type for [`ComplianceViolation`](#complianceviolation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceviolationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceviolationedgenode"></a>`node` | [`ComplianceViolation`](#complianceviolation) | The item at the end of the edge. |

#### `ComponentVersionConnection`

The connection type for [`ComponentVersion`](#componentversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="componentversionconnectionedges"></a>`edges` | [`[ComponentVersionEdge]`](#componentversionedge) | A list of edges. |
| <a id="componentversionconnectionnodes"></a>`nodes` | [`[ComponentVersion]`](#componentversion) | A list of nodes. |
| <a id="componentversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComponentVersionEdge`

The edge type for [`ComponentVersion`](#componentversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="componentversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="componentversionedgenode"></a>`node` | [`ComponentVersion`](#componentversion) | The item at the end of the edge. |

#### `ConnectedAgentConnection`

The connection type for [`ConnectedAgent`](#connectedagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="connectedagentconnectionedges"></a>`edges` | [`[ConnectedAgentEdge]`](#connectedagentedge) | A list of edges. |
| <a id="connectedagentconnectionnodes"></a>`nodes` | [`[ConnectedAgent]`](#connectedagent) | A list of nodes. |
| <a id="connectedagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ConnectedAgentEdge`

The edge type for [`ConnectedAgent`](#connectedagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="connectedagentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="connectedagentedgenode"></a>`node` | [`ConnectedAgent`](#connectedagent) | The item at the end of the edge. |

#### `ContainerProtectionRepositoryRuleConnection`

The connection type for [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerprotectionrepositoryruleconnectionedges"></a>`edges` | [`[ContainerProtectionRepositoryRuleEdge]`](#containerprotectionrepositoryruleedge) | A list of edges. |
| <a id="containerprotectionrepositoryruleconnectionnodes"></a>`nodes` | [`[ContainerProtectionRepositoryRule]`](#containerprotectionrepositoryrule) | A list of nodes. |
| <a id="containerprotectionrepositoryruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerProtectionRepositoryRuleEdge`

The edge type for [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerprotectionrepositoryruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerprotectionrepositoryruleedgenode"></a>`node` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | The item at the end of the edge. |

#### `ContainerProtectionTagRuleConnection`

The connection type for [`ContainerProtectionTagRule`](#containerprotectiontagrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerprotectiontagruleconnectionedges"></a>`edges` | [`[ContainerProtectionTagRuleEdge]`](#containerprotectiontagruleedge) | A list of edges. |
| <a id="containerprotectiontagruleconnectionnodes"></a>`nodes` | [`[ContainerProtectionTagRule]`](#containerprotectiontagrule) | A list of nodes. |
| <a id="containerprotectiontagruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerProtectionTagRuleEdge`

The edge type for [`ContainerProtectionTagRule`](#containerprotectiontagrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerprotectiontagruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerprotectiontagruleedgenode"></a>`node` | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | The item at the end of the edge. |

#### `ContainerRepositoryConnection`

The connection type for [`ContainerRepository`](#containerrepository).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryconnectionedges"></a>`edges` | [`[ContainerRepositoryEdge]`](#containerrepositoryedge) | A list of edges. |
| <a id="containerrepositoryconnectionnodes"></a>`nodes` | [`[ContainerRepository]`](#containerrepository) | A list of nodes. |
| <a id="containerrepositoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryEdge`

The edge type for [`ContainerRepository`](#containerrepository).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositoryedgenode"></a>`node` | [`ContainerRepository`](#containerrepository) | The item at the end of the edge. |

#### `ContainerRepositoryRegistryConnection`

The connection type for [`ContainerRepositoryRegistry`](#containerrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectionedges"></a>`edges` | [`[ContainerRepositoryRegistryEdge]`](#containerrepositoryregistryedge) | A list of edges. |
| <a id="containerrepositoryregistryconnectionnodes"></a>`nodes` | [`[ContainerRepositoryRegistry]`](#containerrepositoryregistry) | A list of nodes. |
| <a id="containerrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `ContainerRepositoryRegistryConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `ContainerRepositoryRegistryEdge`

The edge type for [`ContainerRepositoryRegistry`](#containerrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositoryregistryedgenode"></a>`node` | [`ContainerRepositoryRegistry`](#containerrepositoryregistry) | The item at the end of the edge. |

#### `ContainerRepositoryTagConnection`

The connection type for [`ContainerRepositoryTag`](#containerrepositorytag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagconnectionedges"></a>`edges` | [`[ContainerRepositoryTagEdge]`](#containerrepositorytagedge) | A list of edges. |
| <a id="containerrepositorytagconnectionnodes"></a>`nodes` | [`[ContainerRepositoryTag]`](#containerrepositorytag) | A list of nodes. |
| <a id="containerrepositorytagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryTagEdge`

The edge type for [`ContainerRepositoryTag`](#containerrepositorytag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositorytagedgenode"></a>`node` | [`ContainerRepositoryTag`](#containerrepositorytag) | The item at the end of the edge. |

#### `ContributionAnalyticsContributionConnection`

The connection type for [`ContributionAnalyticsContribution`](#contributionanalyticscontribution).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionconnectionedges"></a>`edges` | [`[ContributionAnalyticsContributionEdge]`](#contributionanalyticscontributionedge) | A list of edges. |
| <a id="contributionanalyticscontributionconnectionnodes"></a>`nodes` | [`[ContributionAnalyticsContribution]`](#contributionanalyticscontribution) | A list of nodes. |
| <a id="contributionanalyticscontributionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContributionAnalyticsContributionEdge`

The edge type for [`ContributionAnalyticsContribution`](#contributionanalyticscontribution).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="contributionanalyticscontributionedgenode"></a>`node` | [`ContributionAnalyticsContribution`](#contributionanalyticscontribution) | The item at the end of the edge. |

#### `CountableVulnerabilityConnection`

The connection type for [`CountableVulnerability`](#countablevulnerability).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="countablevulnerabilityconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="countablevulnerabilityconnectionedges"></a>`edges` | [`[CountableVulnerabilityEdge]`](#countablevulnerabilityedge) | A list of edges. |
| <a id="countablevulnerabilityconnectionnodes"></a>`nodes` | [`[CountableVulnerability]`](#countablevulnerability) | A list of nodes. |
| <a id="countablevulnerabilityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CountableVulnerabilityEdge`

The edge type for [`CountableVulnerability`](#countablevulnerability).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="countablevulnerabilityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="countablevulnerabilityedgenode"></a>`node` | [`CountableVulnerability`](#countablevulnerability) | The item at the end of the edge. |

#### `CoverageFuzzingCorpusConnection`

The connection type for [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusconnectionedges"></a>`edges` | [`[CoverageFuzzingCorpusEdge]`](#coveragefuzzingcorpusedge) | A list of edges. |
| <a id="coveragefuzzingcorpusconnectionnodes"></a>`nodes` | [`[CoverageFuzzingCorpus]`](#coveragefuzzingcorpus) | A list of nodes. |
| <a id="coveragefuzzingcorpusconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CoverageFuzzingCorpusEdge`

The edge type for [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="coveragefuzzingcorpusedgenode"></a>`node` | [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus) | The item at the end of the edge. |

#### `CustomEmojiConnection`

The connection type for [`CustomEmoji`](#customemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customemojiconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="customemojiconnectionedges"></a>`edges` | [`[CustomEmojiEdge]`](#customemojiedge) | A list of edges. |
| <a id="customemojiconnectionnodes"></a>`nodes` | [`[CustomEmoji]`](#customemoji) | A list of nodes. |
| <a id="customemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomEmojiEdge`

The edge type for [`CustomEmoji`](#customemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customemojiedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customemojiedgenode"></a>`node` | [`CustomEmoji`](#customemoji) | The item at the end of the edge. |

#### `CustomFieldConnection`

The connection type for [`CustomField`](#customfield).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customfieldconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="customfieldconnectionedges"></a>`edges` | [`[CustomFieldEdge]`](#customfieldedge) | A list of edges. |
| <a id="customfieldconnectionnodes"></a>`nodes` | [`[CustomField]`](#customfield) | A list of nodes. |
| <a id="customfieldconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomFieldEdge`

The edge type for [`CustomField`](#customfield).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customfieldedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customfieldedgenode"></a>`node` | [`CustomField`](#customfield) | The item at the end of the edge. |

#### `CustomerRelationsContactConnection`

The connection type for [`CustomerRelationsContact`](#customerrelationscontact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactconnectionedges"></a>`edges` | [`[CustomerRelationsContactEdge]`](#customerrelationscontactedge) | A list of edges. |
| <a id="customerrelationscontactconnectionnodes"></a>`nodes` | [`[CustomerRelationsContact]`](#customerrelationscontact) | A list of nodes. |
| <a id="customerrelationscontactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomerRelationsContactEdge`

The edge type for [`CustomerRelationsContact`](#customerrelationscontact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customerrelationscontactedgenode"></a>`node` | [`CustomerRelationsContact`](#customerrelationscontact) | The item at the end of the edge. |

#### `CustomerRelationsOrganizationConnection`

The connection type for [`CustomerRelationsOrganization`](#customerrelationsorganization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationconnectionedges"></a>`edges` | [`[CustomerRelationsOrganizationEdge]`](#cu