=begin
#Error Tracking REST API

#This schema describes the API endpoints for the error tracking feature

The version of the OpenAPI document: 0.0.1

Generated by: https://openapi-generator.tech
OpenAPI Generator version: 6.0.0

=end

require 'cgi'

module ErrorTrackingOpenAPI
  class MessagesApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # List of messages
    # @param project_id [Integer] ID of the project where the message was created
    # @param [Hash] opts the optional parameters
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<MessageEvent>]
    def list_messages(project_id, opts = {})
      data, _status_code, _headers = list_messages_with_http_info(project_id, opts)
      data
    end

    # List of messages
    # @param project_id [Integer] ID of the project where the message was created
    # @param [Hash] opts the optional parameters
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<(Array<MessageEvent>, Integer, Hash)>] Array<MessageEvent> data, response status code and response headers
    def list_messages_with_http_info(project_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: MessagesApi.list_messages ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling MessagesApi.list_messages"
      end
      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] > 100
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling MessagesApi.list_messages, must be smaller than or equal to 100.'
      end

      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] < 1
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling MessagesApi.list_messages, must be greater than or equal to 1.'
      end

      # resource path
      local_var_path = '/projects/{projectId}/messages'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'limit'] = opts[:'limit'] if !opts[:'limit'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Array<MessageEvent>'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"MessagesApi.list_messages",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: MessagesApi#list_messages\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
