/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.draganddrop.DragAndDropEvent;
import androidx.compose.ui.draganddrop.DragAndDropTransferAction;
import androidx.compose.ui.draganddrop.DragAndDropTransferData;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.platform.AwtDragAndDropManager;
import androidx.compose.ui.platform.AwtDragAndDropManager_desktopKt;
import androidx.compose.ui.platform.ComposeTransferHandler;
import androidx.compose.ui.platform.PlatformAdaptations;
import androidx.compose.ui.platform.PlatformDragAndDropManager;
import androidx.compose.ui.platform.PlatformDragAndDropSource;
import androidx.compose.ui.scene.ComposeSceneDragAndDropNode;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.window.LayoutConfiguration_desktopKt;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u00013\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ8\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001a0&\u00a2\u0006\u0002\b(H\u0002\u00a2\u0006\u0004\b)\u0010*J@\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010.\u001a\u00020/2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001a0&\u00a2\u0006\u0002\b(H\u0002\u00a2\u0006\u0004\b0\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0010\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006="}, d2={"Landroidx/compose/ui/platform/AwtDragAndDropManager;", "Landroidx/compose/ui/platform/PlatformDragAndDropManager;", "rootContainer", "Ljavax/swing/JComponent;", "getComposeRootDragAndDropNode", "Lkotlin/Function0;", "Landroidx/compose/ui/scene/ComposeSceneDragAndDropNode;", "<init>", "(Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function0;)V", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "scale", "", "getScale", "()F", "toOffset", "Landroidx/compose/ui/geometry/Offset;", "Ljava/awt/Point;", "toOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "isRequestDragAndDropTransferRequired", "", "()Z", "requestDragAndDropTransfer", "", "source", "Landroidx/compose/ui/platform/PlatformDragAndDropSource;", "offset", "requestDragAndDropTransfer-Uv8p0NA", "(Landroidx/compose/ui/platform/PlatformDragAndDropSource;J)V", "startDrag", "transferData", "Landroidx/compose/ui/draganddrop/DragAndDropTransferData;", "decorationSize", "Landroidx/compose/ui/geometry/Size;", "drawDragDecoration", "Lkotlin/Function1;", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "Lkotlin/ExtensionFunctionType;", "startDrag-12SF9DM", "(Landroidx/compose/ui/draganddrop/DragAndDropTransferData;JLkotlin/jvm/functions/Function1;)Z", "renderDragImage", "Ljava/awt/Image;", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "renderDragImage-Cqks5Fs", "(JLandroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;Lkotlin/jvm/functions/Function1;)Ljava/awt/Image;", "dropTargetListener", "androidx/compose/ui/platform/AwtDragAndDropManager$dropTargetListener$1", "Landroidx/compose/ui/platform/AwtDragAndDropManager$dropTargetListener$1;", "transferHandler", "Landroidx/compose/ui/platform/ComposeTransferHandler;", "getTransferHandler", "()Landroidx/compose/ui/platform/ComposeTransferHandler;", "dropTarget", "Ljava/awt/dnd/DropTarget;", "getDropTarget", "()Ljava/awt/dnd/DropTarget;", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAwtDragAndDropManager.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtDragAndDropManager.desktop.kt\nandroidx/compose/ui/platform/AwtDragAndDropManager\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 6 CanvasDrawScope.kt\nandroidx/compose/ui/graphics/drawscope/CanvasDrawScope\n*L\n1#1,407:1\n30#2:408\n53#3,3:409\n60#3:413\n70#3:416\n57#4:412\n61#4:415\n22#5:414\n22#5:417\n536#6,17:418\n*S KotlinDebug\n*F\n+ 1 AwtDragAndDropManager.desktop.kt\nandroidx/compose/ui/platform/AwtDragAndDropManager\n*L\n94#1:408\n94#1:409,3\n161#1:413\n162#1:416\n161#1:412\n162#1:415\n161#1:414\n162#1:417\n167#1:418,17\n*E\n"})
public final class AwtDragAndDropManager
implements PlatformDragAndDropManager {
    @NotNull
    private final JComponent rootContainer;
    @NotNull
    private final Function0<ComposeSceneDragAndDropNode> getComposeRootDragAndDropNode;
    @NotNull
    private final dropTargetListener.1 dropTargetListener;
    @NotNull
    private final ComposeTransferHandler transferHandler;
    @NotNull
    private final DropTarget dropTarget;
    public static final int $stable = 8;

    public AwtDragAndDropManager(@NotNull JComponent rootContainer, @NotNull Function0<ComposeSceneDragAndDropNode> getComposeRootDragAndDropNode) {
        Intrinsics.checkNotNullParameter((Object)rootContainer, (String)"rootContainer");
        Intrinsics.checkNotNullParameter(getComposeRootDragAndDropNode, (String)"getComposeRootDragAndDropNode");
        this.rootContainer = rootContainer;
        this.getComposeRootDragAndDropNode = getComposeRootDragAndDropNode;
        this.dropTargetListener = new DropTargetListener(this){
            final /* synthetic */ AwtDragAndDropManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                ComposeSceneDragAndDropNode rootNode = (ComposeSceneDragAndDropNode)AwtDragAndDropManager.access$getGetComposeRootDragAndDropNode$p(this.this$0).invoke();
                boolean acceptedTransfer = rootNode.acceptDragAndDropTransfer(event);
                if (acceptedTransfer) {
                    rootNode.onStarted(event);
                    rootNode.onEntered(event);
                } else {
                    dtde.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent dte) {
                Intrinsics.checkNotNullParameter((Object)dte, (String)"dte");
                DragAndDropEvent event = this.DragAndDropEvent(dte);
                ComposeSceneDragAndDropNode rootNode = (ComposeSceneDragAndDropNode)AwtDragAndDropManager.access$getGetComposeRootDragAndDropNode$p(this.this$0).invoke();
                rootNode.onExited(event);
                rootNode.onEnded(event);
            }

            public void dragOver(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                ComposeSceneDragAndDropNode rootNode = (ComposeSceneDragAndDropNode)AwtDragAndDropManager.access$getGetComposeRootDragAndDropNode$p(this.this$0).invoke();
                rootNode.onMoved(event);
                if (rootNode.getHasEligibleDropTarget()) {
                    dtde.acceptDrag(dtde.getDropAction());
                } else {
                    dtde.rejectDrag();
                }
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                ComposeSceneDragAndDropNode rootNode = (ComposeSceneDragAndDropNode)AwtDragAndDropManager.access$getGetComposeRootDragAndDropNode$p(this.this$0).invoke();
                rootNode.onChanged(event);
            }

            public void drop(DropTargetDropEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                DragAndDropEvent event = this.DragAndDropEvent(dtde);
                dtde.acceptDrop(dtde.getDropAction());
                ComposeSceneDragAndDropNode rootNode = (ComposeSceneDragAndDropNode)AwtDragAndDropManager.access$getGetComposeRootDragAndDropNode$p(this.this$0).invoke();
                dtde.dropComplete(rootNode.onDrop(event));
                rootNode.onEnded(event);
            }

            private final DragAndDropEvent DragAndDropEvent(DropTargetDragEvent dragEvent) {
                DragAndDropTransferAction dragAndDropTransferAction = AwtDragAndDropManager_desktopKt.fromAwtAction(DragAndDropTransferAction.Companion, dragEvent.getDropAction());
                Point point = dragEvent.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                return new DragAndDropEvent(dragAndDropTransferAction, dragEvent, AwtDragAndDropManager.access$toOffset-tuRUvjQ(this.this$0, point), null);
            }

            private final DragAndDropEvent DragAndDropEvent(DropTargetDropEvent dropEvent) {
                DragAndDropTransferAction dragAndDropTransferAction = AwtDragAndDropManager_desktopKt.fromAwtAction(DragAndDropTransferAction.Companion, dropEvent.getDropAction());
                Point point = dropEvent.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                return new DragAndDropEvent(dragAndDropTransferAction, dropEvent, AwtDragAndDropManager.access$toOffset-tuRUvjQ(this.this$0, point), null);
            }

            private final DragAndDropEvent DragAndDropEvent(DropTargetEvent dropEvent) {
                long l = Offset.Companion.getZero-F1C5BW0();
                return new DragAndDropEvent(null, dropEvent, l, null);
            }
        };
        this.transferHandler = new ComposeTransferHandler(this.rootContainer);
        this.dropTarget = new DropTarget(this.rootContainer, 0x40000003, this.dropTargetListener, true);
    }

    private final Density getDensity() {
        return LayoutConfiguration_desktopKt.getDensity(this.rootContainer);
    }

    private final float getScale() {
        return this.getDensity().getDensity();
    }

    /*
     * WARNING - void declaration
     */
    private final long toOffset-tuRUvjQ(Point $this$toOffset_u2dtuRUvjQ) {
        void y$iv;
        void x$iv;
        float scale = this.getScale();
        float f = (float)$this$toOffset_u2dtuRUvjQ.x * scale;
        float f2 = (float)$this$toOffset_u2dtuRUvjQ.y * scale;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits((float)y$iv);
        return Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    @Override
    public boolean isRequestDragAndDropTransferRequired() {
        return true;
    }

    @Override
    public void requestDragAndDropTransfer-Uv8p0NA(@NotNull PlatformDragAndDropSource source, long offset) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Ref.BooleanRef isTransferStarted = new Ref.BooleanRef();
        PlatformDragAndDropSource.StartTransferScope startTransferScope2 = new PlatformDragAndDropSource.StartTransferScope(isTransferStarted, this){
            final /* synthetic */ Ref.BooleanRef $isTransferStarted;
            final /* synthetic */ AwtDragAndDropManager this$0;
            {
                this.$isTransferStarted = $isTransferStarted;
                this.this$0 = $receiver;
            }

            public boolean startDragAndDropTransfer-12SF9DM(DragAndDropTransferData transferData, long decorationSize, Function1<? super DrawScope, Unit> drawDragDecoration) {
                Intrinsics.checkNotNullParameter((Object)transferData, (String)"transferData");
                Intrinsics.checkNotNullParameter(drawDragDecoration, (String)"drawDragDecoration");
                this.$isTransferStarted.element = AwtDragAndDropManager.access$startDrag-12SF9DM(this.this$0, transferData, decorationSize, drawDragDecoration);
                return this.$isTransferStarted.element;
            }
        };
        PlatformDragAndDropSource $this$requestDragAndDropTransfer_Uv8p0NA_u24lambda_u241 = source;
        boolean bl = false;
        $this$requestDragAndDropTransfer_Uv8p0NA_u24lambda_u241.startDragAndDropTransfer-d-4ec7I(startTransferScope2, offset, (Function0<Boolean>)((Function0)() -> AwtDragAndDropManager.requestDragAndDropTransfer_Uv8p0NA$lambda$1$lambda$0(isTransferStarted)));
    }

    private final boolean startDrag-12SF9DM(DragAndDropTransferData transferData, long decorationSize, Function1<? super DrawScope, Unit> drawDragDecoration) {
        Density density = this.getDensity();
        LayoutDirection layoutDirection = LayoutConfiguration_desktopKt.layoutDirectionFor(this.rootContainer);
        this.transferHandler.startOutgoingTransfer-0AR0LA0(transferData, this.renderDragImage-Cqks5Fs(decorationSize, density, layoutDirection, drawDragDecoration), transferData.getDragDecorationOffset-F1C5BW0());
        return true;
    }

    private final Image renderDragImage-Cqks5Fs(long size, Density density, LayoutDirection layoutDirection, Function1<? super DrawScope, Unit> drawDragDecoration) {
        CanvasDrawScope canvasScope;
        boolean bl = false;
        long value$iv$iv = size;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        int n = MathKt.roundToInt((float)Float.intBitsToFloat(bits$iv$iv$iv));
        boolean bl2 = false;
        value$iv$iv = size;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        ImageBitmap imageBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(n, MathKt.roundToInt((float)Float.intBitsToFloat(bits$iv$iv$iv)), 0, false, null, 28, null);
        Canvas canvas = CanvasKt.Canvas(imageBitmap);
        CanvasDrawScope this_$iv = canvasScope = new CanvasDrawScope();
        boolean bl3 = false;
        CanvasDrawScope.DrawParams drawParams = this_$iv.getDrawParams();
        Density prevDensity$iv = drawParams.component1();
        LayoutDirection prevLayoutDirection$iv = drawParams.component2();
        Canvas prevCanvas$iv = drawParams.component3();
        long prevSize$iv = drawParams.component4-NH-jbRc();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u240$iv = this_$iv.getDrawParams();
        boolean bl4 = false;
        $this$draw_yzxVdVo_u24lambda_u240$iv.setDensity(density);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setLayoutDirection(layoutDirection);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setCanvas(canvas);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setSize-uvyYCjk(size);
        canvas.save();
        drawDragDecoration.invoke((Object)this_$iv);
        canvas.restore();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u241$iv = this_$iv.getDrawParams();
        boolean bl5 = false;
        $this$draw_yzxVdVo_u24lambda_u241$iv.setDensity(prevDensity$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setLayoutDirection(prevLayoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setCanvas(prevCanvas$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setSize-uvyYCjk(prevSize$iv);
        return PlatformAdaptations.Companion.dragImage(DesktopImageConverters_desktopKt.toAwtImage(imageBitmap), density.getDensity());
    }

    @NotNull
    public final ComposeTransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    @NotNull
    public final DropTarget getDropTarget() {
        return this.dropTarget;
    }

    private static final boolean requestDragAndDropTransfer_Uv8p0NA$lambda$1$lambda$0(Ref.BooleanRef $isTransferStarted) {
        return $isTransferStarted.element;
    }

    public static final /* synthetic */ boolean access$startDrag-12SF9DM(AwtDragAndDropManager $this, DragAndDropTransferData transferData, long decorationSize, Function1 drawDragDecoration) {
        return $this.startDrag-12SF9DM(transferData, decorationSize, (Function1<? super DrawScope, Unit>)drawDragDecoration);
    }

    public static final /* synthetic */ Function0 access$getGetComposeRootDragAndDropNode$p(AwtDragAndDropManager $this) {
        return $this.getComposeRootDragAndDropNode;
    }

    public static final /* synthetic */ long access$toOffset-tuRUvjQ(AwtDragAndDropManager $this, Point $receiver) {
        return $this.toOffset-tuRUvjQ($receiver);
    }
}

