/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolver;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.util.PrivateForInline;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH$J\f\u0010\u001f\u001a\u00020\u001d*\u00020\u001eH$J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\"\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u000f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0*H\u0086\b\u00f8\u0001\u0000J\u001a\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00104\u001a\u0002012\u0006\u00105\u001a\u0002062\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u0002H&J\u001a\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020;2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010<\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010=\u001a\u0002012\u0006\u0010(\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010>\u001a\u00020?2\u0006\u00108\u001a\u00020\u000fJ\u000e\u0010@\u001a\u00020?2\u0006\u00108\u001a\u00020\u000fJ\u001a\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J(\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u000e\b\u0002\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00020JH\u0002J\u001a\u0010K\u001a\u0002012\u0006\u0010L\u001a\u00020M2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010N\u001a\u0002012\u0006\u0010O\u001a\u00020P2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Q\u001a\u0002012\u0006\u0010R\u001a\u00020S2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J(\u0010Q\u001a\u00020?2\u0006\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020S0J2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0002J\u001a\u0010U\u001a\u0002012\u0006\u0010V\u001a\u00020H2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010U\u001a\u00020?2\u0006\u0010V\u001a\u00020H2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020H0JJ\u001a\u0010X\u001a\u0002012\u0006\u0010Y\u001a\u00020Z2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010D\u001a\u0002012\u0006\u0010E\u001a\u00020F2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010[\u001a\u0002012\u0006\u0010\\\u001a\u00020]2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010^\u001a\u0002012\u0006\u0010_\u001a\u00020`2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020d2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010e\u001a\u0002012\u0006\u0010f\u001a\u00020g2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006h"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;)V", "getStatusComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getClasses$annotations", "()V", "getClasses", "()Ljava/util/List;", "statusResolver", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "getStatusResolver", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "containingClass", "getContainingClass$annotations", "getContainingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "needResolveMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "needResolveNestedClassifiers", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "data", "transformDeclarationStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "declarationStatus", "storeClass", "klass", "computeResult", "Lkotlin/Function0;", "transformDeclaration", "declaration", "transformDanglingModifierList", "Lorg/jetbrains/kotlin/fir/declarations/FirDanglingModifierList;", "danglingModifierList", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformClassContent", "firClass", "transformAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "transformDeclarationContent", "transformClass", "transformValueClassRepresentation", "", "transformClassStatus", "transformReplSnippet", "Lorg/jetbrains/kotlin/fir/declarations/FirReplSnippet;", "replSnippet", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "containingProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "overriddenStatuses", "", "transformConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformErrorPrimaryConstructor", "errorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "transformSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenFunctions", "transformProperty", "property", "overriddenProperties", "transformField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "transformTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirStatusResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,510:1\n260#1,2:550\n262#1,2:554\n242#2,4:511\n234#2,4:515\n234#2,2:519\n236#2,2:523\n234#2,4:525\n234#2,4:529\n234#2,2:548\n236#2,2:556\n234#2,4:559\n234#2,4:563\n234#2,4:567\n234#2,4:575\n234#2,4:598\n234#2,4:602\n1869#3,2:521\n1869#3,2:544\n1869#3,2:546\n1869#3,2:552\n1563#3:571\n1634#3,3:572\n1563#3:579\n1634#3,3:580\n1617#3,9:583\n1869#3:592\n1870#3:594\n1626#3:595\n81#4,7:533\n76#4,2:540\n57#4:542\n78#4:543\n51#5:558\n23#5:597\n1#6:593\n1#6:596\n*S KotlinDebug\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n*L\n353#1:550,2\n353#1:554,2\n242#1:511,4\n269#1:515,4\n293#1:519,2\n293#1:523,2\n302#1:525,4\n314#1:529,4\n352#1:548,2\n352#1:556,2\n381#1:559,4\n399#1:563,4\n412#1:567,4\n437#1:575,4\n475#1:598,4\n487#1:602,4\n294#1:521,2\n333#1:544,2\n340#1:546,2\n354#1:552,2\n427#1:571\n427#1:572,3\n444#1:579\n444#1:580,3\n445#1:583,9\n445#1:592\n445#1:594\n445#1:595\n327#1:533,7\n327#1:540,2\n327#1:542\n327#1:543\n360#1:558\n467#1:597\n445#1:593\n*E\n"})
public abstract class AbstractFirStatusResolveTransformer
extends FirAbstractTreeTransformer<FirResolvedDeclarationStatus> {
    @NotNull
    private final StatusComputationSession statusComputationSession;
    @NotNull
    private final List<FirClass> classes;
    @NotNull
    private final FirStatusResolver statusResolver;

    public AbstractFirStatusResolveTransformer(@NotNull StatusComputationSession statusComputationSession) {
        Intrinsics.checkNotNullParameter(statusComputationSession, "statusComputationSession");
        super(FirResolvePhase.STATUS);
        this.statusComputationSession = statusComputationSession;
        this.classes = new ArrayList();
        this.statusResolver = new FirStatusResolver(this.getSession(), this.statusComputationSession.getUseSiteScopeSession());
    }

    @NotNull
    public final StatusComputationSession getStatusComputationSession() {
        return this.statusComputationSession;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.statusComputationSession.getUseSiteSession();
    }

    @NotNull
    public final List<FirClass> getClasses() {
        return this.classes;
    }

    @PrivateForInline
    public static /* synthetic */ void getClasses$annotations() {
    }

    @NotNull
    public final FirStatusResolver getStatusResolver() {
        return this.statusResolver;
    }

    @Nullable
    public final FirClass getContainingClass() {
        return CollectionsKt.lastOrNull(this.classes);
    }

    public static /* synthetic */ void getContainingClass$annotations() {
    }

    protected abstract boolean needResolveMembers(@NotNull FirDeclaration var1);

    protected abstract boolean needResolveNestedClassifiers(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(file, "file");
        FirFile file$iv = file;
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            FirDeclaration firDeclaration = this.transformDeclarationContent(file, data);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file$iv.getModuleData().getSession()).handleExceptionOnFileAnalysis(file$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return file;
    }

    @Override
    @NotNull
    public FirDeclarationStatus transformDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(declarationStatus, "declarationStatus");
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = data;
        return firResolvedDeclarationStatus != null ? (FirDeclarationStatus)firResolvedDeclarationStatus : declarationStatus;
    }

    @NotNull
    public final FirDeclaration storeClass(@NotNull FirClass klass, @NotNull Function0<? extends FirDeclaration> computeResult) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(computeResult, "computeResult");
        boolean $i$f$storeClass = false;
        ((Collection)this.getClasses()).add(klass);
        FirDeclaration result2 = computeResult.invoke();
        this.getClasses().remove(CollectionsKt.getLastIndex(this.getClasses()));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirSession firSession = this.getSession();
        FirElement element$iv = declaration;
        boolean $i$f$whileAnalysing = false;
        try {
            FirDeclaration firDeclaration;
            boolean bl = false;
            if (declaration instanceof FirCallableDeclaration) {
                if (declaration instanceof FirFunction) {
                    for (FirValueParameter valueParameter2 : ((FirFunction)declaration).getValueParameters()) {
                        this.transformValueParameter(valueParameter2, data);
                    }
                }
                firDeclaration = declaration;
            } else {
                firDeclaration = (FirDeclaration)this.transformElement((FirElement)declaration, data);
            }
            return firDeclaration;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirDanglingModifierList transformDanglingModifierList(@NotNull FirDanglingModifierList danglingModifierList, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(danglingModifierList, "danglingModifierList");
        return danglingModifierList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        FirSession firSession = this.getSession();
        FirElement element$iv = typeAlias;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = typeAlias.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv2;
                boolean bl2 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
            typeAlias.transformStatus(this, this.statusResolver.resolveStatus(typeAlias, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeAlias, data);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
            return (FirTypeAlias)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        FirSession firSession = this.getSession();
        FirElement element$iv = regularClass;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(regularClass, data);
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firStatement;
    }

    @NotNull
    public abstract FirStatement transformClassContent(@NotNull FirClass var1, @Nullable FirResolvedDeclarationStatus var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable FirResolvedDeclarationStatus data) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        FirSession firSession = this.getSession();
        FirElement element$iv = anonymousObject;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(anonymousObject, data);
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data) {
        FirDeclaration it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<FirDeclaration> list;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            list = ((FirRegularClass)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            list = ((FirAnonymousObject)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirFile) {
            list = ((FirFile)declaration).getDeclarations();
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            void $this$buildAttachment$iv$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            void cause$iv$iv;
            void message$iv$iv;
            String message$iv = "Unsupported declaration: " + declaration.getClass();
            Object cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            String string = message$iv;
            Object var10_14 = cause$iv;
            String attachmentName$iv$iv = attachmentName$iv;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv$iv;
            String name$iv$iv$iv = attachmentName$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = name$iv$iv$iv;
            void var20_24 = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$transformDeclarationContent_u24lambda_u246 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$transformDeclarationContent_u24lambda_u246, "declaration", declaration);
            var20_24.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        List<FirDeclaration> declarations2 = list;
        if (this.needResolveMembers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (it instanceof FirClassLikeDeclaration) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
        }
        if (this.needResolveNestedClassifiers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirClassLikeDeclaration)) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
        }
        return declaration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformClass(@NotNull FirClass klass, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        FirSession firSession = this.getSession();
        FirElement element$iv = klass;
        boolean $i$f$whileAnalysing = false;
        try {
            void this_$iv;
            boolean bl = false;
            AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer = this;
            FirClass klass$iv = klass;
            boolean $i$f$storeClass = false;
            ((Collection)this_$iv.getClasses()).add(klass$iv);
            boolean bl2 = false;
            Iterable $this$forEach$iv = klass.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv2;
                boolean bl3 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
            FirDeclaration result$iv = this.transformDeclarationContent(klass, data);
            this_$iv.getClasses().remove(CollectionsKt.getLastIndex(this_$iv.getClasses()));
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    public final void transformValueClassRepresentation(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        if (firClass instanceof FirRegularClass) {
            FirClass $this$isInlineOrValue$iv = firClass;
            boolean $i$f$isInlineOrValue = false;
            if ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) {
                FirValueClassRepresentationKt.setValueClassRepresentation((FirRegularClass)firClass, ValueClassesUtilsKt.computeValueClassRepresentation((FirRegularClass)firClass, this.getSession()));
            }
        }
    }

    public final void transformClassStatus(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        firClass.transformStatus(this, this.statusResolver.resolveStatus(firClass, this.getContainingClass(), false));
    }

    @Override
    @NotNull
    public FirReplSnippet transformReplSnippet(@NotNull FirReplSnippet replSnippet, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(replSnippet, "replSnippet");
        return replSnippet;
    }

    /*
     * WARNING - void declaration
     */
    private final void transformPropertyAccessor(FirPropertyAccessor propertyAccessor, FirProperty containingProperty, List<? extends FirResolvedDeclarationStatus> overriddenStatuses) {
        FirSession firSession = this.getSession();
        FirElement element$iv = propertyAccessor;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            propertyAccessor.transformStatus(this, this.statusResolver.resolveStatus(propertyAccessor, this.getContainingClass(), containingProperty, false, overriddenStatuses));
            propertyAccessor.transformValueParameters(this, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    static /* synthetic */ void transformPropertyAccessor$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirPropertyAccessor firPropertyAccessor, FirProperty firProperty, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformPropertyAccessor");
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        abstractFirStatusResolveTransformer.transformPropertyAccessor(firPropertyAccessor, firProperty, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformConstructor(@NotNull FirConstructor constructor, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        FirSession firSession = this.getSession();
        FirElement element$iv = constructor;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            constructor.transformStatus(this, this.statusResolver.resolveStatus(constructor, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)constructor, data);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(errorPrimaryConstructor, "errorPrimaryConstructor");
        return this.transformConstructor((FirConstructor)errorPrimaryConstructor, data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        FirSession firSession = this.getSession();
        FirElement element$iv = simpleFunction;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            List<FirSimpleFunction> overriddenFunctions = this.statusResolver.getOverriddenFunctions(simpleFunction, this.getContainingClass());
            this.transformSimpleFunction(simpleFunction, overriddenFunctions, data);
            return simpleFunction;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull List<? extends FirSimpleFunction> overriddenFunctions, @Nullable FirResolvedDeclarationStatus data) {
        Collection<FirResolvedDeclarationStatus> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        Intrinsics.checkNotNullParameter(overriddenFunctions, "overriddenFunctions");
        Iterable iterable = overriddenFunctions;
        boolean bl = false;
        FirClass firClass = this.getContainingClass();
        FirSimpleFunction firSimpleFunction = simpleFunction;
        FirStatusResolver firStatusResolver = this.statusResolver;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirSimpleFunction firSimpleFunction2 = (FirSimpleFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            FirDeclarationStatus firDeclarationStatus = it.getStatus();
            Intrinsics.checkNotNull(firDeclarationStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
            collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
        }
        collection = (List)destination$iv$iv;
        FirResolvedDeclarationStatus resolvedStatus = firStatusResolver.resolveStatus(firSimpleFunction, firClass, bl, (List<? extends FirResolvedDeclarationStatus>)collection);
        simpleFunction.transformStatus(this, resolvedStatus);
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)simpleFunction, data);
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        FirStatement cfr_ignored_0 = (FirStatement)((Object)firDeclaration);
    }

    public static /* synthetic */ void transformSimpleFunction$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirSimpleFunction firSimpleFunction, List list, FirResolvedDeclarationStatus firResolvedDeclarationStatus, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformSimpleFunction");
        }
        if ((n2 & 4) != 0) {
            firResolvedDeclarationStatus = null;
        }
        abstractFirStatusResolveTransformer.transformSimpleFunction(firSimpleFunction, list, firResolvedDeclarationStatus);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property2, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(property2, "property");
        FirSession firSession = this.getSession();
        FirElement element$iv = property2;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            List<FirProperty> overridden = this.statusResolver.getOverriddenProperties(property2, this.getContainingClass());
            this.transformProperty(property2, overridden);
            return property2;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformProperty(@NotNull FirProperty property2, @NotNull List<? extends FirProperty> overriddenProperties) {
        block8: {
            FirCallableDeclaration it;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(property2, "property");
            Intrinsics.checkNotNullParameter(overriddenProperties, "overriddenProperties");
            Iterable $this$map$iv = overriddenProperties;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirProperty firProperty = (FirProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirDeclarationStatus firDeclarationStatus = it2.getStatus();
                Intrinsics.checkNotNull(firDeclarationStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
            }
            List overriddenStatuses = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = overriddenProperties;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirResolvedDeclarationStatus firResolvedDeclarationStatus;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirProperty it3 = (FirProperty)element$iv$iv;
                boolean bl2 = false;
                if (it3.getSetter() == null) {
                    firResolvedDeclarationStatus = null;
                } else {
                    FirPropertyAccessor setter2;
                    FirDeclarationStatus firDeclarationStatus = setter2.getStatus();
                    Intrinsics.checkNotNull(firDeclarationStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                    firResolvedDeclarationStatus = (FirResolvedDeclarationStatus)firDeclarationStatus;
                }
                if (firResolvedDeclarationStatus == null) continue;
                FirResolvedDeclarationStatus it$iv$iv = firResolvedDeclarationStatus;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List overriddenSetters = (List)destination$iv$iv2;
            property2.transformStatus(this, this.statusResolver.resolveStatus(property2, this.getContainingClass(), false, (List<? extends FirResolvedDeclarationStatus>)overriddenStatuses));
            FirPropertyAccessor firPropertyAccessor = property2.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                AbstractFirStatusResolveTransformer.transformPropertyAccessor$default(this, (FirPropertyAccessor)it, property2, null, 4, null);
            }
            FirPropertyAccessor firPropertyAccessor2 = property2.getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                this.transformPropertyAccessor((FirPropertyAccessor)it, property2, overriddenSetters);
            }
            FirBackingField firBackingField = property2.getBackingField();
            if (firBackingField != null) {
                it = firBackingField;
                boolean bl = false;
                ((FirBackingField)it).transformStatus(this, this.statusResolver.resolveStatus(it, this.getContainingClass(), property2, false));
            }
            FirNamedFunctionSymbol firNamedFunctionSymbol = DeclarationAttributesKt.getComponentFunctionSymbol(property2);
            if (firNamedFunctionSymbol == null) break block8;
            FirNamedFunctionSymbol componentFunction = firNamedFunctionSymbol;
            boolean bl = false;
            if (Intrinsics.areEqual(((FirSimpleFunction)componentFunction.getFir()).getStatus().getVisibility(), Visibilities.Unknown.INSTANCE)) {
                FirMemberDeclaration $this$visibility$iv = property2;
                boolean $i$f$getVisibility = false;
                ((FirSimpleFunction)componentFunction.getFir()).replaceStatus(UtilsKt.copy$default(((FirSimpleFunction)componentFunction.getFir()).getStatus(), $this$visibility$iv.getStatus().getVisibility(), null, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0x3FFFFE, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(field, "field");
        FirSession firSession = this.getSession();
        FirElement element$iv = field;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            field.transformStatus(this, this.statusResolver.resolveStatus(field, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)field, data);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirField");
            return (FirField)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable FirResolvedDeclarationStatus data) {
        FirPropertyAccessor firPropertyAccessor;
        Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
        FirPropertyAccessor it = firPropertyAccessor = propertyAccessor;
        boolean bl = false;
        this.transformProperty((FirProperty)it.getPropertySymbol().getFir(), data);
        return firPropertyAccessor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        FirSession firSession = this.getSession();
        FirElement element$iv = enumEntry;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            enumEntry.transformStatus(this, this.statusResolver.resolveStatus(enumEntry, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)enumEntry, data);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
            return (FirEnumEntry)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)valueParameter2, data);
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration);
    }

    @Override
    @NotNull
    public FirTypeParameterRef transformTypeParameter(@NotNull FirTypeParameter typeParameter, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeParameter, data);
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameter");
        return (FirTypeParameter)firDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter(block, "block");
        return block;
    }
}

