/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.ide.util.RunOnceUtilKt;
import com.intellij.idea.AppMode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import git4idea.GitActionIdsHolder;
import git4idea.commit.signing.GpgAgentConfigurator;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0013\u0010\u0017\u001a\u00020\u000b2\u000b\u0010\u0018\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurationNotificator;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isEnabled", "", "proposeCustomPinentryAgentConfiguration", "", "isSuggestion", "type", "Lcom/intellij/notification/NotificationType;", "showPinentryConfigurationNotification", "getConfigurationProposalMessage", "", "Lorg/jetbrains/annotations/Nls;", "notifyConfigurationSuccessful", "paths", "Lgit4idea/commit/signing/GpgAgentPaths;", "backupCreated", "notifyConfigurationFailed", "message", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "GpgAgentConfiguratorNotification", "intellij.vcs.git"})
public final class GpgAgentConfigurationNotificator {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;

    public GpgAgentConfigurationNotificator(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    private final boolean isEnabled() {
        return Registry.Companion.is("git.commit.gpg.signing.enable.embedded.pinentry.notification.proposal", false);
    }

    @RequiresBackgroundThread
    public final void proposeCustomPinentryAgentConfiguration(boolean isSuggestion, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!this.isEnabled()) {
            return;
        }
        if (!GpgAgentConfigurator.Companion.getInstance(this.project).canBeConfigured(this.project)) {
            return;
        }
        if (isSuggestion) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, type, null){
                int label;
                final /* synthetic */ GpgAgentConfigurationNotificator this$0;
                final /* synthetic */ NotificationType $type;
                {
                    this.this$0 = $receiver;
                    this.$type = $type;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = RunOnceUtilKt.runOnceForProject((Project)GpgAgentConfigurationNotificator.access$getProject$p(this.this$0), (String)"GPG_PINENTRY_CONFIGURATION_PROPOSAL", (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, this.$type, null){
                                int label;
                                final /* synthetic */ GpgAgentConfigurationNotificator this$0;
                                final /* synthetic */ NotificationType $type;
                                {
                                    this.this$0 = $receiver;
                                    this.$type = $type;
                                    super(1, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            GpgAgentConfigurationNotificator.access$showPinentryConfigurationNotification(this.this$0, true, this.$type);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.showPinentryConfigurationNotification(false, type);
        }
    }

    public static /* synthetic */ void proposeCustomPinentryAgentConfiguration$default(GpgAgentConfigurationNotificator gpgAgentConfigurationNotificator, boolean bl, NotificationType notificationType, int n, Object object) {
        if ((n & 2) != 0) {
            notificationType = NotificationType.INFORMATION;
        }
        gpgAgentConfigurationNotificator.proposeCustomPinentryAgentConfiguration(bl, notificationType);
    }

    private final void showPinentryConfigurationNotification(boolean isSuggestion, NotificationType type) {
        String displayId = isSuggestion ? "git.gpg.agent.configuration.propose" : "git.gpg.agent.configuration.propose.suggestion";
        String string = GitBundle.message("gpg.pinentry.configuration.proposal.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object object = string;
        String string2 = this.getConfigurationProposalMessage();
        Object $this$showPinentryConfigurationNotification_u24lambda_u242 = object = new GpgAgentConfiguratorNotification(this, displayId, (String)object, string2, type, isSuggestion);
        boolean bl = false;
        String configureActionId = isSuggestion ? GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_SUGGESTION_CONFIGURE.id : GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_CONFIGURE.id;
        $this$showPinentryConfigurationNotification_u24lambda_u242.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("gpg.pinentry.configuration.proposal.configure", new Object[0]), (String)configureActionId, () -> GpgAgentConfigurationNotificator.showPinentryConfigurationNotification$lambda$2$lambda$0((GpgAgentConfiguratorNotification)((Object)$this$showPinentryConfigurationNotification_u24lambda_u242), this)));
        String manualActionId = isSuggestion ? GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_SUGGESTION_MANUAL.id : GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_PROPOSE_MANUAL.id;
        $this$showPinentryConfigurationNotification_u24lambda_u242.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("gpg.error.see.documentation.link.text", new Object[0]), (String)manualActionId, GpgAgentConfigurationNotificator::showPinentryConfigurationNotification$lambda$2$lambda$1));
        ((GpgAgentConfiguratorNotification)((Object)object)).notifyExpirePrevious(this.project);
    }

    private final String getConfigurationProposalMessage() {
        Object[] objectArray = new Object[]{AppMode.isRemoteDevHost() ? 0 : (GitExecutableManager.getInstance().getExecutable(this.project) instanceof GitExecutable.Wsl ? 1 : 2), ApplicationNamesInfo.getInstance().getFullProductName()};
        String string = GitBundle.message("gpg.pinentry.configuration.proposal.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public final void notifyConfigurationSuccessful(@NotNull GpgAgentPaths paths, boolean backupCreated) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Object[] objectArray = new Object[]{FileUtil.getLocationRelativeToUserHome((String)((Object)paths.getGpgAgentConf()).toString())};
        String string = GitBundle.message("gpg.pinentry.configured.successfully.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object message = string;
        if (backupCreated) {
            object = new Object[]{FileUtil.getLocationRelativeToUserHome((String)((Object)paths.getGpgAgentConfBackup()).toString())};
            message = (String)message + "<br/><br/>" + GitBundle.message("gpg.pinentry.configured.successfully.backup.message", (Object[])object);
        }
        String string2 = GitBundle.message("gpg.pinentry.configured.successfully.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Object $this$notifyConfigurationSuccessful_u24lambda_u244 = object = new GpgAgentConfiguratorNotification(this, "git.gpg.agent.configuration.success", string2, (String)message, NotificationType.INFORMATION, false, 16, null);
        boolean bl = false;
        $this$notifyConfigurationSuccessful_u24lambda_u244.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.message("gpg.error.see.documentation.link.text", new Object[0]), (String)GitActionIdsHolder.Id.GPG_AGENT_CONFIGURATION_SUCCESS_MANUAL.id, GpgAgentConfigurationNotificator::notifyConfigurationSuccessful$lambda$4$lambda$3));
        ((GpgAgentConfiguratorNotification)((Object)object)).notifyExpirePrevious(this.project);
    }

    public final void notifyConfigurationFailed(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = GitBundle.message("gpg.pinentry.configuration.error.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        new GpgAgentConfiguratorNotification(this, "git.gpg.agent.configuration.error", string, message, NotificationType.ERROR, false, 16, null).notifyExpirePrevious(this.project);
    }

    private static final void showPinentryConfigurationNotification$lambda$2$lambda$0(GpgAgentConfiguratorNotification $this_apply, GpgAgentConfigurationNotificator this$0) {
        $this_apply.expire();
        GpgAgentConfigurator.Companion.getInstance(this$0.project).configure();
    }

    private static final void showPinentryConfigurationNotification$lambda$2$lambda$1() {
        HelpManager.getInstance().invokeHelp(GitBundle.message("gpg.pinentry.jb.manual.link", new Object[0]));
    }

    private static final void notifyConfigurationSuccessful$lambda$4$lambda$3() {
        HelpManager.getInstance().invokeHelp(GitBundle.message("gpg.pinentry.jb.manual.link", new Object[0]));
    }

    public static final /* synthetic */ Project access$getProject$p(GpgAgentConfigurationNotificator $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$showPinentryConfigurationNotification(GpgAgentConfigurationNotificator $this, boolean isSuggestion, NotificationType type) {
        $this.showPinentryConfigurationNotification(isSuggestion, type);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurationNotificator$GpgAgentConfiguratorNotification;", "Lcom/intellij/notification/Notification;", "displayId", "", "title", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "type", "Lcom/intellij/notification/NotificationType;", "isSuggestion", "", "<init>", "(Lgit4idea/commit/signing/GpgAgentConfigurationNotificator;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/notification/NotificationType;Z)V", "notifyExpirePrevious", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGpgAgentConfigurationNotificator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfigurationNotificator.kt\ngit4idea/commit/signing/GpgAgentConfigurationNotificator$GpgAgentConfiguratorNotification\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n3829#2:148\n4344#2,2:149\n1869#3,2:151\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfigurationNotificator.kt\ngit4idea/commit/signing/GpgAgentConfigurationNotificator$GpgAgentConfiguratorNotification\n*L\n140#1:148\n140#1:149,2\n141#1:151,2\n*E\n"})
    private final class GpgAgentConfiguratorNotification
    extends Notification {
        final /* synthetic */ GpgAgentConfigurationNotificator this$0;

        public GpgAgentConfiguratorNotification(@NotNull GpgAgentConfigurationNotificator this$0, @NotNull String displayId, @NotNull String title, @NotNull String content, NotificationType type, boolean isSuggestion) {
            Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.this$0 = this$0;
            super(VcsNotifier.importantNotification().getDisplayId(), title, content, type);
            this.setDisplayId(displayId);
            this.setSuggestionType(isSuggestion);
            this.configureDoNotAskOption(displayId, isSuggestion ? GitBundle.message("gpg.pinentry.configuration.global.suggestion.do.not.ask.again.display.name", new Object[0]) : GitBundle.message("gpg.pinentry.configuration.suggestion.do.not.ask.again.display.name", new Object[0]));
        }

        public /* synthetic */ GpgAgentConfiguratorNotification(GpgAgentConfigurationNotificator gpgAgentConfigurationNotificator, String string, String string2, String string3, NotificationType notificationType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                notificationType = NotificationType.INFORMATION;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(gpgAgentConfigurationNotificator, string, string2, string3, notificationType, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void notifyExpirePrevious(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GpgAgentConfigurationNotificator gpgAgentConfigurationNotificator = this.this$0;
            synchronized (gpgAgentConfigurationNotificator) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                boolean bl = false;
                Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(GpgAgentConfiguratorNotification.class, project);
                Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
                Object[] objectArray = notificationArray;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    GpgAgentConfiguratorNotification notification = (GpgAgentConfiguratorNotification)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)notification.getDisplayId(), (Object)this.getDisplayId())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GpgAgentConfiguratorNotification p0 = (GpgAgentConfiguratorNotification)((Object)element$iv);
                    boolean bl3 = false;
                    p0.expire();
                }
                this.notify(project);
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

