/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.main;

import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.rt.coverage.testDiscovery.instrumentation.OpenCloseFileTransformer;
import com.intellij.rt.coverage.testDiscovery.main.TestDiscoveryTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDiscoveryPremain {
    public static final String INCLUDE_PATTERNS_VM_OP = "test.discovery.include.class.patterns";
    public static final String EXCLUDE_PATTERNS_VM_OP = "test.discovery.exclude.class.patterns";

    /*
     * WARNING - void declaration
     */
    private void performPremain(Instrumentation instrumentation) throws Exception {
        void var1_1;
        void var2_2;
        void var3_3;
        System.out.println("---- IntelliJ IDEA Test Discovery ---- ");
        List<Pattern> include = TestDiscoveryPremain.patterns(INCLUDE_PATTERNS_VM_OP);
        List<Pattern> exclude = TestDiscoveryPremain.patterns(EXCLUDE_PATTERNS_VM_OP);
        TestDiscoveryProjectData.getProjectData();
        instrumentation.addTransformer(new TestDiscoveryTransformer((List<Pattern>)var3_3, (List<Pattern>)var2_2));
        TestDiscoveryPremain.addOpenCloseTransformer((Instrumentation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void addOpenCloseTransformer(Instrumentation instrumentation) throws UnmodifiableClassException {
        void var1_1;
        Instrumentation instrumentation2;
        if (!Boolean.parseBoolean(System.getProperty("test.discovery.track.files", "true"))) {
            System.out.println("Tracking for opened/closed files disabled by 'test.discovery.track.files' system property");
            return;
        }
        if (System.getProperty("test.discovery.affected.roots") == null) {
            System.out.println("Tracking for opened/closed files disabled due to undefined 'test.discovery.affected.roots' system property");
            return;
        }
        OpenCloseFileTransformer openCloseFileTransformer = new OpenCloseFileTransformer();
        instrumentation.addTransformer(openCloseFileTransformer, true);
        instrumentation2.retransformClasses(var1_1.classesToTransform());
    }

    private static List<Pattern> patterns(String key) {
        ArrayList arrayList;
        String[] stringArray;
        String property = System.getProperty(key);
        if (property == null) {
            return Collections.emptyList();
        }
        System.out.println("Patterns from " + key);
        ArrayList patterns = new ArrayList(1);
        for (String s : stringArray.split(";")) {
            try {
                patterns.add(Pattern.compile(s));
                System.out.println(s);
            }
            catch (PatternSyntaxException ex) {
                System.err.println("Problem occurred with pattern " + s);
                System.err.println(ex.getDescription());
                System.exit(1);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        void var1_1;
        new TestDiscoveryPremain().performPremain((Instrumentation)var1_1);
    }
}

