/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class AddReturnTypeFix
extends PsiUpdateModCommandAction<PsiElement> {
    public AddReturnTypeFix() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.return.type.to.method.declaration", new Object[0]);
        if (string == null) {
            AddReturnTypeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            AddReturnTypeFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            AddReturnTypeFix.$$$reportNull$$$0(2);
        }
        return AddReturnTypeFix.findMethod(element, context.offset()) != null ? Presentation.of((String)GroovyBundle.message("add.return.type", new Object[0])) : null;
    }

    @Nullable
    private static GrMethod findMethod(@NotNull PsiElement at, int offset) {
        PsiElement psiElement;
        if (at == null) {
            AddReturnTypeFix.$$$reportNull$$$0(3);
        }
        if ((psiElement = at.getParent()) instanceof GrReturnStatement) {
            GrTypeElement returnTypeElement;
            GrReturnStatement returnStatement = (GrReturnStatement)psiElement;
            PsiElement word = returnStatement.getReturnWord();
            if (!word.getTextRange().contains(offset)) {
                return null;
            }
            GroovyPsiElement returnOwner = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrClosableBlock.class, GrMethod.class});
            if (returnOwner instanceof GrMethod && (returnTypeElement = ((GrMethod)returnOwner).getReturnTypeElementGroovy()) == null) {
                return (GrMethod)returnOwner;
            }
            return null;
        }
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)at, GrMethod.class, (boolean)false, (Class[])new Class[]{GrTypeDefinition.class, GrClosableBlock.class});
        if (method == null) {
            return null;
        }
        TextRange headerRange = GrHighlightUtil.getMethodHeaderTextRange(method);
        if (!headerRange.contains(offset) && !headerRange.contains(offset - 1)) {
            return null;
        }
        if (method.isConstructor()) {
            return null;
        }
        if (method.getReturnTypeElementGroovy() != null) {
            return null;
        }
        return method;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        GrMethod method;
        if (context == null) {
            AddReturnTypeFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            AddReturnTypeFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            AddReturnTypeFix.$$$reportNull$$$0(6);
        }
        if ((method = AddReturnTypeFix.findMethod(element, context.offset())) == null) {
            return;
        }
        AddReturnTypeFix.applyFix(context.project(), method);
    }

    public static void applyFix(@NotNull Project project, @NotNull GrMethod method) {
        PsiType type;
        if (project == null) {
            AddReturnTypeFix.$$$reportNull$$$0(7);
        }
        if (method == null) {
            AddReturnTypeFix.$$$reportNull$$$0(8);
        }
        if ((type = method.getInferredReturnType()) == null) {
            type = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)method.getResolveScope());
        }
        type = TypesUtil.unboxPrimitiveTypeWrapper(type);
        GrReferenceAdjuster.shortenAllReferencesIn(method.setReturnType(type));
        method.getModifierList().setModifierProperty("def", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/style/AddReturnTypeFix";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/style/AddReturnTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

