/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.suppress;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/suppress/CaretBox;", "E", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "expression", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/openapi/editor/Editor;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "offsetInExpression", "", "positionCaretInCopy", "", "copy", "Lcom/intellij/psi/PsiElement;", "kotlin.base.code-insight"})
final class CaretBox<E extends KtExpression> {
    @NotNull
    private final E expression;
    @Nullable
    private final Editor editor;
    private final int offsetInExpression;

    public CaretBox(@NotNull E expression, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        this.expression = expression;
        this.editor = editor;
        Editor editor2 = this.editor;
        int n = editor2 != null && (editor2 = editor2.getCaretModel()) != null ? editor2.getOffset() : 0;
        TextRange textRange = ((PsiElement)this.expression).getTextRange();
        Intrinsics.checkNotNull((Object)textRange);
        this.offsetInExpression = n - textRange.getStartOffset();
    }

    @NotNull
    public final E getExpression() {
        return this.expression;
    }

    public final void positionCaretInCopy(@NotNull PsiElement copy) {
        Intrinsics.checkNotNullParameter((Object)copy, (String)"copy");
        if (this.editor == null) {
            return;
        }
        this.editor.getCaretModel().moveToOffset(copy.getTextOffset() + this.offsetInExpression);
    }
}

