/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.bytecode;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.ThreadingAssertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LongRunningReadTask<RequestInfo, ResultData> {
    private final Disposable parentDisposable;
    private ProgressIndicator progressIndicator = null;
    private RequestInfo requestInfo = null;
    private State currentState = State.NOT_INITIALIZED;

    protected LongRunningReadTask(Disposable disposable) {
        this.parentDisposable = disposable;
    }

    public boolean shouldStart(@Nullable LongRunningReadTask<RequestInfo, ResultData> previousTask) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.currentState != State.INITIALIZED) {
            throw new IllegalStateException("Task should be initialized state. Call init() method.");
        }
        if (!(previousTask == null || previousTask.currentState != State.STARTED || this.requestInfo != null && this.requestInfo.equals(previousTask.requestInfo))) {
            previousTask.progressIndicator.cancel();
        }
        if (this.requestInfo == null) {
            if (previousTask != null && (previousTask.currentState == State.FINISHED_WITH_ACTUAL_DATA || previousTask.currentState == State.FINISHED)) {
                previousTask.hideResultOnInvalidLocation();
            }
            return false;
        }
        if (previousTask != null) {
            if (previousTask.currentState == State.STARTED) {
                return !this.requestInfo.equals(previousTask.requestInfo);
            }
            if (previousTask.currentState == State.FINISHED_WITH_ACTUAL_DATA && this.requestInfo.equals(previousTask.requestInfo)) {
                return false;
            }
        }
        return true;
    }

    public final void run() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.currentState != State.INITIALIZED) {
            throw new IllegalStateException("Task should be initialized with init() method");
        }
        if (this.requestInfo == null) {
            throw new IllegalStateException("Invalid request for task beginning");
        }
        this.currentState = State.STARTED;
        this.beforeRun();
        this.progressIndicator = new ProgressIndicatorBase();
        RequestInfo requestInfoCopy = this.cloneRequestInfo(this.requestInfo);
        ApplicationManager.getApplication().executeOnPooledThread(() -> LongRunningReadTask.runWithWriteActionPriority(this.progressIndicator, this.parentDisposable, () -> {
            Object resultData = null;
            try {
                resultData = this.processRequest(requestInfoCopy);
            }
            finally {
                Object finalResult = resultData;
                ApplicationManager.getApplication().invokeLater(() -> this.resultReady(finalResult));
            }
        }));
    }

    public final boolean init() {
        ThreadingAssertions.assertEventDispatchThread();
        this.requestInfo = this.prepareRequestInfo();
        this.currentState = State.INITIALIZED;
        return this.requestInfo != null;
    }

    private void resultReady(ResultData resultData) {
        RequestInfo actualInfo;
        ThreadingAssertions.assertEventDispatchThread();
        this.currentState = State.FINISHED;
        if (resultData != null && this.requestInfo.equals(actualInfo = this.prepareRequestInfo())) {
            this.currentState = State.FINISHED_WITH_ACTUAL_DATA;
            this.onResultReady(actualInfo, resultData);
        }
    }

    @NotNull
    protected RequestInfo cloneRequestInfo(@NotNull RequestInfo requestInfo) {
        RequestInfo cloneRequestInfo;
        if (requestInfo == null) {
            LongRunningReadTask.$$$reportNull$$$0(0);
        }
        if ((cloneRequestInfo = this.prepareRequestInfo()) == null) {
            throw new IllegalStateException("Cloned request object can't be null");
        }
        RequestInfo RequestInfo = cloneRequestInfo;
        if (RequestInfo == null) {
            LongRunningReadTask.$$$reportNull$$$0(1);
        }
        return RequestInfo;
    }

    @Nullable
    protected abstract RequestInfo prepareRequestInfo();

    protected void hideResultOnInvalidLocation() {
    }

    protected void beforeRun() {
    }

    @Nullable
    protected abstract ResultData processRequest(@NotNull RequestInfo var1);

    protected void onResultReady(@NotNull RequestInfo requestInfo, @Nullable ResultData resultData) {
        if (requestInfo == null) {
            LongRunningReadTask.$$$reportNull$$$0(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithWriteActionPriority(final @NotNull ProgressIndicator indicator, @NotNull Disposable parentDisposable, @NotNull Runnable action2) {
        if (indicator == null) {
            LongRunningReadTask.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            LongRunningReadTask.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            LongRunningReadTask.$$$reportNull$$$0(5);
        }
        Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)parentDisposable, (Disposable)disposable);
        ApplicationListener listener2 = new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/kotlin/idea/jvm/shared/bytecode/LongRunningReadTask$1", "beforeWriteActionStart"));
            }
        };
        Application application = ApplicationManager.getApplication();
        try {
            application.addApplicationListener(listener2, disposable);
            ProgressManager.getInstance().runProcess(() -> application.runReadAction(action2), indicator);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/jvm/shared/bytecode/LongRunningReadTask";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/jvm/shared/bytecode/LongRunningReadTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneRequestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cloneRequestInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onResultReady";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWithWriteActionPriority";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum State {
        NOT_INITIALIZED,
        INITIALIZED,
        STARTED,
        FINISHED,
        FINISHED_WITH_ACTUAL_DATA;

    }
}

