/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.ConvertClassToKClassFix;
import org.jetbrains.kotlin.idea.quickfix.ConvertClassToKClassFixFactoryKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertClassToKClassFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "<init>", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class ConvertClassToKClassFixFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final ConvertClassToKClassFixFactory INSTANCE = new ConvertClassToKClassFixFactory();

    private ConvertClassToKClassFixFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticWithParameters2 casted = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast((UnboundDiagnostic)diagnostic);
        PsiElement psiElement = casted.getPsiElement();
        KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
        if (ktDotQualifiedExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtDotQualifiedExpression element = ktDotQualifiedExpression;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)casted.getA()).getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor expectedClassDescriptor = classDescriptor;
        if (!KotlinBuiltIns.isKClass((ClassDescriptor)expectedClassDescriptor)) {
            return CollectionsKt.emptyList();
        }
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL);
        KotlinType kotlinType = bindingContext.getType((KtExpression)element);
        if (kotlinType == null) {
            return CollectionsKt.emptyList();
        }
        KotlinType expressionType = kotlinType;
        if (!ConvertClassToKClassFixFactoryKt.isJClass(expressionType)) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = element.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
        Object[] children = objectArray;
        if (children.length != 2) {
            return CollectionsKt.emptyList();
        }
        Object object = ArraysKt.first((Object[])children);
        KtExpression ktExpression = object instanceof KtExpression ? (KtExpression)object : null;
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression firstChild = ktExpression;
        KotlinType kotlinType2 = bindingContext.getType(firstChild);
        if (kotlinType2 == null) {
            return CollectionsKt.emptyList();
        }
        KotlinType firstChildType = kotlinType2;
        Object object2 = casted.getA();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-a>(...)");
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)firstChildType, (KotlinType)((KotlinType)object2))) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new ConvertClassToKClassFix(element).asIntention());
    }
}

