/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/FirJvmNamesChecker;", "", "<init>", "()V", "INVALID_CHARS", "", "", "DANGEROUS_CHARS", "checkNameAndReport", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "declarationSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmNamesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmNamesChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/FirJvmNamesChecker\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,46:1\n1088#2,2:47\n1088#2,2:49\n*S KotlinDebug\n*F\n+ 1 FirJvmNamesChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/FirJvmNamesChecker\n*L\n28#1:47,2\n35#1:49,2\n*E\n"})
public final class FirJvmNamesChecker {
    @NotNull
    public static final FirJvmNamesChecker INSTANCE = new FirJvmNamesChecker();
    @NotNull
    private static final Set<Character> INVALID_CHARS;
    @NotNull
    private static final Set<Character> DANGEROUS_CHARS;

    private FirJvmNamesChecker() {
    }

    public final void checkNameAndReport(@NotNull Name name2, @Nullable KtSourceElement declarationSource, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declarationSource != null && !(declarationSource.getKind() instanceof KtFakeSourceElementKind) && !name2.isSpecial()) {
            boolean bl;
            char it;
            char element$iv;
            int n;
            boolean $i$f$any;
            CharSequence $this$any$iv;
            String nameString;
            block6: {
                String string2 = name2.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                nameString = string2;
                $this$any$iv = nameString;
                $i$f$any = false;
                for (n = 0; n < $this$any$iv.length(); ++n) {
                    it = element$iv = $this$any$iv.charAt(n);
                    boolean bl2 = false;
                    if (!INVALID_CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declarationSource, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)("contains illegal characters: " + CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)INVALID_CHARS, (Iterable)StringsKt.toSet(nameString)), "", null, null, 0, null, null, 62, null)), (DiagnosticContext)context, null, 16, null);
            } else {
                boolean bl3;
                block7: {
                    $this$any$iv = nameString;
                    $i$f$any = false;
                    for (n = 0; n < $this$any$iv.length(); ++n) {
                        it = element$iv = $this$any$iv.charAt(n);
                        boolean bl4 = false;
                        if (!DANGEROUS_CHARS.contains(Character.valueOf(it))) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declarationSource, FirJvmErrors.INSTANCE.getDANGEROUS_CHARACTERS(), (Object)CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)DANGEROUS_CHARS, (Iterable)StringsKt.toSet(nameString)), "", null, null, 0, null, null, 62, null), (DiagnosticContext)context, null, 16, null);
                }
            }
        }
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\')};
        INVALID_CHARS = SetsKt.setOf(characterArray);
        characterArray = new Character[]{Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('%')};
        DANGEROUS_CHARS = SetsKt.setOf(characterArray);
    }
}

