/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryManifest;
import org.jetbrains.kotlin.library.abi.LibraryTarget;
import org.jetbrains.kotlin.library.abi.impl.AbiSignatureVersions;
import org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.util.DummyLogger;

@ExperimentalLibraryAbiReader
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl;", "", "libraryFile", "Ljava/io/File;", "filters", "", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "<init>", "(Ljava/io/File;Ljava/util/List;)V", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "compositeFilter", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite;", "readAbi", "Lorg/jetbrains/kotlin/library/abi/LibraryAbi;", "readManifest", "Lorg/jetbrains/kotlin/library/abi/LibraryManifest;", "readSupportedSignatureVersions", "", "Lorg/jetbrains/kotlin/library/abi/AbiSignatureVersion;", "malformedLibrary", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "kotlin-util-klib-abi"})
@SourceDebugExtension(value={"SMAP\nLibraryAbiReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,814:1\n1#2:815\n1634#3,3:816\n1634#3,3:819\n1634#3,3:822\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n*L\n84#1:816,3\n85#1:819,3\n94#1:822,3\n*E\n"})
public final class LibraryAbiReaderImpl {
    @NotNull
    private final KotlinLibrary library;
    @Nullable
    private final AbiReadingFilter.Composite compositeFilter;

    /*
     * WARNING - void declaration
     */
    public LibraryAbiReaderImpl(@NotNull File libraryFile, @NotNull List<? extends AbiReadingFilter> filters) {
        KotlinLibrary kotlinLibrary;
        Intrinsics.checkNotNullParameter(libraryFile, "libraryFile");
        Intrinsics.checkNotNullParameter(filters, "filters");
        LibraryAbiReaderImpl libraryAbiReaderImpl = this;
        try {
            KotlinLibrary kotlinLibrary2;
            LibraryAbiReaderImpl libraryAbiReaderImpl2 = libraryAbiReaderImpl;
            String string2 = libraryFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string2, "getAbsolutePath(...)");
            KotlinLibrary kotlinLibrary3 = ToolingSingleFileKlibResolveStrategy.INSTANCE.tryResolve(new org.jetbrains.kotlin.konan.file.File(string2), DummyLogger.INSTANCE);
            if (kotlinLibrary3 != null) {
                void $this$library_u24lambda_u242;
                KotlinLibrary kotlinLibrary4;
                KotlinLibrary kotlinLibrary5 = kotlinLibrary4 = kotlinLibrary3;
                LibraryAbiReaderImpl libraryAbiReaderImpl3 = libraryAbiReaderImpl2;
                boolean bl = false;
                if (!(((CharSequence)KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)$this$library_u24lambda_u242)).length() > 0)) {
                    boolean $i$a$-check-LibraryAbiReaderImpl$library$1$32 = false;
                    String $i$a$-check-LibraryAbiReaderImpl$library$1$32 = "Can't read unique name from manifest";
                    throw new IllegalStateException($i$a$-check-LibraryAbiReaderImpl$library$1$32.toString());
                }
                if (!$this$library_u24lambda_u242.getHasIr()) {
                    boolean bl2 = false;
                    String string3 = "Library does not have IR";
                    throw new IllegalStateException(string3.toString());
                }
                libraryAbiReaderImpl2 = libraryAbiReaderImpl3;
                kotlinLibrary2 = kotlinLibrary4;
            } else {
                kotlinLibrary2 = null;
            }
            kotlinLibrary = kotlinLibrary2;
        }
        catch (Exception exception) {
            void e;
            LibraryAbiReaderImpl libraryAbiReaderImpl4 = libraryAbiReaderImpl;
            this.malformedLibrary(libraryFile, (Exception)e);
            throw new KotlinNothingValueException();
        }
        KotlinLibrary kotlinLibrary6 = kotlinLibrary;
        if (kotlinLibrary6 == null) {
            throw new IllegalStateException(("Library not found: " + libraryFile).toString());
        }
        libraryAbiReaderImpl2.library = kotlinLibrary6;
        this.compositeFilter = !((Collection)filters).isEmpty() ? new AbiReadingFilter.Composite(filters) : null;
    }

    @NotNull
    public final LibraryAbi readAbi() {
        Set<AbiSignatureVersion> supportedSignatureVersions = this.readSupportedSignatureVersions();
        return new LibraryAbi(this.readManifest(), KotlinLibraryKt.getUniqueName(this.library), supportedSignatureVersions, new LibraryDeserializer(this.library, supportedSignatureVersions, this.compositeFilter).deserialize());
    }

    /*
     * WARNING - void declaration
     */
    private final LibraryManifest readManifest() {
        String p0;
        Collection collection;
        void $this$readManifest_u24lambda_u244;
        List list;
        KotlinLibraryVersioning versions2 = this.library.getVersions();
        BuiltInsPlatform builtInsPlatform = KotlinLibraryKt.getBuiltInsPlatform((BaseKotlinLibrary)this.library);
        List list2 = list = CollectionsKt.createListBuilder();
        String string2 = builtInsPlatform != null ? builtInsPlatform.name() : null;
        boolean bl = false;
        Iterable $this$mapTo$iv = CollectionsKt.sorted((Iterable)KotlinLibraryKt.getNativeTargets(this.library));
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string3 = (String)item$iv;
            collection = (Collection)$this$readManifest_u24lambda_u244;
            boolean bl2 = false;
            collection.add(new LibraryTarget.Native(p0));
        }
        Collection cfr_ignored_0 = (Collection)$this$readManifest_u24lambda_u244;
        $this$mapTo$iv = CollectionsKt.sorted((Iterable)KotlinLibraryKt.getWasmTargets(this.library));
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            p0 = (String)item$iv;
            collection = (Collection)$this$readManifest_u24lambda_u244;
            boolean bl3 = false;
            collection.add(new LibraryTarget.WASM(p0));
        }
        Collection cfr_ignored_1 = (Collection)$this$readManifest_u24lambda_u244;
        KotlinAbiVersion kotlinAbiVersion = versions2.getAbiVersion();
        String string4 = KotlinLibraryKt.getIrProviderName(this.library);
        String string5 = kotlinAbiVersion != null ? kotlinAbiVersion.toString() : null;
        String string6 = versions2.getCompilerVersion();
        List list3 = CollectionsKt.build(list);
        String string7 = string2;
        return new LibraryManifest(string7, list3, string6, string5, string4);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AbiSignatureVersion> readSupportedSignatureVersions() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.library.getVersions().getIrSignatureVersions();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KotlinIrSignatureVersion kotlinIrSignatureVersion = (KotlinIrSignatureVersion)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(AbiSignatureVersions.INSTANCE.resolveByVersionNumber(it.getNumber()));
        }
        return (Set)var2_2;
    }

    private final Void malformedLibrary(File libraryFile, Exception cause) {
        throw new IllegalArgumentException("Malformed library: " + libraryFile, cause);
    }
}

