/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanCrazyParseDetector;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.tools.StringTools;

class VerbFormChoice {
    static final String MISSING_VERB_MSG = "Fehlt ein Verb?";
    private static final String REDUNDANT_AUX = "Redundantes Hilfsverb?";
    private static final String REDUNDANT_VERB = "Redundantes Verb?";
    private static final NodePattern pastTense = NodePattern.N.withHead(CommonPatterns.skipConjUp(NodePattern.or(NodePattern.N.pos(".*PRT.*"), NodePattern.N.withDependent("aux|cop", NodePattern.N.pos(".*PRT.*")))));

    VerbFormChoice() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Grammar.VERB_FORM_CHOICE", "Falsche Verwendung von Verbformen", "Nach Hilfsverben sollte Infinitiv oder Partizip verwendet werden.", null, () -> NodePattern.or(VerbFormChoice.finiteVerbInsteadOfInfinitiveOrParticiple(), VerbFormChoice.missingFiniteVerb(), VerbFormChoice.redundantVerb(), VerbFormChoice.unnecessaryKonjunktiv(), VerbFormChoice.substituteInfinitive(), VerbFormChoice.incorrectVerbChoice(), VerbFormChoice.wordeWurde(), VerbFormChoice.incongruentConjVerb(), VerbFormChoice.falseImperative(), VerbFormChoice.unnecessaryExpletive(), VerbFormChoice.finiteVerbInInfinitiveClause()), new Example("Danach kannst du es <b>anpasse</b>.", "Danach kannst du es <b>anpassen</b>."), new Example("Er sagte, dass wir es schon <b>gemacht</b>.", "Er sagte, dass wir es schon <b>gemacht hatten</b>."), new Example("Da musste ich im Krankenhaus bleiben <b>wird</b>.", "Da musste ich im Krankenhaus <b>bleiben</b>."));
    }

    private static NodePattern finiteVerbInInfinitiveClause() {
        return NodePattern.ROOT.pos("VER:IMP:SIN.*").form(".+e").noDependents("nsubj(:pass)?|aux(:pass)?|cop|csubj|xcomp").withDependent("i?obj|obl", NodePattern.N.beforeHead()).noDependents("nsubj(:pass)?|i?obj|obl|nmod|compound|advmod|conj", NodePattern.N.afterHead()).correct(NodeCorrector.inflect("VER:IMP:SIN.*", "VER:INF:.*")).message("Meinten Sie Infinitiv?");
    }

    private static NodePattern falseImperative() {
        return CommonPatterns.firstWord.pos(".*2:SIN:PR\u00c4.*").markAs("Verb").and(CommonPatterns.skipUp("cop", NodePattern.ROOT.withDependent("nsubj", NodePattern.N.form("du").directlyAfter("Verb").directlyBefore(NodePattern.N.noForm("aber"))).noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").withPhraseEnd(CommonPatterns.skipBack(GermanTreePatterns.anyQuotation, NodePattern.N.noForm(".*\\?.*")).andNot(CommonPatterns.dot.directlyAfter(NodePattern.N.form("Mt"))).andOr(NodePattern.markedNodeMatches("Verb", NodePattern.N.withDependent("discourse", NodePattern.N.form("bitte"))), NodePattern.or(CommonPatterns.dot, CommonPatterns.ellipsis, NodePattern.N.form(".*!.*")).correct(NodeCorrector.replace("?")), NodePattern.N.correct(NodeCorrector.insertAfter("?")))))).noLemma("sehen|gucken|kennen|haben").noPos(".*MOD.*").correct(NodeCorrector.inflect("VER:2:SIN:PR\u00c4.*", "VER:IMP:SIN.*").join(NodeCorrector.replace(NodePointer.neighbor(1), ""))).message("Meinten Sie eine Aufforderung oder eine Frage?");
    }

    private static NodePattern withoutClauseBetween(String label) {
        return NodePattern.N.noDependents("a(dv)?cl|ccomp|conj", NodePattern.N.before(label).afterHead());
    }

    static List<NodeCorrector> calculatePossibleVerbReplacements(Node head, NodeMatch match, String lemma, Node anchor) {
        String number;
        String tense = pastTense.matches(head) ? "PRT" : "PR\u00c4";
        Node subj = match.getMarkedNode("Subj");
        String subjLowForm = subj.lowForm();
        String string = subjLowForm.equals("wir") || subjLowForm.equals("ihr") ? "PLU" : (subjLowForm.equals("ich") || subjLowForm.equals("du") ? "SIN" : (!subj.hasPos(".*") || subj.hasPos(".*NOM:SIN.*") || subj.nerLabel() != null ? "SIN" : (number = subj.hasPos(".*NOM:PLU.*") ? "PLU" : ".*")));
        String person = subjLowForm.equals("ich") || subjLowForm.equals("wir") ? "1" : (subjLowForm.equals("du") || subjLowForm.equals("ihr") ? "2" : "3");
        return head.tree().treeSupport().synthesize(lemma, lemma, "VER:INF.*", "VER:" + person + ":" + number + ":" + tense + ".*").stream().map(s -> NodeCorrector.insertAfter(anchor, " " + s)).toList();
    }

    private static NodePattern missingFiniteVerb() {
        NodePattern seinVerb = WordSet.loadResource((String)"de/sein_verben.txt").lemmaPattern;
        return NodePattern.N.withHeadRelation("ccomp|a(dv)?cl|csubj").pos("PA2:PRD.*").noPos("VER:([123]|INF).*").andOr(NodePattern.not(NodePattern.N.withHeadRelation("acl")), NodePattern.N.withDependent(".*", GermanTreePatterns.firstInPhraseAfterCommasOrConj.lemma("der"))).andOr(NodePattern.not(NodePattern.N.withHeadRelation("advcl")), NodePattern.N.withDependent("mark")).noDependents("aux(:pass)?|cop").noDependents("conj", NodePattern.N.withDependent("aux(:pass)?|cop")).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VER:AUX.*"))).withDependent("nsubj(:pass)?", NodePattern.N.markAs("Subj")).withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.N.withHeadRelation("conj|punct"))).and((head, match) -> match.withCorrectors(VerbFormChoice.calculatePossibleVerbReplacements(head, match, seinVerb.matches(head) ? "sein" : "haben", head)).withMessage(MISSING_VERB_MSG));
    }

    private static NodePattern redundantVerb() {
        NodePattern finiteAux = NodePattern.N.anyPos().andOr(NodePattern.N.noPos(".*(INF|PA2).*"), NodePattern.N.form("werden").withHead("aux(:pass)?", NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.lemma("sein")))).noDependents("punct").andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cc").directlyBefore(NodePattern.N.withHeadRelation("aux(:pass)?"))));
        NodePattern mayBeFiniteVerb = NodePattern.N.pos("VER:[123].*").noPos("ART.*");
        NodePattern doubleInfCSubj = NodePattern.N.withDependent("csubj", NodePattern.N.pos("VER:INF.*").markAs("CSubj").correct(NodeCorrector.replace("")).message(REDUNDANT_VERB)).withDependent("csubj", NodePattern.N.after("CSubj").sameWordAs("CSubj"));
        NodePattern doubleCopula = NodePattern.N.withDependent("cop|dep", mayBeFiniteVerb.lemma("sein").noPos(".*KJ.*").noDependents().markAs("Cop1")).withDependent("cop|dep", mayBeFiniteVerb.lemma("sein").after("Cop1").noDependents().markAs("Cop2")).noDependents(NodePattern.N.between("Cop1", "Cop2").andOr(NodePattern.N.withHeadRelation("a(dv)?cl|parataxis|ccomp|mark|cc"), NodePattern.N.withHeadRelation("nmod").withDependent("mark"), NodePattern.N.withPhraseStart(CommonPatterns.capitalized.noPos()))).andOr(NodePattern.N.withDependent("mark").and(NodePattern.markedNodeMatches("Cop1", NodePattern.N.correct(NodeCorrector.replace("")))), NodePattern.markedNodeMatches("Cop2", NodePattern.N.correct(NodeCorrector.replace("")))).andNot(CommonPatterns.severalDependents("nsubj(:pass)?")).message(REDUNDANT_AUX);
        NodePattern looksLikeVerbFinalClause = NodePattern.or(NodePattern.N.withDependent("mark", NodePattern.N.noForm("denn")), NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("denn"))), NodePattern.N.pos(".*INF.*").withHead("conj", NodePattern.N.withDependent("aux(:pass)?")), NodePattern.N.withDependent("cop|aux(:pass)?", NodePattern.N.beforeHead()));
        NodePattern doubleVerb = mayBeFiniteVerb.markAs("Head").andOr(NodePattern.N.withDependent("conj|dep|parataxis", mayBeFiniteVerb.andOr(NodePattern.N.sameWordAs("Head").andNot(NodePattern.N.pos(".*AUX.*").pos(".*INF.*")), NodePattern.N.lemma("sein|werden").withHead("dep", NodePattern.N.noPos(".*PA2:PRD.*")).noDependents(), NodePattern.N.withHead("dep", NodePattern.N.noDependents("cop|aux(:pass)?").noHeadRelation("xcomp")).noDependents().andOr(NodePattern.N.directlyAfter("Head"), NodePattern.N.directlyBefore("Head")).andOr(NodePattern.N.pos(".*PR\u00c4.*").and(NodePattern.markedNodeMatches("Head", NodePattern.N.pos(".*PR\u00c4.*"))), NodePattern.N.pos(".*PRT.*").and(NodePattern.markedNodeMatches("Head", NodePattern.N.pos(".*PRT.*")))).markAs("Dep")).andOr(NodePattern.N.withHeadRelation("conj").noDependents("cc|punct"), NodePattern.N.withHeadRelation("dep|parataxis").noDependents("nsubj(:pass)?")).noDependents("punct|discourse").andNot(NodePattern.N.withPhraseStart(CommonPatterns.capitalized.noPos())).andNot(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(CommonPatterns.ellipsis))).noLabel(".*").markAs("Verb")).noDependents("conj|dep|parataxis", NodePattern.not(NodePattern.N.alreadyMarkedAs("Verb")).sameWordAs("Verb")).noDependents("punct", NodePattern.N.between("Head", "Verb")), NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|cop|aux(:pass)?").directlyAfter(mayBeFiniteVerb.onlyPos("VER.*").withHead("conj", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")).withDependent("nsubj").andNot(CommonPatterns.severalDependents("nsubj(:pass)?")).noLabel(".*").markAs("Verb")).andNot(NodePattern.N.directlyAfterHead())).andOr(NodePattern.markedNodeMatches("Verb", NodePattern.N.alreadyMarkedAs("Dep").correct(NodeCorrector.replace(""))).correct(NodeCorrector.replace("")), NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.before("Verb")).and(NodePattern.markedNodeMatches("Verb", NodePattern.N.directlyAfter(NodePattern.PUNCT).directlyBefore(CommonPatterns.dot.and(CommonPatterns.lastToken)).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodeMatch::anchor, "")).reportEverythingTouched())), looksLikeVerbFinalClause.before("Verb").correct(NodeCorrector.replace("")), NodePattern.markedNodeMatches("Verb", NodePattern.N.correct(NodeCorrector.replace("")))).message(REDUNDANT_VERB);
        NodePattern checkPossibleWordenConfusion = NodePattern.or(NodePattern.N.form("w[ue\u00fc]rden").correct(NodeCorrector.replace("worden")), NodePattern.N.correct(NodeCorrector.replace("")));
        NodePattern doubleAux = NodePattern.or(finiteAux.markAs("Aux1").withHead("aux(:pass)?", NodePattern.not(CommonPatterns.severalDependents("nsubj(:pass)?")).noDependents("conj").andOr(NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.after("Aux1").and(finiteAux).markAs("Aux2")), NodePattern.N.withDependent("cop", NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.after("Aux1").and(finiteAux).markAs("Aux2"))))).andOr(NodePattern.N.pos("VER:MOD.*").and(NodePattern.markedNodeMatches("Aux2", NodePattern.N.withHead("aux:pass", NodePattern.or(NodePattern.N.pos(".*PA2.*"), NodePattern.N.form("ge.*")).noDependents("aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("Aux2")))).correct(NodeCorrector.replace("werden")))).message("Bei Modalverben wird der Infinitiv verwendet"), NodePattern.or(NodePattern.N.withHead(NodePattern.N.withDependent("mark")).and(checkPossibleWordenConfusion), NodePattern.markedNodeMatches("Aux2", checkPossibleWordenConfusion)).message(REDUNDANT_AUX)), NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.noForm("werden").markAs("Aux")).sameWordAs("Aux").andOr(NodePattern.N.withDependent("mark").and(NodePattern.markedNodeMatches("Aux", NodePattern.N.correct(NodeCorrector.replace("")))), NodePattern.N.correct(NodeCorrector.replace(""))).message(REDUNDANT_VERB), NodePattern.N.form("(ge)?worden").markAs("Aux1").withHead("aux(:pass)?", NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.lemma("werden").before("Aux1"))).correct(NodeCorrector.replace("")).message(REDUNDANT_AUX));
        return NodePattern.or(doubleAux, doubleVerb, doubleCopula, doubleInfCSubj);
    }

    private static NodePattern unnecessaryKonjunktiv() {
        return StyleRules.prohibitKonjunktiv().form(".+es?t").andNot(CommonPatterns.skipConjUp(CommonPatterns.skipUp("aux", NodePattern.N.withHead("acl", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound"))))).andNot(NodePattern.N.withHeadRelation("parataxis").withPrevSibling(NodePattern.N.withHeadRelation("ccomp"))).andNot(NodePattern.N.form(".+e").and(CommonPatterns.skipConjUp(CommonPatterns.skipUp("aux", NodePattern.ROOT)))).andNot(CommonPatterns.skipConjUp(CommonPatterns.skipUp("aux", NodePattern.N.withDependent("mark", NodePattern.N.form("dass"))))).andNot(CommonPatterns.skipConjUp(CommonPatterns.skipUp("aux", CommonPatterns.skipConjUp(NodePattern.N.withHead(NodePattern.N.withHeadRelation("ccomp")))))).andNot(CommonPatterns.skipConjUp(CommonPatterns.skipUp("aux", NodePattern.N.withHeadRelation("ccomp"))));
    }

    private static NodePattern unnecessaryExpletive() {
        NodePattern das = NodePattern.N.form("das");
        return NodePattern.N.form(".+s").noPos().andOr(NodePattern.N.withDependent("expl"), NodePattern.N.withHead("cop", NodePattern.N.pos("ADV:MOD|ADJ:PRD:GRU").withDependent("nsubj", das)).directlyBeforeHead(), NodePattern.N.withDependent("nsubj", das).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("sich")), NodePattern.N.withDependent("obj", NodePattern.N.form("ni(chts|x)|etwas"))), NodePattern.N.form("brauchts").withDependent("nsubj", NodePattern.or(NodePattern.N.pos("SUB.*"), NodePattern.N.label("PERSON"))).withDependent("xcomp").noDependents("obj")).message("Die Verschmelzung der Verbform mit \u201ees\u201c ist hier unwahrscheinlich").and(node -> node.tree().treeSupport().tagToken(node.form().substring(0, node.form().length() - 1)).hasPos("VER.*")).correct(NodeCorrector.regexReplace("(.*)s", "$1"));
    }

    private static NodePattern finiteVerbInsteadOfInfinitiveOrParticiple() {
        WordSet seinVerb = WordSet.loadResource("de/sein_verben.txt");
        WordSet habenUndSeinVerb = WordSet.loadResource("de/haben_und_sein_verben.txt");
        NodePattern seinHead = NodePattern.or(seinVerb.lemmaPattern, habenUndSeinVerb.lemmaPattern);
        NodePattern withPastActionMarkers = NodePattern.N.withDependent("advmod|ob[lj]", NodePattern.or(NodePattern.N.form("schon|bereits|sofort"), NodePattern.N.withDependent("case|amod", NodePattern.or(NodePattern.N.form("vor|seit|ab"), NodePattern.N.lemma("letzte")))));
        return NodePattern.N.pos("(VER|PA2:(NOM|AKK|DAT|GEN)).*").noPos(".*(ART|EIZ|ZAL).*").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("mark")).pos(".*INF.*")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("wie"))).noDependents("det(:poss)?").andNot(NodePattern.N.form(".*[^e]n").potentialPos(".*IMP:SIN.*")).andNot(CommonPatterns.insideQuotes).noForm("durch(arbeitet|schnitten|s\u00e4gt)|entflochten|\u00fcbergeben|erhalten").andNot(NodePattern.N.inFormSequence(1, "zu", "ende").withDependent("cop")).andOr(NodePattern.N.noDependents("aux", NodePattern.N.withDependent("nsubj.*")), NodePattern.N.noDependents("nsubj.*")).andNot(CommonPatterns.capitalizedMiddle.label(".*")).andNot(GermanCrazyParseDetector.softHyphen).andNot(CommonPatterns.severalDependents("nsubj(:pass)?")).andOr(NodePattern.or(NodePattern.or(NodePattern.N.withDependent("aux", NodePattern.N.lemma("werden").markAs("Future")).and(VerbFormChoice.withoutClauseBetween("Future")).noDependents("conj"), NodePattern.N.withDependent("aux", NodePattern.N.pos("VER:MOD.*").markAs("ModalVerb")).and(VerbFormChoice.withoutClauseBetween("ModalVerb"))).noDependents("cop|(nsubj|aux):pass").noDependents("conj", NodePattern.N.withDependent("aux:pass")).noDependents("aux", NodePattern.N.form("haben|sein")), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("mark").form("zu")).markAs("Infinitive").andOr(NodePattern.N.noDependents("cop|aux(:pass)?", NodePattern.N.lemma("sein")), NodePattern.custom(verb -> !verb.lemmaReadings().isEmpty() && !verb.tree().treeSupport().isAcceptedBySpellchecker("zu" + verb.lemmaReadings().get(0)))).noDependents("aux", NodePattern.N.lemma("haben").directlyAfter(NodePattern.N.form("zu"))).andOptionally(NodePattern.or(NodePattern.N.form("fuhren").correct(NodeCorrector.replace("f\u00fchren")), NodePattern.N.form("lasen").correct(NodeCorrector.replace("lassen")))), NodePattern.N.withHeadRelation("aux:pass").withNextSibling(NodePattern.N.withHeadRelation("aux").pos("VER:MOD.*").markAs("ModalVerb"))).noPos(".*INF.*"), NodePattern.or(NodePattern.or(NodePattern.or(NodePattern.N.withDependent("aux:pass", NodePattern.N.markAs("Passive")).noDependents("obj"), NodePattern.N.withDependent("aux", NodePattern.N.lemma("sein").noPos(".*KJ2.*").markAs("Passive")).noDependents("obj").andNot(seinHead)).and(VerbFormChoice.withoutClauseBetween("Passive")), NodePattern.N.withDependent("aux", NodePattern.N.lemma("sein").noPos(".*KJ2.*").markAs("FiniteVerb")).withDependent("obj").andNot(seinHead), NodePattern.N.withDependent("aux", NodePattern.N.lemma("sein").pos(".*KJ2.*").markAs("Subjunctive")).andNot(seinHead)).noDependents("cop").withDependent("(nsubj|expl).*"), NodePattern.N.withDependent("cop", NodePattern.N.lemma("sein")).noPos(".*(KJ2|AD[JV]|SUB|PA1).*").markAs("Passive").noDependents("obj").andNot(seinHead).withDependent("(nsubj|expl).*").and(VerbFormChoice.withoutClauseBetween("Passive")), NodePattern.N.withDependent("aux", NodePattern.or(NodePattern.N.lemma("haben").withHead(NodePattern.not(seinHead)).andOptionally(NodePattern.N.pos("VER:.*PR\u00c4.*").withHead(NodePattern.ROOT.pos("VER:INF:(SFT|NON)").andOr(NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", CommonPatterns.possiblySkipDown("aux:pass", NodePattern.N.pos("VER.*PR\u00c4.*"))), CommonPatterns.lastWord.noDependents("advcl", NodePattern.N.beforeHead())).andNot(withPastActionMarkers).markAs("ZuInfinitive"))), NodePattern.N.lemma("sein").withHead(seinHead)).noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|advmod").markAs("Perfect")).andNot(NodePattern.N.form("brauchen|sehen|h\u00f6ren|k\u00f6nnen|d\u00fcrfen|wollen|sollen|m\u00fcssen|lassen").withDependent("xcomp")).noForm("fragen").andOr(NodePattern.N.noPos("VER:AUX:.*"), NodePattern.not(NodePattern.N.sameWordAs("Perfect"))).noDependents("aux", NodePattern.N.pos("VER:MOD.*")).andNot(NodePattern.N.pos(".*INF.*").noLemma("aufwachsen").withDependent("aux", NodePattern.N.lemma("sein"))).noDependents("obl", NodePattern.N.form("Zeit").withOnlyDependents(NodePattern.N.withHeadRelation("det").pos("ART:IND.*"))).and(VerbFormChoice.withoutClauseBetween("Perfect"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(WordSeparation.withBitte).andNot(Capitalization.withDependentAm).andNot(NodePattern.N.pos(".*PA2.*").noPos("PA2:(NOM|AKK|DAT|GEN).*")).andNot(NodePattern.N.form(".+er").pos(".*PA2.*"))).and((node, match) -> {
            boolean zuInfinitive;
            boolean bl = zuInfinitive = match.findMarkedNode("ZuInfinitive") != null;
            String message = match.findMarkedNode("Future") != null ? "Das Futur wird mit dem Infinitiv des Verbs gebildet" : (match.findMarkedNode("ModalVerb") != null ? "Bei Modalverben wird der Infinitiv verwendet" : (match.findMarkedNode("Passive") != null ? "Das Passiv wird mit dem Partizip II des Verbs gebildet" : (match.findMarkedNode("Subjunctive") != null ? "Mit dem Infinitiv kann der Konjunktiv von \u201esein\u201c nicht verwendet werden" : (match.findMarkedNode("FiniteVerb") != null ? REDUNDANT_AUX : (match.findMarkedNode("Infinitive") != null ? "Hier ist der Infinitiv zu erwarten" : (zuInfinitive ? "Meinten Sie die Form f\u00fcr erledigt (Perfekt) oder noch ausstehend (zu + Infinitiv)?" : "Das Perfekt wird mit dem Partizip II des Verbs gebildet"))))));
            NodeCorrector resultCorrector = null;
            Node finiteVerb = match.findMarkedNode("FiniteVerb");
            Node subjunctive = match.findMarkedNode("Subjunctive");
            if (finiteVerb == null) {
                String posReplacement = match.findMarkedNode("Future") == null && match.findMarkedNode("ModalVerb") == null && match.findMarkedNode("Subjunctive") == null && match.findMarkedNode("Infinitive") == null ? (node.hasPos("PA2.*VER") ? "PA2:PRD:GRU:VER.*" : (node.hasPos("PA2.*") ? "PA2:PRD.*" : "VER:.*PA2.*")) : "VER.*:INF.*";
                List<String> inflectList = node.tree().treeSupport().inflectNode(node, "(VER|PA2):.*", posReplacement);
                if (inflectList.isEmpty()) {
                    return null;
                }
                resultCorrector = NodeCorrector.replace(node, inflectList);
                if (subjunctive != null) {
                    resultCorrector = resultCorrector.join(NodeCorrector.regexReplace(subjunctive, "w\u00e4r(.+)", "w\u00fcrd$1"));
                }
            }
            if (finiteVerb != null) {
                String person = finiteVerb.hasPos(".*1.*") ? "1" : (finiteVerb.hasPos(".*2.*") ? "2" : "3");
                String number = finiteVerb.hasPos(".*SIN.*") ? "SIN" : "PLU";
                String tense = finiteVerb.hasPos(".*PR\u00c4.*") ? "PR\u00c4" : "PRT";
                List<String> inflect = node.tree().treeSupport().inflectNode(node, "VER:.*", "VER:" + person + ":" + number + ":" + tense + ".*");
                if (inflect.isEmpty()) {
                    return match.withMessage(message);
                }
                String replacement = inflect.get(0);
                resultCorrector = NodeCorrector.replace(finiteVerb, replacement).join(NodeCorrector.removeNode(node));
            }
            if (zuInfinitive) {
                String prefix = node.lowForm().replaceFirst("(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).{3,}", "$1");
                String verbStem = node.lowForm().substring(prefix.length());
                String replacement = node.hasForm("(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).*") && !node.hasForm("(durch|\u00fcber|um|unter|voll|wider|hinter|ent).+") ? prefix + "zu" + verbStem : "zu " + node.form();
                NodeCorrector secondCorrector = NodeCorrector.replace(node, replacement);
                return match.withCorrector(resultCorrector).withCorrector(secondCorrector).withMessage(message);
            }
            return match.withCorrector(resultCorrector).withMessage(message);
        });
    }

    private static NodePattern substituteInfinitive() {
        return NodePattern.N.form("ge(konnt|k\u00f6nnt|durft|d\u00fcrft|wollt|sollt|mocht|m\u00f6cht|musst|m\u00fcsst|braucht)").withDependent("aux", NodePattern.N.lemma("haben")).withDependent("xcomp", NodePattern.N.pos(".*INF.*")).and((node, match) -> {
            String replacement = node.lemmaReadings().stream().filter(l -> !l.startsWith("ge")).findFirst().orElse(null);
            if (replacement == null) {
                replacement = node.form().replaceAll("ge(.+)t", "$1en");
            }
            return match.withCorrector(NodeCorrector.replace(node, replacement));
        }).message("Nach einem Infinitiv erfordern einige Verben statt des Partizips den Infinitiv");
    }

    private static NodePattern incorrectVerbChoice() {
        NodePattern clauseLike = NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root");
        NodePattern haengen = NodePattern.or(clauseLike.andOr(NodePattern.N.form("((ab|auf)?ge|be)hangen").correct(NodeCorrector.regexReplace("(?i)(.+)hangen", "$1h\u00e4ngt")), NodePattern.N.form("(be)?hing(en|s?t)?").correct(NodeCorrector.regexReplace("(?i)(be)?hinge?(.*)", "$1h\u00e4ngte$2"))).andOr(NodePattern.N.withDependent("obj"), NodePattern.N.withDependent("aux:pass", NodePattern.N.lemma("werden"))).message("\u201eH\u00e4ngen\u201c ist ein schwaches Verb wenn transitiv mit Formen \u201eh\u00e4ngte\u201c, \u201egeh\u00e4ngt\u201c"), clauseLike.andOr(NodePattern.N.form("((ab|auf)?ge|be)h\u00e4ngt").correct(NodeCorrector.regexReplace("(?i)(.+)h\u00e4ngt", "$1hangen")), NodePattern.N.form("(be)?h\u00e4ngte(n|s?t)?").correct(NodeCorrector.regexReplace("(?i)(be)?h\u00e4ngte", "$1hing")).correct(NodeCorrector.regexReplace("(?i)(be)?h\u00e4ngte(.+)", "$1hinge$2"))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("obj|aux:pass"))).message("\u201eH\u00e4ngen\u201c ist ein starkes Verb wenn intransitiv mit Formen \u201ehing\u201c, \u201egehangen\u201c"));
        NodePattern ueberleben = NodePattern.or(NodePattern.N.form("\u00fcbergelebt(e[rmns]?)?").correct(NodeCorrector.regexReplace("(\u00fcber)ge(lebt)(e[rmns]?)?", "$1$2$3")), NodePattern.N.form("\u00fcberzuleben").correct(NodeCorrector.replace("zu \u00fcberleben"))).message("\u201e\u00dcberleben\u201c ist ein untrennbares Verb");
        NodePattern handhaben = NodePattern.or(NodePattern.N.form("handgehabt(e[rmns]?)?").correct(NodeCorrector.regexReplace("(hand)ge(habt)(e[rmns]?)?", "ge$1$2$3")), NodePattern.N.form("handzuhaben").correct(NodeCorrector.replace("zu handhaben"))).message("\u201eHandhaben\u201c ist ein untrennbares Verb");
        NodePattern uebertreten = NodePattern.or(NodePattern.or(NodePattern.N.lemma("treten").withDependent("compound:prt", NodePattern.N.form("\u00fcber").markAs("Prt")).and((verb, match) -> match.withCorrector(NodeCorrector.replace(verb, "\u00fcber" + verb.lowForm()).join(NodeCorrector.removeNode(match.getMarkedNode("Prt"))))), NodePattern.N.form("\u00fcbergetreten").correct(NodeCorrector.replace("\u00fcbertreten"))).withDependent("obj").message("\u201e\u00dcbertreten\u201c ist ein untrennbares Verb wenn transitiv"), NodePattern.N.form("\u00fcbertreten").withDependent("aux(:pass)?").noDependents("obj").correct(NodeCorrector.replace("\u00fcbergetreten")).message("\u201e\u00dcbertreten\u201c ist ein trennbares Verb wenn intransitiv"));
        NodePattern entscheidenEntschliessen = NodePattern.N.lemma("entschlie\u00dfen").withDependent("obl", NodePattern.N.noPos(".*INF*").noForm(".+([hk]eit|ung)").withDependent("case", NodePattern.N.form("zu").markAs("Prep")).markAs("Obl")).and((node, match) -> {
            Node prep = match.getMarkedNode("Prep");
            NodeCorrector resultCorrector = ChangeLemma.to("entscheiden").corrector(node).join(NodeCorrector.replace(prep, "f\u00fcr"));
            Node obl = match.getMarkedNode("Obl");
            AgreementSet oblSet = AgreementSet.create(obl);
            if (oblSet == null || oblSet.calcPossibleGenders().size() != 1) {
                return null;
            }
            AgreementSet.Gender gender = oblSet.calcPossibleGenders().stream().findFirst().orElse(AgreementSet.Gender.ALG);
            AgreementSet.Number number = oblSet.numberRestriction != null ? oblSet.numberRestriction : (obl.hasPos(".*PLU.*") ? AgreementSet.Number.PLU : AgreementSet.Number.SIN);
            AgreementSet.InflectedForm form = new AgreementSet.InflectedForm(gender, number, Case.AKK, AdjDeclination.fromNPHead(obl), AgreementSet.Person.P3);
            Map<Node, NodeCorrector> oblCorrectors = oblSet.imposeFeatures(form, true);
            return match.withCorrector(resultCorrector.join(NodeCorrector.joinAll(oblCorrectors.values())));
        }).message("\u201eSich entschlie\u00dfen\u201c bezieht sich nur auf Sachverhalte und nicht auf Sachen oder Personen");
        VerbFormChoice.incompleteImperative();
        return NodePattern.or(haengen, uebertreten, ueberleben, handhaben, entscheidenEntschliessen, VerbFormChoice.incompleteImperative());
    }

    private static NodePattern incongruentConjVerb() {
        NodePattern noSubjFinite = NodePattern.N.noDependents("nsubj(:pass)?|expl|aux(:pass)?|cop");
        return noSubjFinite.pos("VER:(IMP|1:SIN|INF).*").onlyPos("VER.*").noPos(".*AUX.*").withHead("conj", noSubjFinite.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noHeadRelation("xcomp").noDependents("conj", NodePattern.not(noSubjFinite)).pos("VER:IMP.*").noPos(".*(PA2|SUB|AUX).*").markAs("ConjHead")).andNot(GermanTreePatterns.headInQuotes).andOr(NodePattern.N.noPos("VER:IMP:SIN.*").and(NodePattern.markedNodeMatches("ConjHead", NodePattern.N.pos("VER:IMP:SIN.*"))).correct(NodeCorrector.inflect("VER:.*", "VER:IMP:SIN.*")), NodePattern.N.noPos("VER:IMP:PLU.*").and(NodePattern.markedNodeMatches("ConjHead", NodePattern.N.pos("VER:IMP:PLU.*"))).correct(NodeCorrector.inflect("VER:.*", "VER:IMP:PLU.*"))).message("Die Verbform scheint dem Kontext nicht zu passen");
    }

    private static NodePattern incompleteImperative() {
        String imperative = "VER:IMP.*";
        String infinitive = "VER:INF:.*";
        NodePattern suspiciousPos = NodePattern.or(NodePattern.N.onlyPos("VER:1:SIN:PR\u00c4.*"), NodePattern.N.noPos().noLabel(".*"), NodePattern.N.pos("VER:2:SIN:PR\u00c4.*"));
        NodePattern optionalObj = NodePattern.N.withOptionalDependent("i?obj", NodePattern.N.pos("PRO:REF.*").markAs("Obj"));
        return NodePattern.or(NodePattern.ROOT.andOr(CommonPatterns.firstToken, NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.N.withHeadRelation("iobj"), NodePattern.N.form("bitte")))).and(optionalObj), NodePattern.N.withHead("conj", NodePattern.or(NodePattern.N.pos(infinitive).noDependents("aux(:pass)?|cop").and(NodePattern.ROOT), NodePattern.N.onlyPos("VER:IMP.*").noDependents("nsubj").markAs("ImpConjHead")).and(optionalObj)), NodePattern.N.withHead("conj", optionalObj.withHeadRelation("parataxis").noDependents("dep")).withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.PUNCT)), NodePattern.N.withHead("parataxis", optionalObj).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("(wer|wen|wem|wann|wie|wo(hin|her)?|welch)")))).and(suspiciousPos).noForm("(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).+").noPos("(VER:IMP|SUB).*").andNot(NodePattern.N.directlyBefore(NodePattern.N.onlyPos("VER.*").noPos(".*INF.*"))).noDependents("nsubj|flat|compound|appos|amod").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("[+/-]"))).andNot(CommonPatterns.upperCase).andNot(CommonPatterns.lowercasedHasPos(imperative)).and((node, match) -> {
            String[] endings;
            ArrayList<NodeCorrector> correctors = new ArrayList<NodeCorrector>();
            Node obj = match.findMarkedNode("Obj");
            Node impConjHead = match.findMarkedNode("ImpConjHead");
            List<Node> impConjDepList = node.findDependents("conj").stream().filter(dep -> suspiciousPos.matches((Node)dep) || dep.hasPos(imperative)).toList();
            for (String ending : endings = new String[]{"en", "n"}) {
                String newVerb;
                String string = newVerb = node.form().matches(".+st") ? StringTools.uppercaseFirstChar((String)(node.form().substring(0, node.form().length() - 2) + ending)) : StringTools.uppercaseFirstChar((String)(node.form() + ending));
                if (!node.tree().treeSupport().tagToken(newVerb).hasPos(infinitive)) continue;
                AgreementSet.Number number = obj != null && obj.hasPos(".*SIN:ALG:2:B") || impConjHead != null && impConjHead.hasPos("VER:(1:SIN:PR\u00c4|IMP:SIN).*") ? AgreementSet.Number.SIN : (obj != null && obj.hasPos(".*PLU.*") || impConjHead != null && impConjHead.hasPos("VER:IMP:PLU.*") ? AgreementSet.Number.PLU : null);
                List<AgreementSet.Number> numList = number != null ? List.of(number) : List.of(AgreementSet.Number.PLU, AgreementSet.Number.SIN);
                for (AgreementSet.Number num : numList) {
                    String srsPos = "VER:IMP:" + num.name() + ":.*";
                    NodeCorrector corrector = NodeCorrector.inflect(node, "VER.*", srsPos);
                    for (Node impConjDep : impConjDepList) {
                        corrector = corrector.join(NodeCorrector.inflect(impConjDep, "VER.*", srsPos));
                    }
                    correctors.add(corrector);
                }
                return match.withCorrectors(correctors);
            }
            return null;
        }).message("Meinten Sie die Imperativform?");
    }

    private static NodePattern wordeWurde() {
        return NodePattern.or(NodePattern.N.form("worden").markAs("Worden").withHead("aux:pass", NodePattern.or(CommonPatterns.possiblyConj(NodePattern.N.withDependent("aux", NodePattern.N.pos(".*MOD.*"))).and(NodePattern.markedNodeMatches("Worden", SpellingRules.typoReplacement("werden"))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.not(NodePattern.N.alreadyMarkedAs("Worden")).lemma("sein")))), NodePattern.markedNodeMatches("Worden", SpellingRules.typoRegexReplacement("worde(n)?", "wurde$1")).andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.not(NodePattern.N.alreadyMarkedAs("Worden")))))).noDependents("conj", NodePattern.N.withDependent("aux(:pass)?|cop")).and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass)?")))), NodePattern.N.form("worde").withHeadRelation("aux(:pass)?").and(SpellingRules.typoRegexReplacement("worde(n)?", "wurde$1")));
    }
}

