/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jps;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.jps.SetupKotlinJpsPluginBeforeCompileTaskKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\b\u001a\u00020\t*\u00020\u00072\u0017\u0010\n\u001a\u00130\u000b\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000fH\u0002J%\u0010\u0010\u001a\u00020\t*\u00020\u00072\u0017\u0010\n\u001a\u00130\u000b\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/jps/SetupKotlinJpsPluginBeforeCompileTask;", "Lcom/intellij/openapi/compiler/CompileTask;", "<init>", "()V", "execute", "", "context", "Lcom/intellij/openapi/compiler/CompileContext;", "addError", "", "msg", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "addErrorWithReferenceToKotlincXml", "intellij.kotlin.base.jps"})
@SourceDebugExtension(value={"SMAP\nSetupKotlinJpsPluginBeforeCompileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupKotlinJpsPluginBeforeCompileTask.kt\norg/jetbrains/kotlin/idea/jps/SetupKotlinJpsPluginBeforeCompileTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class SetupKotlinJpsPluginBeforeCompileTask
implements CompileTask {
    public boolean execute(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String bundledJpsVersion = KotlinJpsPluginSettings.Companion.getRawBundledVersion();
        SetupKotlinJpsPluginBeforeCompileTaskKt.access$getLOG$p().debug("Found bundled JPS version: " + bundledJpsVersion);
        String string = KotlinJpsPluginSettings.Companion.supportedJpsVersion(project2, arg_0 -> SetupKotlinJpsPluginBeforeCompileTask.execute$lambda$0(this, context, arg_0));
        if (string == null) {
            return true;
        }
        String jpsVersion = string;
        SetupKotlinJpsPluginBeforeCompileTaskKt.access$getLOG$p().debug("Attempting to lazy download JPS version: " + jpsVersion);
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        return KotlinArtifactsDownloader.INSTANCE.lazyDownloadMissingJpsPluginDependencies(project2, jpsVersion, progressIndicator, arg_0 -> SetupKotlinJpsPluginBeforeCompileTask.execute$lambda$1(this, context, arg_0));
    }

    private final void addError(CompileContext $this$addError, String msg) {
        $this$addError.addMessage(CompilerMessageCategory.ERROR, msg, null, -1, -1);
    }

    private final void addErrorWithReferenceToKotlincXml(CompileContext $this$addErrorWithReferenceToKotlincXml, String msg) {
        VirtualFile virtualFile;
        Path path;
        Project project = $this$addErrorWithReferenceToKotlincXml.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Path path2 = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
        if (path2 != null && (path = path2.resolve("kotlinc.xml")) != null) {
            Path path3 = path;
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
            VirtualFileManager virtualFileManager2 = virtualFileManager;
            Path p0 = path3;
            boolean bl = false;
            virtualFile = virtualFileManager2.findFileByNioPath(p0);
        } else {
            virtualFile = null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> SetupKotlinJpsPluginBeforeCompileTask.addErrorWithReferenceToKotlincXml$lambda$0(virtualFile2, $this$addErrorWithReferenceToKotlincXml));
        VirtualFile virtualFile3 = virtualFile2;
        $this$addErrorWithReferenceToKotlincXml.addMessage(CompilerMessageCategory.ERROR, msg, virtualFile3 != null ? virtualFile3.getUrl() : null, -1, -1, (Navigatable)psiFile);
    }

    private static final Unit execute$lambda$0(SetupKotlinJpsPluginBeforeCompileTask this$0, CompileContext $context, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addErrorWithReferenceToKotlincXml($context, it);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$1(SetupKotlinJpsPluginBeforeCompileTask this$0, CompileContext $context, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addError($context, it);
        return Unit.INSTANCE;
    }

    private static final PsiFile addErrorWithReferenceToKotlincXml$lambda$0(VirtualFile $virtualFile, CompileContext $this_addErrorWithReferenceToKotlincXml) {
        PsiFile psiFile;
        VirtualFile virtualFile = $virtualFile;
        if (virtualFile != null) {
            Project project = $this_addErrorWithReferenceToKotlincXml.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiFile = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)virtualFile, (Project)project);
        } else {
            psiFile = null;
        }
        return psiFile;
    }
}

