/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateDiffOnHoverToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotatedLineModificationDetails;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InlineDiffFromAnnotation
implements EditorMouseListener,
EditorMouseMotionListener,
DocumentListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(InlineDiffFromAnnotation.class);
    @NotNull
    private final EditorEx myEditor;
    @NotNull
    private final FileAnnotation myFileAnnotation;
    @NotNull
    private final TextAnnotationPresentation myTextPresentation;
    @NotNull
    private final FileAnnotation.LineModificationDetailsProvider myProvider;
    @NotNull
    private final Alarm myAlarm;
    private int myCurrentLine;
    @Nullable
    private ProgressIndicator myIndicator;
    @Nullable
    private Disposable myDisposable;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;

    private InlineDiffFromAnnotation(@NotNull EditorEx editor, @NotNull FileAnnotation fileAnnotation, @NotNull TextAnnotationPresentation textPresentation, @NotNull FileAnnotation.LineModificationDetailsProvider provider, @NotNull Disposable disposable) {
        if (editor == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(0);
        }
        if (fileAnnotation == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(1);
        }
        if (textPresentation == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(3);
        }
        if (disposable == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(4);
        }
        this.myCurrentLine = -1;
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myEditor = editor;
        this.myFileAnnotation = fileAnnotation;
        this.myTextPresentation = textPresentation;
        this.myProvider = provider;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, disposable);
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    public void dispose() {
        this.removeDiff();
    }

    public static void showDiffOnHover(@NotNull Editor editor, @NotNull FileAnnotation fileAnnotation, @NotNull TextAnnotationPresentation textPresentation, @NotNull Disposable disposable) {
        if (editor == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(5);
        }
        if (fileAnnotation == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(6);
        }
        if (textPresentation == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(7);
        }
        if (disposable == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(8);
        }
        if (!(editor instanceof EditorEx)) {
            return;
        }
        FileAnnotation.LineModificationDetailsProvider provider = fileAnnotation.getLineModificationDetailsProvider();
        if (provider == null) {
            return;
        }
        InlineDiffFromAnnotation inlineDiffFromAnnotation = new InlineDiffFromAnnotation((EditorEx)editor, fileAnnotation, textPresentation, provider, disposable);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)inlineDiffFromAnnotation, disposable);
        editor.addEditorMouseListener((EditorMouseListener)inlineDiffFromAnnotation, disposable);
        editor.getDocument().addDocumentListener((DocumentListener)inlineDiffFromAnnotation, disposable);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(9);
        }
        if (!InlineDiffFromAnnotation.mouseIsInsideAnnotationArea(this.myEditor, e.getMouseEvent())) {
            this.removeDiff();
            return;
        }
        int editorLine = EditorUtil.yToLogicalLineNoCustomRenderers((Editor)this.myEditor, (int)e.getMouseEvent().getY());
        if (editorLine == this.myCurrentLine) {
            return;
        }
        this.removeDiff();
        if (!AnnotateDiffOnHoverToggleAction.isShowDiffOnHover()) {
            return;
        }
        int annotationLine = this.myTextPresentation.getAnnotationLine(editorLine);
        if (annotationLine >= 0 && annotationLine < this.myFileAnnotation.getLineCount()) {
            this.myCurrentLine = editorLine;
            this.scheduleUpdateDiff(editorLine, annotationLine);
        }
    }

    public void mouseExited(@NotNull EditorMouseEvent event) {
        if (event == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(10);
        }
        this.removeDiff();
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(11);
        }
        this.removeDiff();
    }

    @RequiresEdt
    private void removeDiff() {
        this.myAlarm.cancelAllRequests();
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
            this.myIndicator = null;
        }
        this.removeHighlighters();
        this.myCurrentLine = -1;
    }

    private void removeHighlighters() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
        this.myHighlighters.forEach(highlighter -> this.myEditor.getMarkupModel().removeHighlighter(highlighter));
        this.myHighlighters.clear();
    }

    @RequiresEdt
    private void scheduleUpdateDiff(int editorLine, int annotationLine) {
        this.myAlarm.addRequest(() -> {
            if (this.myCurrentLine == editorLine) {
                this.updateDiff(editorLine, annotationLine);
            }
        }, 100);
    }

    @RequiresEdt
    private void updateDiff(int editorLine, int annotationLine) {
        this.myIndicator = BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
            try {
                AnnotatedLineModificationDetails details = this.myProvider.getDetails(annotationLine);
                if (details == null) {
                    return;
                }
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                ApplicationManager.getApplication().invokeLater(() -> this.showDiff(editorLine, details, indicator));
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    private void showDiff(int editorLine, @NotNull AnnotatedLineModificationDetails details, @Nullable ProgressIndicator indicator) {
        if (details == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(12);
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (editorLine == this.myCurrentLine) {
            this.removeHighlighters();
            this.addHighlighters(editorLine, details);
        }
    }

    private void addHighlighters(int editorLine, @NotNull AnnotatedLineModificationDetails details) {
        DocumentEx document;
        if (details == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(13);
        }
        if (editorLine >= DiffUtil.getLineCount((Document)(document = this.myEditor.getDocument()))) {
            return;
        }
        int lineStartOffset = document.getLineStartOffset(editorLine);
        int lineEndOffset = document.getLineEndOffset(editorLine);
        String currentContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset).toString();
        String contentAfter = details.lineContentAfter;
        List changes = details.changes;
        this.myDisposable = Disposer.newDisposable();
        DiffDrawUtil.setupLayeredRendering((Editor)this.myEditor, (int)editorLine, (int)(editorLine + 1), (int)3, (Disposable)this.myDisposable);
        AnnotatedLineModificationDetails.InnerChange onlyItem = (AnnotatedLineModificationDetails.InnerChange)ContainerUtil.getOnlyItem((Collection)changes);
        if (onlyItem != null && onlyItem.startOffset == 0 && onlyItem.endOffset == contentAfter.length()) {
            TextDiffType diffType = InlineDiffFromAnnotation.getDiffType(onlyItem.type);
            this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myEditor, editorLine, editorLine + 1, diffType).withLayerPriority(3).withIgnored(false).withHideStripeMarkers(true).done());
        } else {
            this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myEditor, editorLine, editorLine + 1, TextDiffType.MODIFIED).withLayerPriority(3).withIgnored(true).withHideStripeMarkers(true).done());
            List<AnnotatedLineModificationDetails.InnerChange> currentChanges = InlineDiffFromAnnotation.adjustChangesToCurrent(currentContent, contentAfter, changes);
            for (AnnotatedLineModificationDetails.InnerChange change : currentChanges) {
                int start2 = lineStartOffset + change.startOffset;
                int end = lineStartOffset + change.endOffset;
                TextDiffType diffType = InlineDiffFromAnnotation.getDiffType(change.type);
                LOG.assertTrue(start2 <= end && end <= lineEndOffset, (Object)String.format("Range: [%s, %s), Line range: [%s, %s)", start2, end, lineStartOffset, lineEndOffset));
                this.myHighlighters.addAll(new DiffDrawUtil.InlineHighlighterBuilder((Editor)this.myEditor, start2, end, diffType).withLayerPriority(3).done());
            }
        }
    }

    @NotNull
    private static List<AnnotatedLineModificationDetails.InnerChange> adjustChangesToCurrent(@NotNull String currentContent, @NotNull String contentAfter, @NotNull List<AnnotatedLineModificationDetails.InnerChange> changes) {
        if (currentContent == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(14);
        }
        if (contentAfter == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(15);
        }
        if (changes == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(16);
        }
        if (contentAfter.equals(currentContent)) {
            List<AnnotatedLineModificationDetails.InnerChange> list = changes;
            if (list == null) {
                InlineDiffFromAnnotation.$$$reportNull$$$0(17);
            }
            return list;
        }
        List delta = ByWord.compare((CharSequence)contentAfter, (CharSequence)currentContent, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        DiffIterable iterable = DiffIterableUtil.createFragments((List)delta, (int)contentAfter.length(), (int)currentContent.length());
        LineNumberConvertor convertor = LineNumberConvertor.fromIterable((DiffIterable)iterable);
        List list = ContainerUtil.map(changes, change -> {
            int start2 = convertor.convertApproximate(change.startOffset);
            int end = convertor.convertApproximate(change.endOffset);
            return new AnnotatedLineModificationDetails.InnerChange(start2, end, change.type);
        });
        if (list == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private static TextDiffType getDiffType(@NotNull AnnotatedLineModificationDetails.InnerChangeType changeType) {
        if (changeType == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(19);
        }
        TextDiffType textDiffType = switch (changeType) {
            default -> throw new MatchException(null, null);
            case AnnotatedLineModificationDetails.InnerChangeType.DELETED -> TextDiffType.DELETED;
            case AnnotatedLineModificationDetails.InnerChangeType.INSERTED -> TextDiffType.INSERTED;
            case AnnotatedLineModificationDetails.InnerChangeType.MODIFIED -> TextDiffType.MODIFIED;
        };
        if (textDiffType == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(20);
        }
        return textDiffType;
    }

    private static boolean mouseIsInsideAnnotationArea(@NotNull EditorEx editor, @NotNull MouseEvent event) {
        if (editor == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(21);
        }
        if (event == null) {
            InlineDiffFromAnnotation.$$$reportNull$$$0(22);
        }
        if (event.getSource() != editor.getGutter()) {
            return false;
        }
        EditorGutterComponentEx gutter = editor.getGutterComponentEx();
        int x = event.getX();
        int areaOffset = gutter.getAnnotationsAreaOffset();
        int areaWidth = gutter.getAnnotationsAreaWidth();
        return x >= areaOffset && x < areaOffset + areaWidth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPresentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentContent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAfter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/InlineDiffFromAnnotation";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/InlineDiffFromAnnotation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustChangesToCurrent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDiffOnHover";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mouseExited";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighters";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "adjustChangesToCurrent";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDiffType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mouseIsInsideAnnotationArea";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 20 -> new IllegalStateException(string);
        };
    }
}

