/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.vcs.VcsException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public abstract class Loader {
    @NotNull
    protected final SvnRepositoryCache myCache;

    protected Loader(@NotNull SvnRepositoryCache cache) {
        if (cache == null) {
            Loader.$$$reportNull$$$0(0);
        }
        this.myCache = cache;
    }

    public abstract void load(@NotNull RepositoryTreeNode var1, @NotNull Expander var2);

    @NotNull
    protected abstract NodeLoadState getNodeLoadState();

    protected void refreshNodeError(@NotNull RepositoryTreeNode node, @NotNull VcsException error) {
        RepositoryTreeNode existingNode;
        if (node == null) {
            Loader.$$$reportNull$$$0(1);
        }
        if (error == null) {
            Loader.$$$reportNull$$$0(2);
        }
        if ((existingNode = Loader.findExistingNode(node)) != null) {
            existingNode.setErrorNode(error.getMessage());
        }
    }

    protected void refreshNode(@NotNull RepositoryTreeNode node, @NotNull List<DirectoryEntry> data, @NotNull Expander expander) {
        RepositoryTreeNode existingNode;
        if (node == null) {
            Loader.$$$reportNull$$$0(3);
        }
        if (data == null) {
            Loader.$$$reportNull$$$0(4);
        }
        if (expander == null) {
            Loader.$$$reportNull$$$0(5);
        }
        if ((existingNode = Loader.findExistingNode(node)) != null) {
            expander.onBeforeRefresh(existingNode);
            existingNode.setChildren(data, this.getNodeLoadState());
            expander.onAfterRefresh(existingNode);
        }
    }

    @Nullable
    private static RepositoryTreeNode findExistingNode(@NotNull RepositoryTreeNode node) {
        if (node == null) {
            Loader.$$$reportNull$$$0(6);
        }
        RepositoryTreeNode result = null;
        if (!node.isDisposed()) {
            result = node.getNodeWithSamePathUnderModelRoot();
        }
        return result == null || result.isDisposed() ? null : result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expander";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/dialogs/browserCache/Loader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshNodeError";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

