/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.IKotlinFacetSettings;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.AddRequiresDirectiveFacilityKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.projectConfiguration.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.serialization.KotlinFacetSettingsWorkspaceModelKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0,H\u0014J.\u0010-\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\u0014\u00100\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020*02\u0018\u000101H\u0016J.\u00103\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\u0014\u00100\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020*02\u0018\u000101H\u0016J\u0010\u00104\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00168UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018R\u0014\u0010\u001f\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0018R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lorg/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties;", "<init>", "()V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "libraryType", "Lcom/intellij/jarRepository/RepositoryLibraryType;", "getLibraryType", "()Lcom/intellij/jarRepository/RepositoryLibraryType;", "libraryProperties", "getLibraryProperties", "()Lorg/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties;", "stdlibDetector", "Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "getStdlibDetector", "()Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "isConfigured", "libraryName", "", "getLibraryName", "()Ljava/lang/String;", "dialogTitle", "getDialogTitle", "messageForOverrideDialog", "getMessageForOverrideDialog", "presentableText", "getPresentableText", "name", "getName", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "getLibraryJarDescriptor", "()Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "configureKotlinSettings", "", "modules", "", "configureModule", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "writeActions", "", "Lkotlin/Function0;", "configureModuleAndGetResult", "hasBrokenJsRuntime", "Companion", "intellij.kotlin.projectConfiguration"})
@SourceDebugExtension(value={"SMAP\nKotlinJavaModuleConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJavaModuleConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,142:1\n1232#2,2:143\n*S KotlinDebug\n*F\n+ 1 KotlinJavaModuleConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator\n*L\n75#1:143,2\n*E\n"})
public class KotlinJavaModuleConfigurator
extends KotlinWithLibraryConfigurator<RepositoryLibraryProperties> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "java";

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return super.isApplicable(module) && !this.hasBrokenJsRuntime(module);
    }

    @NotNull
    public RepositoryLibraryType getLibraryType() {
        RepositoryLibraryType repositoryLibraryType = RepositoryLibraryType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryLibraryType, (String)"getInstance(...)");
        return repositoryLibraryType;
    }

    @Override
    @NotNull
    public RepositoryLibraryProperties getLibraryProperties() {
        return this.getLibraryJarDescriptor().getRepositoryLibraryProperties();
    }

    @Override
    @NotNull
    public StdlibDetectorFacility getStdlibDetector() {
        return KotlinJvmStdlibDetectorFacility.INSTANCE;
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJvmRuntimeInScope(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return "KotlinJavaRuntime";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JavaRuntimeLibraryDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @Nls
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JavaRuntimeLibraryDescription.Companion.getJAVA_RUNTIME_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return KotlinProjectConfigurationBundle.message("language.name.java", new Object[0]);
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @Override
    @NotNull
    public LibraryJarDescriptor getLibraryJarDescriptor() {
        return LibraryJarDescriptor.RUNTIME_JDK8_JAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void configureKotlinSettings(@NotNull List<? extends Module> modules2) {
        boolean canChangeProjectSettings;
        Module project;
        block8: {
            boolean bl;
            void $this$all$iv;
            Intrinsics.checkNotNullParameter(modules2, (String)"modules");
            Module module = (Module)CollectionsKt.firstOrNull(modules2);
            if (module == null || (module = module.getProject()) == null) {
                return;
            }
            project = module;
            Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])ProjectUtil.getModules((Project)project)), KotlinJavaModuleConfigurator::configureKotlinSettings$lambda$0), KotlinJavaModuleConfigurator::configureKotlinSettings$lambda$1);
            boolean bl2 = false;
            for (Object element$iv : $this$all$iv) {
                JavaSdkVersion it = (JavaSdkVersion)element$iv;
                boolean bl22 = false;
                if (it.isAtLeast(JavaSdkVersion.JDK_1_8)) continue;
                bl = false;
                break block8;
            }
            bl = canChangeProjectSettings = true;
        }
        if (canChangeProjectSettings) {
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance((Project)project).update(KotlinJavaModuleConfigurator::configureKotlinSettings$lambda$3);
        } else {
            for (Module module : modules2) {
                IdeModifiableModelsProvider modelsProvider;
                JavaSdkVersion sdkVersion;
                Sdk sdk2;
                if (ProjectStructureUtils.getSdk(module) == null || JavaSdk.getInstance().getVersion(sdk2) == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)ProjectDataManager.getInstance().createModifiableModelsProvider((Project)project), (String)"createModifiableModelsProvider(...)");
                try {
                    KotlinFacet facet = FacetUtilsKt.getOrCreateFacet$default(module, modelsProvider, false, null, true, 4, null);
                    IKotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                    KotlinFacetUtils.initializeIfNeeded$default(facetSettings, module, null, JvmPlatforms.INSTANCE.getJvm8(), null, 8, null);
                    KotlinFacetSettingsWorkspaceModelKt.updateCompilerArguments(facetSettings, (Function1<? super CommonCompilerArguments, Unit>)((Function1)KotlinJavaModuleConfigurator::configureKotlinSettings$lambda$4));
                }
                finally {
                    modelsProvider.dispose();
                }
            }
        }
    }

    @Override
    public void configureModule(@NotNull Module module, @NotNull NotificationMessageCollector collector2, @Nullable List<Function0<Unit>> writeActions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        this.configureModuleAndGetResult(module, collector2, writeActions);
    }

    @Override
    public boolean configureModuleAndGetResult(@NotNull Module module, @NotNull NotificationMessageCollector collector2, @Nullable List<Function0<Unit>> writeActions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        boolean configured = super.configureModuleAndGetResult(module, collector2, writeActions);
        Function0<Unit> function0 = AddRequiresDirectiveFacilityKt.addStdlibToJavaModuleInfoLazy(module, collector2);
        if (function0 == null) {
            return configured;
        }
        Function0<Unit> callable = function0;
        if (writeActions != null) {
            writeActions.add(callable);
        } else {
            callable.invoke();
        }
        return configured;
    }

    private final boolean hasBrokenJsRuntime(Module module) {
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
        for (OrderEntry orderEntry : orderEntryArray) {
            LibraryEx library;
            LibraryOrderEntry libraryOrderEntry = orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if ((object instanceof LibraryEx ? (LibraryEx)object : null) == null) continue;
            library = library;
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!KotlinJavaScriptStdlibDetectorFacility.INSTANCE.isStdlib(project, (Library)library, true)) continue;
            return true;
        }
        return false;
    }

    private static final Sdk configureKotlinSettings$lambda$0(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectStructureUtils.getSdk(it);
    }

    private static final JavaSdkVersion configureKotlinSettings$lambda$1(Sdk it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JavaSdk.getInstance().getVersion(it);
    }

    private static final Unit configureKotlinSettings$lambda$3(K2JVMCompilerArguments $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setJvmTarget("1.8");
        return Unit.INSTANCE;
    }

    private static final Unit configureKotlinSettings$lambda$4(CommonCompilerArguments $this$updateCompilerArguments) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$updateCompilerArguments, (String)"$this$updateCompilerArguments");
            K2JVMCompilerArguments k2JVMCompilerArguments = $this$updateCompilerArguments instanceof K2JVMCompilerArguments ? (K2JVMCompilerArguments)$this$updateCompilerArguments : null;
            if (k2JVMCompilerArguments == null) break block0;
            k2JVMCompilerArguments.setJvmTarget("1.8");
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator$Companion;", "", "<init>", "()V", "NAME", "", "instance", "Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "getInstance", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "intellij.kotlin.projectConfiguration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinJavaModuleConfigurator getInstance() {
            Object object = Extensions.findExtension(KotlinProjectConfigurator.Companion.getEP_NAME(), KotlinJavaModuleConfigurator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"findExtension(...)");
            return (KotlinJavaModuleConfigurator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

