/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.ui.impl.watch.ThisDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.ReflectionUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingInstanceThisRemapper;", "", "children", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "index", "", "value", "Lcom/intellij/xdebugger/frame/XValue;", "size", "<init>", "(Lcom/intellij/xdebugger/frame/XValueChildrenList;ILcom/intellij/xdebugger/frame/XValue;I)V", "getValue", "()Lcom/intellij/xdebugger/frame/XValue;", "remapName", "", "newName", "", "remove", "getLists", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingInstanceThisRemapper$Lists;", "Companion", "Lists", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nExistingInstanceThisRemapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExistingInstanceThisRemapper.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingInstanceThisRemapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class ExistingInstanceThisRemapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XValueChildrenList children;
    private final int index;
    @NotNull
    private final XValue value;
    private final int size;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String THIS_NAME = "this";

    public ExistingInstanceThisRemapper(@NotNull XValueChildrenList children, int index2, @NotNull XValue value, int size) {
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.children = children;
        this.index = index2;
        this.value = value;
        this.size = size;
    }

    @NotNull
    public final XValue getValue() {
        return this.value;
    }

    public final void remapName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Lists lists = this.getLists();
        if (lists == null) {
            return;
        }
        List<Object> names = lists.component1();
        names.set(this.index, newName);
    }

    public final void remove() {
        Lists lists = this.getLists();
        if (lists == null) {
            return;
        }
        Lists lists2 = lists;
        List<Object> names = lists2.component1();
        List<Object> values2 = lists2.component2();
        names.remove(this.index);
        values2.remove(this.index);
    }

    private final Lists getLists() {
        String string;
        if (this.children.size() != this.size) {
            throw new IllegalStateException("Children list was modified");
        }
        List namesList = null;
        List valuesList = null;
        Field[] fieldArray = XValueChildrenList.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        for (Field field2 : fieldArray) {
            int mods = field2.getModifiers();
            if (Modifier.isPrivate(mods) && Modifier.isFinal(mods) && !Modifier.isStatic(mods) && Intrinsics.areEqual(field2.getType(), List.class)) {
                List list2;
                Intrinsics.checkNotNull((Object)field2);
                Object object = ReflectionUtilKt.getSafe((Field)field2, (Object)this.children);
                List list3 = TypeIntrinsics.isMutableList((Object)object) ? (List)object : null;
                if (list3 == null) continue;
                List it = list2 = list3;
                boolean bl = false;
                list3 = it.size() == this.size ? list2 : null;
                if (list3 == null) {
                    continue;
                }
                List list4 = list3;
                if (Intrinsics.areEqual(list4.get(this.index), (Object)THIS_NAME)) {
                    namesList = list4;
                } else if (list4.get(this.index) == this.value) {
                    valuesList = list4;
                }
            }
            if (namesList == null || valuesList == null) continue;
            return new Lists(namesList, valuesList);
        }
        Object[] objectArray = XValueChildrenList.class.getDeclaredFields();
        if (objectArray != null) {
            String string2 = Arrays.toString(objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            string = null;
        }
        LOG.error("Can't find name/value lists, existing fields: " + string);
        return null;
    }

    static {
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingInstanceThisRemapper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "THIS_NAME", "", "find", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingInstanceThisRemapper;", "children", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "intellij.kotlin.jvm.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ExistingInstanceThisRemapper find(@NotNull XValueChildrenList children) {
            Intrinsics.checkNotNullParameter((Object)children, (String)"children");
            int size = children.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ValueDescriptorImpl valueDescriptor;
                if (!Intrinsics.areEqual((Object)children.getName(i2), (Object)ExistingInstanceThisRemapper.THIS_NAME)) continue;
                XValue xValue = children.getValue(i2);
                JavaValue javaValue = xValue instanceof JavaValue ? (JavaValue)xValue : null;
                Object object = valueDescriptor = javaValue != null ? javaValue.getDescriptor() : null;
                if (!(valueDescriptor instanceof ThisDescriptorImpl)) {
                    return null;
                }
                XValue xValue2 = children.getValue(i2);
                Intrinsics.checkNotNullExpressionValue((Object)xValue2, (String)"getValue(...)");
                return new ExistingInstanceThisRemapper(children, i2, xValue2, size);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003H\u00c6\u0003J\u0011\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003H\u00c6\u0003J-\u0010\f\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingInstanceThisRemapper$Lists;", "", "names", "", "values", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getNames", "()Ljava/util/List;", "getValues", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.jvm.debugger.core"})
    private static final class Lists {
        @NotNull
        private final List<Object> names;
        @NotNull
        private final List<Object> values;

        public Lists(@NotNull List<Object> names, @NotNull List<Object> values2) {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            this.names = names;
            this.values = values2;
        }

        @NotNull
        public final List<Object> getNames() {
            return this.names;
        }

        @NotNull
        public final List<Object> getValues() {
            return this.values;
        }

        @NotNull
        public final List<Object> component1() {
            return this.names;
        }

        @NotNull
        public final List<Object> component2() {
            return this.values;
        }

        @NotNull
        public final Lists copy(@NotNull List<Object> names, @NotNull List<Object> values2) {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            return new Lists(names, values2);
        }

        public static /* synthetic */ Lists copy$default(Lists lists, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = lists.names;
            }
            if ((n & 2) != 0) {
                list3 = lists.values;
            }
            return lists.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "Lists(names=" + this.names + ", values=" + this.values + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.names).hashCode();
            result2 = result2 * 31 + ((Object)this.values).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Lists)) {
                return false;
            }
            Lists lists = (Lists)other;
            if (!Intrinsics.areEqual(this.names, lists.names)) {
                return false;
            }
            return Intrinsics.areEqual(this.values, lists.values);
        }
    }
}

