/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import icons.MavenIcons;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.navigator.structure.GroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectNode;

@ApiStatus.Internal
public abstract class ProjectsGroupNode
extends GroupNode {
    private final List<ProjectNode> myProjectNodes = new CopyOnWriteArrayList<ProjectNode>();

    ProjectsGroupNode(MavenProjectsStructure structure, MavenSimpleNode parent) {
        super(structure, parent);
        this.getTemplatePresentation().setIcon(MavenIcons.ModulesClosed);
    }

    @Override
    protected List<? extends MavenSimpleNode> doGetChildren() {
        return this.myProjectNodes;
    }

    @TestOnly
    public List<ProjectNode> getProjectNodesInTests() {
        return this.myProjectNodes;
    }

    @VisibleForTesting
    public void add(ProjectNode projectNode) {
        projectNode.setParent(this);
        this.insertSorted(this.myProjectNodes, projectNode);
        this.childrenChanged();
    }

    public void remove(ProjectNode projectNode) {
        projectNode.setParent(null);
        this.myProjectNodes.remove(projectNode);
        this.childrenChanged();
    }

    public void sortProjects() {
        this.sort(this.myProjectNodes);
        this.childrenChanged();
    }
}

