/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.RowidBinder;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CURowidCopyingBinder;

class T4CURowidBinder
extends RowidBinder {
    static void init(Binder x) {
        x.type = (short)208;
        x.bytelen = 130;
    }

    T4CURowidBinder(byte[] val) {
        super(val);
        this.theRowidCopyingBinder = new T4CURowidCopyingBinder();
        T4CURowidBinder.init(this);
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] value = this.paramVal;
        long pos = 0L;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            int offset;
            byte[] b;
            bindIndicators[indoffset] = 0;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                b = stmt.connection.methodTempLargeByteBuffer;
                offset = 0;
            } else {
                b = bindBytes;
                offset = byteoffset + 2;
            }
            int len = value.length;
            int convertedLength = T4CRowidAccessor.kgrdc2ub(value, 0, b, offset, len);
            if (bindUseDBA) {
                bindData.put(b, 0, convertedLength);
                bindDataLengths[bindDataIndex] = convertedLength;
                stmt.lastBoundDataLengths[bindPosition] = convertedLength;
            } else {
                bindBytes[byteoffset] = (byte)(convertedLength >> 8);
                bindBytes[byteoffset + 1] = (byte)(convertedLength & 0xFF);
            }
            bindIndicators[lenoffset] = (short)(convertedLength + 2);
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value, 0, value.length);
        }
        return localCheckSum;
    }
}

