"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderPointGroup = exports.renderPoints = void 0;
var shapes_1 = require("./primitives/shapes");
var panel_transform_1 = require("./utils/panel_transform");
function renderPoints(ctx, points, _a) {
    var opacity = _a.opacity;
    points
        .map(function (_a) {
        var x = _a.x, y = _a.y, radius = _a.radius, transform = _a.transform, style = _a.style;
        var fill = {
            color: applyOpacity(style.fill.color, opacity),
        };
        var stroke = __assign(__assign({}, style.stroke), { color: applyOpacity(style.stroke.color, opacity) });
        var coordinates = {
            x: x + transform.x,
            y: y + transform.y,
            radius: radius,
        };
        return [coordinates, fill, stroke, style.shape];
    })
        .sort(function (_a, _b) {
        var _c = __read(_a, 1), a = _c[0].radius;
        var _d = __read(_b, 1), b = _d[0].radius;
        return b - a;
    })
        .forEach(function (_a) {
        var _b = __read(_a, 4), coordinates = _b[0], fill = _b[1], stroke = _b[2], shape = _b[3];
        return shapes_1.renderShape(ctx, shape, coordinates, fill, stroke);
    });
}
exports.renderPoints = renderPoints;
function renderPointGroup(ctx, points, themeStyles, geometryStateStyles, rotation, renderingArea, clippings, shouldClip) {
    points
        .map(function (_a) {
        var x = _a.x, y = _a.y, radius = _a.radius, transform = _a.transform, style = _a.style, key = _a.seriesIdentifier.key, panel = _a.panel;
        var opacity = geometryStateStyles[key].opacity;
        var fill = {
            color: applyOpacity(style.fill.color, opacity),
        };
        var stroke = __assign(__assign({}, style.stroke), { color: applyOpacity(style.stroke.color, opacity) });
        var coordinates = {
            x: x + transform.x,
            y: y,
            radius: radius,
        };
        return [coordinates, fill, stroke, panel, style.shape];
    })
        .sort(function (_a, _b) {
        var _c = __read(_a, 1), a = _c[0].radius;
        var _d = __read(_b, 1), b = _d[0].radius;
        return b - a;
    })
        .forEach(function (_a) {
        var _b = __read(_a, 5), coordinates = _b[0], fill = _b[1], stroke = _b[2], panel = _b[3], shape = _b[4];
        panel_transform_1.withPanelTransform(ctx, panel, rotation, renderingArea, function (ctx) {
            shapes_1.renderShape(ctx, shape, coordinates, fill, stroke);
        }, { area: clippings, shouldClip: shouldClip });
    });
}
exports.renderPointGroup = renderPointGroup;
function applyOpacity(color, opacity) {
    return __assign(__assign({}, color), { opacity: color.opacity * opacity });
}
//# sourceMappingURL=points.js.map